# Section E - What do anarchists think causes ecological problems?

This section of the FAQ expands upon section D.4 (["What is the relationship
between capitalism and the ecological crisis?"](secD4.md)) in which we
indicated that since capitalism is based upon the principle of "grow or die,"
a "green" capitalism is impossible. By its very nature capitalism must expand,
creating new markets, increasing production and consumption, and so invading
more ecosystems, using more resources, and upsetting the interrelations and
delicate balances that exist with ecosystems. We have decided to include a
separate section on this to stress how important green issues are to anarchism
and what a central place ecology has in modern anarchism.

Anarchists have been at the forefront of ecological thinking and the green
movement for decades. This is unsurprisingly, as many key concepts of
anarchism are also key concepts in ecological thought. In addition, the
ecological implications of many anarchist ideas (such as decentralisation,
integration of industry and agriculture, and so forth) has meant that
anarchists have quickly recognised the importance of ecological movements and
ideas.

Murray Bookchin in particular has placed anarchist ideas at the centre of
green debate as well as bringing out the links anarchism has with ecological
thinking. His eco-anarchism (which he called **social ecology** ) was based on
emphasising the **social** nature of the ecological problems we face. In such
classic works as **Post-Scarcity Anarchism** , **Toward an Ecological
Society** and **The Ecology of Freedom** he has consistently argued that
humanity's domination of nature is the result of domination **within**
humanity itself.

However, anarchism has always had an ecological dimension. As Peter Marshall
notes in his extensive overview of ecological thought, ecologists _"find in
Proudhon two of their most cherished social principles: federalism and
decentralisation."_ He _"stands as an important forerunner of the modern
ecological movement for his stress on the close communion between humanity and
nature, for his belief in natural justice, for his doctrine of federalism and
for his insight that liberty is the mother and not the daughter of order."_ [
**Nature's Web** , p. 307 and p. 308] For Proudhon, a key problem was that
people viewed the land as _"something which enables them to levy a certain
revenue each year. Gone is the deep feeling for nature."_ People _"no longer
love the soil. Landowners sell it, lease it, divide it into shares, prostitute
it, bargain with it and treat it as an object of speculation. Farmers torture
it, violate it, exhaust it and sacrifice it to their impatient desire for
gain. They never become one with it."_ We _"have lost our feeling for
nature."_ [ **Selected Writings of Pierre-Joseph Proudhon** , p. 261]

Other precursors of eco-anarchism can be found in Peter Kropotkin's writings.
For example, in his classic work **Fields, Factories and Workshops** ,
Kropotkin argued the case for _"small is beautiful"_ 70 years before E. F.
Schumacher coined the phase, advocating _"a harmonious balance between
agriculture and industry. Instead of the concentration of large factories in
cities, he called for economic as well as social decentralisation, believing
that diversity is the best way to organise production by mutual co-operation.
He favoured the scattering of industry throughout the country and the
integration of industry and agriculture at the local level."_ His vision of a
decentralised commonwealth based on an integration of agriculture and industry
as well as manual and intellectual work has obvious parallels with much modern
green thought, as does his stress on the need for **appropriate** levels of
technology and his recognition that the capitalist market distorts the
development, size and operation of technology and industry. Through his
investigations in geography and biology, Kropotkin discovered species to be
interconnected with each other and with their environment. **Mutual Aid** is
the classic source book on the survival value of co-operation within species
which Kropotkin regarded as an important factor of evolution, arguing that
those who claim competition within and between species is the chief or only
factor have distorted Darwin's work. All this ensures that Kropotkin is _"a
great inspiration to the modern ecological movement."_ [Marshall, **Op. Cit.**
, p. 311 and p. 312]

As well as Kropotkin's work, special note must be made of French anarchist
Elisee Reclus. As Clark and Martin note, Reclus introduced _"a strongly
ecological dimension into the tradition of anarchist and libertarian social
theory"._ He made _"a powerful contribution to introducing this more
ecological perspective into anarchist thought,"_ of _"looking beyond the
project of planetary domination and attempting to restore humanity to its
rightful place within, rather than above, nature."_ Reclus, _"much more than
Kropotkin, introduced into anarchist theory themes that were later developed
in social ecology and eco-anarchism."_ [John P. Clark and Camille Martin
(ed.), **Anarchy, Geography, Modernity** , p. 19] For example, in 1866 Reclus
argued as follows:

> _"Wild nature is so beautiful. Is it really necessary for man, in seizing
> it, to proceed with mathematical precision in exploiting each new conquered
> domain and then mark his possession with vulgar constructions and perfectly
> straight boundaries? If this continues to occur, the harmonious contrasts
> that are one of the beauties of the earth will soon give way to depressing
> uniformity . . .  
>  _
>
> _"The question of knowing which of the works of man serves to beautify and
> which contributes to the degradation of external nature can seem pointless
> to so-called practical minds; nevertheless, it is a matter of the greatest
> importance. Humanity's development is most intimately connected with the
> nature that surrounds it. A secret harmony exists between the earth and the
> peoples whom it nourishes, and when reckless societies allow themselves to
> meddle with that which creates the beauty of their domain, they always end
> up regretting it."_ [quoted by Clark and Martin, **Op. Cit.** , pp. 125-6]

_"Man,"_ Reclus says, can find beauty in _"the intimate and deeply seated
harmony of his work with that of nature."_ Like the eco-anarchists a century
later, he stressed the social roots of our environmental problems arguing that
a _"complete union of Man with Nature can only be effected by the destruction
of the frontiers between castes as well as between peoples."_ He also
indicated that the exploitation of nature is part and parcel of capitalism,
for _"it matters little to the industrialist . . . whether he blackens the
atmosphere with fumes . . . or contaminates it with foul-smelling vapours."_
_"Since nature is so often desecrated by speculators precisely because of its
beauty,"_ Reclus argued, _"it is not surprising that farmers and
industrialists, in their own exploitative endeavours, fail to consider whether
they contribute to defacing the land."_ The capitalist is _"concerned not with
making his work harmonious with the landscape."_ [quoted by Clark and Martin,
**Op. Cit.** , p. 28, p. 30, p. 124 and p. 125] Few modern day eco-anarchists
would disagree.

So, while a specifically ecological anarchism did not develop until the
revolutionary work done by Murray Bookchin from the 1950's onwards, anarchist
theory has had a significant "proto-green" content since at least the 1860s.
What Bookchin and writers like him did was to make anarchism's implicit
ecological aspects explicit, a work which has immensely enriched anarchist
theory and practice.

In addition to pointing out the key role ecology plays within anarchism, this
section is required to refute some commonly proposed solutions to the
ecological problems we face. While it is wonderful that green ideas have
becoming increasingly commonplace, the sad fact is that many people have
jumped on the green bandwagon whose basic assumptions and practices are deeply
anti-ecological. Thus we find fascists expounding on their environmental
vision or defenders of capitalism proposing "ecological" solutions based on
expanding private property rights. Similarly, we find the notion of green
consumerism raised as viable means of greening the planet (rather than as an
addition to social struggle) or a focus on symptoms (such as population
growth) rather than root causes. This section refutes many such flawed
suggestions.

A key concept to remember in our discussion is that between environmentalism
and ecology. Following Bookchin, eco-anarchists contrast their ideas with
those who seek to reform capitalism and make it more green (a position they
term _"environmentalism"_ rather than ecology). The latter _"focus on specific
issues like air and water pollution"_ while ignoring the social roots of the
problems they are trying to solve. In other words, their outlook _"rest[s] on
an instrumental, almost engineering approach to solving ecological
dislocations. To all appearances, they wanted to adapt the natural world to
the needs of the existing society and its exploitative, capitalist imperatives
by way of reforms that minimise harm to human health and well-being. The much-
needed goals of formulating a project for radical social change and for
cultivating a new sensibility toward the natural world tended to fall outside
the orbit of their practical concerns."_ Eco-anarchists, while supporting such
partial struggles, stress that _"these problems originate in a hierarchical,
class, and today, competitive capitalist system that nourishes a view of the
natural world as a mere agglomeration of 'resources' for human production and
consumption."_ [ **The Ecology of Freedom** , pp. 15-6] This means that while
some kind of environmentalism may be possible under capitalism or some other
authoritarian system, an ecological approach is impossible. Simply put, the
concerns of ecology cannot be squeezed into a hierarchical perspective or
private property. Just as an eco-system cannot be commanded, divided and
enclosed, nor can a truly ecological vision. Attempts to do so will impoverish
both.

As we discuss in the [next section](secE1.md), for anarchists the root cause
of our ecological problems is hierarchy in society compounded by a capitalist
economy. For anarchists, the notion of an ecological capitalism is, literally,
impossible. Libertarian socialist Takis Fotopoulous has argued that the main
reason why the project of "greening" capitalism is just a utopian dream _"lies
in a fundamental contradiction that exists between the logic and dynamic of
the growth economy, on the one hand, and the attempt to condition this dynamic
with qualitative interests"_ on the other. [ _"Development or Democracy?"_ ,
pp. 57-92, **Society and Nature** , No. 7, p. 82] Green issues, like social
ones, are inherently qualitative in nature and, as such, it is unsurprising
that a system based on profit would ignore them.

Under capitalism, ethics, nature and humanity all have a price tag. And that
price tag is god. This is understandable as every hierarchical social system
requires a belief-system. Under feudalism, the belief-system came from the
Church, whereas under capitalism, it pretends to come from science, whose
biased practitioners (usually funded by the state and capital) are the new
priesthood. Like the old priesthoods, only those members who produce
"objective research" become famous and influential -- "objective research"
being that which accepts the status quo as "natural" and produces what the
elite want to hear (i.e. apologetics for capitalism and elite rule will always
be praised as "objective" and "scientific" regardless of its actual scientific
and factual content, the infamous "bell curve" and Malthus's "Law of
Population" being classic examples). More importantly, capitalism needs
science to be able to measure and quantify everything in order to sell it.
This mathematical faith is reflected in its politics and economics, where
quantity is more important than quality, where 5 votes are better than 2
votes, where $5 is better than $2. And like all religions, capitalism needs
sacrifice. In the name of "free enterprise," "economic efficiency,"
"stability" and "growth" it sacrifices individuality, freedom, humanity, and
nature for the power and profits of the few.

Understanding the social roots of the problems we face is the key. Many greens
attack what they consider the "wrong ideas" of modern society, its
"materialistic values" and counter-pose **new** ideas, more in tune with a
green society. This approach, however, misses the point. Ideas and values do
not "just happen", but are the **product** of a given set of social
relationships and the struggles they produce. This means that it is not just a
matter of changing our values in a way that places humanity in harmony with
nature (important though that is), but also of understanding the **social**
and **structural** origins of the ecological crisis. Ideas and values **do**
need to be challenged, but unless the authoritarian social relationships,
hierarchy and inequalities in power (i.e. what produces these values and
ideas) are also challenged and, more importantly, **changed** an ecological
society is impossible. So unless other Greens recognise that this crisis did
not develop in a social vacuum and is not the "fault" of people as **people**
(as opposed to people in a hierarchical society), little can be done root out
the systemic causes of the problems that we and the planet face.

Besides its alliance with the ecology movement, eco-anarchism also finds
allies in the feminist and peace movements, which it regards, like the ecology
movement, as implying the need for anarchist principles. Thus eco-anarchists
think that global competition between nation-states is responsible not only
for the devouring of nature but is also the primary cause of international
military tensions, as nations seek to dominate each other by military force or
the threat thereof. As international competition becomes more intense and
weapons of mass destruction spread, the seeds are being sown for catastrophic
global warfare involving nuclear, chemical, and/or biological weapons. Because
such warfare would be the ultimate ecological disaster, eco-anarchism and the
peace movement are but two aspects of the same basic project. Similarly, eco-
anarchists recognise that domination of nature and male domination of women
have historically gone hand in hand, so that eco-feminism is yet another
aspect of eco-anarchism. Since feminism, ecology, and peace are key issues of
the Green movement, anarchists believe that many Greens are implicitly
committed to anarchism, whether they realise it or not, and hence that they
should adopt anarchist principles of direct action rather than getting bogged
down in trying to elect people to state offices.

Here we discuss some of the main themes of eco-anarchism and consider a few
suggestions by non-anarchists about how to protect the environment. In
[section E.1](secE1.md), we summarise why anarchists consider why a green
society cannot be a capitalist one (and vice versa). [Section E.2](secE2.md)
presents a short overview of what an ecological society would be like.
[Section E.3](secE3.md) refutes the false capitalist claim that the answer
to the ecological crisis is to privatise everything while [section
E.4](secE4.md) discusses why capitalism is anti-ecological and its
defenders, invariably, anti-green. Then we indicate why green consumerism is
doomed to failure in [section E.5](secE5.md) before, in [section
E.6](secE6.md), refuting the myth that population growth is a **cause** of
ecological problems rather than the **effect** of deeper issues.

Obviously, these are hardly the end of the matter. Some tactics popular in the
green movement are shared by others and we discuss these elsewhere. For
example, the issue of electing Green Parties to power will be addressed in
section J.2.4 (["Surely voting for radical parties will be
effective?"](secJ2.md#secj24)) and so will be ignored here. The question of
"single-issue" campaigns (like C.N.D. and Friends of the Earth) will be
discussed in [section J.1.4](secJ1.md#secj14). Remember that eco-anarchists,
like all anarchists, take a keen interest in many other issues and struggles
and just because we do not discuss something here does not mean we are
indifferent to it.

For anarchists, unless we resolve the underlying contradictions within
society, which stem from domination, hierarchy and a capitalist economy,
ecological disruption will continue and grow, putting our Earth in increasing
danger. We need to resist the system and create new values based on quality,
not quantity. We must return the human factor to our alienated society before
we alienate ourselves completely off the planet.

Peter Marshall's **Nature's Web** presents a good overview of all aspects of
green thought over human history from a libertarian perspective, including
excellent summaries of such anarchists as Proudhon, Kropotkin and Bookchin (as
well as libertarian socialist William Morris and his ecologically balanced
utopia **News from Nowhere** ).

[‹ Section E - What do anarchists think causes ecological
problems?](secEcon.md "Go to previous page") [up](secEcon.md "Go to parent
page") [E.1 What are the root causes of our ecological problems? ›](secE1.md
"Go to next page")

