//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Mask/MaskGraphicsProxy.h
//! @brief     Defines class MaskGraphicsProxy
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_MASK_MASKGRAPHICSPROXY_H
#define BORNAGAIN_GUI_VIEW_MASK_MASKGRAPHICSPROXY_H

#include "GUI/View/Mask/MaskEditorHelper.h"
#include <QGraphicsProxyWidget>

class ColorMap;
class ColorMapSceneAdaptor;
class IntensityDataItem;
class ISceneAdaptor;

//! Graphics proxy to place QWidget inside QGraphicsScene, used by MaskEditorCanvas.

class MaskGraphicsProxy : public QGraphicsProxyWidget {
    Q_OBJECT
public:
    MaskGraphicsProxy();
    ~MaskGraphicsProxy() override;

    int type() const override { return MaskEditorHelper::MASKGRAPHICSPROXY; }

    void setIntensityItem(IntensityDataItem* intensityDataItem);
    void setSceneAdaptor(ISceneAdaptor* sceneAdaptor);
    void setInZoomMode(bool value);

    ColorMap* colorMap();

private:
    void mousePressEvent(QGraphicsSceneMouseEvent* event) override;
    void mouseMoveEvent(QGraphicsSceneMouseEvent* event) override;
    void mouseReleaseEvent(QGraphicsSceneMouseEvent* event) override;
    void wheelEvent(QGraphicsSceneWheelEvent* event) override;

    ColorMap* m_colorMap;
    ColorMapSceneAdaptor* m_sceneAdaptor;
    bool m_send_signals_to_colormap;
};

#endif // BORNAGAIN_GUI_VIEW_MASK_MASKGRAPHICSPROXY_H
