//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Plot2D/IntensityDataFFTPresenter.h
//! @brief     Defines class IntensityDataFFTPresenter
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_PLOT2D_INTENSITYDATAFFTPRESENTER_H
#define BORNAGAIN_GUI_VIEW_PLOT2D_INTENSITYDATAFFTPRESENTER_H

#include <QAction>
#include <QWidget>

class IntensityDataItem;

//! Provides support in Fast Fourier transformation of IntensityDataItem.
//! Contains own IntensityDataItem instance with fft-transformed results.

class IntensityDataFFTPresenter : public QObject {
    Q_OBJECT
public:
    IntensityDataFFTPresenter(QWidget* parent = nullptr);

    void reset();

    IntensityDataItem* fftItem(IntensityDataItem* origItem);

    QList<QAction*> actionList();

    bool inFFTMode() const;

signals:
    void fftActionRequest();

private slots:
    void onFFTActionToggled(bool toggled);

private:
    QAction* m_fftAction;
    std::unique_ptr<IntensityDataItem> m_fftItem;
    bool m_in_fft_mode;
};

#endif // BORNAGAIN_GUI_VIEW_PLOT2D_INTENSITYDATAFFTPRESENTER_H
