//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      Img3D/Type/CameraParams.cpp
//! @brief     Implements struct CameraParams
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#include "Img3D/Type/CameraParams.h"

namespace Img3D {

namespace {

F3 interpolateF3(const F3& from, const F3& to, float rat)
{
    return from * (1 - rat) + to * rat;
}

} // namespace

CameraParams::CameraParams(const F3& eye_, const F3& ctr_, const F3& up_, QQuaternion const& rot_)
    : eye(eye_)
    , ctr(ctr_)
    , up(up_)
    , rot(rot_)
{
}

CameraParams CameraParams::interpolateTo(const CameraParams& to, float r) const
{
    return CameraParams(interpolateF3(eye, to.eye, r), interpolateF3(ctr, to.ctr, r),
                        interpolateF3(up, to.up, r), QQuaternion::slerp(rot, to.rot, r));
}

} // namespace Img3D
