/*******************************************************************************
*
*       This file is part of the General Hidden Markov Model Library,
*       GHMM version __VERSION__, see http://ghmm.org
*
*       Filename: ghmm/ghmm/smixturehmm.h
*       Authors:  Bernd Wichern
*
*       Copyright (C) 1998-2004 Alexander Schliep 
*       Copyright (C) 1998-2001 ZAIK/ZPR, Universitaet zu Koeln
*	Copyright (C) 2002-2004 Max-Planck-Institut fuer Molekulare Genetik, 
*                               Berlin
*                                   
*       Contact: schliep@ghmm.org             
*
*       This library is free software; you can redistribute it and/or
*       modify it under the terms of the GNU Library General Public
*       License as published by the Free Software Foundation; either
*       version 2 of the License, or (at your option) any later version.
*
*       This library is distributed in the hope that it will be useful,
*       but WITHOUT ANY WARRANTY; without even the implied warranty of
*       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*       Library General Public License for more details.
*
*       You should have received a copy of the GNU Library General Public
*       License along with this library; if not, write to the Free
*       Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*
*
*       This file is version $Revision: 2276 $ 
*                       from $Date: 2009-04-28 08:41:29 -0400 (Tue, 28 Apr 2009) $
*             last change by $Author: grunau $.
*
*******************************************************************************/

#include "ghmmconfig.h"

#ifdef GHMM_OBSOLETE

#ifndef GHMM_SMIXTUREHMM_H
#define GHMM_SMIXTUREHMM_H

#ifdef __cplusplus
extern "C" {
#endif

#include "sequence.h"
#include "smodel.h"

/**
   @name mixture-shmm methods
 */

/**
 */
  int ghmm_smixturehmm_cluster (FILE * outfile, double **cp, ghmm_cseq * sqd,
                           ghmm_cmodel ** smo, int smo_number);

/**
 */
  double smixturehmm_like (ghmm_cmodel ** smo, int smo_number,
                           ghmm_cseq * sqd_test, long *errors);

/**
 */
  int ghmm_smixturehmm_init (double **cp, ghmm_cseq * sqd, ghmm_cmodel ** smo,
                        int smo_number, int mode);

/**
 */
  int smixturehmm_calc_priors (double **cp, ghmm_cseq * sqd, ghmm_cmodel ** smo,
                               int smo_number);

/**
 */
  int ghmm_smixturehmm_calc_cp (double **cp, ghmm_cseq * sqd, ghmm_cmodel ** smo,
                           int smo_number, double *total_train_w);

/**
*/
  void ghmm_smixture_calc_logp (double **logp, int **error, ghmm_cseq * sqd,
                           ghmm_cmodel ** smo, int smo_number);

/**
 */
  void ghmm_smixturehmm_print_header (FILE * file, char *argv[], int flag);


/**
 */
  double *ghmm_smixturehmm_avg_like (double **cp, ghmm_cseq * sqd,
                                ghmm_cmodel ** smo, int smo_number);
#ifdef __cplusplus
}
#endif

#endif                          /* GHMM_SMIXTUREHMM_H */

#endif /* GHMM_OBSOLETE */
