package machinelearningservices

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// WorkspaceClient is the these APIs allow end users to operate on Azure Machine Learning Workspace resources.
type WorkspaceClient struct {
	BaseClient
}

// NewWorkspaceClient creates an instance of the WorkspaceClient client.
func NewWorkspaceClient(subscriptionID string) WorkspaceClient {
	return NewWorkspaceClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewWorkspaceClientWithBaseURI creates an instance of the WorkspaceClient client using a custom endpoint.  Use this
// when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewWorkspaceClientWithBaseURI(baseURI string, subscriptionID string) WorkspaceClient {
	return WorkspaceClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// ListSkus lists all skus with associated features
func (client WorkspaceClient) ListSkus(ctx context.Context) (result SkuListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkspaceClient.ListSkus")
		defer func() {
			sc := -1
			if result.slr.Response.Response != nil {
				sc = result.slr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listSkusNextResults
	req, err := client.ListSkusPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "machinelearningservices.WorkspaceClient", "ListSkus", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSkusSender(req)
	if err != nil {
		result.slr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "machinelearningservices.WorkspaceClient", "ListSkus", resp, "Failure sending request")
		return
	}

	result.slr, err = client.ListSkusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "machinelearningservices.WorkspaceClient", "ListSkus", resp, "Failure responding to request")
		return
	}
	if result.slr.hasNextLink() && result.slr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListSkusPreparer prepares the ListSkus request.
func (client WorkspaceClient) ListSkusPreparer(ctx context.Context) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-04-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.MachineLearningServices/workspaces/skus", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSkusSender sends the ListSkus request. The method will close the
// http.Response Body if it receives an error.
func (client WorkspaceClient) ListSkusSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListSkusResponder handles the response to the ListSkus request. The method always
// closes the http.Response Body.
func (client WorkspaceClient) ListSkusResponder(resp *http.Response) (result SkuListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listSkusNextResults retrieves the next set of results, if any.
func (client WorkspaceClient) listSkusNextResults(ctx context.Context, lastResults SkuListResult) (result SkuListResult, err error) {
	req, err := lastResults.skuListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "machinelearningservices.WorkspaceClient", "listSkusNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSkusSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "machinelearningservices.WorkspaceClient", "listSkusNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListSkusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "machinelearningservices.WorkspaceClient", "listSkusNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListSkusComplete enumerates all values, automatically crossing page boundaries as required.
func (client WorkspaceClient) ListSkusComplete(ctx context.Context) (result SkuListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkspaceClient.ListSkus")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListSkus(ctx)
	return
}
