/* -*- c++ -*- */
/*
 * @file
 * @author (C) 2018 by Piotr Krysik <ptrkrysik@gmail.com>
 * @section LICENSE
 *
 * Gr-gsm is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * Gr-gsm is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gr-gsm; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street,
 * Boston, MA 02110-1301, USA.
 */

#ifndef INCLUDED_GSM_EXTRACT_ASSIGNMENT_CMD_IMPL_H
#define INCLUDED_GSM_EXTRACT_ASSIGNMENT_CMD_IMPL_H

#include <gsm/misc_utils/extract_assignment_cmd.h>
#include <vector>

namespace gr {
  namespace gsm {          
    class extract_assignment_cmd_impl : public extract_assignment_cmd
    {
     private:
      void process_messages(pmt::pmt_t msg);
      std::vector<int> d_assignment_commands;
     public:
      virtual std::vector<int> get_assignment_commands();
      extract_assignment_cmd_impl();
      ~extract_assignment_cmd_impl();
    };
  } // namespace gsm
} // namespace gr
#endif /* INCLUDED_GSM_EXTRACT_ASSIGNMENT_CMD_IMPL_H */
