Hellfire
========

_PAT**H**spider **E**ffects **Li**st **Re**solver_

[![Travis](https://img.shields.io/travis/irl/hellfire.svg)](https://travis-ci.org/irl/hellfire)
[![GoDoc](https://godoc.org/github.com/irl/hellfire?status.svg)](https://godoc.org/github.com/irl/hellfire)

Hellfire is a parallelised DNS resolver. It is written in Go and for the
purpose of generating input lists to [PATHspider](https://pathspider.net/),
though may be useful for other applications.


Install
-------
Debian 10 or above:

```$ apt install hellfire```

Go:

```$ go get pathspider.net/hellfire/cmd/hellfire```

Input and Output Formats
------------------------

The following input formats are supported:

 * [Alexa Topsites](http://www.alexa.com/topsites)
 * [Cisco Umbrella Popularity
   List](http://s3-us-west-1.amazonaws.com/umbrella-static/index.html)
 * [Citizen Lab Test
   Lists](https://github.com/citizenlab/test-lists/tree/master/lists) (by
   country)
 * [OpenDNS Public Domain Lists](https://github.com/opendns/public-domain-lists)
 * Plain text (not implemented yet)
 * JSON (not implemented yet)

Extra metadata can be declared to Hellfire that will be present in the jobs
when output. The output format is [NDJSON](http://specs.okfnlabs.org/ndjson/)
(not yet implemented) using the native input schema for PATHspider.

Services
--------

As well as looking up the A and AAAA records for the domain directly, it is
also possible to select indirect lookups for the addresses of the mail
exchanger (not yet implemented) and the name server (not yet implemented).

Copyright
---------

    Copyright (c) 2016 Iain R. Learmonth <irl@fsfe.org>
    All rights reserved.
    
    Redistribution and use in source and binary forms, with or without
    modification, are permitted provided that the following conditions are met:
    
    1. Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
    
    2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.
    
    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
    AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
    IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
    ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
    LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
    CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
    SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
    INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
    CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
    ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
    POSSIBILITY OF SUCH DAMAGE.
