/* Generated by re2c 3.1 on Thu Jan  4 05:01:04 2024 */
#line 1 "preprocessor.re"
#include <iostream>
#include <map>

#include <lfortran/parser/preprocessor.h>
#include <libasr/assert.h>
#include <lfortran/utils.h>
#include <libasr/string_utils.h>

namespace LCompilers::LFortran {

CPreprocessor::CPreprocessor(CompilerOptions &compiler_options)
    : compiler_options{compiler_options} {
    CPPMacro md;
    md.expansion = "1";
    macro_definitions["__LFORTRAN__"] = md;
    md.expansion = "\"" + std::string(LFORTRAN_VERSION) + "\"";
    macro_definitions["__VERSION__"] = md;
    md.expansion = std::to_string(LFORTRAN_MAJOR);
    macro_definitions["__LFORTRAN_MAJOR__"] = md;
    md.expansion = std::to_string(LFORTRAN_MINOR);
    macro_definitions["__LFORTRAN_MINOR__"] = md;
    md.expansion = std::to_string(LFORTRAN_PATCHLEVEL);
    macro_definitions["__LFORTRAN_PATCHLEVEL__"] = md;
    if (compiler_options.platform == Platform::Windows) {
        md.expansion = "1";
        macro_definitions["_WIN32"] = md;
    }
    for (auto &d : compiler_options.c_preprocessor_defines) {
        std::size_t idx = d.find("=");
        if (idx != std::string::npos) {
            md.expansion = d.substr(idx+1);
            d = d.substr(0, idx);
        } else {
            md.expansion = "1";
        }
        macro_definitions[d] = md;
    }

    md.expansion = "\"\"";
    macro_definitions["__FILE__"] = md;
    md.expansion = "0";
    macro_definitions["__LINE__"] = md;
}
std::string CPreprocessor::token(unsigned char *tok, unsigned char* cur) const
{
    return std::string((char *)tok, cur - tok);
}

void handle_continuation_lines(std::string &s, unsigned char *&cur);

std::string parse_continuation_lines(unsigned char *&cur) {
    std::string output;
    while (*cur != '\n') {
        output += *cur;
        cur++;
    }
    cur++;
    handle_continuation_lines(output, cur);
    return output;
}

void handle_continuation_lines(std::string &s, unsigned char *&cur) {
    if (s.size() > 0 && s[s.size()-1] == '\\') {
        s = s.substr(0, s.size()-1);
        s += parse_continuation_lines(cur);
    }
}

// Parse a macro declaration argument, e.g. in:
// f(a,b, c,  d  )
std::string parse_argument(unsigned char *&cur) {
    std::string arg;
    while (*cur == ' ' && *cur != '\0') cur++;
    while (*cur != ')' && *cur != ',' && *cur != ' ') {
        if (*cur == '\0') {
            throw LCompilersException("C preprocessor: runaway argument");
        }
        arg += *cur;
        cur++;
    }
    while (*cur == ' ' && *cur != '\0') cur++;
    if (*cur == '\0') {
        throw LCompilersException("C preprocessor: runaway argument");
    }
    return arg;
}

std::string match_parentheses(unsigned char *&cur) {
    LCOMPILERS_ASSERT(*cur == '(')
    std::string arg;
    arg += *cur;
    cur++;
    while (*cur != ')') {
        if (*cur == '\0') {
            throw LCompilersException("C preprocessor: unmatched parentheses");
        }
        if (*cur == '(') {
            arg += match_parentheses(cur);
            LCOMPILERS_ASSERT(*cur == ')')
        } else {
            arg += *cur;
        }
        cur++;
    }
    arg += *cur;
    return arg;
}

// Parse a macro call argument, e.g. in:
// ASSERT(fn(3, 5))
std::string parse_argument2(unsigned char *&cur) {
    std::string arg;
    while (*cur != ')' && *cur != ',') {
        if (*cur == '\0') {
            throw LCompilersException("C preprocessor: runaway argument");
        }
        if (*cur == '(') {
            arg += match_parentheses(cur);
            LCOMPILERS_ASSERT(*cur == ')')
        } else {
            arg += *cur;
        }
        cur++;
    }
    return arg;
}

std::vector<std::string> parse_arguments(unsigned char *&cur, bool skip_spaces) {
    std::vector<std::string> args;
    LCOMPILERS_ASSERT(*cur == '(');
    cur++;
    while (*cur != ')') {
        if (skip_spaces) {
            args.push_back(parse_argument(cur));
        } else {
            args.push_back(parse_argument2(cur));
        }
        if (*cur == ',') cur++;
    }
    return args;
}

void interval_end(LocationManager &lm, size_t output_len,
                size_t input_len, size_t input_interval_len,
                uint32_t interval_type) {
    lm.files.back().out_start0.push_back(output_len);
    lm.files.back().in_start0.push_back(input_len);
    lm.files.back().in_size0.push_back(input_interval_len);
    lm.files.back().interval_type0.push_back(interval_type);
}

void interval_end_type_0(LocationManager &lm, size_t output_len,
                size_t input_len) {
    size_t input_interval_len = output_len - lm.files.back().out_start0.back();
    interval_end(lm, output_len, input_len, input_interval_len, 0);
}

struct IfDef {
    bool active=true;
    bool branch_enabled=true;
};

namespace {

int parse_bexpr(unsigned char *&cur, const cpp_symtab &macro_definitions);

}

std::string CPreprocessor::run(const std::string &input, LocationManager &lm,
        cpp_symtab &macro_definitions) const {
    LCOMPILERS_ASSERT(input[input.size()] == '\0');
    unsigned char *string_start=(unsigned char*)(&input[0]);
    unsigned char *cur = string_start;
    std::string output;
    lm.files.back().preprocessor = true;
    lm.get_newlines(input, lm.files.back().in_newlines0);
    lm.files.back().out_start0.push_back(0);
    lm.files.back().in_start0.push_back(0);
    std::vector<IfDef> ifdef_stack;
    bool branch_enabled = true;
    macro_definitions["__FILE__"].expansion = "\"" + lm.files.back().in_filename + "\"";
    for (;;) {
        unsigned char *tok = cur;
        unsigned char *mar;
        unsigned char *t1, *t2, *t3, *t4;
        
#line 190 "preprocessor.cpp"
unsigned char *yyt1;
unsigned char *yyt2;
unsigned char *yyt3;
unsigned char *yyt4;
#line 186 "preprocessor.re"

        
#line 198 "preprocessor.cpp"
{
	unsigned char yych;
	unsigned int yyaccept = 0;
	static const unsigned char yybm[] = {
		  0, 176, 176, 176, 176, 176, 176, 176, 
		176, 240, 160, 240, 176, 240, 176, 176, 
		176, 176, 176, 176, 176, 176, 176, 176, 
		176, 176, 176, 176, 176, 176, 176, 176, 
		240, 176, 144, 176, 176, 176, 176,  48, 
		176, 176, 176, 176, 176, 176, 176, 176, 
		184, 184, 184, 184, 184, 184, 184, 184, 
		184, 184, 176, 176, 176, 176, 176, 176, 
		176, 184, 184, 184, 184, 184, 184, 184, 
		184, 184, 184, 184, 184, 184, 184, 184, 
		184, 184, 184, 184, 184, 184, 184, 184, 
		184, 184, 184, 176, 176, 176, 176, 184, 
		176, 184, 184, 184, 184, 184, 184, 184, 
		184, 184, 184, 184, 184, 184, 184, 184, 
		184, 184, 184, 184, 184, 184, 184, 184, 
		184, 184, 184, 176, 176, 176, 176, 176, 
		176, 176, 176, 176, 176, 176, 176, 176, 
		176, 176, 176, 176, 176, 176, 176, 176, 
		176, 176, 176, 176, 176, 176, 176, 176, 
		176, 176, 176, 176, 176, 176, 176, 176, 
		176, 176, 176, 176, 176, 176, 176, 176, 
		176, 176, 176, 176, 176, 176, 176, 176, 
		176, 176, 176, 176, 176, 176, 176, 176, 
		176, 176, 176, 176, 176, 176, 176, 176, 
		176, 176, 176, 176, 176, 176, 176, 176, 
		176, 176, 176, 176, 176, 176, 176, 176, 
		176, 176, 176, 176, 176, 176, 176, 176, 
		176, 176, 176, 176, 176, 176, 176, 176, 
		176, 176, 176, 176, 176, 176, 176, 176, 
		176, 176, 176, 176, 176, 176, 176, 176, 
		176, 176, 176, 176, 176, 176, 176, 176, 
		176, 176, 176, 176, 176, 176, 176, 176, 
	};
	yych = *cur;
	if (yych <= '.') {
		if (yych <= '"') {
			if (yych <= 0x00) goto yy1;
			if (yych <= ' ') goto yy2;
			if (yych <= '!') goto yy4;
			goto yy5;
		} else {
			if (yych <= '#') goto yy6;
			if (yych == '\'') goto yy7;
			goto yy2;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '/') goto yy8;
			if (yych <= '@') goto yy2;
			if (yych <= 'Z') goto yy9;
			goto yy2;
		} else {
			if (yych == '`') goto yy2;
			if (yych <= 'z') goto yy9;
			goto yy2;
		}
	}
yy1:
	++cur;
#line 209 "preprocessor.re"
	{
                break;
            }
#line 266 "preprocessor.cpp"
yy2:
	++cur;
yy3:
#line 204 "preprocessor.re"
	{
                if (!branch_enabled) continue;
                output.append(token(tok, cur));
                continue;
            }
#line 276 "preprocessor.cpp"
yy4:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych <= 0x00) goto yy3;
	goto yy11;
yy5:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych <= 0x00) goto yy3;
	goto yy15;
yy6:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych <= 0x1F) {
		if (yych <= '\n') {
			if (yych == '\t') goto yy18;
			goto yy3;
		} else {
			if (yych == '\f') goto yy3;
			if (yych <= '\r') goto yy18;
			goto yy3;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= ' ') goto yy18;
			if (yych <= 'c') goto yy3;
			if (yych <= 'e') goto yy18;
			goto yy3;
		} else {
			if (yych <= 'i') goto yy18;
			if (yych == 'u') goto yy18;
			goto yy3;
		}
	}
yy7:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych <= 0x00) goto yy3;
	goto yy24;
yy8:
	yych = *++cur;
	if (yych == '*') goto yy26;
	goto yy3;
yy9:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy9;
	}
#line 392 "preprocessor.re"
	{
                if (!branch_enabled) continue;
                std::string t = token(tok, cur);
                if (macro_definitions.find(t) != macro_definitions.end()) {
                    // Prepare the start of the interval
                    interval_end_type_0(lm, output.size(), tok-string_start);

                    // Expand the macro once
                    std::string expansion;
                    if (macro_definitions[t].function_like) {
                        if (*cur != '(') {
                            throw LCompilersException("C preprocessor: function-like macro invocation must have argument list");
                        }
                        std::vector<std::string> args;
                        args = parse_arguments(cur, false);
                        if (*cur != ')') {
                            throw LCompilersException("C preprocessor: expected )");
                        }
                        cur++;
                        expansion = function_like_macro_expansion(
                            macro_definitions[t].args,
                            macro_definitions[t].expansion,
                            args);
                    } else {
                        if (t == "__LINE__") {
                            uint32_t line;
                            if (lm.files.back().current_line == 0) {
                                uint32_t pos = cur-string_start;
                                uint32_t col;
                                std::string filename;
                                lm.pos_to_linecol(pos, line, col, filename);
                            } else {
                                line = lm.files.back().current_line;
                            }
                            expansion = std::to_string(line);
                        } else {
                            expansion = macro_definitions[t].expansion;
                        }
                    }

                    // Recursively expand the expansion
                    std::string expansion2;
                    int i = 0;
                    while (expansion2 != expansion) {
                        expansion2 = expansion;
                        LocationManager lm_tmp = lm; // Make a copy

                        uint32_t pos = cur-string_start;
                        uint32_t line, col;
                        std::string filename;
                        lm.pos_to_linecol(pos, line, col, filename);
                        lm_tmp.files.back().current_line = line;

                        expansion = run(expansion2, lm_tmp, macro_definitions);
                        i++;
                        if (i == 40) {
                            throw LCompilersException("C preprocessor: maximum recursion limit reached");
                        }
                    }

                    // Output the final recursively expanded macro
                    output.append(expansion);

                    // Prepare the end of the interval
                    interval_end(lm, output.size(), cur-string_start,
                        t.size(), 1);
                } else {
                    output.append(t);
                }
                continue;
            }
#line 397 "preprocessor.cpp"
yy10:
	yych = *++cur;
yy11:
	if (yybm[0+yych] & 16) {
		goto yy10;
	}
	if (yych >= 0x01) goto yy13;
yy12:
	cur = mar;
	if (yyaccept <= 1) {
		if (yyaccept == 0) {
			goto yy3;
		} else {
			goto yy16;
		}
	} else {
		goto yy25;
	}
yy13:
	++cur;
#line 212 "preprocessor.re"
	{
                if (!branch_enabled) continue;
                output.append(token(tok, cur));
                continue;
            }
#line 424 "preprocessor.cpp"
yy14:
	yych = *++cur;
yy15:
	if (yybm[0+yych] & 32) {
		goto yy14;
	}
	if (yych <= 0x00) goto yy12;
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych == '"') goto yy14;
yy16:
#line 463 "preprocessor.re"
	{
                if (!branch_enabled) continue;
                output.append(token(tok, cur));
                continue;
            }
#line 442 "preprocessor.cpp"
yy17:
	yych = *++cur;
yy18:
	if (yybm[0+yych] & 64) {
		goto yy17;
	}
	if (yych <= 'h') {
		if (yych <= 'c') goto yy12;
		if (yych <= 'd') goto yy19;
		if (yych <= 'e') goto yy20;
		goto yy12;
	} else {
		if (yych <= 'i') goto yy21;
		if (yych == 'u') goto yy22;
		goto yy12;
	}
yy19:
	yych = *++cur;
	if (yych == 'e') goto yy27;
	goto yy12;
yy20:
	yych = *++cur;
	if (yych == 'l') goto yy28;
	if (yych == 'n') goto yy29;
	goto yy12;
yy21:
	yych = *++cur;
	if (yych == 'f') goto yy30;
	if (yych == 'n') goto yy31;
	goto yy12;
yy22:
	yych = *++cur;
	if (yych == 'n') goto yy32;
	goto yy12;
yy23:
	yych = *++cur;
yy24:
	if (yybm[0+yych] & 128) {
		goto yy23;
	}
	if (yych <= 0x00) goto yy12;
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yych == '\'') goto yy23;
yy25:
#line 468 "preprocessor.re"
	{
                if (!branch_enabled) continue;
                output.append(token(tok, cur));
                continue;
            }
#line 494 "preprocessor.cpp"
yy26:
	++cur;
#line 473 "preprocessor.re"
	{
                if (!branch_enabled) continue;
                cur++;
                while (!(*cur == '/' && *(cur - 1) == '*')) {
                    cur++;
                }
                cur++;
                interval_end_type_0(lm, output.size(), cur-string_start);
                continue;
            }
#line 508 "preprocessor.cpp"
yy27:
	yych = *++cur;
	if (yych == 'f') goto yy33;
	goto yy12;
yy28:
	yych = *++cur;
	if (yych == 's') goto yy34;
	goto yy12;
yy29:
	yych = *++cur;
	if (yych == 'd') goto yy35;
	goto yy12;
yy30:
	yych = *++cur;
	if (yych <= '\r') {
		if (yych <= '\n') {
			if (yych == '\t') goto yy36;
			goto yy12;
		} else {
			if (yych == '\f') goto yy12;
			goto yy36;
		}
	} else {
		if (yych <= 'c') {
			if (yych == ' ') goto yy36;
			goto yy12;
		} else {
			if (yych <= 'd') goto yy37;
			if (yych == 'n') goto yy38;
			goto yy12;
		}
	}
yy31:
	yych = *++cur;
	if (yych == 'c') goto yy39;
	goto yy12;
yy32:
	yych = *++cur;
	if (yych == 'd') goto yy40;
	goto yy12;
yy33:
	yych = *++cur;
	if (yych == 'i') goto yy41;
	goto yy12;
yy34:
	yych = *++cur;
	if (yych == 'e') goto yy42;
	goto yy12;
yy35:
	yych = *++cur;
	if (yych == 'i') goto yy43;
	goto yy12;
yy36:
	yych = *++cur;
	if (yych <= '\v') {
		if (yych <= 0x08) {
			if (yych <= 0x00) goto yy12;
			yyt1 = cur;
			goto yy44;
		} else {
			if (yych == '\n') {
				yyt1 = cur;
				goto yy45;
			}
			goto yy36;
		}
	} else {
		if (yych <= '\r') {
			if (yych <= '\f') {
				yyt1 = cur;
				goto yy44;
			}
			goto yy36;
		} else {
			if (yych == ' ') goto yy36;
			yyt1 = cur;
			goto yy44;
		}
	}
yy37:
	yych = *++cur;
	if (yych == 'e') goto yy46;
	goto yy12;
yy38:
	yych = *++cur;
	if (yych == 'd') goto yy47;
	goto yy12;
yy39:
	yych = *++cur;
	if (yych == 'l') goto yy48;
	goto yy12;
yy40:
	yych = *++cur;
	if (yych == 'e') goto yy49;
	goto yy12;
yy41:
	yych = *++cur;
	if (yych == 'n') goto yy50;
	goto yy12;
yy42:
	yych = *++cur;
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy12;
			goto yy42;
		} else {
			if (yych <= '\n') goto yy51;
			if (yych <= '\v') goto yy42;
			goto yy12;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy42;
			if (yych <= 0x1F) goto yy12;
			goto yy42;
		} else {
			if (yych == '/') goto yy52;
			goto yy12;
		}
	}
yy43:
	yych = *++cur;
	if (yych == 'f') goto yy53;
	goto yy12;
yy44:
	yych = *++cur;
	if (yych <= 0x00) goto yy12;
	if (yych != '\n') goto yy44;
yy45:
	++cur;
	t1 = yyt1;
	t2 = cur - 1;
#line 298 "preprocessor.re"
	{
                IfDef ifdef;
                ifdef.active = branch_enabled;
                if (ifdef.active) {
                    bool test_true = parse_bexpr(t1, macro_definitions) > 0;
                    cur = t1;
                    if (test_true) {
                        ifdef.branch_enabled = true;
                    } else {
                        ifdef.branch_enabled = false;
                    }
                    branch_enabled = ifdef.branch_enabled;
                } else {
                    ifdef.branch_enabled = false;
                }
                ifdef_stack.push_back(ifdef);
                if (!ifdef.active) continue;

                interval_end_type_0(lm, output.size(), cur-string_start);
                continue;
            }
#line 663 "preprocessor.cpp"
yy46:
	yych = *++cur;
	if (yych == 'f') goto yy54;
	goto yy12;
yy47:
	yych = *++cur;
	if (yych == 'e') goto yy55;
	goto yy12;
yy48:
	yych = *++cur;
	if (yych == 'u') goto yy56;
	goto yy12;
yy49:
	yych = *++cur;
	if (yych == 'f') goto yy57;
	goto yy12;
yy50:
	yych = *++cur;
	if (yych == 'e') goto yy58;
	goto yy12;
yy51:
	++cur;
#line 319 "preprocessor.re"
	{
                if (ifdef_stack.size() == 0) {
                    throw LCompilersException("C preprocessor: #else encountered outside of #ifdef or #ifndef");
                }
                IfDef ifdef = ifdef_stack[ifdef_stack.size()-1];
                if (ifdef.active) {
                    ifdef.branch_enabled = !ifdef.branch_enabled;
                    branch_enabled = ifdef.branch_enabled;
                } else {
                    continue;
                }

                interval_end_type_0(lm, output.size(), cur-string_start);
                continue;
            }
#line 702 "preprocessor.cpp"
yy52:
	yych = *++cur;
	if (yych == '/') goto yy59;
	goto yy12;
yy53:
	yych = *++cur;
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy12;
			goto yy53;
		} else {
			if (yych <= '\n') goto yy60;
			if (yych <= '\v') goto yy53;
			goto yy12;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy53;
			if (yych <= 0x1F) goto yy12;
			goto yy53;
		} else {
			if (yych == '/') goto yy61;
			goto yy12;
		}
	}
yy54:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '@') goto yy63;
		if (yych <= 'Z') goto yy12;
		goto yy63;
	} else {
		if (yych == '`') goto yy63;
		if (yych <= 'z') goto yy12;
		goto yy63;
	}
yy55:
	yych = *++cur;
	if (yych == 'f') goto yy64;
	goto yy12;
yy56:
	yych = *++cur;
	if (yych == 'd') goto yy65;
	goto yy12;
yy57:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '@') goto yy67;
		if (yych <= 'Z') goto yy12;
		goto yy67;
	} else {
		if (yych == '`') goto yy67;
		if (yych <= 'z') goto yy12;
		goto yy67;
	}
yy58:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '@') goto yy69;
		if (yych <= 'Z') goto yy12;
		goto yy69;
	} else {
		if (yych == '`') goto yy69;
		if (yych <= 'z') goto yy12;
		goto yy69;
	}
yy59:
	yych = *++cur;
	if (yych <= 0x00) goto yy12;
	if (yych == '\n') goto yy51;
	goto yy59;
yy60:
	++cur;
#line 334 "preprocessor.re"
	{
                if (ifdef_stack.size() == 0) {
                    throw LCompilersException("C preprocessor: #endif encountered outside of #ifdef or #ifndef");
                }
                IfDef ifdef = ifdef_stack[ifdef_stack.size()-1];
                ifdef_stack.pop_back();
                if (ifdef.active) {
                    branch_enabled = true;
                } else {
                    continue;
                }

                interval_end_type_0(lm, output.size(), cur-string_start);
                continue;
            }
#line 792 "preprocessor.cpp"
yy61:
	yych = *++cur;
	if (yych == '/') goto yy70;
	goto yy12;
yy62:
	yych = *++cur;
yy63:
	if (yych <= 0x1F) {
		if (yych <= '\n') {
			if (yych == '\t') goto yy62;
			goto yy12;
		} else {
			if (yych == '\f') goto yy12;
			if (yych <= '\r') goto yy62;
			goto yy12;
		}
	} else {
		if (yych <= '^') {
			if (yych <= ' ') goto yy62;
			if (yych <= '@') goto yy12;
			if (yych <= 'Z') {
				yyt1 = cur;
				goto yy71;
			}
			goto yy12;
		} else {
			if (yych == '`') goto yy12;
			if (yych <= 'z') {
				yyt1 = cur;
				goto yy71;
			}
			goto yy12;
		}
	}
yy64:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '@') goto yy73;
		if (yych <= 'Z') goto yy12;
		goto yy73;
	} else {
		if (yych == '`') goto yy73;
		if (yych <= 'z') goto yy12;
		goto yy73;
	}
yy65:
	yych = *++cur;
	if (yych == 'e') goto yy74;
	goto yy12;
yy66:
	yych = *++cur;
yy67:
	if (yych <= 0x1F) {
		if (yych <= '\n') {
			if (yych == '\t') goto yy66;
			goto yy12;
		} else {
			if (yych == '\f') goto yy12;
			if (yych <= '\r') goto yy66;
			goto yy12;
		}
	} else {
		if (yych <= '^') {
			if (yych <= ' ') goto yy66;
			if (yych <= '@') goto yy12;
			if (yych <= 'Z') {
				yyt1 = cur;
				goto yy75;
			}
			goto yy12;
		} else {
			if (yych == '`') goto yy12;
			if (yych <= 'z') {
				yyt1 = cur;
				goto yy75;
			}
			goto yy12;
		}
	}
yy68:
	yych = *++cur;
yy69:
	if (yych <= 0x1F) {
		if (yych <= '\n') {
			if (yych == '\t') goto yy68;
			goto yy12;
		} else {
			if (yych == '\f') goto yy12;
			if (yych <= '\r') goto yy68;
			goto yy12;
		}
	} else {
		if (yych <= '^') {
			if (yych <= ' ') goto yy68;
			if (yych <= '@') goto yy12;
			if (yych <= 'Z') {
				yyt1 = cur;
				goto yy76;
			}
			goto yy12;
		} else {
			if (yych == '`') goto yy12;
			if (yych <= 'z') {
				yyt1 = cur;
				goto yy76;
			}
			goto yy12;
		}
	}
yy70:
	yych = *++cur;
	if (yych <= 0x00) goto yy12;
	if (yych == '\n') goto yy60;
	goto yy70;
yy71:
	yych = *++cur;
	if (yych <= ' ') {
		if (yych <= '\v') {
			if (yych <= 0x08) goto yy12;
			if (yych == '\n') {
				yyt2 = cur;
				goto yy78;
			}
			yyt2 = cur;
			goto yy77;
		} else {
			if (yych == '\r') {
				yyt2 = cur;
				goto yy77;
			}
			if (yych <= 0x1F) goto yy12;
			yyt2 = cur;
			goto yy77;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy12;
			if (yych <= '9') goto yy71;
			if (yych <= '@') goto yy12;
			goto yy71;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy12;
				goto yy71;
			} else {
				if (yych <= '`') goto yy12;
				if (yych <= 'z') goto yy71;
				goto yy12;
			}
		}
	}
yy72:
	yych = *++cur;
yy73:
	if (yych <= 0x1F) {
		if (yych <= '\n') {
			if (yych == '\t') goto yy72;
			goto yy12;
		} else {
			if (yych == '\f') goto yy12;
			if (yych <= '\r') goto yy72;
			goto yy12;
		}
	} else {
		if (yych <= '^') {
			if (yych <= ' ') goto yy72;
			if (yych <= '@') goto yy12;
			if (yych <= 'Z') {
				yyt1 = cur;
				goto yy79;
			}
			goto yy12;
		} else {
			if (yych == '`') goto yy12;
			if (yych <= 'z') {
				yyt1 = cur;
				goto yy79;
			}
			goto yy12;
		}
	}
yy74:
	yych = *++cur;
	if (yych == '"') goto yy12;
	goto yy81;
yy75:
	yych = *++cur;
	if (yych <= ' ') {
		if (yych <= '\v') {
			if (yych <= 0x08) goto yy12;
			if (yych == '\n') {
				yyt2 = cur;
				goto yy83;
			}
			yyt2 = cur;
			goto yy82;
		} else {
			if (yych == '\r') {
				yyt2 = cur;
				goto yy82;
			}
			if (yych <= 0x1F) goto yy12;
			yyt2 = cur;
			goto yy82;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy12;
			if (yych <= '9') goto yy75;
			if (yych <= '@') goto yy12;
			goto yy75;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy12;
				goto yy75;
			} else {
				if (yych <= '`') goto yy12;
				if (yych <= 'z') goto yy75;
				goto yy12;
			}
		}
	}
yy76:
	yych = *++cur;
	if (yych <= '\'') {
		if (yych <= '\v') {
			if (yych <= 0x08) goto yy12;
			if (yych == '\n') {
				yyt3 = yyt4 = NULL;
				yyt2 = cur;
				goto yy85;
			}
			yyt2 = cur;
			goto yy84;
		} else {
			if (yych <= '\r') {
				if (yych <= '\f') goto yy12;
				yyt2 = cur;
				goto yy84;
			} else {
				if (yych == ' ') {
					yyt2 = cur;
					goto yy84;
				}
				goto yy12;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') {
				if (yych <= '(') {
					yyt2 = cur;
					goto yy86;
				}
				goto yy12;
			} else {
				if (yych <= '9') goto yy76;
				if (yych <= '@') goto yy12;
				goto yy76;
			}
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy12;
				goto yy76;
			} else {
				if (yych <= '`') goto yy12;
				if (yych <= 'z') goto yy76;
				goto yy12;
			}
		}
	}
yy77:
	yych = *++cur;
	if (yych <= '\v') {
		if (yych <= 0x08) goto yy12;
		if (yych != '\n') goto yy77;
	} else {
		if (yych <= '\r') {
			if (yych <= '\f') goto yy12;
			goto yy77;
		} else {
			if (yych == ' ') goto yy77;
			goto yy12;
		}
	}
yy78:
	++cur;
	t1 = yyt1;
	t2 = yyt2;
#line 258 "preprocessor.re"
	{
                IfDef ifdef;
                ifdef.active = branch_enabled;
                if (ifdef.active) {
                    std::string macro_name = token(t1, t2);
                    if (macro_definitions.find(macro_name) != macro_definitions.end()) {
                        ifdef.branch_enabled = true;
                    } else {
                        ifdef.branch_enabled = false;
                    }
                    branch_enabled = ifdef.branch_enabled;
                } else {
                    ifdef.branch_enabled = false;
                }
                ifdef_stack.push_back(ifdef);
                if (!ifdef.active) continue;

                interval_end_type_0(lm, output.size(), cur-string_start);
                continue;
            }
#line 1103 "preprocessor.cpp"
yy79:
	yych = *++cur;
	if (yych <= ' ') {
		if (yych <= '\v') {
			if (yych <= 0x08) goto yy12;
			if (yych == '\n') {
				yyt2 = cur;
				goto yy88;
			}
			yyt2 = cur;
			goto yy87;
		} else {
			if (yych == '\r') {
				yyt2 = cur;
				goto yy87;
			}
			if (yych <= 0x1F) goto yy12;
			yyt2 = cur;
			goto yy87;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy12;
			if (yych <= '9') goto yy79;
			if (yych <= '@') goto yy12;
			goto yy79;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy12;
				goto yy79;
			} else {
				if (yych <= '`') goto yy12;
				if (yych <= 'z') goto yy79;
				goto yy12;
			}
		}
	}
yy80:
	yych = *++cur;
yy81:
	switch (yych) {
		case '\t':
		case '\v':
		case '\r':
		case ' ': goto yy80;
		case '"': goto yy89;
		default: goto yy12;
	}
yy82:
	yych = *++cur;
	if (yych <= '\v') {
		if (yych <= 0x08) goto yy12;
		if (yych != '\n') goto yy82;
	} else {
		if (yych <= '\r') {
			if (yych <= '\f') goto yy12;
			goto yy82;
		} else {
			if (yych == ' ') goto yy82;
			goto yy12;
		}
	}
yy83:
	++cur;
	t1 = yyt1;
	t2 = yyt2;
#line 247 "preprocessor.re"
	{
                if (!branch_enabled) continue;
                std::string macro_name = token(t1, t2);
                auto search = macro_definitions.find(macro_name);
                if (search != macro_definitions.end()) {
                    macro_definitions.erase(search);
                }

                interval_end_type_0(lm, output.size(), cur-string_start);
                continue;
            }
#line 1182 "preprocessor.cpp"
yy84:
	yych = *++cur;
	if (yych <= '\v') {
		if (yych <= 0x08) {
			if (yych <= 0x00) goto yy12;
			yyt4 = cur;
			goto yy90;
		} else {
			if (yych != '\n') goto yy84;
			yyt3 = yyt4 = NULL;
		}
	} else {
		if (yych <= '\r') {
			if (yych <= '\f') {
				yyt4 = cur;
				goto yy90;
			}
			goto yy84;
		} else {
			if (yych == ' ') goto yy84;
			yyt4 = cur;
			goto yy90;
		}
	}
yy85:
	++cur;
	t1 = yyt1;
	t2 = yyt2;
	t3 = yyt4;
	t4 = yyt3;
#line 217 "preprocessor.re"
	{
                if (!branch_enabled) continue;
                std::string macro_name = token(t1, t2), macro_subs;
                if (t3 != nullptr) {
                    LCOMPILERS_ASSERT(t4 != nullptr);
                    macro_subs = token(t3, t4);
                    handle_continuation_lines(macro_subs, cur);
                }
                CPPMacro fn;
                fn.expansion = macro_subs;
                macro_definitions[macro_name] = fn;

                interval_end_type_0(lm, output.size(), cur-string_start);
                continue;
            }
#line 1229 "preprocessor.cpp"
yy86:
	yych = *++cur;
	if (yych <= 0x1F) {
		if (yych <= '\n') {
			if (yych == '\t') goto yy86;
			goto yy12;
		} else {
			if (yych == '\f') goto yy12;
			if (yych <= '\r') goto yy86;
			goto yy12;
		}
	} else {
		if (yych <= '^') {
			if (yych <= ' ') goto yy86;
			if (yych <= '@') goto yy12;
			if (yych <= 'Z') goto yy91;
			goto yy12;
		} else {
			if (yych == '`') goto yy12;
			if (yych <= 'z') goto yy91;
			goto yy12;
		}
	}
yy87:
	yych = *++cur;
	if (yych <= '\v') {
		if (yych <= 0x08) goto yy12;
		if (yych != '\n') goto yy87;
	} else {
		if (yych <= '\r') {
			if (yych <= '\f') goto yy12;
			goto yy87;
		} else {
			if (yych == ' ') goto yy87;
			goto yy12;
		}
	}
yy88:
	++cur;
	t1 = yyt1;
	t2 = yyt2;
#line 278 "preprocessor.re"
	{
                IfDef ifdef;
                ifdef.active = branch_enabled;
                if (ifdef.active) {
                    std::string macro_name = token(t1, t2);
                    if (macro_definitions.find(macro_name) != macro_definitions.end()) {
                        ifdef.branch_enabled = false;
                    } else {
                        ifdef.branch_enabled = true;
                    }
                    branch_enabled = ifdef.branch_enabled;
                } else {
                    ifdef.branch_enabled = false;
                }
                ifdef_stack.push_back(ifdef);
                if (!ifdef.active) continue;

                interval_end_type_0(lm, output.size(), cur-string_start);
                continue;
            }
#line 1292 "preprocessor.cpp"
yy89:
	yych = *++cur;
	if (yych <= 0x00) goto yy12;
	if (yych == '"') {
		yyt1 = yyt2 = cur;
		goto yy93;
	}
	yyt1 = cur;
	goto yy92;
yy90:
	yych = *++cur;
	if (yych <= 0x00) goto yy12;
	if (yych == '\n') {
		yyt3 = cur;
		goto yy85;
	}
	goto yy90;
yy91:
	yych = *++cur;
	if (yych <= ')') {
		if (yych <= '\f') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy12;
				goto yy94;
			} else {
				if (yych == '\v') goto yy94;
				goto yy12;
			}
		} else {
			if (yych <= 0x1F) {
				if (yych <= '\r') goto yy94;
				goto yy12;
			} else {
				if (yych <= ' ') goto yy94;
				if (yych <= '(') goto yy12;
				goto yy95;
			}
		}
	} else {
		if (yych <= '@') {
			if (yych <= ',') {
				if (yych <= '+') goto yy12;
				goto yy86;
			} else {
				if (yych <= '/') goto yy12;
				if (yych <= '9') goto yy91;
				goto yy12;
			}
		} else {
			if (yych <= '_') {
				if (yych <= 'Z') goto yy91;
				if (yych <= '^') goto yy12;
				goto yy91;
			} else {
				if (yych <= '`') goto yy12;
				if (yych <= 'z') goto yy91;
				goto yy12;
			}
		}
	}
yy92:
	yych = *++cur;
	if (yych <= 0x00) goto yy12;
	if (yych != '"') goto yy92;
	yyt2 = cur;
yy93:
	yych = *++cur;
	if (yych <= 0x00) goto yy12;
	if (yych == '\n') goto yy96;
	goto yy93;
yy94:
	yych = *++cur;
	if (yych <= '\r') {
		if (yych <= '\n') {
			if (yych == '\t') goto yy94;
			goto yy12;
		} else {
			if (yych == '\f') goto yy12;
			goto yy94;
		}
	} else {
		if (yych <= '(') {
			if (yych == ' ') goto yy94;
			goto yy12;
		} else {
			if (yych <= ')') goto yy95;
			if (yych == ',') goto yy86;
			goto yy12;
		}
	}
yy95:
	yych = *++cur;
	if (yych <= '\v') {
		if (yych == '\t') goto yy97;
		if (yych <= '\n') goto yy12;
		goto yy97;
	} else {
		if (yych <= '\r') {
			if (yych <= '\f') goto yy12;
			goto yy97;
		} else {
			if (yych == ' ') goto yy97;
			goto yy12;
		}
	}
yy96:
	++cur;
	t1 = yyt1;
	t2 = yyt2;
#line 349 "preprocessor.re"
	{
                if (!branch_enabled) continue;
                std::string filename = token(t1, t2);
                std::vector<std::filesystem::path> include_dirs;
                include_dirs.push_back(parent_path(lm.files.back().in_filename));
                include_dirs.insert(include_dirs.end(),
                                    compiler_options.po.include_dirs.begin(),
                                    compiler_options.po.include_dirs.end());
                bool file_found = false;
                std::string include = "";
                if (is_relative_path(filename)) {
                    for (auto &path:include_dirs) {
                        std::string filepath = join_paths({path.generic_string(), filename});
                        file_found = read_file(filepath, include);
                        if (file_found) {
                            filename = filepath;
                            break;
                        }
                    }
                } else {
                    file_found = read_file(filename, include);
                }

                if (!file_found) {
                    throw LCompilersException("C preprocessor: Include file '" + filename
                        + "' not found. If an include path "
                        "is available, please use the `-I` option to specify it.");
                }

                LocationManager lm_tmp = lm; // Make a copy
                include = run(include, lm_tmp, macro_definitions);

                // Prepare the start of the interval
                interval_end_type_0(lm, output.size(), tok-string_start);

                // Include
                output.append(include);

                // Prepare the end of the interval
                interval_end(lm, output.size(), cur-string_start,
                    token(tok, cur).size()-1, 1);
                continue;
            }
#line 1446 "preprocessor.cpp"
yy97:
	yych = *++cur;
	if (yych <= '\v') {
		if (yych <= 0x08) {
			if (yych <= 0x00) goto yy12;
			yyt3 = cur;
		} else {
			if (yych == '\n') {
				yyt3 = cur;
				goto yy99;
			}
			goto yy97;
		}
	} else {
		if (yych <= '\r') {
			if (yych >= '\r') goto yy97;
			yyt3 = cur;
		} else {
			if (yych == ' ') goto yy97;
			yyt3 = cur;
		}
	}
yy98:
	yych = *++cur;
	if (yych <= 0x00) goto yy12;
	if (yych != '\n') goto yy98;
yy99:
	++cur;
	t1 = yyt1;
	t2 = yyt2;
	t3 = yyt3;
	t4 = cur - 1;
#line 232 "preprocessor.re"
	{
                if (!branch_enabled) continue;
                std::string macro_name = token(t1, t2),
                        macro_subs = token(t3, t4);
                handle_continuation_lines(macro_subs, cur);
                std::vector<std::string> args = parse_arguments(t2, true);
                CPPMacro fn;
                fn.function_like = true;
                fn.args = args;
                fn.expansion = macro_subs;
                macro_definitions[macro_name] = fn;

                interval_end_type_0(lm, output.size(), cur-string_start);
                continue;
            }
#line 1495 "preprocessor.cpp"
}
#line 483 "preprocessor.re"

    }
    lm.files.back().out_start0.push_back(output.size());
    lm.files.back().in_start0.push_back(input.size());
    // The just created interval ID:
    size_t N = lm.files.back().out_start0.size()-2;
    lm.files.back().in_size0.push_back(
        lm.files.back().out_start0[N+1] - lm.files.back().out_start0[N]);
    lm.files.back().interval_type0.push_back(0);

    // Uncomment for debugging
    /*
    std::cout << "in_start0: ";
    for (auto A : lm.files.back().in_start0) { std::cout << A << " "; }
    std::cout << std::endl;
    std::cout << "in_size0: ";
    for (auto A : lm.files.back().in_size0) { std::cout << A << " "; }
    std::cout << std::endl;
    std::cout << "interval_type0: ";
    for (auto A : lm.files.back().interval_type0) { std::cout << A << " "; }
    std::cout << std::endl;
    std::cout << "out_start0: ";
    for (auto A : lm.files.back().out_start0) { std::cout << A << " "; }
    std::cout << std::endl;
    */

    return output;
}

std::string CPreprocessor::function_like_macro_expansion(
            std::vector<std::string> &def_args,
            std::string &expansion,
            std::vector<std::string> &call_args) const {
    LCOMPILERS_ASSERT(expansion[expansion.size()] == '\0');
    unsigned char *string_start=(unsigned char*)(&expansion[0]);
    unsigned char *cur = string_start;
    std::string output;
    for (;;) {
        unsigned char *tok = cur;
        unsigned char *mar;
        
#line 1539 "preprocessor.cpp"
{
	unsigned char yych;
	unsigned int yyaccept = 0;
	static const unsigned char yybm[] = {
		  0, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 128, 192, 192, 192, 192,  64, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		224, 224, 224, 224, 224, 224, 224, 224, 
		224, 224, 192, 192, 192, 192, 192, 192, 
		192, 224, 224, 224, 224, 224, 224, 224, 
		224, 224, 224, 224, 224, 224, 224, 224, 
		224, 224, 224, 224, 224, 224, 224, 224, 
		224, 224, 224, 192, 192, 192, 192, 224, 
		192, 224, 224, 224, 224, 224, 224, 224, 
		224, 224, 224, 224, 224, 224, 224, 224, 
		224, 224, 224, 224, 224, 224, 224, 224, 
		224, 224, 224, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
	};
	yych = *cur;
	if (yych <= '@') {
		if (yych <= '"') {
			if (yych <= 0x00) goto yy101;
			if (yych <= '!') goto yy102;
			goto yy104;
		} else {
			if (yych == '\'') goto yy105;
			goto yy102;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy106;
			if (yych <= '^') goto yy102;
			goto yy106;
		} else {
			if (yych <= '`') goto yy102;
			if (yych <= 'z') goto yy106;
			goto yy102;
		}
	}
yy101:
	++cur;
#line 533 "preprocessor.re"
	{
                break;
            }
#line 1604 "preprocessor.cpp"
yy102:
	++cur;
yy103:
#line 529 "preprocessor.re"
	{
                output.append(token(tok, cur));
                continue;
            }
#line 1613 "preprocessor.cpp"
yy104:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych <= 0x00) goto yy103;
	goto yy108;
yy105:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych <= 0x00) goto yy103;
	goto yy113;
yy106:
	yych = *++cur;
	if (yybm[0+yych] & 32) {
		goto yy106;
	}
#line 536 "preprocessor.re"
	{
                std::string t = token(tok, cur);
                auto search = std::find(def_args.begin(), def_args.end(), t);
                if (search != def_args.end()) {
                    size_t i = std::distance(def_args.begin(), search);
                    output.append(call_args[i]);
                } else {
                    output.append(t);
                }
                continue;
            }
#line 1641 "preprocessor.cpp"
yy107:
	yych = *++cur;
yy108:
	if (yybm[0+yych] & 64) {
		goto yy107;
	}
	if (yych >= 0x01) goto yy110;
yy109:
	cur = mar;
	if (yyaccept <= 1) {
		if (yyaccept == 0) {
			goto yy103;
		} else {
			goto yy111;
		}
	} else {
		goto yy114;
	}
yy110:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych == '"') goto yy107;
yy111:
#line 547 "preprocessor.re"
	{
                output.append(token(tok, cur));
                continue;
            }
#line 1670 "preprocessor.cpp"
yy112:
	yych = *++cur;
yy113:
	if (yybm[0+yych] & 128) {
		goto yy112;
	}
	if (yych <= 0x00) goto yy109;
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yych == '\'') goto yy112;
yy114:
#line 551 "preprocessor.re"
	{
                output.append(token(tok, cur));
                continue;
            }
#line 1687 "preprocessor.cpp"
}
#line 555 "preprocessor.re"

    }
    return output;
}

enum CPPTokenType {
    TK_EOF, TK_NAME, TK_INTEGER, TK_STRING, TK_AND, TK_OR, TK_NEG,
    TK_LPAREN, TK_RPAREN, TK_LT, TK_GT, TK_LTE, TK_GTE, TK_NE, TK_EQ,
    TK_PLUS, TK_MINUS, TK_MUL, TK_DIV
};

namespace {

std::string token(unsigned char *tok, unsigned char* cur)
{
    return std::string((char *)tok, cur - tok);
}

}

void get_next_token(unsigned char *&cur, CPPTokenType &type, std::string &str) {
    std::string output;
    for (;;) {
        unsigned char *tok = cur;
        unsigned char *mar;
        
#line 1716 "preprocessor.cpp"
{
	unsigned char yych;
	static const unsigned char yybm[] = {
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,  32,   0,  32,   0,  32,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		 32,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192,   0,   0,   0,   0,   0,   0, 
		  0, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128,   0,   0,   0,   0, 128, 
		  0, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128, 128, 128, 128, 128, 128, 
		128, 128, 128,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
	};
	yych = *cur;
	if (yybm[0+yych] & 32) {
		goto yy119;
	}
	if (yych <= '/') {
		if (yych <= '\'') {
			if (yych <= 0x1F) {
				if (yych <= 0x00) goto yy116;
				if (yych <= 0x08) goto yy117;
				if (yych <= '\n') goto yy120;
				goto yy117;
			} else {
				if (yych <= '!') goto yy121;
				if (yych == '&') goto yy122;
				goto yy117;
			}
		} else {
			if (yych <= '+') {
				if (yych <= '(') goto yy123;
				if (yych <= ')') goto yy124;
				if (yych <= '*') goto yy125;
				goto yy126;
			} else {
				if (yych == '-') goto yy127;
				if (yych <= '.') goto yy117;
				goto yy128;
			}
		}
	} else {
		if (yych <= '[') {
			if (yych <= '=') {
				if (yych <= '9') goto yy129;
				if (yych <= ';') goto yy117;
				if (yych <= '<') goto yy130;
				goto yy131;
			} else {
				if (yych <= '>') goto yy132;
				if (yych <= '@') goto yy117;
				if (yych <= 'Z') goto yy133;
				goto yy117;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '\\') goto yy134;
				if (yych == '_') goto yy133;
				goto yy117;
			} else {
				if (yych <= 'z') goto yy133;
				if (yych == '|') goto yy135;
				goto yy117;
			}
		}
	}
yy116:
	++cur;
#line 590 "preprocessor.re"
	{ type = CPPTokenType::TK_EOF; return; }
#line 1810 "preprocessor.cpp"
yy117:
	++cur;
yy118:
#line 586 "preprocessor.re"
	{
                std::string t = token(tok, cur);
                throw LCompilersException("Unknown token: " + t);
            }
#line 1819 "preprocessor.cpp"
yy119:
	yych = *++cur;
	if (yybm[0+yych] & 32) {
		goto yy119;
	}
#line 592 "preprocessor.re"
	{ continue; }
#line 1827 "preprocessor.cpp"
yy120:
	++cur;
#line 591 "preprocessor.re"
	{ type = CPPTokenType::TK_EOF; return; }
#line 1832 "preprocessor.cpp"
yy121:
	yych = *++cur;
	if (yych == '=') goto yy136;
#line 600 "preprocessor.re"
	{ type = CPPTokenType::TK_NEG; return; }
#line 1838 "preprocessor.cpp"
yy122:
	yych = *++cur;
	if (yych == '&') goto yy137;
	goto yy118;
yy123:
	++cur;
#line 601 "preprocessor.re"
	{ type = CPPTokenType::TK_LPAREN; return; }
#line 1847 "preprocessor.cpp"
yy124:
	++cur;
#line 602 "preprocessor.re"
	{ type = CPPTokenType::TK_RPAREN; return; }
#line 1852 "preprocessor.cpp"
yy125:
	++cur;
#line 596 "preprocessor.re"
	{ type = CPPTokenType::TK_MUL; return; }
#line 1857 "preprocessor.cpp"
yy126:
	++cur;
#line 594 "preprocessor.re"
	{ type = CPPTokenType::TK_PLUS; return; }
#line 1862 "preprocessor.cpp"
yy127:
	++cur;
#line 595 "preprocessor.re"
	{ type = CPPTokenType::TK_MINUS; return; }
#line 1867 "preprocessor.cpp"
yy128:
	yych = *++cur;
	if (yych == '=') goto yy138;
#line 597 "preprocessor.re"
	{ type = CPPTokenType::TK_DIV; return; }
#line 1873 "preprocessor.cpp"
yy129:
	yych = *++cur;
	if (yybm[0+yych] & 64) {
		goto yy129;
	}
#line 610 "preprocessor.re"
	{
                str = token(tok, cur);
                type = CPPTokenType::TK_INTEGER;
                return;
            }
#line 1885 "preprocessor.cpp"
yy130:
	yych = *++cur;
	if (yych == '=') goto yy139;
#line 603 "preprocessor.re"
	{ type = CPPTokenType::TK_LT; return; }
#line 1891 "preprocessor.cpp"
yy131:
	yych = *++cur;
	if (yych == '=') goto yy140;
	goto yy118;
yy132:
	yych = *++cur;
	if (yych == '=') goto yy141;
#line 604 "preprocessor.re"
	{ type = CPPTokenType::TK_GT; return; }
#line 1901 "preprocessor.cpp"
yy133:
	yych = *++cur;
	if (yybm[0+yych] & 128) {
		goto yy133;
	}
#line 615 "preprocessor.re"
	{
                str = token(tok, cur);
                type = CPPTokenType::TK_NAME;
                return;
            }
#line 1913 "preprocessor.cpp"
yy134:
	yych = *(mar = ++cur);
	if (yych <= '\f') {
		if (yych <= 0x08) goto yy118;
		if (yych <= '\v') goto yy143;
		goto yy118;
	} else {
		if (yych <= '\r') goto yy143;
		if (yych == ' ') goto yy143;
		goto yy118;
	}
yy135:
	yych = *++cur;
	if (yych == '|') goto yy146;
	goto yy118;
yy136:
	++cur;
#line 608 "preprocessor.re"
	{ type = CPPTokenType::TK_NE; return; }
#line 1933 "preprocessor.cpp"
yy137:
	++cur;
#line 598 "preprocessor.re"
	{ type = CPPTokenType::TK_AND; return; }
#line 1938 "preprocessor.cpp"
yy138:
	++cur;
#line 607 "preprocessor.re"
	{ type = CPPTokenType::TK_NE; return; }
#line 1943 "preprocessor.cpp"
yy139:
	++cur;
#line 605 "preprocessor.re"
	{ type = CPPTokenType::TK_LTE; return; }
#line 1948 "preprocessor.cpp"
yy140:
	++cur;
#line 609 "preprocessor.re"
	{ type = CPPTokenType::TK_EQ; return; }
#line 1953 "preprocessor.cpp"
yy141:
	++cur;
#line 606 "preprocessor.re"
	{ type = CPPTokenType::TK_GTE; return; }
#line 1958 "preprocessor.cpp"
yy142:
	yych = *++cur;
yy143:
	if (yych <= '\v') {
		if (yych <= 0x08) goto yy144;
		if (yych == '\n') goto yy145;
		goto yy142;
	} else {
		if (yych <= '\r') {
			if (yych >= '\r') goto yy142;
		} else {
			if (yych == ' ') goto yy142;
		}
	}
yy144:
	cur = mar;
	goto yy118;
yy145:
	++cur;
#line 593 "preprocessor.re"
	{ continue; }
#line 1980 "preprocessor.cpp"
yy146:
	++cur;
#line 599 "preprocessor.re"
	{ type = CPPTokenType::TK_OR; return; }
#line 1985 "preprocessor.cpp"
}
#line 620 "preprocessor.re"

    }
}

namespace {

void accept(unsigned char *&cur, CPPTokenType type_expected) {
    CPPTokenType type;
    std::string str;
    get_next_token(cur, type, str);
    if (type != type_expected) {
        throw LCompilersException("Unexpected token type "
            + std::to_string((int)type)
            + ", expected type "
            + std::to_string((int)type_expected) );
    }
}

std::string accept_name(unsigned char *&cur) {
    CPPTokenType type;
    std::string str;
    get_next_token(cur, type, str);
    if (type != CPPTokenType::TK_NAME) {
        throw LCompilersException("Unexpected token type "
            + std::to_string((int)type)
            + ", expected TK_NAME");
    }
    return str;
}

int parse_term(unsigned char *&cur, const cpp_symtab &macro_definitions);
int parse_factor(unsigned char *&cur, const cpp_symtab &macro_definitions);
int parse_bfactor(unsigned char *&cur, const cpp_symtab &macro_definitions);

/*
b-expr
    = b-factor (("&&"|"||") b-factor)*
*/
int parse_bexpr(unsigned char *&cur, const cpp_symtab &macro_definitions) {
    int tmp = parse_bfactor(cur, macro_definitions);

    CPPTokenType type;
    std::string str;
    unsigned char *old_cur = cur;
    get_next_token(cur, type, str);
    while (type == CPPTokenType::TK_AND || type == CPPTokenType::TK_OR) {
        bool factor = parse_bfactor(cur, macro_definitions) > 0;
        if (type == CPPTokenType::TK_AND) {
            tmp = (int)( (tmp > 0) && (factor > 0) );
        } else {
            tmp = (int)( (tmp > 0) || (factor > 0) );
        }
        old_cur = cur;
        get_next_token(cur, type, str);
    }
    cur = old_cur; // Revert the last token, as we will not consume it
    return tmp;
}

/*
expr
    = term ((+,-) term)*
*/
int parse_expr(unsigned char *&cur, const cpp_symtab &macro_definitions) {
    int tmp;
    tmp = parse_term(cur, macro_definitions);

    CPPTokenType type;
    std::string str;
    unsigned char *old_cur = cur;
    get_next_token(cur, type, str);
    while (type == CPPTokenType::TK_PLUS || type == CPPTokenType::TK_MINUS) {
        int term = parse_term(cur, macro_definitions);
        if (type == CPPTokenType::TK_PLUS) {
            tmp = tmp + term;
        } else {
            tmp = tmp - term;
        }
        old_cur = cur;
        get_next_token(cur, type, str);
    }
    cur = old_cur; // Revert the last token, as we will not consume it
    return tmp;
}

/*
term
    = factor ((*,/) factor)*
*/
int parse_term(unsigned char *&cur, const cpp_symtab &macro_definitions) {
    int tmp;
    tmp = parse_factor(cur, macro_definitions);

    CPPTokenType type;
    std::string str;
    unsigned char *old_cur = cur;
    get_next_token(cur, type, str);
    while (type == CPPTokenType::TK_MUL || type == CPPTokenType::TK_DIV) {
        int term = parse_factor(cur, macro_definitions);
        if (type == CPPTokenType::TK_MUL) {
            tmp = tmp * term;
        } else {
            tmp = tmp / term;
        }
        old_cur = cur;
        get_next_token(cur, type, str);
    }
    cur = old_cur; // Revert the last token, as we will not consume it
    return tmp;
}

/*
factor
    = TK_INTEGER
    | TK_NAME
    | (-,+) factor
    | "(" b-expr ")"
*/
int parse_factor(unsigned char *&cur, const cpp_symtab &macro_definitions) {
    CPPTokenType type;
    std::string str;
    get_next_token(cur, type, str);
    if (type == CPPTokenType::TK_NAME) {
        if (macro_definitions.find(str) != macro_definitions.end()) {
            std::string v = macro_definitions.at(str).expansion;
            unsigned char *cur2 = (unsigned char*)(&v[0]);
            int i = parse_expr(cur2, macro_definitions);
            return i;
        } else {
            // If the variable/macro is not defined, we evaluate it as 0
            return 0;
        }
    } else if (type == CPPTokenType::TK_INTEGER) {
        int i = std::stoi(str);
        return i;
    } else if (type == CPPTokenType::TK_MINUS) {
        int result = parse_factor(cur, macro_definitions);
        return -result;
    } else if (type == CPPTokenType::TK_PLUS) {
        int result = parse_factor(cur, macro_definitions);
        return +result;
    } else if (type == CPPTokenType::TK_LPAREN) {
        int result = parse_bexpr(cur, macro_definitions);
        accept(cur, CPPTokenType::TK_RPAREN);
        return result;

    // This is the only place where we can get unexpected tokens. Let us
    // handle them here:
    } else if (type == CPPTokenType::TK_EOF) {
        // EOF means the expression
        throw LCompilersException("factor(): The expression is not complete, expecting integer, name, +, - or (");
    } else {
        throw LCompilersException("Unexpected token type " + std::to_string((int)type) + " in factor()");
    }
}

/*
relation
    = expr
    | expr (<,>,>=,<=,/=,!=,==) expr
*/
int parse_relation(unsigned char *&cur, const cpp_symtab &macro_definitions) {
    int lhs;
    lhs = parse_expr(cur, macro_definitions);
    unsigned char *old_cur = cur;

    CPPTokenType type;
    std::string str;
    get_next_token(cur, type, str);
    if (type >= CPPTokenType::TK_LT && type <= CPPTokenType::TK_EQ) {
        int rhs = parse_expr(cur, macro_definitions);
        if (type == CPPTokenType::TK_LT) {
            return lhs < rhs;
        } else if (type == CPPTokenType::TK_GT) {
            return lhs > rhs;
        } else if (type == CPPTokenType::TK_LTE) {
            return lhs <= rhs;
        } else if (type == CPPTokenType::TK_GTE) {
            return lhs >= rhs;
        } else if (type == CPPTokenType::TK_NE) {
            return lhs != rhs;
        } else if (type == CPPTokenType::TK_EQ) {
            return lhs == rhs;
        } else {
            throw LCompilersException("Inconsistent ifs");
        }
    } else {
        cur = old_cur; // Revert the last token, as we will not consume it
        return lhs;
    }
}

/*
b-factor
    = "defined(" TK_NAME ")"
    | "!" b-factor
    | relation
*/
int parse_bfactor(unsigned char *&cur, const cpp_symtab &macro_definitions) {
    CPPTokenType type;
    std::string str;
    unsigned char *old_cur = cur;
    get_next_token(cur, type, str);
    if (type == CPPTokenType::TK_NAME && str == "defined") {
        accept(cur, CPPTokenType::TK_LPAREN);
        std::string macro_name = accept_name(cur);
        accept(cur, CPPTokenType::TK_RPAREN);
        if (macro_definitions.find(macro_name) != macro_definitions.end()) {
            return true;
        } else {
            return false;
        }
    } else if (type == CPPTokenType::TK_NEG) {
        bool bresult = parse_bfactor(cur, macro_definitions) > 0;
        bresult = !bresult; // Apply "!"
        return (int) bresult;
    } else {
        // For everything else we commit to relation and handle any potential errors there:
        cur = old_cur; // Restore the token
        int result = parse_relation(cur, macro_definitions);
        return result;
    }
}

}

} // namespace LCompilers::LFortran
