/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 */

 /* (C) Marcin Kwadrans <quarter@users.sourceforge.net> */

#include "include/support.h"
#include "include/paritycommand.h"
#include "include/message.h"

class LWCommandBraceOpen: public LWCommandSegment {

LWValue *execute1 (LWContext *context, guint argc, LWValue *args[])
{
	(void) context;
	
	g_return_val_if_fail (argc == 1, new LWValue());
	
	if (args[0]->isVariable())
		return args[0];
	
	return new LWValue(args[0]);
}

const gchar *getName ()
{
	return "(";
}	

gchar *getHint ()
{
	return _("Open brace");
}

guint getPriority ()
{
	return 15;
}

LWLink getLinkType ()
{
	return LW_LINK_LEFT;
}

gboolean hasReturn()
{
	return TRUE;
}

gboolean matchNextCondition (LWCommand *cmd)
{
	(void) cmd;
	return TRUE;
}

gboolean matchWith (LWCommand *cmd)
{
	if (cmd == NULL)
		throw new LWMessage (LW_ERROR_UnmatchedBrace);
	
	if (cmd->getName()[0] != ')')
		throw new LWMessage (LW_ERROR_UnmatchedBrace);
	
	match();
	
	return TRUE;
}

void checkArgc (guint n)
{
	if (n == 0) 
		throw new LWMessage (LW_ERROR_EmptyBrace);
	
	if (n > 1) 
		throw new LWMessage (LW_ERROR_WrongNumberOfArguments);
}	

};

LWSymbol *new_LWCommandBraceOpen()
{
	return new LWCommandBraceOpen();
}
