/*
 * Decompiled with CFR 0.152.
 */
package org.tuckey.web.filters.urlrewrite;

import javax.servlet.http.Cookie;
import junit.framework.TestCase;
import org.tuckey.web.MockRequest;
import org.tuckey.web.MockResponse;
import org.tuckey.web.filters.urlrewrite.SetAttribute;
import org.tuckey.web.filters.urlrewrite.utils.Log;

public class SetAttributeTest
extends TestCase {
    public void setUp() {
        Log.setLevel("DEBUG");
    }

    public void testBasic() {
        SetAttribute set = new SetAttribute();
        set.setName("blah");
        set.setValue("mercuryrev");
        MockRequest request = new MockRequest();
        MockResponse response = new MockResponse();
        set.initialise();
        set.execute(request, response);
        SetAttributeTest.assertTrue((boolean)request.getAttribute("blah").equals("mercuryrev"));
    }

    public void testTypeStatus() {
        SetAttribute set = new SetAttribute();
        set.setType("status");
        set.setValue("999");
        MockRequest request = new MockRequest();
        MockResponse response = new MockResponse();
        set.initialise();
        set.execute(request, response);
        SetAttributeTest.assertEquals((int)999, (int)response.getStatus());
    }

    public void testTypeCookie() {
        SetAttribute set = new SetAttribute();
        set.setType("cookie");
        set.setName("mycook");
        set.setValue("someval dasd:blah.com:89009:/ass");
        MockRequest request = new MockRequest();
        MockResponse response = new MockResponse();
        set.initialise();
        set.execute(request, response);
        Cookie cookie = (Cookie)response.getCookies().get(0);
        SetAttributeTest.assertEquals((String)"blah.com", (String)cookie.getDomain());
        SetAttributeTest.assertEquals((int)89009, (int)cookie.getMaxAge());
        SetAttributeTest.assertEquals((String)"someval dasd", (String)cookie.getValue());
        SetAttributeTest.assertEquals((String)"/ass", (String)cookie.getPath());
    }

    public void testTypeLocale() {
        SetAttribute set = new SetAttribute();
        set.setType("locale");
        set.setValue("en");
        SetAttributeTest.assertTrue((boolean)set.initialise());
        set.setValue("en-NZ");
        SetAttributeTest.assertTrue((boolean)set.initialise());
        set.setValue("en-NZ-slang");
        MockRequest request = new MockRequest();
        MockResponse response = new MockResponse();
        set.initialise();
        set.execute(request, response);
        SetAttributeTest.assertEquals((String)"slang", (String)response.getLocale().getVariant());
    }
}

