# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class ContextDevice2D(Object):
    r"""
    ContextDevice2D - Abstract class for drawing 2D primitives.
    
    Superclass: Object
    
    This defines the interface for a ContextDevice2D. In this sense a
    context_device is a class used to paint 2D primitives onto a device,
    such as an open_gl context or a Qgraphics_view.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkContextDevice2D, obj, update, **traits)
    
    def get_matrix(self, *args):
        """
        get_matrix(self, m:Matrix3x3) -> None
        C++: virtual void get_matrix(Matrix3x3 *m)
        Set the model view matrix for the display
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetMatrix, *my_args)
        return ret

    def set_matrix(self, *args):
        """
        set_matrix(self, m:Matrix3x3) -> None
        C++: virtual void set_matrix(Matrix3x3 *m)
        Set the model view matrix for the display
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetMatrix, *my_args)
        return ret

    def _get_brush(self):
        return wrap_vtk(self._vtk_obj.GetBrush())
    brush = traits.Property(_get_brush, desc=\
        r"""
        Get the pen which controls the outlines of shapes as well as
        lines, points and related primitives.
        """
    )

    def _get_buffer_id_mode(self):
        return self._vtk_obj.GetBufferIdMode()
    buffer_id_mode = traits.Property(_get_buffer_id_mode, desc=\
        r"""
        Tell if the device context is in buffer_id creation mode. Initial
        value is false.
        """
    )

    def _get_height(self):
        return self._vtk_obj.GetHeight()
    height = traits.Property(_get_height, desc=\
        r"""
        Get the width of the device in pixels.
        """
    )

    def _get_pen(self):
        return wrap_vtk(self._vtk_obj.GetPen())
    pen = traits.Property(_get_pen, desc=\
        r"""
        Get the pen which controls the outlines of shapes, as well as
        lines, points and related primitives. This object can be modified
        and the changes will be reflected in subsequent drawing
        operations.
        """
    )

    def _get_text_prop(self):
        return wrap_vtk(self._vtk_obj.GetTextProp())
    text_prop = traits.Property(_get_text_prop, desc=\
        r"""
        Get the text properties object for the Context2D.
        """
    )

    def _get_width(self):
        return self._vtk_obj.GetWidth()
    width = traits.Property(_get_width, desc=\
        r"""
        Get the width of the device in pixels.
        """
    )

    def apply_brush(self, *args):
        """
        apply_brush(self, brush:Brush) -> None
        C++: virtual void apply_brush(Brush *brush)
        Apply the supplied brush which controls the outlines of shapes,
        as well as lines, points and related primitives. This makes a
        deep copy of the Brush object in the Context2D, it does not
        hold a pointer to the supplied object.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ApplyBrush, *my_args)
        return ret

    def apply_pen(self, *args):
        """
        apply_pen(self, pen:Pen) -> None
        C++: virtual void apply_pen(Pen *pen)
        Apply the supplied pen which controls the outlines of shapes, as
        well as lines, points and related primitives. This makes a deep
        copy of the Pen object in the Context2D, it does not hold a
        pointer to the supplied object.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ApplyPen, *my_args)
        return ret

    def apply_text_prop(self, *args):
        """
        apply_text_prop(self, prop:TextProperty) -> None
        C++: virtual void apply_text_prop(TextProperty *prop)
        Apply the supplied text property which controls how text is
        rendered. This makes a deep copy of the TextProperty object in
        the Context2D, it does not hold a pointer to the supplied
        object.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ApplyTextProp, *my_args)
        return ret

    def begin(self, *args):
        """
        begin(self, __a:Viewport) -> None
        C++: virtual void begin(Viewport *)
        Begin drawing, pass in the viewport to set up the view.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Begin, *my_args)
        return ret

    def buffer_id_mode_begin(self, *args):
        """
        buffer_id_mode_begin(self, bufferId:AbstractContextBufferId)
            -> None
        C++: virtual void buffer_id_mode_begin(
            AbstractContextBufferId *bufferId)
        Start buffer_id creation Mode. The default implementation is
        empty.
        \\pre not_yet: !get_buffer_id_mode()
        \\pre bufferId_exists: bufferId!=0
        \\post started: get_buffer_id_mode()
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.BufferIdModeBegin, *my_args)
        return ret

    def buffer_id_mode_end(self):
        """
        buffer_id_mode_end(self) -> None
        C++: virtual void buffer_id_mode_end()
        Finalize buffer_id creation Mode. It makes sure that the content
        of the bufferId passed in argument of buffer_id_mode_begin() is
        correctly set. The default implementation is empty.
        \\pre started: get_buffer_id_mode()
        \\post done: !get_buffer_id_mode()
        """
        ret = self._vtk_obj.BufferIdModeEnd()
        return ret
        

    def compute_justified_string_bounds(self, *args):
        """
        compute_justified_string_bounds(self, string:str, bounds:[float,
            float, float, float]) -> None
        C++: virtual void compute_justified_string_bounds(const char *string,
             float bounds[4])
        Compute the bounds of the supplied string while taking into
        account the justification of the currently applied text property.
        Simple rotations (0, 90, 180, 270) are also correctly taken into
        account.
        """
        ret = self._wrap_call(self._vtk_obj.ComputeJustifiedStringBounds, *args)
        return ret

    def compute_string_bounds(self, *args):
        """
        compute_string_bounds(self, string:str, bounds:[float, float, float,
             float]) -> None
        C++: virtual void compute_string_bounds(const StdString &string,
            float bounds[4])
        Compute the bounds of the supplied string. The bounds will be
        copied to the supplied bounds variable, the first two elements
        are the bottom corner of the string, and the second two elements
        are the width and height of the bounding box. NOTE: This function
        does not take account of the text rotation or justification.
        """
        ret = self._wrap_call(self._vtk_obj.ComputeStringBounds, *args)
        return ret

    def disable_clipping(self):
        """
        disable_clipping(self) -> None
        C++: virtual void disable_clipping()
        Disable clipping of the display. Remove in a future release -
        retained for API compatibility.
        """
        ret = self._vtk_obj.DisableClipping()
        return ret
        

    def draw_colored_polygon(self, *args):
        """
        draw_colored_polygon(self, points:[float, ...], numPoints:int,
            colors:[int, ...]=..., nc_comps:int=0) -> None
        C++: virtual void draw_colored_polygon(float *points, int numPoints,
             unsigned char *colors=nullptr, int nc_comps=0)"""
        ret = self._wrap_call(self._vtk_obj.DrawColoredPolygon, *args)
        return ret

    def draw_ellipse_wedge(self, *args):
        """
        draw_ellipse_wedge(self, x:float, y:float, outRx:float, outRy:float,
             inRx:float, inRy:float, startAngle:float, stopAngle:float)
            -> None
        C++: virtual void draw_ellipse_wedge(float x, float y, float outRx,
            float outRy, float inRx, float inRy, float startAngle,
            float stopAngle)
        Draw an elliptic wedge with center at x, y, outer radii outRx,
        outRy, inner radii inRx, inRy between angles startAngle and
        stopAngle (expressed in degrees).
        \\pre positive_outRx: outRx>=0
        \\pre positive_outRy: outRy>=0
        \\pre positive_inRx: inRx>=0
        \\pre positive_inRy: inRy>=0
        \\pre ordered_rx: inRx<=outRx
        \\pre ordered_ry: inRy<=outRy
        """
        ret = self._wrap_call(self._vtk_obj.DrawEllipseWedge, *args)
        return ret

    def draw_elliptic_arc(self, *args):
        """
        draw_elliptic_arc(self, x:float, y:float, rX:float, rY:float,
            startAngle:float, stopAngle:float) -> None
        C++: virtual void draw_elliptic_arc(float x, float y, float rX,
            float rY, float startAngle, float stopAngle)
        Draw an elliptic arc with center at x,y with radii rX and rY
        between angles startAngle and stopAngle (expressed in degrees).
        \\pre positive_rX: rX>=0
        \\pre positive_rY: rY>=0
        """
        ret = self._wrap_call(self._vtk_obj.DrawEllipticArc, *args)
        return ret

    def draw_image(self, *args):
        """
        draw_image(self, p:[float, float], scale:float, image:ImageData)
             -> None
        C++: virtual void draw_image(float p[2], float scale,
            ImageData *image)
        draw_image(self, pos:Rectf, image:ImageData) -> None
        C++: virtual void draw_image(const Rectf &pos,
            ImageData *image)
        Draw the supplied image at the given x, y (p[0], p[1]) (bottom
        corner), scaled by scale (1.0 would match the image).
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.DrawImage, *my_args)
        return ret

    def draw_lines(self, *args):
        """
        draw_lines(self, f:[float, ...], n:int, colors:[int, ...]=...,
            nc_comps:int=0) -> None
        C++: virtual void draw_lines(float *f, int n,
            unsigned char *colors=nullptr, int nc_comps=0)
        Draw lines using the points - memory layout is as follows:
        l1p1,l1p2,l2p1,l2p2... The lines will be colored by colors array
        which has nc_comps components (defining a single color).
        \\sa draw_poly()
        """
        ret = self._wrap_call(self._vtk_obj.DrawLines, *args)
        return ret

    def draw_markers(self, *args):
        """
        draw_markers(self, shape:int, highlight:bool, points:[float, ...],
            n:int, colors:[int, ...]=..., nc_comps:int=0) -> None
        C++: virtual void draw_markers(int shape, bool highlight,
            float *points, int n, unsigned char *colors=nullptr,
            int nc_comps=0)
        Draw a series of markers centered at the points supplied. The
        shape argument controls the marker shape, and can be one of
        - VTK_MARKER_CROSS
        - VTK_MARKER_PLUS
        - VTK_MARKER_SQUARE
        - VTK_MARKER_CIRCLE
        - VTK_MARKER_DIAMOND
        \\param shape the shape of the marker
        \\param highlight whether to highlight the marker or not
        \\param points where to draw the sprites
        \\param n the number of points
        \\param colors is an optional array of colors.
        \\param nc_comps is the number of components for the color.
        """
        ret = self._wrap_call(self._vtk_obj.DrawMarkers, *args)
        return ret

    def draw_math_text_string(self, *args):
        """
        draw_math_text_string(self, point:[float, ...], string:str) -> None
        C++: virtual void draw_math_text_string(float *point,
            const StdString &string)
        Draw text using math_text markup for mathematical equations. See
        http://matplotlib.sourceforge.net/users/mathtext.html for more
        information.
        """
        ret = self._wrap_call(self._vtk_obj.DrawMathTextString, *args)
        return ret

    def draw_point_sprites(self, *args):
        """
        draw_point_sprites(self, sprite:ImageData, points:[float, ...],
            n:int, colors:[int, ...]=..., nc_comps:int=0) -> None
        C++: virtual void draw_point_sprites(ImageData *sprite,
            float *points, int n, unsigned char *colors=nullptr,
            int nc_comps=0)
        Draw a series of point sprites, images centred at the points
        supplied. The supplied ImageData is the sprite to be drawn,
        only squares will be drawn and the size is set using
        set_point_size.
        \\param sprite the image to draw
        \\param points where to draw the sprites
        \\param n the number of points
        \\param colors is an optional array of colors.
        \\param nc_comps is the number of components for the color.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.DrawPointSprites, *my_args)
        return ret

    def draw_points(self, *args):
        """
        draw_points(self, points:[float, ...], n:int, colors:[int,
            ...]=..., nc_comps:int=0) -> None
        C++: virtual void draw_points(float *points, int n,
            unsigned char *colors=nullptr, int nc_comps=0)
        Draw a series of points - fastest code path due to memory layout
        of the coordinates. The colors and nc_comps are optional - color
        array.
        """
        ret = self._wrap_call(self._vtk_obj.DrawPoints, *args)
        return ret

    def draw_poly(self, *args):
        """
        draw_poly(self, points:[float, ...], n:int, colors:[int, ...]=...,
            nc_comps:int=0) -> None
        C++: virtual void draw_poly(float *points, int n,
            unsigned char *colors=nullptr, int nc_comps=0)
        Draw a poly line using the points - fastest code path due to
        memory layout of the coordinates. The line will be colored by the
        colors array, which must be have nc_comps components (defining a
        single color).
        \\sa draw_lines()
        """
        ret = self._wrap_call(self._vtk_obj.DrawPoly, *args)
        return ret

    def draw_poly_data(self, *args):
        """
        draw_poly_data(self, p:[float, float], scale:float,
            polyData:PolyData, colors:UnsignedCharArray,
            scalarMode:int) -> None
        C++: virtual void draw_poly_data(float p[2], float scale,
            PolyData *polyData, UnsignedCharArray *colors,
            int scalarMode)
        Draw the supplied poly_data at the given x, y (p[0], p[1]) (bottom
        corner), scaled by scale (1.0 would match the actual dataset).
        
        Only lines and polys are rendered. Only the x/y coordinates of
        the polydata are used.
        
        @param p Offset to apply to polydata.
        @param scale Isotropic scale for polydata. Applied after offset.
        @param polyData Draw lines and polys from this dataset.
        @param colors RGBA for points or cells, depending on value of
            scalarMode.
        Must not be NULL.
        @param scalarMode Must be either VTK_SCALAR_MODE_USE_POINT_DATA
            or
        VTK_SCALAR_MODE_USE_CELL_DATA.
        
        The base implementation breaks the polydata apart and renders
        each polygon individually using the device API. Subclasses should
        override this method with a batch-drawing implementation if
        performance is a concern.
        """
        my_args = deref_array(args, [(['float', 'float'], 'float', 'vtkPolyData', 'vtkUnsignedCharArray', 'int')])
        ret = self._wrap_call(self._vtk_obj.DrawPolyData, *my_args)
        return ret

    def draw_polygon(self, *args):
        """
        draw_polygon(self, p:[float, ...], n:int) -> None
        C++: virtual void draw_polygon(float *p, int n)"""
        ret = self._wrap_call(self._vtk_obj.DrawPolygon, *args)
        return ret

    def draw_quad(self, *args):
        """
        draw_quad(self, __a:[float, ...], __b:int) -> None
        C++: virtual void draw_quad(float *, int)
        Draw a quad using the specified number of points.
        """
        ret = self._wrap_call(self._vtk_obj.DrawQuad, *args)
        return ret

    def draw_quad_strip(self, *args):
        """
        draw_quad_strip(self, __a:[float, ...], __b:int) -> None
        C++: virtual void draw_quad_strip(float *, int)
        Draw a quad using the specified number of points.
        """
        ret = self._wrap_call(self._vtk_obj.DrawQuadStrip, *args)
        return ret

    def draw_string(self, *args):
        """
        draw_string(self, point:[float, ...], string:str) -> None
        C++: virtual void draw_string(float *point,
            const StdString &string)
        Draw some text to the screen.
        """
        ret = self._wrap_call(self._vtk_obj.DrawString, *args)
        return ret

    def enable_clipping(self, *args):
        """
        enable_clipping(self, enable:bool) -> None
        C++: virtual void enable_clipping(bool enable)
        Enable or disable the clipping of the scene.
        """
        ret = self._wrap_call(self._vtk_obj.EnableClipping, *args)
        return ret

    def end(self):
        """
        end(self) -> None
        C++: virtual void end()
        End drawing, clean up the view.
        """
        ret = self._vtk_obj.End()
        return ret
        

    def math_text_is_supported(self):
        """
        math_text_is_supported(self) -> bool
        C++: virtual bool math_text_is_supported()
        Return true if math_text rendering available on this device.
        """
        ret = self._vtk_obj.MathTextIsSupported()
        return ret
        

    def multiply_matrix(self, *args):
        """
        multiply_matrix(self, m:Matrix3x3) -> None
        C++: virtual void multiply_matrix(Matrix3x3 *m)
        Multiply the current model view matrix by the supplied one
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.MultiplyMatrix, *my_args)
        return ret

    def pop_matrix(self):
        """
        pop_matrix(self) -> None
        C++: virtual void pop_matrix()
        Pop the current matrix off of the stack.
        """
        ret = self._vtk_obj.PopMatrix()
        return ret
        

    def push_matrix(self):
        """
        push_matrix(self) -> None
        C++: virtual void push_matrix()
        Push the current matrix onto the stack.
        """
        ret = self._vtk_obj.PushMatrix()
        return ret
        

    def set_clipping(self, *args):
        """
        set_clipping(self, x:[int, ...]) -> None
        C++: virtual void set_clipping(int *x)
        Supply an int array of length 4 with x1, y1, width, height
        specifying clipping region for the device in pixels.
        """
        ret = self._wrap_call(self._vtk_obj.SetClipping, *args)
        return ret

    def set_color4(self, *args):
        """
        set_color4(self, color:[int, int, int, int]) -> None
        C++: virtual void set_color4(unsigned char color[4])
        Set the color for the device using unsigned char of length 4,
        RGBA.
        """
        ret = self._wrap_call(self._vtk_obj.SetColor4, *args)
        return ret

    def set_line_type(self, *args):
        """
        set_line_type(self, type:int) -> None
        C++: virtual void set_line_type(int type)
        Set the line type type (using anonymous enum in Pen).
        """
        ret = self._wrap_call(self._vtk_obj.SetLineType, *args)
        return ret

    def set_line_width(self, *args):
        """
        set_line_width(self, width:float) -> None
        C++: virtual void set_line_width(float width)
        Set the line width.
        """
        ret = self._wrap_call(self._vtk_obj.SetLineWidth, *args)
        return ret

    def set_point_size(self, *args):
        """
        set_point_size(self, size:float) -> None
        C++: virtual void set_point_size(float size)
        Set the point size for glyphs/sprites.
        """
        ret = self._wrap_call(self._vtk_obj.SetPointSize, *args)
        return ret

    def set_texture(self, *args):
        """
        set_texture(self, image:ImageData, properties:int) -> None
        C++: virtual void set_texture(ImageData *image, int properties)
        Set the texture for the device, it is used to fill the polygons
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetTexture, *my_args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('object_name', 'GetObjectName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'object_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ContextDevice2D, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ContextDevice2D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['object_name']),
            title='Edit ContextDevice2D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ContextDevice2D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

