"use strict";

var helpers = require("../../helpers/helpers");

exports["Asia/Brunei"] = {

	"guess:by:offset" : helpers.makeTestGuess("Asia/Brunei", { offset: true, expect: "Asia/Manila" }),

	"guess:by:abbr" : helpers.makeTestGuess("Asia/Brunei", { abbr: true, expect: "Asia/Manila" }),

	"1926" : helpers.makeTestYear("Asia/Brunei", [
		["1926-02-28T16:38:40+00:00", "00:08:40", "+0730", -450]
	]),

	"1932" : helpers.makeTestYear("Asia/Brunei", [
		["1932-12-31T16:29:59+00:00", "23:59:59", "+0730", -450],
		["1932-12-31T16:30:00+00:00", "00:30:00", "+08", -480]
	]),

	"1935" : helpers.makeTestYear("Asia/Brunei", [
		["1935-09-13T15:59:59+00:00", "23:59:59", "+08", -480],
		["1935-09-13T16:00:00+00:00", "00:20:00", "+0820", -500],
		["1935-12-13T15:39:59+00:00", "23:59:59", "+0820", -500],
		["1935-12-13T15:40:00+00:00", "23:40:00", "+08", -480]
	]),

	"1936" : helpers.makeTestYear("Asia/Brunei", [
		["1936-09-13T15:59:59+00:00", "23:59:59", "+08", -480],
		["1936-09-13T16:00:00+00:00", "00:20:00", "+0820", -500],
		["1936-12-13T15:39:59+00:00", "23:59:59", "+0820", -500],
		["1936-12-13T15:40:00+00:00", "23:40:00", "+08", -480]
	]),

	"1937" : helpers.makeTestYear("Asia/Brunei", [
		["1937-09-13T15:59:59+00:00", "23:59:59", "+08", -480],
		["1937-09-13T16:00:00+00:00", "00:20:00", "+0820", -500],
		["1937-12-13T15:39:59+00:00", "23:59:59", "+0820", -500],
		["1937-12-13T15:40:00+00:00", "23:40:00", "+08", -480]
	]),

	"1938" : helpers.makeTestYear("Asia/Brunei", [
		["1938-09-13T15:59:59+00:00", "23:59:59", "+08", -480],
		["1938-09-13T16:00:00+00:00", "00:20:00", "+0820", -500],
		["1938-12-13T15:39:59+00:00", "23:59:59", "+0820", -500],
		["1938-12-13T15:40:00+00:00", "23:40:00", "+08", -480]
	]),

	"1939" : helpers.makeTestYear("Asia/Brunei", [
		["1939-09-13T15:59:59+00:00", "23:59:59", "+08", -480],
		["1939-09-13T16:00:00+00:00", "00:20:00", "+0820", -500],
		["1939-12-13T15:39:59+00:00", "23:59:59", "+0820", -500],
		["1939-12-13T15:40:00+00:00", "23:40:00", "+08", -480]
	]),

	"1940" : helpers.makeTestYear("Asia/Brunei", [
		["1940-09-13T15:59:59+00:00", "23:59:59", "+08", -480],
		["1940-09-13T16:00:00+00:00", "00:20:00", "+0820", -500],
		["1940-12-13T15:39:59+00:00", "23:59:59", "+0820", -500],
		["1940-12-13T15:40:00+00:00", "23:40:00", "+08", -480]
	]),

	"1941" : helpers.makeTestYear("Asia/Brunei", [
		["1941-09-13T15:59:59+00:00", "23:59:59", "+08", -480],
		["1941-09-13T16:00:00+00:00", "00:20:00", "+0820", -500],
		["1941-12-13T15:39:59+00:00", "23:59:59", "+0820", -500],
		["1941-12-13T15:40:00+00:00", "23:40:00", "+08", -480]
	]),

	"1942" : helpers.makeTestYear("Asia/Brunei", [
		["1942-02-15T15:59:59+00:00", "23:59:59", "+08", -480],
		["1942-02-15T16:00:00+00:00", "01:00:00", "+09", -540]
	]),

	"1945" : helpers.makeTestYear("Asia/Brunei", [
		["1945-09-11T14:59:59+00:00", "23:59:59", "+09", -540]
	])
};