<!--

@license Apache-2.0

Copyright (c) 2018 The Stdlib Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

-->

# isRegExp

> Test if a value is a regular expression.

<section class="usage">

## Usage

```javascript
var isRegExp = require( '@stdlib/assert/is-regexp' );
```

#### isRegExp( value )

Tests if a `value` is a regular expression.

```javascript
var bool = isRegExp( /.+/ );
// returns true

bool = isRegExp( {} );
// returns false
```

</section>

<!-- /.usage -->

<section class="examples">

## Examples

<!-- eslint no-undef: "error" -->

```javascript
var isRegExp = require( '@stdlib/assert/is-regexp' );

var bool = isRegExp( /.+/ );
// returns true

bool = isRegExp( new RegExp( '.+' ) );
// returns true

bool = isRegExp( '/.+/' );
// returns false

bool = isRegExp( {} );
// returns false

bool = isRegExp( null );
// returns false
```

</section>

<!-- /.examples -->

<section class="links">

</section>

<!-- /.links -->
