IOobject phiBHeader
(
    "phiB",
    runTime.timeName(),
    mesh,
    IOobject::NO_READ
);


surfaceScalarField* phiBPtr = nullptr;

if (phiBHeader.typeHeaderOk<surfaceScalarField>(true))
{
    Info<< "Reading face flux ";

    phiBPtr = new surfaceScalarField
    (
        IOobject
        (
            "phiB",
            runTime.timeName(),
            mesh,
            IOobject::MUST_READ,
            IOobject::AUTO_WRITE
        ),
        mesh
    );
}
else
{
    Info<< "Calculating face flux ";

    phiBPtr = new surfaceScalarField
    (
        IOobject
        (
            "phiB",
            runTime.timeName(),
            mesh,
            IOobject::NO_READ,
            IOobject::AUTO_WRITE
        ),
        fvc::flux(B)
    );
}

surfaceScalarField& phiB = *phiBPtr;

Info<< phiB.name() << nl << endl;
