SELECT
    *
FROM
    accounts
WHERE
    type = 'good'
    AND amount > 0;

CREATE OR REPLACE FUNCTION get_from_partitioned_table(partitioned_table.a%type)
RETURNS partitioned_table AS $$
DECLARE
    a_val partitioned_table.a%TYPE;
    result partitioned_table%ROWTYPE;
BEGIN
    a_val := $1;

    SELECT * INTO result FROM partitioned_table WHERE a = a_val;

RETURN result;
END; $$ LANGUAGE plpgsql;


