/*
 * Decompiled with CFR 0.152.
 */
package com.sixlegs.png;

import java.awt.Rectangle;

public final class PngConfig {
    public static final int READ_ALL = 0;
    public static final int READ_HEADER = 1;
    public static final int READ_UNTIL_DATA = 2;
    public static final int READ_EXCEPT_DATA = 3;
    public static final int READ_EXCEPT_METADATA = 4;
    final int readLimit;
    final float defaultGamma;
    final float displayExponent;
    final boolean warningsFatal;
    final boolean progressive;
    final boolean reduce16;
    final boolean gammaCorrect;
    final Rectangle sourceRegion;
    final int[] subsampling;
    final boolean convertIndexed;

    PngConfig(Builder builder) {
        boolean subsampleOn;
        this.readLimit = builder.readLimit;
        this.defaultGamma = builder.defaultGamma;
        this.displayExponent = builder.displayExponent;
        this.warningsFatal = builder.warningsFatal;
        this.progressive = builder.progressive;
        this.reduce16 = builder.reduce16;
        this.gammaCorrect = builder.gammaCorrect;
        this.sourceRegion = builder.sourceRegion;
        this.subsampling = builder.subsampling;
        this.convertIndexed = builder.convertIndexed;
        boolean bl = subsampleOn = this.getSourceXSubsampling() != 1 || this.getSourceYSubsampling() != 1;
        if (this.progressive && (subsampleOn || this.getSourceRegion() != null)) {
            throw new IllegalStateException("Progressive rendering cannot be used with source regions or subsampling");
        }
    }

    public boolean getConvertIndexed() {
        return this.convertIndexed;
    }

    public boolean getReduce16() {
        return this.reduce16;
    }

    public float getDefaultGamma() {
        return this.defaultGamma;
    }

    public boolean getGammaCorrect() {
        return this.gammaCorrect;
    }

    public boolean getProgressive() {
        return this.progressive;
    }

    public float getDisplayExponent() {
        return this.displayExponent;
    }

    public int getReadLimit() {
        return this.readLimit;
    }

    public boolean getWarningsFatal() {
        return this.warningsFatal;
    }

    public Rectangle getSourceRegion() {
        return this.sourceRegion != null ? new Rectangle(this.sourceRegion) : null;
    }

    public int getSourceXSubsampling() {
        return this.subsampling[0];
    }

    public int getSourceYSubsampling() {
        return this.subsampling[1];
    }

    public int getSubsamplingXOffset() {
        return this.subsampling[2];
    }

    public int getSubsamplingYOffset() {
        return this.subsampling[3];
    }

    public static final class Builder {
        private static final int[] DEFAULT_SUBSAMPLING = new int[]{1, 1, 0, 0};
        int readLimit = 0;
        float defaultGamma = 0.45455f;
        float displayExponent = 2.2f;
        boolean warningsFatal;
        boolean progressive;
        boolean reduce16 = true;
        boolean gammaCorrect = true;
        Rectangle sourceRegion;
        int[] subsampling = DEFAULT_SUBSAMPLING;
        boolean convertIndexed;

        public Builder() {
        }

        public Builder(PngConfig cfg) {
            this.readLimit = cfg.readLimit;
            this.defaultGamma = cfg.defaultGamma;
            this.displayExponent = cfg.displayExponent;
            this.warningsFatal = cfg.warningsFatal;
            this.progressive = cfg.progressive;
            this.reduce16 = cfg.reduce16;
            this.gammaCorrect = cfg.gammaCorrect;
            this.subsampling = cfg.subsampling;
        }

        public PngConfig build() {
            return new PngConfig(this);
        }

        public Builder reduce16(boolean reduce16) {
            this.reduce16 = reduce16;
            return this;
        }

        public Builder defaultGamma(float defaultGamma) {
            this.defaultGamma = defaultGamma;
            return this;
        }

        public Builder displayExponent(float displayExponent) {
            this.displayExponent = displayExponent;
            return this;
        }

        public Builder gammaCorrect(boolean gammaCorrect) {
            this.gammaCorrect = gammaCorrect;
            return this;
        }

        public Builder progressive(boolean progressive) {
            this.progressive = progressive;
            return this;
        }

        public Builder readLimit(int readLimit) {
            this.readLimit = readLimit;
            return this;
        }

        public Builder warningsFatal(boolean warningsFatal) {
            this.warningsFatal = warningsFatal;
            return this;
        }

        public Builder sourceRegion(Rectangle sourceRegion) {
            if (sourceRegion != null) {
                if (sourceRegion.x < 0 || sourceRegion.y < 0 || sourceRegion.width <= 0 || sourceRegion.height <= 0) {
                    throw new IllegalArgumentException("invalid source region: " + sourceRegion);
                }
                this.sourceRegion = new Rectangle(sourceRegion);
            } else {
                this.sourceRegion = null;
            }
            return this;
        }

        public Builder sourceSubsampling(int xsub, int ysub, int xoff, int yoff) {
            if (xsub <= 0 || ysub <= 0 || xoff < 0 || xoff >= xsub || yoff < 0 || yoff >= ysub) {
                throw new IllegalArgumentException("invalid subsampling values");
            }
            this.subsampling = new int[]{xsub, ysub, xoff, yoff};
            return this;
        }

        public Builder convertIndexed(boolean convertIndexed) {
            this.convertIndexed = convertIndexed;
            return this;
        }
    }
}

