/*
 * Copyright 2022-2023 Soren Stoutner <soren@stoutner.com>.
 *
 * This file is part of Privacy Browser PC <https://www.stoutner.com/privacy-browser-pc>.
 *
 * Privacy Browser PC is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Privacy Browser PC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Privacy Browser PC.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PRIVACYWEBENGINEVIEW_H
#define PRIVACYWEBENGINEVIEW_H

// Qt toolkit headers.
#include <QIcon>
#include <QNetworkCookie>
#include <QWebEngineFindTextResult>
#include <QWebEngineView>

class PrivacyWebEngineView : public QWebEngineView
{
    // Include the Q_OBJECT macro.
    Q_OBJECT

public:
    // The default constructor.
    explicit PrivacyWebEngineView();

    // The public variables.
    std::list<QNetworkCookie> *cookieListPointer = new std::list<QNetworkCookie>;
    double defaultZoomFactor = 1.00;
    QString domainSettingsName = QLatin1String("");
    QIcon favoriteIcon = QIcon::fromTheme(QLatin1String("globe"), QIcon::fromTheme(QLatin1String("applications-internet")));
    bool findCaseSensitive = false;
    QString findString = QLatin1String("");
    QWebEngineFindTextResult findTextResult = QWebEngineFindTextResult();
    bool isLoading = false;
    int loadProgressInt = -1;
    bool localStorageEnabled = false;

    // The public functions.
    void applyDomainSettings(const QString &hostname, const bool reloadWebsite);

signals:
    // The signals.
    void displayHttpPingBlockedDialog(const QString &httpPingUrl) const;
    void updateCookiesAction(const int numberOfCookies) const;
    void updateUi(const PrivacyWebEngineView *privacyWebEngineViewPointer) const;

public Q_SLOTS:
    // The public slots.
    void addCookieToList(const QNetworkCookie &cookie) const;
    void removeCookieFromList(const QNetworkCookie &cookie) const;

private Q_SLOTS:
    // The private slots.
    void applyDomainSettingsWithoutReloading(const QString &hostname);
    void displayHttpPingDialog(const QString &httpPingUrl) const;

private:
    // The private variables.
    QWebEngineProfile *webEngineProfilePointer;
    QWebEngineSettings *webEngineSettingsPointer;

protected:
    // The protected functions.
    void contextMenuEvent(QContextMenuEvent *contextMenuEvent) override;
    QWebEngineView* createWindow(QWebEnginePage::WebWindowType webWindowType) override;
};
#endif
