# PySNMP SMI module. Autogenerated from smidump -f python DLSW-MIB
# by libsmi2pysnmp-0.1.3 at Mon Apr  2 20:38:50 2012,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsIntersection, ConstraintsUnion, SingleValueConstraint, ValueRangeConstraint, ValueSizeConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsIntersection", "ConstraintsUnion", "SingleValueConstraint", "ValueRangeConstraint", "ValueSizeConstraint")
( ifIndex, ) = mibBuilder.importSymbols("IF-MIB", "ifIndex")
( sdlcLSAddress, ) = mibBuilder.importSymbols("SNA-SDLC-MIB", "sdlcLSAddress")
( ModuleCompliance, NotificationGroup, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup", "ObjectGroup")
( Bits, Counter32, Gauge32, Integer32, ModuleIdentity, MibIdentifier, NotificationType, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, TimeTicks, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Gauge32", "Integer32", "ModuleIdentity", "MibIdentifier", "NotificationType", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "TimeTicks", "mib-2")
( DisplayString, RowPointer, RowStatus, TextualConvention, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "DisplayString", "RowPointer", "RowStatus", "TextualConvention", "TruthValue")

# Types

class DlcType(Integer):
    subtypeSpec = Integer.subtypeSpec+SingleValueConstraint(1,5,4,3,2,)
    namedValues = NamedValues(("other", 1), ("na", 2), ("llc", 3), ("sdlc", 4), ("qllc", 5), )
    
class DlswTCPAddress(TextualConvention, OctetString):
    displayHint = "1d.1d.1d.1d"
    subtypeSpec = OctetString.subtypeSpec+ValueSizeConstraint(4,4)
    fixedLength = 4
    
class EndStationLocation(Integer):
    subtypeSpec = Integer.subtypeSpec+SingleValueConstraint(3,1,4,2,)
    namedValues = NamedValues(("other", 1), ("internal", 2), ("remote", 3), ("local", 4), )
    
class LFSize(Integer):
    subtypeSpec = Integer.subtypeSpec+SingleValueConstraint(7663,10997,12992,32655,8539,41600,17749,56559,15370,1979,1112,20730,26693,3812,1615,8130,3225,50575,10587,2052,59551,2345,1231,47583,8949,16163,4105,993,754,2932,3518,1688,516,4865,23711,635,44591,1350,1542,6730,873,6264,1761,65535,13785,12199,14578,29674,11407,1833,16956,1906,10178,9358,1470,53567,4399,9768,38618,7197,5798,5331,2638,)
    namedValues = NamedValues(("lfs10178", 10178), ("lfs10587", 10587), ("lfs10997", 10997), ("lfs1112", 1112), ("lfs11407", 11407), ("lfs12199", 12199), ("lfs1231", 1231), ("lfs12992", 12992), ("lfs1350", 1350), ("lfs13785", 13785), ("lfs14578", 14578), ("lfs1470", 1470), ("lfs15370", 15370), ("lfs1542", 1542), ("lfs1615", 1615), ("lfs16163", 16163), ("lfs1688", 1688), ("lfs16956", 16956), ("lfs1761", 1761), ("lfs17749", 17749), ("lfs1833", 1833), ("lfs1906", 1906), ("lfs1979", 1979), ("lfs2052", 2052), ("lfs20730", 20730), ("lfs2345", 2345), ("lfs23711", 23711), ("lfs2638", 2638), ("lfs26693", 26693), ("lfs2932", 2932), ("lfs29674", 29674), ("lfs3225", 3225), ("lfs32655", 32655), ("lfs3518", 3518), ("lfs3812", 3812), ("lfs38618", 38618), ("lfs4105", 4105), ("lfs41600", 41600), ("lfs4399", 4399), ("lfs44591", 44591), ("lfs47583", 47583), ("lfs4865", 4865), ("lfs50575", 50575), ("lfs516", 516), ("lfs5331", 5331), ("lfs53567", 53567), ("lfs56559", 56559), ("lfs5798", 5798), ("lfs59551", 59551), ("lfs6264", 6264), ("lfs635", 635), ("lfs65535", 65535), ("lfs6730", 6730), ("lfs7197", 7197), ("lfs754", 754), ("lfs7663", 7663), ("lfs8130", 8130), ("lfs8539", 8539), ("lfs873", 873), ("lfs8949", 8949), ("lfs9358", 9358), ("lfs9768", 9768), ("lfs993", 993), )
    
class MacAddressNC(TextualConvention, OctetString):
    displayHint = "1x:"
    subtypeSpec = OctetString.subtypeSpec+ConstraintsUnion(ValueSizeConstraint(0,0),ValueSizeConstraint(6,6),)
    
class NBName(OctetString):
    subtypeSpec = OctetString.subtypeSpec+ValueSizeConstraint(0,16)
    
class TAddress(OctetString):
    subtypeSpec = OctetString.subtypeSpec+ValueSizeConstraint(0,255)
    

# Objects

null = MibIdentifier((0, 0))
dlsw = ModuleIdentity((1, 3, 6, 1, 2, 1, 46)).setRevisions(("1996-06-04 09:00",))
if mibBuilder.loadTexts: dlsw.setOrganization("AIW DLSw MIB RIGLET and IETF DLSw MIB Working Group")
if mibBuilder.loadTexts: dlsw.setContactInfo("David D. Chen\nIBM Corporation\n800 Park, Highway 54\nResearch Triangle Park, NC 27709-9990\nTel:    1 919 254 6182\nE-mail: dchen@vnet.ibm.com")
if mibBuilder.loadTexts: dlsw.setDescription("This MIB module contains objects to manage Data Link\nSwitches.")
dlswMIB = MibIdentifier((1, 3, 6, 1, 2, 1, 46, 1))
dlswTraps = MibIdentifier((1, 3, 6, 1, 2, 1, 46, 1, 0))
dlswNode = MibIdentifier((1, 3, 6, 1, 2, 1, 46, 1, 1))
dlswNodeVersion = MibScalar((1, 3, 6, 1, 2, 1, 46, 1, 1, 1), OctetString().subtype(subtypeSpec=ValueSizeConstraint(2, 2)).setFixedLength(2)).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswNodeVersion.setDescription("This value identifies the particular version of the DLSw\nstandard supported by this DLSw.  The first octet is a\nhexadecimal value representing the DLSw standard Version\nnumber of this DLSw, and the second is a hexadecimal value\nrepresenting the DLSw standard Release number. This\ninformation is reported in DLSw Capabilities Exchange.")
dlswNodeVendorID = MibScalar((1, 3, 6, 1, 2, 1, 46, 1, 1, 2), OctetString().subtype(subtypeSpec=ValueSizeConstraint(3, 3)).setFixedLength(3)).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswNodeVendorID.setDescription("The value identifies the manufacturer's IEEE-assigned\norganizationally Unique Identifier (OUI) of this DLSw.\nThis information is reported in DLSw Capabilities\nExchange.")
dlswNodeVersionString = MibScalar((1, 3, 6, 1, 2, 1, 46, 1, 1, 3), DisplayString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswNodeVersionString.setDescription("This string gives product-specific information about\nthis DLSw (e.g., product name, code release and fix level).\nThis flows in Capabilities Exchange messages.")
dlswNodeStdPacingSupport = MibScalar((1, 3, 6, 1, 2, 1, 46, 1, 1, 4), Integer().subtype(subtypeSpec=SingleValueConstraint(3,1,2,)).subtype(namedValues=NamedValues(("none", 1), ("adaptiveRcvWindow", 2), ("fixedRcvWindow", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswNodeStdPacingSupport.setDescription("Circuit pacing, as defined in the DLSw Standard, allows each\nof the two DLSw nodes on a circuit to control the amount\nof data the other is permitted to send to them.  This object\nreflects the level of support the DLSw node has for this\nprotocol.  (1) means the node has no support for the standard\ncircuit pacing flows;  it may use RFC 1434+ methods only, or\na proprietary flow control scheme.  (2) means the node supports\nthe standard scheme and can vary the window sizes it grants as\na data receiver.  (3) means the node supports the standard\nscheme but never varies its receive window size.")
dlswNodeStatus = MibScalar((1, 3, 6, 1, 2, 1, 46, 1, 1, 5), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,)).subtype(namedValues=NamedValues(("active", 1), ("inactive", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dlswNodeStatus.setDescription("The status of the DLSw part of the system.  Changing the\nvalue from active to inactive causes DLSw to take\nthe following actions - (1) it disconnects all circuits\nthrough all DLSw partners, (2) it disconnects all\ntransport connections to all DLSw partners, (3) it\ndisconnects all local DLC connections, and (4) it stops\nprocessing all DLC connection set-up traffic.\nSince these are destructive actions, the user should\nquery the circuit and transport connection tables in\nadvance to understand the effect this action will have.\nChanging the value from inactive to active causes DLSw\nto come up in its initial state, i.e., transport\nconnections established and ready to bring up circuits.")
dlswNodeUpTime = MibScalar((1, 3, 6, 1, 2, 1, 46, 1, 1, 6), TimeTicks()).setMaxAccess("readonly").setUnits("hundredths of a second")
if mibBuilder.loadTexts: dlswNodeUpTime.setDescription("The amount of time (in hundredths of a second) since\nthe DLSw portion of the system was last re-initialized.\nThat is, if dlswState is in the active state,\nthe time the dlswState entered the active state.\nIt will remain zero if dlswState is in the\ninactive state.")
dlswNodeVirtualSegmentLFSize = MibScalar((1, 3, 6, 1, 2, 1, 46, 1, 1, 7), LFSize().clone('lfs65535')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dlswNodeVirtualSegmentLFSize.setDescription("The largest frame size (including DLC header and info field\nbut not any MAC-level or framing octets) this DLSw can forward\non any path through itself.  This object can represent any box-\nlevel frame size forwarding restriction (e.g., from the use\nof fixed-size buffers).  Some DLSw implementations will have\nno such restriction.\n\nThis value will affect the LF size of circuits during circuit\ncreation.  The LF size of an existing circuit can be found in\nthe RIF (Routing Information Field).")
dlswNodeResourceNBExclusivity = MibScalar((1, 3, 6, 1, 2, 1, 46, 1, 1, 8), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dlswNodeResourceNBExclusivity.setDescription("The value of true indicates that the NetBIOS Names\nconfigured in dlswDirNBTable are the only ones accessible\nvia this DLSw.\n\nIf a node supports sending run-time capabilities exchange\nmessages, changes to this object should cause that action.\nIt is up to the implementation exactly when to start the\nrun-time capabilities exchange.")
dlswNodeResourceMacExclusivity = MibScalar((1, 3, 6, 1, 2, 1, 46, 1, 1, 9), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dlswNodeResourceMacExclusivity.setDescription("The value of true indicates that the MAC addresses\nconfigured in the dlswDirMacTable are the only ones\naccessible via this DLSw.\n\nIf a node supports sending run-time capabilities exchange\nmessages, changes to this object should cause that action.\nIt is up to the implementation exactly when to start the\nrun-time capabilities exchange.")
dlswTrapControl = MibIdentifier((1, 3, 6, 1, 2, 1, 46, 1, 1, 10))
dlswTrapCntlTConnPartnerReject = MibScalar((1, 3, 6, 1, 2, 1, 46, 1, 1, 10, 1), Integer().subtype(subtypeSpec=SingleValueConstraint(2,3,1,)).subtype(namedValues=NamedValues(("enabled", 1), ("disabled", 2), ("partial", 3), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dlswTrapCntlTConnPartnerReject.setDescription("Indicates whether the DLSw is permitted to emit partner\nreject related traps.  With the value of `enabled'\nthe DLSw will emit all partner reject related traps.\nWith the value of `disabled' the DLSw will not emit\nany partner reject related traps.  With the value\nof `partial' the DLSw will only emits partner reject\ntraps for CapEx reject.  The changes take effect\nimmediately.")
dlswTrapCntlTConnProtViolation = MibScalar((1, 3, 6, 1, 2, 1, 46, 1, 1, 10, 2), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dlswTrapCntlTConnProtViolation.setDescription("Indicates whether the DLSw is permitted to generate\nprotocol-violation traps on the events such as\nwindow size violation.  The changes take effect\nimmediately.")
dlswTrapCntlTConn = MibScalar((1, 3, 6, 1, 2, 1, 46, 1, 1, 10, 3), Integer().subtype(subtypeSpec=SingleValueConstraint(2,3,1,)).subtype(namedValues=NamedValues(("enabled", 1), ("disabled", 2), ("partial", 3), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dlswTrapCntlTConn.setDescription("Indicates whether the DLSw is permitted to emit transport\nconnection up and down traps.  With the value of `enabled'\nthe DLSw will emit traps when connections enter `connected'\nand `disconnected' states.  With the value of `disabled'\nthe DLSw will not emit traps when connections enter of\n`connected' and `disconnected' states.  With the value\nof `partial' the DLSw will only emits transport connection\ndown traps when the connection is closed with busy.\nThe changes take effect immediately.")
dlswTrapCntlCircuit = MibScalar((1, 3, 6, 1, 2, 1, 46, 1, 1, 10, 4), Integer().subtype(subtypeSpec=SingleValueConstraint(2,3,1,)).subtype(namedValues=NamedValues(("enabled", 1), ("disabled", 2), ("partial", 3), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dlswTrapCntlCircuit.setDescription("Indicates whether the DLSw is permitted to generate\ncircuit up and down traps.  With the value of `enabled'\nthe DLSw will emit traps when circuits enter `connected'\nand `disconnected' states.  With the value of `disabled'\nthe DLSw will not emit traps when circuits enter of\n`connected' and `disconnected' states.  With the value\nof `partial' the DLSw will emit traps only for those\ncircuits that are initiated by this DLSw, e.g.,\noriginating the CUR_CS message.  The changes take effect\nimmediately.")
dlswTConn = MibIdentifier((1, 3, 6, 1, 2, 1, 46, 1, 2))
dlswTConnStat = MibIdentifier((1, 3, 6, 1, 2, 1, 46, 1, 2, 1))
dlswTConnStatActiveConnections = MibScalar((1, 3, 6, 1, 2, 1, 46, 1, 2, 1, 1), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswTConnStatActiveConnections.setDescription("The number of transport connections that are not in\n`disconnected' state.")
dlswTConnStatCloseIdles = MibScalar((1, 3, 6, 1, 2, 1, 46, 1, 2, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswTConnStatCloseIdles.setDescription("The number of times transport connections in this node\nexited the connected state with zero active circuits on\nthe transport connection.")
dlswTConnStatCloseBusys = MibScalar((1, 3, 6, 1, 2, 1, 46, 1, 2, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswTConnStatCloseBusys.setDescription("The number of times transport connections in this node\nexited the connected state with some non-zero number\nof active circuits on the transport connection.  Normally\nthis means the transport connection failed unexpectedly.")
dlswTConnConfigTable = MibTable((1, 3, 6, 1, 2, 1, 46, 1, 2, 2))
if mibBuilder.loadTexts: dlswTConnConfigTable.setDescription("This table defines the transport connections\nthat will be initiated or accepted by this\nDLSw.  Structure of masks allows wildcard\ndefinition for a collection of transport\nconnections by a conceptual row.  For a\nspecific transport connection, there may\nbe multiple of conceptual rows match the\ntransport address.  The `best' match will\nthe one to determine the characteristics\nof the transport connection.")
dlswTConnConfigEntry = MibTableRow((1, 3, 6, 1, 2, 1, 46, 1, 2, 2, 1)).setIndexNames((0, "DLSW-MIB", "dlswTConnConfigIndex"))
if mibBuilder.loadTexts: dlswTConnConfigEntry.setDescription("Each conceptual row defines a collection of\ntransport connections.")
dlswTConnConfigIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 2, 2, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dlswTConnConfigIndex.setDescription("The index to the conceptual row of the table.\nNegative numbers are not allowed.  There\nare objects defined that point to conceptual\nrows of this table with this index value.\nZero is used to denote that no corresponding\nrow exists.\n\nIndex values are assigned by the agent, and\nshould not be reused but should continue to\nincrease in value.")
dlswTConnConfigTDomain = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 2, 2, 1, 2), ObjectIdentifier()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dlswTConnConfigTDomain.setDescription("The object identifier which indicates the transport\ndomain of this conceptual row.")
dlswTConnConfigLocalTAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 2, 2, 1, 3), TAddress()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dlswTConnConfigLocalTAddr.setDescription("The local transport address for this conceptual row\nof the transport connection definition.")
dlswTConnConfigRemoteTAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 2, 2, 1, 4), TAddress()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dlswTConnConfigRemoteTAddr.setDescription("The remote transport address.  Together with\ndlswTConnConfigEntryType and dlswTConnConfigGroupDefinition,\nthe object instance of this conceptual row identifies a\ncollection of the transport connections that will be\neither initiated by this DLSw or initiated by a partner\nDLSw and accepted by this DLSw.")
dlswTConnConfigLastModifyTime = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 2, 2, 1, 5), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswTConnConfigLastModifyTime.setDescription("The time (in hundredths of a second) since the value of\nany object in this conceptual row except for\ndlswTConnConfigOpens was last changed.  This value\nmay be compared to dlswTConnOperConnectTime to\ndetermine whether values in this row are completely\nvalid for a transport connection created using\nthis row definition.")
dlswTConnConfigEntryType = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 2, 2, 1, 6), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,3,)).subtype(namedValues=NamedValues(("individual", 1), ("global", 2), ("group", 3), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dlswTConnConfigEntryType.setDescription("The object instance signifies the type of entry in the\nassociated conceptual row.  The value of `individual'\nmeans that the entry applies to a specific partner DLSw\nnode as identified by dlswTConnConfigRemoteTAddr and\ndlswTConnConfigTDomain.  The value of `global'\nmeans that the entry applies to all partner DLSw nodes\nof the TDomain.  The value of 'group' means that the entry\napplies to a specific set of DLSw nodes in the TDomain.\nAny group definitions are enterprise-specific and are pointed\nto by dlswTConnConfigGroupDefinition.  In the cases of\n`global' and `group', the value in dlswTConnConfigRemoteTAddr\nmay not have any significance.")
dlswTConnConfigGroupDefinition = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 2, 2, 1, 7), RowPointer()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dlswTConnConfigGroupDefinition.setDescription("For conceptual rows of `individual' and `global' as\nspecified in dlswTConnConfigEntryType, the instance\nof this object is  `0.0'.  For conceptual rows of\n`group', the instance points to the specific\ngroup definition.")
dlswTConnConfigSetupType = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 2, 2, 1, 8), Integer().subtype(subtypeSpec=SingleValueConstraint(2,4,1,5,3,)).subtype(namedValues=NamedValues(("other", 1), ("activePersistent", 2), ("activeOnDemand", 3), ("passive", 4), ("excluded", 5), )).clone(4)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dlswTConnConfigSetupType.setDescription("This value of the instance of a conceptual row\nidentifies the behavior of the collection of\ntransport connections that this conceptual row\ndefines.  The value of activePersistent, activeOnDemand\nand passive means this DLSw will accept any transport\nconnections, initiated by partner DLSw nodes, which\nare defined by this conceptual row.  The value of\nactivePersistent means this DLSw will also initiate\nthe transport connections of this conceptual row and\nretry periodically if necessary.  The value of\nactiveOnDemand means this DLSw will initiate a\ntransport connection of this conceptual row, if\nthere is a directory cache hits.  The value of\nother is implementation specific.  The value of exclude\nmeans that the specified node is not allowed to be\na partner to this DLSw node.  To take a certain\nconceptual row definition out of service, a value of\nnotInService for dlswTConnConfigRowStatus should be\nused.")
dlswTConnConfigSapList = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 2, 2, 1, 9), OctetString().subtype(subtypeSpec=ValueSizeConstraint(16, 16)).setFixedLength(16).clone(hexValue='ff000000000000000000000000000000')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dlswTConnConfigSapList.setDescription("The SAP list indicates which SAPs are advertised to\nthe transport connection defined by this conceptual\nrow.  Only SAPs with even numbers are represented,\nin the form of the most significant bit of the first\noctet representing the SAP 0, the next most significant\nbit representing the SAP 2, to the least significant\nbit of the last octet representing the SAP 254.  Data\nlink switching is allowed for those SAPs which have\none in its corresponding bit, not allowed otherwise.\nThe whole SAP list has to be changed together.  Changing\nthe SAP list affects only new circuit establishments\nand has no effect on established circuits.\n\nThis list can be used to restrict specific partners\nfrom knowing about all the SAPs used by DLSw on all its\ninterfaces (these are represented in dlswIfSapList for\neach interface).  For instance, one may want to run NetBIOS\nwith some partners but not others.\n\nIf a node supports sending run-time capabilities exchange\nmessages, changes to this object should cause that action.\nWhen to start the run-time capabilities exchange is\nimplementation-specific.\nThe DEFVAL below indicates support for SAPs 0, 4, 8, and C.")
dlswTConnConfigAdvertiseMacNB = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 2, 2, 1, 10), TruthValue().clone('true')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dlswTConnConfigAdvertiseMacNB.setDescription("The value of true indicates that any defined local MAC\naddresses and NetBIOS names will be advertised to a\npartner node via initial and (if supported) run-time\ncapabilities exchange messages.  The DLSw node should send\nthe appropriate exclusivity control vector to accompany\neach list it sends, or to represent that the node is\nexplicitly configured to have a null list.\n\nThe value of false indicates that the DLSw node should not\nsend a MAC address list or NetBIOS name list, and should\nalso not send their corresponding exclusivity control\nvectors.")
dlswTConnConfigInitCirRecvWndw = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 2, 2, 1, 11), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535)).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dlswTConnConfigInitCirRecvWndw.setDescription("The initial circuit receive pacing window size, in the unit\nof SSP messages, to be used for future transport connections\nactivated using this table row.  The managed node sends this\nvalue as its initial receive pacing window in its initial\ncapabilities exchange message.  Changing this value does not\naffect the initial circuit receive pacing window size of\ncurrently active transport connections.  If the standard window\npacing scheme is not supported, the value is zero.\n\nA larger receive window value may be appropriate for partners\nthat are reachable only via physical paths that have longer\nnetwork delays.")
dlswTConnConfigOpens = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 2, 2, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswTConnConfigOpens.setDescription("Number of times transport connections entered\nconnected state according to the definition of\nthis conceptual row.")
dlswTConnConfigRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 2, 2, 1, 13), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dlswTConnConfigRowStatus.setDescription("This object is used by the manager to create\nor delete the row entry in the dlswTConnConfigTable\nfollowing the RowStatus textual convention.  The value\nof notInService will be used to take a conceptual\nrow definition out of use.")
dlswTConnOperTable = MibTable((1, 3, 6, 1, 2, 1, 46, 1, 2, 3))
if mibBuilder.loadTexts: dlswTConnOperTable.setDescription("A list of transport connections.   It is optional but\ndesirable for the agent to keep an entry for some\nperiod of time after the transport connection is\ndisconnected.  This allows the manager to capture\nadditional useful information about the connection, in\nparticular, statistical information and the cause of the\ndisconnection.")
dlswTConnOperEntry = MibTableRow((1, 3, 6, 1, 2, 1, 46, 1, 2, 3, 1)).setIndexNames((0, "DLSW-MIB", "dlswTConnOperTDomain"), (0, "DLSW-MIB", "dlswTConnOperRemoteTAddr"))
if mibBuilder.loadTexts: dlswTConnOperEntry.setDescription("")
dlswTConnOperTDomain = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 2, 3, 1, 1), ObjectIdentifier()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dlswTConnOperTDomain.setDescription("The object identifier indicates the transport domain\nof this transport connection.")
dlswTConnOperLocalTAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 2, 3, 1, 2), TAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswTConnOperLocalTAddr.setDescription("The local transport address for this transport connection.\nThis value could be different from dlswTConnConfigLocalAddr,\nif the value of the latter were changed after this transport\nconnection was established.")
dlswTConnOperRemoteTAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 2, 3, 1, 3), TAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dlswTConnOperRemoteTAddr.setDescription("The remote transport address of this transport connection.")
dlswTConnOperEntryTime = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 2, 3, 1, 4), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswTConnOperEntryTime.setDescription("The amount of time (in hundredths of a second) since this\ntransport connection conceptual row was created.")
dlswTConnOperConnectTime = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 2, 3, 1, 5), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswTConnOperConnectTime.setDescription("The amount of time (in hundredths of a second) since this\ntransport connection last entered the 'connected' state.\nA value of zero means this transport connection has never\nbeen established.")
dlswTConnOperState = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 2, 3, 1, 6), Integer().subtype(subtypeSpec=SingleValueConstraint(6,3,1,4,2,5,)).subtype(namedValues=NamedValues(("connecting", 1), ("initCapExchange", 2), ("connected", 3), ("quiescing", 4), ("disconnecting", 5), ("disconnected", 6), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dlswTConnOperState.setDescription("The state of this transport connection.  The transport\nconnection enters `connecting' state when DLSw makes\na connection request to the transport layer.  Once initial\nCapabilities Exchange is sent, the transport connection\nenters enters `initCapExchange' state.  When partner\ncapabilities have been determined and the transport\nconnection is ready for sending CanUReach (CUR) messages,\nit moves to the `connected' state.  When DLSw is in the\nprocess of bringing down the connection, it is in the\n`disconnecting' state.  When the transport layer\nindicates one of its connections is disconnected, the\ntransport connection moves to the `disconnected' state.\n\nWhereas all of the values will be returned in response\nto a management protocol retrieval operation, only two\nvalues may be specified in a management protocol set\noperation: `quiescing' and `disconnecting'.  Changing\nthe value to `quiescing' prevents new circuits from being\nestablished, and will cause a transport disconnect when\nthe last circuit on the connection goes away.  Changing\nthe value to `disconnecting' will force off all circuits\nimmediately and bring the connection to `disconnected'\nstate.")
dlswTConnOperConfigIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 2, 3, 1, 7), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswTConnOperConfigIndex.setDescription("The value of dlswTConnConfigIndex of the dlswTConnConfigEntry\nthat governs the configuration information used by this\ndlswTConnOperEntry.  The manager can therefore normally\nexamine both configured and operational information\nfor this transport connection.\n\nThis value is zero if the corresponding dlswTConnConfigEntry\nwas deleted after the creation of this dlswTConnOperEntry.\nIf some fields in the former were changed but the conceptual\nrow was not deleted, some configuration information may not\nbe valid for this operational transport connection.  The\nmanager can compare dlswTConnOperConnectTime and\ndlswTConnConfigLastModifyTime to determine if this condition\nexists.")
dlswTConnOperFlowCntlMode = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 2, 3, 1, 8), Integer().subtype(subtypeSpec=SingleValueConstraint(1,3,2,)).subtype(namedValues=NamedValues(("undetermined", 1), ("pacing", 2), ("other", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswTConnOperFlowCntlMode.setDescription("The flow control mechanism in use on this transport connection.\nThis value is undetermined (1) before the mode of flow control\ncan be established on a new transport connection (i.e., after\nCapEx is sent but before Capex or other SSP control messages\nhave been received).  Pacing (2) indicates that the standard\nRFC 1795 pacing mechanism is in use.  Other (3) may be either\nthe RFC 1434+ xBusy mechanism operating to a back-level DLSw,\nor a vendor-specific flow control method.  Whether it is xBusy\nor not can be inferred from dlswTConnOperPartnerVersion.")
dlswTConnOperPartnerVersion = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 2, 3, 1, 9), OctetString().subtype(subtypeSpec=ConstraintsUnion(ValueSizeConstraint(0,0),ValueSizeConstraint(2,2),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswTConnOperPartnerVersion.setDescription("This value identifies which version (first octet) and release\n(second octet) of the DLSw standard is supported by this\npartner DLSw. This information is obtained from a DLSw\ncapabilities exchange message received from the partner DLSw.\nA string of zero length is returned before a Capabilities\nExchange message is received, or if one is never received.\nA conceptual row with a dlswTConnOperState of `connected' but\na zero length partner version indicates that the partner is\na non-standard DLSw partner.\n\nIf an implementation chooses to keep dlswTConnOperEntrys in\nthe `disconnected' state, this value should remain unchanged.")
dlswTConnOperPartnerVendorID = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 2, 3, 1, 10), OctetString().subtype(subtypeSpec=ConstraintsUnion(ValueSizeConstraint(0,0),ValueSizeConstraint(3,3),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswTConnOperPartnerVendorID.setDescription("This value identifies the IEEE-assigned organizationally\nUnique Identifier (OUI) of the maker of this partner\nDLSw.  This information is obtained from a DLSw\ncapabilities exchange message received from the partner DLSw.\nA string of zero length is returned before a Capabilities\nExchange message is received, or if one is never received.\n\nIf an implementation chooses to keep dlswTConnOperEntrys in\nthe `disconnected' state, this value should remain unchanged.")
dlswTConnOperPartnerVersionStr = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 2, 3, 1, 11), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0, 253))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswTConnOperPartnerVersionStr.setDescription("This value identifies the particular product version (e.g.,\nproduct name, code level, fix level) of this partner DLSw.\nThe format of the actual version string is vendor-specific.\nThis information is obtained from a DLSw capabilities exchange\nmessage received from the partner DLSw.\nA string of zero length is returned before a Capabilities\nExchange message is received, if one is never received, or\nif one is received but it does not contain a version string.\nIf an implementation chooses to keep dlswTConnOperEntrys in\nthe `disconnected' state, this value should remain unchanged.")
dlswTConnOperPartnerInitPacingWndw = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 2, 3, 1, 12), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswTConnOperPartnerInitPacingWndw.setDescription("The value of the partner initial receive pacing window.  This\nis our initial send pacing window for all new circuits on this\ntransport connection, as modified and granted by the first flow\ncontrol indication the partner sends on each circuit.\nThis information is obtained from a DLSw capabilities exchange\nmessage received from the partner DLSw.\nA value of zero is returned before a Capabilities\nExchange message is received, or if one is never received.\n\nIf an implementation chooses to keep dlswTConnOperEntrys in\nthe `disconnected' state, this value should remain unchanged.")
dlswTConnOperPartnerSapList = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 2, 3, 1, 13), OctetString().subtype(subtypeSpec=ConstraintsUnion(ValueSizeConstraint(0,0),ValueSizeConstraint(16,16),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswTConnOperPartnerSapList.setDescription("The Supported SAP List received in the capabilities\nexchange message from the partner DLSw.  This list has\nthe same format described for dlswTConnConfigSapList.\nA string of zero length is returned before a Capabilities\nExchange message is received, or if one is never received.\n\nIf an implementation chooses to keep dlswTConnOperEntrys in\nthe `disconnected' state, this value should remain unchanged.")
dlswTConnOperPartnerNBExcl = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 2, 3, 1, 14), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswTConnOperPartnerNBExcl.setDescription("The value of true signifies that the NetBIOS names received\nfrom this partner in the NetBIOS name list in its capabilities\nexchange message are the only NetBIOS names reachable by\nthat partner.  `False' indicates that other NetBIOS names may\nbe reachable.  `False' should be returned before a Capabilities\nExchange message is received, if one is never received, or if\none is received without a NB Name Exclusivity CV.\n\nIf an implementation chooses to keep dlswTConnOperEntrys in\nthe `disconnected' state, this value should remain unchanged.")
dlswTConnOperPartnerMacExcl = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 2, 3, 1, 15), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswTConnOperPartnerMacExcl.setDescription("The value of true signifies that the MAC addresses received\nfrom this partner in the MAC address list in its capabilities\nexchange message are the only MAC addresses reachable by\nthat partner.  `False' indicates that other MAC addresses may\nbe reachable.  `False' should be returned before a Capabilities\nExchange message is received, if one is never received, or if\none is received without a MAC Address Exclusivity CV.\n\nIf an implementation chooses to keep dlswTConnOperEntrys in\nthe `disconnected' state, this value should remain unchanged.")
dlswTConnOperPartnerNBInfo = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 2, 3, 1, 16), Integer().subtype(subtypeSpec=SingleValueConstraint(4,1,2,3,)).subtype(namedValues=NamedValues(("none", 1), ("partial", 2), ("complete", 3), ("notApplicable", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswTConnOperPartnerNBInfo.setDescription("It is up to this DSLw whether to keep either none, some,\nor all of the NetBIOS name list that was received in\nthe capabilities exchange message sent by this partner DLSw.\nThis object identifies how much information was kept by\nthis DLSw.  These names are stored as userConfigured\nremote entries in dlswDirNBTable.\nA value of (4), notApplicable, should be returned before\na Capabilities Exchange message is received, or if one is\nnever received.\nIf an implementation chooses to keep dlswTConnOperEntrys in\nthe `disconnected' state, this value should remain unchanged.")
dlswTConnOperPartnerMacInfo = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 2, 3, 1, 17), Integer().subtype(subtypeSpec=SingleValueConstraint(4,1,2,3,)).subtype(namedValues=NamedValues(("none", 1), ("partial", 2), ("complete", 3), ("notApplicable", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswTConnOperPartnerMacInfo.setDescription("It is up to this DLSw whether to keep either none, some,\nor all of the MAC address list that was received in the\ncapabilities exchange message sent by this partner DLSw.\nThis object identifies how much information was kept by\nthis DLSw.  These names are stored as userConfigured\nremote entries in dlswDirMACTable.\nA value of (4), notApplicable, should be returned before\na Capabilities Exchange message is received, or if one is\nnever received.\n\nIf an implementation chooses to keep dlswTConnOperEntrys in\nthe `disconnected' state, this value should remain unchanged.")
dlswTConnOperDiscTime = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 2, 3, 1, 18), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswTConnOperDiscTime.setDescription("The amount of time (in hundredths of a second) since the\ndlswTConnOperState last entered `disconnected' state.")
dlswTConnOperDiscReason = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 2, 3, 1, 19), Integer().subtype(subtypeSpec=SingleValueConstraint(6,5,4,2,1,3,)).subtype(namedValues=NamedValues(("other", 1), ("capExFailed", 2), ("transportLayerDisc", 3), ("operatorCommand", 4), ("lastCircuitDiscd", 5), ("protocolError", 6), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswTConnOperDiscReason.setDescription("This object signifies the reason that either prevented the\ntransport connection from entering the connected state, or\ncaused the transport connection to enter the disconnected\nstate.")
dlswTConnOperDiscActiveCir = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 2, 3, 1, 20), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswTConnOperDiscActiveCir.setDescription("The number of circuits active (not in DISCONNECTED state)\nat the time the transport connection was last disconnected.\nThis value is zero if the transport connection has never\nbeen connected.")
dlswTConnOperInDataPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 2, 3, 1, 21), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswTConnOperInDataPkts.setDescription("The number of Switch-to-Switch Protocol (SSP) messages of\ntype DGRMFRAME, DATAFRAME, or INFOFRAME received on this\ntransport connection.")
dlswTConnOperOutDataPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 2, 3, 1, 22), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswTConnOperOutDataPkts.setDescription("The number of Switch-to-Switch Protocol (SSP) messages of\ntype DGRMFRAME, DATAFRAME, or INFOFRAME transmitted on this\ntransport connection.")
dlswTConnOperInDataOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 2, 3, 1, 23), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswTConnOperInDataOctets.setDescription("The number octets in Switch-to-Switch Protocol (SSP) messages\nof type DGRMFRAME, DATAFRAME, or INFOFRAME received on this\ntransport connection.  Each message is counted starting with\nthe first octet following the SSP message header.")
dlswTConnOperOutDataOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 2, 3, 1, 24), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswTConnOperOutDataOctets.setDescription("The number octets in Switch-to-Switch Protocol (SSP) messages\nof type DGRMFRAME, DATAFRAME, or INFOFRAME transmitted on this\ntransport connection.  Each message is counted starting with\nthe first octet following the SSP message header.")
dlswTConnOperInCntlPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 2, 3, 1, 25), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswTConnOperInCntlPkts.setDescription("The number of Switch-to-Switch Protocol (SSP) messages\nreceived on this transport connection which were not of\ntype DGRMFRAME, DATAFRAME, or INFOFRAME.")
dlswTConnOperOutCntlPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 2, 3, 1, 26), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswTConnOperOutCntlPkts.setDescription("The number of Switch-to-Switch Protocol (SSP) messages of\ntransmitted on this transport connection which were not of\ntype DGRMFRAME, DATAFRAME, or INFOFRAME.")
dlswTConnOperCURexSents = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 2, 3, 1, 27), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswTConnOperCURexSents.setDescription("The number of CanUReach_ex messages sent on this transport\nconnection.")
dlswTConnOperICRexRcvds = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 2, 3, 1, 28), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswTConnOperICRexRcvds.setDescription("The number of ICanReach_ex messages received on this transport\nconnection.")
dlswTConnOperCURexRcvds = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 2, 3, 1, 29), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswTConnOperCURexRcvds.setDescription("The number of CanUReach_ex messages received on this transport\nconnection.")
dlswTConnOperICRexSents = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 2, 3, 1, 30), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswTConnOperICRexSents.setDescription("The number of ICanReach_ex messages sent on this transport\nconnection.")
dlswTConnOperNQexSents = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 2, 3, 1, 31), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswTConnOperNQexSents.setDescription("The number of NetBIOS_NQ_ex (NetBIOS Name Query-explorer)\nmessages sent on this transport connection.")
dlswTConnOperNRexRcvds = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 2, 3, 1, 32), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswTConnOperNRexRcvds.setDescription("The number of NETBIOS_NR_ex (NetBIOS Name Recognized-explorer)\nmessages received on this transport connection.")
dlswTConnOperNQexRcvds = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 2, 3, 1, 33), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswTConnOperNQexRcvds.setDescription("The number of NETBIOS_NQ_ex messages received on this\ntransport connection.")
dlswTConnOperNRexSents = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 2, 3, 1, 34), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswTConnOperNRexSents.setDescription("The number of NETBIOS_NR_ex messages sent on this transport\nconnection.")
dlswTConnOperCirCreates = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 2, 3, 1, 35), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswTConnOperCirCreates.setDescription("The number of times that circuits entered `circuit_established'\nstate (not counting transitions from `circuit_restart').")
dlswTConnOperCircuits = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 2, 3, 1, 36), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswTConnOperCircuits.setDescription("The number of currently active circuits on this transport\nconnection, where `active' means not in `disconnected' state.")
dlswTConnSpecific = MibIdentifier((1, 3, 6, 1, 2, 1, 46, 1, 2, 4))
dlswTConnTcp = MibIdentifier((1, 3, 6, 1, 2, 1, 46, 1, 2, 4, 1))
dlswTConnTcpConfigTable = MibTable((1, 3, 6, 1, 2, 1, 46, 1, 2, 4, 1, 1))
if mibBuilder.loadTexts: dlswTConnTcpConfigTable.setDescription("This table defines the TCP transport connections that\nwill be either initiated by or accepted by this DSLw.\nIt augments the entries in dlswTConnConfigTable whose domain\nis dlswTCPDomain.")
dlswTConnTcpConfigEntry = MibTableRow((1, 3, 6, 1, 2, 1, 46, 1, 2, 4, 1, 1, 1)).setIndexNames((0, "DLSW-MIB", "dlswTConnConfigIndex"))
if mibBuilder.loadTexts: dlswTConnTcpConfigEntry.setDescription("Each conceptual row defines parameters that are\nspecific to dlswTCPDomain transport connections.")
dlswTConnTcpConfigKeepAliveInt = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 2, 4, 1, 1, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 1800)).clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dlswTConnTcpConfigKeepAliveInt.setDescription("The time in seconds between TCP keepAlive messages when\nno traffic is flowing.  Zero signifies no keepAlive protocol.\nChanges take effect only for new TCP connections.")
dlswTConnTcpConfigTcpConnections = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 2, 4, 1, 1, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 16)).clone(2)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dlswTConnTcpConfigTcpConnections.setDescription("This is our preferred number of TCP connections within a\nTCP transport connection.  The actual number used is negotiated\nat capabilities exchange time. Changes take effect only\nfor new transport connections.")
dlswTConnTcpConfigMaxSegmentSize = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 2, 4, 1, 1, 1, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535)).clone(4096)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dlswTConnTcpConfigMaxSegmentSize.setDescription("This is the number of bytes that this node is\nwilling to receive over the read TCP connection(s).\nChanges take effect for new transport connections.")
dlswTConnTcpOperTable = MibTable((1, 3, 6, 1, 2, 1, 46, 1, 2, 4, 1, 2))
if mibBuilder.loadTexts: dlswTConnTcpOperTable.setDescription("A list of TCP transport connections.   It is optional\nbut desirable for the agent to keep an entry for some\nperiod of time after the transport connection is\ndisconnected.  This allows the manager to capture\nadditional useful information about the connection, in\nparticular, statistical information and the cause of the\ndisconnection.")
dlswTConnTcpOperEntry = MibTableRow((1, 3, 6, 1, 2, 1, 46, 1, 2, 4, 1, 2, 1)).setIndexNames((0, "DLSW-MIB", "dlswTConnOperTDomain"), (0, "DLSW-MIB", "dlswTConnOperRemoteTAddr"))
if mibBuilder.loadTexts: dlswTConnTcpOperEntry.setDescription("")
dlswTConnTcpOperKeepAliveInt = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 2, 4, 1, 2, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 1800))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswTConnTcpOperKeepAliveInt.setDescription("The time in seconds between TCP keepAlive messages when\nno traffic is flowing.  Zero signifies no keepAlive protocol is\noperating.")
dlswTConnTcpOperPrefTcpConnections = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 2, 4, 1, 2, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 16))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswTConnTcpOperPrefTcpConnections.setDescription("This is the number of TCP connections preferred by this DLSw\npartner, as received in its capabilities exchange message.")
dlswTConnTcpOperTcpConnections = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 2, 4, 1, 2, 1, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 16))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswTConnTcpOperTcpConnections.setDescription("This is the actual current number of TCP connections within\nthis transport connection.")
dlswInterface = MibIdentifier((1, 3, 6, 1, 2, 1, 46, 1, 3))
dlswIfTable = MibTable((1, 3, 6, 1, 2, 1, 46, 1, 3, 1))
if mibBuilder.loadTexts: dlswIfTable.setDescription("The list of interfaces on which DLSw is active.")
dlswIfEntry = MibTableRow((1, 3, 6, 1, 2, 1, 46, 1, 3, 1, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: dlswIfEntry.setDescription("")
dlswIfRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 3, 1, 1, 1), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dlswIfRowStatus.setDescription("This object is used by the manager to create\nor delete the row entry in the dlswIfTable\nfollowing the RowStatus textual convention.")
dlswIfVirtualSegment = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 3, 1, 1, 2), Integer32().subtype(subtypeSpec=ConstraintsUnion(ValueRangeConstraint(0,4095),ValueRangeConstraint(65535,65535),)).clone(65535)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dlswIfVirtualSegment.setDescription("The segment number that uniquely identifies the virtual\nsegment to which this DLSw interface is connected.\nCurrent source routing protocols limit this value to\nthe range 0 - 4095. (The value 0 is used by some\nmanagement applications for special test cases.)\nA value of 65535 signifies that no virtual segment\nis assigned to this interface.  For instance,\nin a non-source routing environment, segment number\nassignment is not required.")
dlswIfSapList = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 3, 1, 1, 3), OctetString().subtype(subtypeSpec=ValueSizeConstraint(16, 16)).setFixedLength(16).clone(hexValue='ff000000000000000000000000000000')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dlswIfSapList.setDescription("The SAP list indicates which SAPs are allowed to be\ndata link switched through this interface.  This list\nhas the same format described for dlswTConnConfigSapList.\n\nWhen changes to this object take effect is implementation-\nspecific.  Turning off a particular SAP can destroy\nactive circuits that are using that SAP.  An agent\nimplementation may reject such changes until there are no\nactive circuits if it so chooses.  In this case, it is up\nto the manager to close the circuits first, using\ndlswCircuitState.\n\nThe DEFVAL below indicates support for SAPs 0, 4, 8, and C.")
dlswDirectory = MibIdentifier((1, 3, 6, 1, 2, 1, 46, 1, 4))
dlswDirStat = MibIdentifier((1, 3, 6, 1, 2, 1, 46, 1, 4, 1))
dlswDirMacEntries = MibScalar((1, 3, 6, 1, 2, 1, 46, 1, 4, 1, 1), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswDirMacEntries.setDescription("The current total number of entries in the dlswDirMacTable.")
dlswDirMacCacheHits = MibScalar((1, 3, 6, 1, 2, 1, 46, 1, 4, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswDirMacCacheHits.setDescription("The number of times a cache search for a particular MAC address\nresulted in success.")
dlswDirMacCacheMisses = MibScalar((1, 3, 6, 1, 2, 1, 46, 1, 4, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswDirMacCacheMisses.setDescription("The number of times a cache search for a particular MAC address\nresulted in failure.")
dlswDirMacCacheNextIndex = MibScalar((1, 3, 6, 1, 2, 1, 46, 1, 4, 1, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswDirMacCacheNextIndex.setDescription("The next value of dlswDirMacIndex to be assigned by\nthe agent.  A retrieval of this object atomically reserves\nthe returned value for use by the manager to create a row\nin dlswDirMacTable.  This makes it possible for the agent\nto control the index space of the MAC address cache, yet\nallows the manager to administratively create new rows.")
dlswDirNBEntries = MibScalar((1, 3, 6, 1, 2, 1, 46, 1, 4, 1, 5), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswDirNBEntries.setDescription("The current total number of entries in the dlswDirNBTable.")
dlswDirNBCacheHits = MibScalar((1, 3, 6, 1, 2, 1, 46, 1, 4, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswDirNBCacheHits.setDescription("The number of times a cache search for a particular NetBIOS\nname resulted in success.")
dlswDirNBCacheMisses = MibScalar((1, 3, 6, 1, 2, 1, 46, 1, 4, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswDirNBCacheMisses.setDescription("The number of times a cache search for a particular NetBIOS\nname resulted in failure.")
dlswDirNBCacheNextIndex = MibScalar((1, 3, 6, 1, 2, 1, 46, 1, 4, 1, 8), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswDirNBCacheNextIndex.setDescription("The next value of dlswDirNBIndex to be assigned by the\nagent.  A retrieval of this object atomically reserves\nthe returned value for use by the manager to create\na row in dlswDirNBTable.  This makes it possible for the\nagent to control the index space for the NetBIOS name\ncache, yet allows the manager to administratively\ncreate new rows.")
dlswDirCache = MibIdentifier((1, 3, 6, 1, 2, 1, 46, 1, 4, 2))
dlswDirMacTable = MibTable((1, 3, 6, 1, 2, 1, 46, 1, 4, 2, 1))
if mibBuilder.loadTexts: dlswDirMacTable.setDescription("This table contains locations of MAC addresses.\nThey could be either verified or not verified,\nlocal or remote, and configured locally or learned\nfrom either Capabilities Exchange messages or\ndirectory searches.")
dlswDirMacEntry = MibTableRow((1, 3, 6, 1, 2, 1, 46, 1, 4, 2, 1, 1)).setIndexNames((0, "DLSW-MIB", "dlswDirMacIndex"))
if mibBuilder.loadTexts: dlswDirMacEntry.setDescription("Indexed by dlswDirMacIndex.")
dlswDirMacIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 4, 2, 1, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dlswDirMacIndex.setDescription("Uniquely identifies a conceptual row of this table.")
dlswDirMacMac = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 4, 2, 1, 1, 2), MacAddressNC()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dlswDirMacMac.setDescription("The MAC address, together with the dlswDirMacMask,\nspecifies a set of MAC addresses that are defined or\ndiscovered through an interface or partner DLSw nodes.")
dlswDirMacMask = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 4, 2, 1, 1, 3), MacAddressNC().clone(hexValue='ffffffffffff')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dlswDirMacMask.setDescription("The MAC address mask, together with the dlswDirMacMac,\nspecifies a set of MAC addresses that are defined or\ndiscovered through an interface or partner DLSw nodes.")
dlswDirMacEntryType = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 4, 2, 1, 1, 4), Integer().subtype(subtypeSpec=SingleValueConstraint(2,3,4,5,1,)).subtype(namedValues=NamedValues(("other", 1), ("userConfiguredPublic", 2), ("userConfiguredPrivate", 3), ("partnerCapExMsg", 4), ("dynamic", 5), )).clone(2)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dlswDirMacEntryType.setDescription("The cause of the creation of this conceptual row.\nIt could be one of the three methods: (1) user\nconfigured, including via management protocol\nset operations, configuration file, command line\nor equivalent methods; (2) learned from the\npartner DLSw Capabilities Exchange messages;\nand (3) dynamic, e.g., learned from ICanReach\nmessages, or LAN explorer frames.  Since only\nindividual MAC addresses can be dynamically learned,\ndynamic entries will all have a mask of all FFs.\n\nThe public versus private distinction for user-\nconfigured resources applies only to local resources\n(UC remote resources are private), and indicates\nwhether that resource should be advertised in\ncapabilities exchange messages sent by this node.")
dlswDirMacLocationType = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 4, 2, 1, 1, 5), Integer().subtype(subtypeSpec=SingleValueConstraint(3,1,2,)).subtype(namedValues=NamedValues(("other", 1), ("local", 2), ("remote", 3), )).clone(2)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dlswDirMacLocationType.setDescription("The location of the resource (or a collection of\nresources using a mask) of this conceptual row\nis either (1) local - the resource is reachable\nvia an interface, or (2) remote - the resource\nis reachable via a partner DLSw node (or a set\nof partner DLSw nodes).")
dlswDirMacLocation = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 4, 2, 1, 1, 6), RowPointer().clone('0.0')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dlswDirMacLocation.setDescription("Points to either the ifEntry, dlswTConnConfigEntry,\ndlswTConnOperEntry, 0.0, or something that is implementation\nspecific.  It identifies the location of the MAC address\n(or the collection of MAC addresses.)")
dlswDirMacStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 4, 2, 1, 1, 7), Integer().subtype(subtypeSpec=SingleValueConstraint(3,1,2,)).subtype(namedValues=NamedValues(("unknown", 1), ("reachable", 2), ("notReachable", 3), )).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dlswDirMacStatus.setDescription("This object specifies whether DLSw currently believes\nthe MAC address to be accessible at the specified location.\nThe value `notReachable' allows a configured resource\ndefinition to be taken out of service when a search to\nthat resource fails (avoiding a repeat of the search).")
dlswDirMacLFSize = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 4, 2, 1, 1, 8), LFSize().clone('lfs65535')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dlswDirMacLFSize.setDescription("The largest size of the MAC INFO field (LLC header and data)\nthat a circuit to the MAC address can carry through this path.")
dlswDirMacRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 4, 2, 1, 1, 9), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dlswDirMacRowStatus.setDescription("This object is used by the manager to create\nor delete the row entry in the dlswDirMacTable\nfollowing the RowStatus textual convention.")
dlswDirNBTable = MibTable((1, 3, 6, 1, 2, 1, 46, 1, 4, 2, 2))
if mibBuilder.loadTexts: dlswDirNBTable.setDescription("This table contains locations of NetBIOS names.\nThey could be either verified or not verified,\nlocal or remote, and configured locally or learned\nfrom either Capabilities Exchange messages or\ndirectory searches.")
dlswDirNBEntry = MibTableRow((1, 3, 6, 1, 2, 1, 46, 1, 4, 2, 2, 1)).setIndexNames((0, "DLSW-MIB", "dlswDirNBIndex"))
if mibBuilder.loadTexts: dlswDirNBEntry.setDescription("Indexed by dlswDirNBIndex.")
dlswDirNBIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 4, 2, 2, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dlswDirNBIndex.setDescription("Uniquely identifies a conceptual row of this table.")
dlswDirNBName = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 4, 2, 2, 1, 2), NBName()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dlswDirNBName.setDescription("The NetBIOS name (including `any char' and `wildcard'\ncharacters) specifies a set of NetBIOS names that are\ndefined or discovered through an interface or partner\nDLSw nodes.")
dlswDirNBNameType = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 4, 2, 2, 1, 3), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,3,)).subtype(namedValues=NamedValues(("unknown", 1), ("individual", 2), ("group", 3), )).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dlswDirNBNameType.setDescription("Whether dlswDirNBName represents an (or a set of) individual\nor group NetBIOS name(s).")
dlswDirNBEntryType = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 4, 2, 2, 1, 4), Integer().subtype(subtypeSpec=SingleValueConstraint(2,3,4,5,1,)).subtype(namedValues=NamedValues(("other", 1), ("userConfiguredPublic", 2), ("userConfiguredPrivate", 3), ("partnerCapExMsg", 4), ("dynamic", 5), )).clone(2)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dlswDirNBEntryType.setDescription("The cause of the creation of this conceptual row.\nIt could be one of the three methods: (1) user\nconfigured, including via management protocol\nset operations, configuration file, command line,\nor equivalent methods; (2) learned from the\npartner DLSw Capabilities Exchange messages;\nand (3) dynamic, e.g., learned from ICanReach\nmessages, or test frames.  Since only actual\nNetBIOS names can be dynamically learned, dynamic\nentries will not contain any char or wildcard\ncharacters.\n\nThe public versus private distinction for user-\nconfigured resources applies only to local resources\n(UC remote resources are private), and indicates\nwhether that resource should be advertised in\ncapabilities exchange messages sent by this node.")
dlswDirNBLocationType = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 4, 2, 2, 1, 5), Integer().subtype(subtypeSpec=SingleValueConstraint(3,1,2,)).subtype(namedValues=NamedValues(("other", 1), ("local", 2), ("remote", 3), )).clone(2)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dlswDirNBLocationType.setDescription("The location of the resource (or a collection of resources\nusing any char/wildcard characters) of this conceptual row\nis either (1) local - the resource is reachable via an\ninterface, or (2) remote - the resource is reachable via a\na partner DLSw node (or a set of partner DLSw nodes).")
dlswDirNBLocation = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 4, 2, 2, 1, 6), RowPointer().clone('0.0')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dlswDirNBLocation.setDescription("Points to either the ifEntry, dlswTConnConfigEntry,\ndlswTConnOperEntry, 0.0, or something that is implementation\nspecific.  It identifies the location of the NetBIOS name\nor the set of NetBIOS names.")
dlswDirNBStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 4, 2, 2, 1, 7), Integer().subtype(subtypeSpec=SingleValueConstraint(3,1,2,)).subtype(namedValues=NamedValues(("unknown", 1), ("reachable", 2), ("notReachable", 3), )).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dlswDirNBStatus.setDescription("This object specifies whether DLSw currently believes\nthe NetBIOS name to be accessible at the specified location.\nThe value `notReachable' allows a configured resource\ndefinition to be taken out of service when a search to\nthat resource fails (avoiding a repeat of the search).")
dlswDirNBLFSize = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 4, 2, 2, 1, 8), LFSize().clone('lfs65535')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dlswDirNBLFSize.setDescription("The largest size of the MAC INFO field (LLC header and data)\nthat a circuit to the NB name can carry through this path.")
dlswDirNBRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 4, 2, 2, 1, 9), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dlswDirNBRowStatus.setDescription("This object is used by manager to create\nor delete the row entry in the dlswDirNBTable\nfollowing the RowStatus textual convention.")
dlswDirLocate = MibIdentifier((1, 3, 6, 1, 2, 1, 46, 1, 4, 3))
dlswDirLocateMacTable = MibTable((1, 3, 6, 1, 2, 1, 46, 1, 4, 3, 1))
if mibBuilder.loadTexts: dlswDirLocateMacTable.setDescription("This table is used to retrieve all entries in the\ndlswDirMacTable that match a given MAC address,\nin the order of the best matched first, the\nsecond best matched second, and so on, till\nno more entries match the given MAC address.")
dlswDirLocateMacEntry = MibTableRow((1, 3, 6, 1, 2, 1, 46, 1, 4, 3, 1, 1)).setIndexNames((0, "DLSW-MIB", "dlswDirLocateMacMac"), (0, "DLSW-MIB", "dlswDirLocateMacMatch"))
if mibBuilder.loadTexts: dlswDirLocateMacEntry.setDescription("Indexed by dlswDirLocateMacMac and dlswDirLocateMacMatch.\nThe first object is the MAC address of interest, and\nthe second object is the order in the list of all\nentries that match the MAC address.")
dlswDirLocateMacMac = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 4, 3, 1, 1, 1), MacAddressNC()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dlswDirLocateMacMac.setDescription("The MAC address to be located.")
dlswDirLocateMacMatch = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 4, 3, 1, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 255))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dlswDirLocateMacMatch.setDescription("The order of the entries of dlswDirMacTable\nthat match dlswDirLocateMacMac.  A value of\none represents the entry that best matches the\nMAC address.  A value of two represents the second\nbest matched entry, and so on.")
dlswDirLocateMacLocation = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 4, 3, 1, 1, 3), RowPointer()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswDirLocateMacLocation.setDescription("Points to the dlswDirMacEntry.")
dlswDirLocateNBTable = MibTable((1, 3, 6, 1, 2, 1, 46, 1, 4, 3, 2))
if mibBuilder.loadTexts: dlswDirLocateNBTable.setDescription("This table is used to retrieve all entries in the\ndlswDirNBTable that match a given NetBIOS name,\nin the order of the best matched first, the\nsecond best matched second, and so on, till\nno more entries match the given NetBIOS name.")
dlswDirLocateNBEntry = MibTableRow((1, 3, 6, 1, 2, 1, 46, 1, 4, 3, 2, 1)).setIndexNames((0, "DLSW-MIB", "dlswDirLocateNBName"), (0, "DLSW-MIB", "dlswDirLocateNBMatch"))
if mibBuilder.loadTexts: dlswDirLocateNBEntry.setDescription("Indexed by dlswDirLocateNBName and dlswDirLocateNBMatch.\nThe first object is the NetBIOS name of interest, and\nthe second object is the order in the list of all\nentries that match the NetBIOS name.")
dlswDirLocateNBName = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 4, 3, 2, 1, 1), NBName()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dlswDirLocateNBName.setDescription("The NetBIOS name to be located (no any char or wildcards).")
dlswDirLocateNBMatch = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 4, 3, 2, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 255))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dlswDirLocateNBMatch.setDescription("The order of the entries of dlswDirNBTable\nthat match dlswDirLocateNBName.  A value of\none represents the entry that best matches the\nNetBIOS name.  A value of two represents the second\nbest matched entry, and so on.")
dlswDirLocateNBLocation = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 4, 3, 2, 1, 3), RowPointer()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswDirLocateNBLocation.setDescription("Points to the dlswDirNBEntry.")
dlswCircuit = MibIdentifier((1, 3, 6, 1, 2, 1, 46, 1, 5))
dlswCircuitStat = MibIdentifier((1, 3, 6, 1, 2, 1, 46, 1, 5, 1))
dlswCircuitStatActives = MibScalar((1, 3, 6, 1, 2, 1, 46, 1, 5, 1, 1), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswCircuitStatActives.setDescription("The current number of circuits in dlswCircuitTable that are\nnot in the disconnected state.")
dlswCircuitStatCreates = MibScalar((1, 3, 6, 1, 2, 1, 46, 1, 5, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswCircuitStatCreates.setDescription("The total number of entries ever added to dlswCircuitTable,\nor reactivated upon exiting `disconnected' state.")
dlswCircuitTable = MibTable((1, 3, 6, 1, 2, 1, 46, 1, 5, 2))
if mibBuilder.loadTexts: dlswCircuitTable.setDescription("This table is the circuit representation in the DLSw\nentity. Virtual data links are used to represent any internal\nend stations.  There is a conceptual row associated with\neach data link.  Thus, for circuits without an intervening\ntransport connection, there are two conceptual rows\nfor each circuit.\n\nThe table consists of the circuits being established,\nestablished, and as an implementation option, circuits that\nhave been disconnected.  For circuits carried over\ntransport connections, an entry is created after\nthe CUR_cs was sent or received.  For circuits between\ntwo locally attached devices, or internal virtual MAC\naddresses, an entry is created when the equivalent of\nCUR_cs sent/received status is reached.\n\nEnd station 1 (S1) and End station 2 (S2) are used to\nrepresent the two end stations of the circuit.\nS1 is always an end station which is locally attached.\nS2 may be locally attached or remote.  If it is locally\nattached, the circuit will be represented by two rows indexed\nby (A, B) and (B, A) where A & B are the relevant MACs/SAPs.\n\nThe table may be used to store the causes of disconnection of\ncircuits.  It is recommended that the oldest disconnected\ncircuit entry be removed from this table when the memory\nspace of disconnected circuits is needed.")
dlswCircuitEntry = MibTableRow((1, 3, 6, 1, 2, 1, 46, 1, 5, 2, 1)).setIndexNames((0, "DLSW-MIB", "dlswCircuitS1Mac"), (0, "DLSW-MIB", "dlswCircuitS1Sap"), (0, "DLSW-MIB", "dlswCircuitS2Mac"), (0, "DLSW-MIB", "dlswCircuitS2Sap"))
if mibBuilder.loadTexts: dlswCircuitEntry.setDescription("")
dlswCircuitS1Mac = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 5, 2, 1, 1), MacAddressNC()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dlswCircuitS1Mac.setDescription("The MAC Address of End Station 1 (S1) used for this circuit.")
dlswCircuitS1Sap = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 5, 2, 1, 2), OctetString().subtype(subtypeSpec=ValueSizeConstraint(1, 1)).setFixedLength(1)).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dlswCircuitS1Sap.setDescription("The SAP at End Station 1 (S1) used for this circuit.")
dlswCircuitS1IfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 5, 2, 1, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswCircuitS1IfIndex.setDescription("The ifEntry index of the local interface through which S1\ncan be reached.")
dlswCircuitS1DlcType = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 5, 2, 1, 4), DlcType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswCircuitS1DlcType.setDescription("The DLC protocol in use between the DLSw node and S1.")
dlswCircuitS1RouteInfo = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 5, 2, 1, 5), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 30))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswCircuitS1RouteInfo.setDescription("If source-route bridging is in use between the DLSw\nnode and S1, this is the routing information field\ndescribing the path between the two devices.\nOtherwise the value will be an OCTET STRING of\nzero length.")
dlswCircuitS1CircuitId = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 5, 2, 1, 6), OctetString().subtype(subtypeSpec=ConstraintsUnion(ValueSizeConstraint(0,0),ValueSizeConstraint(8,8),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswCircuitS1CircuitId.setDescription("The Circuit ID assigned by this DLSw node to this circuit.\nThe first four octets are the DLC port Id, and\nthe second four octets are the Data Link Correlator.\nIf the DLSw SSP was not used to establish this circuit,\nthe value will be a string of zero length.")
dlswCircuitS1Dlc = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 5, 2, 1, 7), RowPointer()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswCircuitS1Dlc.setDescription("Points to a conceptual row of the underlying DLC MIB,\nwhich could either be the standard MIBs (e.g., the SDLC),\nor an enterprise-specific DLC MIB.")
dlswCircuitS2Mac = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 5, 2, 1, 8), MacAddressNC()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dlswCircuitS2Mac.setDescription("The MAC Address of End Station 2 (S2) used for this circuit.")
dlswCircuitS2Sap = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 5, 2, 1, 9), OctetString().subtype(subtypeSpec=ValueSizeConstraint(1, 1)).setFixedLength(1)).setMaxAccess("noaccess")
if mibBuilder.loadTexts: dlswCircuitS2Sap.setDescription("The SAP at End Station 2 (S2) used for this circuit.")
dlswCircuitS2Location = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 5, 2, 1, 10), EndStationLocation()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswCircuitS2Location.setDescription("The location of End Station 2 (S2).\nIf the location of End Station 2 is local, the\ninterface information will be available in the\nconceptual row whose S1 and S2 are the S2 and\nthe S1 of this conceptual row, respectively.")
dlswCircuitS2TDomain = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 5, 2, 1, 11), ObjectIdentifier()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswCircuitS2TDomain.setDescription("If the location of End Station 2 is remote,\nthis value is the transport domain of the\ntransport protocol the circuit is running\nover.  Otherwise, the value is 0.0.")
dlswCircuitS2TAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 5, 2, 1, 12), TAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswCircuitS2TAddress.setDescription("If the location of End Station 2 is remote,\nthis object contains the address of the partner\nDLSw, else it will be an OCTET STRING of zero length.")
dlswCircuitS2CircuitId = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 5, 2, 1, 13), OctetString().subtype(subtypeSpec=ConstraintsUnion(ValueSizeConstraint(0,0),ValueSizeConstraint(8,8),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswCircuitS2CircuitId.setDescription("The Circuit ID assigned to this circuit by the partner\nDLSw node.  The first four octets are the DLC port Id, and\nthe second four octets are the Data Link Correlator.\nIf the DLSw SSP was not used to establish this circuit,\nthe value will be a string of zero length.")
dlswCircuitOrigin = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 5, 2, 1, 14), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("s1", 1), ("s2", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswCircuitOrigin.setDescription("This object specifies which of the two end stations\ninitiated the establishment of this circuit.")
dlswCircuitEntryTime = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 5, 2, 1, 15), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswCircuitEntryTime.setDescription("The amount of time (in hundredths of a second) since this\ncircuit table conceptual row was created.")
dlswCircuitStateTime = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 5, 2, 1, 16), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswCircuitStateTime.setDescription("The amount of time (in hundredths of a second) since this\ncircuit entered the current state.")
dlswCircuitState = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 5, 2, 1, 17), Integer().subtype(subtypeSpec=SingleValueConstraint(12,11,5,10,13,3,8,6,7,1,2,4,9,)).subtype(namedValues=NamedValues(("disconnected", 1), ("haltPending", 10), ("haltPendingNoack", 11), ("circuitRestart", 12), ("restartPending", 13), ("circuitStart", 2), ("resolvePending", 3), ("circuitPending", 4), ("circuitEstablished", 5), ("connectPending", 6), ("contactPending", 7), ("connected", 8), ("disconnectPending", 9), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: dlswCircuitState.setDescription("The current state of this circuit.  The agent, implementation\nspecific, may choose to keep entries for some period of time\nafter circuit disconnect, so the manager can gather the time\nand cause of disconnection.\n\nWhile all of the specified values may be returned from a GET\noperation, the only SETable value is `disconnectPending'.\nWhen this value is set, DLSw should perform the appropriate\naction given its previous state (e.g., send HALT_DL if the\nstate was `connected') to bring the circuit down to the\n`disconnected' state.  Both the partner DLSw and local end\nstation(s) should be notified as appropriate.\n\nThis MIB provides no facility to re-establish a disconnected\ncircuit, because in DLSw this should be an end station-driven\nfunction.")
dlswCircuitPriority = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 5, 2, 1, 18), Integer().subtype(subtypeSpec=SingleValueConstraint(3,1,4,2,5,)).subtype(namedValues=NamedValues(("unsupported", 1), ("low", 2), ("medium", 3), ("high", 4), ("highest", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswCircuitPriority.setDescription("The transmission priority of this circuit as understood by\nthis DLSw node.  This value is determined by the two DLSw\nnodes at circuit startup time.  If this DLSw node does not\nsupport DLSw circuit priority, the value `unsupported' should\nbe returned.")
dlswCircuitFCSendGrantedUnits = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 5, 2, 1, 19), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswCircuitFCSendGrantedUnits.setDescription("The number of paced SSP messages that this DLSw is currently\nauthorized to send on this circuit before it must stop and\nwait for an additional flow control indication from the\npartner DLSw.\n\nThe value zero should be returned if this circuit is not\nrunning the DLSw pacing protocol.")
dlswCircuitFCSendCurrentWndw = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 5, 2, 1, 20), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswCircuitFCSendCurrentWndw.setDescription("The current window size that this DLSw is using in its role\nas a data sender.  This is the value by which this DLSw would\nincrease the number of messages it is authorized to send, if\nit were to receive a flow control indication with the bits\nspecifying `repeat window'.\nThe value zero should be returned if this circuit is not\nrunning the DLSw pacing protocol.")
dlswCircuitFCRecvGrantedUnits = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 5, 2, 1, 21), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswCircuitFCRecvGrantedUnits.setDescription("The current number of paced SSP messages that this DLSw has\nauthorized the partner DLSw to send on this circuit before\nthe partner DLSw must stop and wait for an additional flow\ncontrol indication from this DLSw.\n\nThe value zero should be returned if this circuit is not\nrunning the DLSw pacing protocol.")
dlswCircuitFCRecvCurrentWndw = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 5, 2, 1, 22), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswCircuitFCRecvCurrentWndw.setDescription("The current window size that this DLSw is using in its role\nas a data receiver.  This is the number of additional paced\nSSP messages that this DLSw would be authorizing its DLSw\npartner to send, if this DLSw were to send a flow control\nindication with the bits specifying `repeat window'.\n\nThe value zero should be returned if this circuit is not\nrunning the DLSw pacing protocol.")
dlswCircuitFCLargestRecvGranted = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 5, 2, 1, 23), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswCircuitFCLargestRecvGranted.setDescription("The largest receive window size granted by this DLSw during\nthe current activation of this circuit.  This is not the\nlargest number of messages granted at any time, but the\nlargest window size as represented by FCIND operator bits.\n\nThe value zero should be returned if this circuit is not\nrunning the DLSw pacing protocol.")
dlswCircuitFCLargestSendGranted = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 5, 2, 1, 24), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswCircuitFCLargestSendGranted.setDescription("The largest send (with respect to this DLSw) window size\ngranted by the partner DLSw during the current activation of\nthis circuit.\n\nThe value zero should be returned if this circuit is not\nrunning the DLSw pacing protocol.")
dlswCircuitFCHalveWndwSents = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 5, 2, 1, 25), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswCircuitFCHalveWndwSents.setDescription("The number of Halve Window operations this DLSw has sent on\nthis circuit, in its role as a data receiver.\n\nThe value zero should be returned if this circuit is not\nrunning the DLSw pacing protocol.")
dlswCircuitFCResetOpSents = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 5, 2, 1, 26), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswCircuitFCResetOpSents.setDescription("The number of Reset Window operations this DLSw has sent on\nthis circuit, in its role as a data receiver.\n\nThe value zero should be returned if this circuit is not\nrunning the DLSw pacing protocol.")
dlswCircuitFCHalveWndwRcvds = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 5, 2, 1, 27), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswCircuitFCHalveWndwRcvds.setDescription("The number of Halve Window operations this DLSw has received on\nthis circuit, in its role as a data sender.\n\nThe value zero should be returned if this circuit is not\nrunning the DLSw pacing protocol.")
dlswCircuitFCResetOpRcvds = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 5, 2, 1, 28), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswCircuitFCResetOpRcvds.setDescription("The number of Reset Window operations this DLSw has received on\nthis circuit, in its role as a data sender.\nThe value zero should be returned if this circuit is not\nrunning the DLSw pacing protocol.")
dlswCircuitDiscReasonLocal = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 5, 2, 1, 29), Integer().subtype(subtypeSpec=SingleValueConstraint(7,3,5,2,6,1,4,)).subtype(namedValues=NamedValues(("endStationDiscRcvd", 1), ("endStationDlcError", 2), ("protocolError", 3), ("operatorCommand", 4), ("haltDlRcvd", 5), ("haltDlNoAckRcvd", 6), ("transportConnClosed", 7), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswCircuitDiscReasonLocal.setDescription("The reason why this circuit was last disconnected, as seen\nby this DLSw node.\n\nThis object is present only if the agent keeps circuit\ntable entries around for some period after circuit disconnect.")
dlswCircuitDiscReasonRemote = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 5, 2, 1, 30), Integer().subtype(subtypeSpec=SingleValueConstraint(4,3,1,5,2,)).subtype(namedValues=NamedValues(("unknown", 1), ("endStationDiscRcvd", 2), ("endStationDlcError", 3), ("protocolError", 4), ("operatorCommand", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswCircuitDiscReasonRemote.setDescription("The generic reason code why this circuit was last\ndisconnected, as reported by the DLSw partner in a HALT_DL\nor HALT_DL_NOACK.  If the partner does not send a reason\ncode in these messages, or the DLSw implementation does\nnot report receiving one, the value `unknown' is returned.\n\nThis object is present only if the agent keeps circuit table\nentries around for some period after circuit disconnect.")
dlswCircuitDiscReasonRemoteData = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 5, 2, 1, 31), OctetString().subtype(subtypeSpec=ConstraintsUnion(ValueSizeConstraint(0,0),ValueSizeConstraint(4,4),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswCircuitDiscReasonRemoteData.setDescription("Implementation-specific data reported by the DLSw partner in\na HALT_DL or HALT_DL_NOACK, to help specify how and why this\ncircuit was last disconnected.  If the partner does not send\nthis data in these messages, or the DLSw implementation does\nnot report receiving it, a string of zero length is returned.\n\nThis object is present only if the agent keeps circuit table\nentries around for some period after circuit disconnect.")
dlswSdlc = MibIdentifier((1, 3, 6, 1, 2, 1, 46, 1, 6))
dlswSdlcLsEntries = MibScalar((1, 3, 6, 1, 2, 1, 46, 1, 6, 1), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: dlswSdlcLsEntries.setDescription("The number of entries in dlswSdlcLsTable.")
dlswSdlcLsTable = MibTable((1, 3, 6, 1, 2, 1, 46, 1, 6, 2))
if mibBuilder.loadTexts: dlswSdlcLsTable.setDescription("The table defines the virtual MAC addresses for those\nSDLC link stations that participate in data link switching.")
dlswSdlcLsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 46, 1, 6, 2, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "SNA-SDLC-MIB", "sdlcLSAddress"))
if mibBuilder.loadTexts: dlswSdlcLsEntry.setDescription("The index of this table is the ifIndex value for the\nSDLC port which owns this link station and the poll\naddress of the particular SDLC link station.")
dlswSdlcLsLocalMac = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 6, 2, 1, 1), MacAddressNC()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dlswSdlcLsLocalMac.setDescription("The virtual MAC address used to represent the SDLC-attached\nlink station to the rest of the DLSw network.")
dlswSdlcLsLocalSap = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 6, 2, 1, 2), OctetString().subtype(subtypeSpec=ValueSizeConstraint(1, 1)).setFixedLength(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dlswSdlcLsLocalSap.setDescription("The SAP used to represent this link station.")
dlswSdlcLsLocalIdBlock = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 6, 2, 1, 3), DisplayString().subtype(subtypeSpec=ConstraintsUnion(ValueSizeConstraint(0,0),ValueSizeConstraint(3,3),)).clone('')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dlswSdlcLsLocalIdBlock.setDescription("The block number is the first three digits of the node_id,\nif available.  These 3 hexadecimal digits identify the\nproduct.")
dlswSdlcLsLocalIdNum = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 6, 2, 1, 4), DisplayString().subtype(subtypeSpec=ConstraintsUnion(ValueSizeConstraint(0,0),ValueSizeConstraint(5,5),)).clone('')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dlswSdlcLsLocalIdNum.setDescription("The ID number is the last 5 digits of the node_id, if\navailable.  These 5 hexadecimal digits are\nadministratively defined and combined with the 3 digit\nblock number form the node_id.  This node_id is used to\nidentify the local node and is included in SNA XIDs.")
dlswSdlcLsRemoteMac = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 6, 2, 1, 5), MacAddressNC().clone('')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dlswSdlcLsRemoteMac.setDescription("The MAC address to which DLSw should attempt to connect\nthis link station. If this information is not available,\na length of zero for this object should be returned.")
dlswSdlcLsRemoteSap = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 6, 2, 1, 6), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 1)).clone('')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dlswSdlcLsRemoteSap.setDescription("The SAP of the remote station to which this link\nstation should be connected.  If this information\nis not available, a length of zero for this object\nshould be returned.")
dlswSdlcLsRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 46, 1, 6, 2, 1, 7), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: dlswSdlcLsRowStatus.setDescription("This object is used by the manager to create\nor delete the row entry in the dlswSdlcLsTable\nfollowing the RowStatus textual convention.")
dlswDomains = MibIdentifier((1, 3, 6, 1, 2, 1, 46, 2))
dlswTCPDomain = MibIdentifier((1, 3, 6, 1, 2, 1, 46, 2, 1))
dlswConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 46, 3))
dlswCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 46, 3, 1))
dlswGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 46, 3, 2))

# Augmentions

# Notifications

dlswTrapTConnPartnerReject = NotificationType((1, 3, 6, 1, 2, 1, 46, 1, 0, 1)).setObjects(*(("DLSW-MIB", "dlswTConnOperTDomain"), ("DLSW-MIB", "dlswTConnOperRemoteTAddr"), ) )
if mibBuilder.loadTexts: dlswTrapTConnPartnerReject.setDescription("This trap is sent each time a transport connection\nis rejected by a partner DLSw during Capabilities\nExchanges.  The emission of this trap is controlled\nby dlswTrapCntlTConnPartnerReject.")
dlswTrapTConnProtViolation = NotificationType((1, 3, 6, 1, 2, 1, 46, 1, 0, 2)).setObjects(*(("DLSW-MIB", "dlswTConnOperTDomain"), ("DLSW-MIB", "dlswTConnOperRemoteTAddr"), ) )
if mibBuilder.loadTexts: dlswTrapTConnProtViolation.setDescription("This trap is sent each time a protocol violation is\ndetected for a transport connection.  The emission of this\ntrap is controlled by dlswTrapCntlTConnProtViolation.")
dlswTrapTConnUp = NotificationType((1, 3, 6, 1, 2, 1, 46, 1, 0, 3)).setObjects(*(("DLSW-MIB", "dlswTConnOperTDomain"), ("DLSW-MIB", "dlswTConnOperRemoteTAddr"), ) )
if mibBuilder.loadTexts: dlswTrapTConnUp.setDescription("This trap is sent each time a transport connection\nenters `connected' state.  The emission of this trap\nis controlled by dlswTrapCntlTConn.")
dlswTrapTConnDown = NotificationType((1, 3, 6, 1, 2, 1, 46, 1, 0, 4)).setObjects(*(("DLSW-MIB", "dlswTConnOperTDomain"), ("DLSW-MIB", "dlswTConnOperRemoteTAddr"), ) )
if mibBuilder.loadTexts: dlswTrapTConnDown.setDescription("This trap is sent each time a transport connection\nenters `disconnected' state.  The emission of this trap\nis controlled by dlswTrapCntlTConn.")
dlswTrapCircuitUp = NotificationType((1, 3, 6, 1, 2, 1, 46, 1, 0, 5)).setObjects(*(("DLSW-MIB", "dlswCircuitS2Sap"), ("DLSW-MIB", "dlswCircuitS2Mac"), ("DLSW-MIB", "dlswCircuitS1Mac"), ("DLSW-MIB", "dlswCircuitS1Sap"), ) )
if mibBuilder.loadTexts: dlswTrapCircuitUp.setDescription("This trap is sent each time a circuit enters `connected'\nstate.  The emission of this trap is controlled by\ndlswTrapCntlCircuit.")
dlswTrapCircuitDown = NotificationType((1, 3, 6, 1, 2, 1, 46, 1, 0, 6)).setObjects(*(("DLSW-MIB", "dlswCircuitS2Sap"), ("DLSW-MIB", "dlswCircuitS2Mac"), ("DLSW-MIB", "dlswCircuitS1Mac"), ("DLSW-MIB", "dlswCircuitS1Sap"), ) )
if mibBuilder.loadTexts: dlswTrapCircuitDown.setDescription("This trap is sent each time a circuit enters `disconnected'\nstate.  The emission of this trap is controlled by\ndlswTrapCntlCircuit.")

# Groups

dlswNodeGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 46, 3, 2, 1)).setObjects(*(("DLSW-MIB", "dlswNodeVersionString"), ("DLSW-MIB", "dlswNodeStatus"), ("DLSW-MIB", "dlswNodeUpTime"), ("DLSW-MIB", "dlswNodeVersion"), ("DLSW-MIB", "dlswNodeVendorID"), ("DLSW-MIB", "dlswTrapCntlTConnProtViolation"), ("DLSW-MIB", "dlswNodeResourceMacExclusivity"), ("DLSW-MIB", "dlswTrapCntlCircuit"), ("DLSW-MIB", "dlswTrapCntlTConnPartnerReject"), ("DLSW-MIB", "dlswTrapCntlTConn"), ("DLSW-MIB", "dlswNodeStdPacingSupport"), ("DLSW-MIB", "dlswNodeVirtualSegmentLFSize"), ) )
if mibBuilder.loadTexts: dlswNodeGroup.setDescription("Conformance group for DLSw node general information.")
dlswNodeNBGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 46, 3, 2, 2)).setObjects(*(("DLSW-MIB", "dlswNodeResourceNBExclusivity"), ) )
if mibBuilder.loadTexts: dlswNodeNBGroup.setDescription("Conformance group for DLSw node general information\nspecifically for nodes that support NetBIOS.")
dlswTConnStatGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 46, 3, 2, 3)).setObjects(*(("DLSW-MIB", "dlswTConnStatActiveConnections"), ("DLSW-MIB", "dlswTConnStatCloseIdles"), ("DLSW-MIB", "dlswTConnStatCloseBusys"), ) )
if mibBuilder.loadTexts: dlswTConnStatGroup.setDescription("Conformance group for statistics for transport\nconnections.")
dlswTConnConfigGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 46, 3, 2, 4)).setObjects(*(("DLSW-MIB", "dlswTConnConfigEntryType"), ("DLSW-MIB", "dlswTConnConfigRowStatus"), ("DLSW-MIB", "dlswTConnConfigOpens"), ("DLSW-MIB", "dlswTConnConfigLocalTAddr"), ("DLSW-MIB", "dlswTConnConfigInitCirRecvWndw"), ("DLSW-MIB", "dlswTConnConfigGroupDefinition"), ("DLSW-MIB", "dlswTConnConfigLastModifyTime"), ("DLSW-MIB", "dlswTConnConfigSetupType"), ("DLSW-MIB", "dlswTConnConfigTDomain"), ("DLSW-MIB", "dlswTConnConfigAdvertiseMacNB"), ("DLSW-MIB", "dlswTConnConfigSapList"), ("DLSW-MIB", "dlswTConnConfigRemoteTAddr"), ) )
if mibBuilder.loadTexts: dlswTConnConfigGroup.setDescription("Conformance group for the configuration of\ntransport connections.")
dlswTConnOperGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 46, 3, 2, 5)).setObjects(*(("DLSW-MIB", "dlswTConnOperConnectTime"), ("DLSW-MIB", "dlswTConnOperState"), ("DLSW-MIB", "dlswTConnOperLocalTAddr"), ("DLSW-MIB", "dlswTConnOperPartnerSapList"), ("DLSW-MIB", "dlswTConnOperDiscActiveCir"), ("DLSW-MIB", "dlswTConnOperPartnerMacInfo"), ("DLSW-MIB", "dlswTConnOperICRexRcvds"), ("DLSW-MIB", "dlswTConnOperICRexSents"), ("DLSW-MIB", "dlswTConnOperOutDataOctets"), ("DLSW-MIB", "dlswTConnOperOutCntlPkts"), ("DLSW-MIB", "dlswTConnOperPartnerVendorID"), ("DLSW-MIB", "dlswTConnOperInDataOctets"), ("DLSW-MIB", "dlswTConnOperPartnerMacExcl"), ("DLSW-MIB", "dlswTConnOperInDataPkts"), ("DLSW-MIB", "dlswTConnOperInCntlPkts"), ("DLSW-MIB", "dlswTConnOperDiscReason"), ("DLSW-MIB", "dlswTConnOperCircuits"), ("DLSW-MIB", "dlswTConnOperPartnerInitPacingWndw"), ("DLSW-MIB", "dlswTConnOperCirCreates"), ("DLSW-MIB", "dlswTConnOperCURexSents"), ("DLSW-MIB", "dlswTConnOperPartnerVersionStr"), ("DLSW-MIB", "dlswTConnOperConfigIndex"), ("DLSW-MIB", "dlswTConnOperEntryTime"), ("DLSW-MIB", "dlswTConnOperPartnerVersion"), ("DLSW-MIB", "dlswTConnOperFlowCntlMode"), ("DLSW-MIB", "dlswTConnOperOutDataPkts"), ("DLSW-MIB", "dlswTConnOperCURexRcvds"), ("DLSW-MIB", "dlswTConnOperDiscTime"), ) )
if mibBuilder.loadTexts: dlswTConnOperGroup.setDescription("Conformance group for operation information for\ntransport connections.")
dlswTConnNBGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 46, 3, 2, 6)).setObjects(*(("DLSW-MIB", "dlswTConnOperNRexRcvds"), ("DLSW-MIB", "dlswTConnOperPartnerNBExcl"), ("DLSW-MIB", "dlswTConnOperPartnerNBInfo"), ("DLSW-MIB", "dlswTConnOperNQexRcvds"), ("DLSW-MIB", "dlswTConnOperNRexSents"), ("DLSW-MIB", "dlswTConnOperNQexSents"), ) )
if mibBuilder.loadTexts: dlswTConnNBGroup.setDescription("Conformance group for operation information for\ntransport connections, specifically for nodes\nthat support NetBIOS.")
dlswTConnTcpConfigGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 46, 3, 2, 7)).setObjects(*(("DLSW-MIB", "dlswTConnTcpConfigKeepAliveInt"), ("DLSW-MIB", "dlswTConnTcpConfigMaxSegmentSize"), ("DLSW-MIB", "dlswTConnTcpConfigTcpConnections"), ) )
if mibBuilder.loadTexts: dlswTConnTcpConfigGroup.setDescription("Conformance group for configuration information for\ntransport connections using TCP.")
dlswTConnTcpOperGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 46, 3, 2, 8)).setObjects(*(("DLSW-MIB", "dlswTConnTcpOperPrefTcpConnections"), ("DLSW-MIB", "dlswTConnTcpOperTcpConnections"), ("DLSW-MIB", "dlswTConnTcpOperKeepAliveInt"), ) )
if mibBuilder.loadTexts: dlswTConnTcpOperGroup.setDescription("Conformance group for operation information for\ntransport connections using TCP.")
dlswInterfaceGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 46, 3, 2, 9)).setObjects(*(("DLSW-MIB", "dlswIfRowStatus"), ("DLSW-MIB", "dlswIfVirtualSegment"), ("DLSW-MIB", "dlswIfSapList"), ) )
if mibBuilder.loadTexts: dlswInterfaceGroup.setDescription("Conformance group for DLSw interfaces.")
dlswDirGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 46, 3, 2, 10)).setObjects(*(("DLSW-MIB", "dlswDirMacLFSize"), ("DLSW-MIB", "dlswDirMacMask"), ("DLSW-MIB", "dlswDirMacLocation"), ("DLSW-MIB", "dlswDirMacEntries"), ("DLSW-MIB", "dlswDirMacStatus"), ("DLSW-MIB", "dlswDirMacCacheNextIndex"), ("DLSW-MIB", "dlswDirMacLocationType"), ("DLSW-MIB", "dlswDirMacMac"), ("DLSW-MIB", "dlswDirMacCacheHits"), ("DLSW-MIB", "dlswDirMacEntryType"), ("DLSW-MIB", "dlswDirMacCacheMisses"), ("DLSW-MIB", "dlswDirMacRowStatus"), ) )
if mibBuilder.loadTexts: dlswDirGroup.setDescription("Conformance group for DLSw directory using MAC\naddresses.")
dlswDirNBGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 46, 3, 2, 11)).setObjects(*(("DLSW-MIB", "dlswDirNBCacheHits"), ("DLSW-MIB", "dlswDirNBEntryType"), ("DLSW-MIB", "dlswDirNBLocation"), ("DLSW-MIB", "dlswDirNBCacheNextIndex"), ("DLSW-MIB", "dlswDirNBNameType"), ("DLSW-MIB", "dlswDirNBName"), ("DLSW-MIB", "dlswDirNBLFSize"), ("DLSW-MIB", "dlswDirNBStatus"), ("DLSW-MIB", "dlswDirNBRowStatus"), ("DLSW-MIB", "dlswDirNBEntries"), ("DLSW-MIB", "dlswDirNBCacheMisses"), ("DLSW-MIB", "dlswDirNBLocationType"), ) )
if mibBuilder.loadTexts: dlswDirNBGroup.setDescription("Conformance group for DLSw directory using NetBIOS\nnames.")
dlswDirLocateGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 46, 3, 2, 12)).setObjects(*(("DLSW-MIB", "dlswDirLocateMacLocation"), ) )
if mibBuilder.loadTexts: dlswDirLocateGroup.setDescription("Conformance group for a node that can return directory\nentry order for a given MAC address.")
dlswDirLocateNBGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 46, 3, 2, 13)).setObjects(*(("DLSW-MIB", "dlswDirLocateNBLocation"), ) )
if mibBuilder.loadTexts: dlswDirLocateNBGroup.setDescription("Conformance group for a node that can return directory\nentry order for a given NetBIOS name.")
dlswCircuitStatGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 46, 3, 2, 14)).setObjects(*(("DLSW-MIB", "dlswCircuitStatCreates"), ("DLSW-MIB", "dlswCircuitStatActives"), ) )
if mibBuilder.loadTexts: dlswCircuitStatGroup.setDescription("Conformance group for statistics about circuits.")
dlswCircuitGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 46, 3, 2, 15)).setObjects(*(("DLSW-MIB", "dlswCircuitS1Dlc"), ("DLSW-MIB", "dlswCircuitFCSendGrantedUnits"), ("DLSW-MIB", "dlswCircuitS1RouteInfo"), ("DLSW-MIB", "dlswCircuitFCRecvGrantedUnits"), ("DLSW-MIB", "dlswCircuitPriority"), ("DLSW-MIB", "dlswCircuitOrigin"), ("DLSW-MIB", "dlswCircuitS2TAddress"), ("DLSW-MIB", "dlswCircuitEntryTime"), ("DLSW-MIB", "dlswCircuitS1DlcType"), ("DLSW-MIB", "dlswCircuitDiscReasonRemote"), ("DLSW-MIB", "dlswCircuitS2TDomain"), ("DLSW-MIB", "dlswCircuitFCRecvCurrentWndw"), ("DLSW-MIB", "dlswCircuitState"), ("DLSW-MIB", "dlswCircuitFCLargestSendGranted"), ("DLSW-MIB", "dlswCircuitFCLargestRecvGranted"), ("DLSW-MIB", "dlswCircuitS1IfIndex"), ("DLSW-MIB", "dlswCircuitFCSendCurrentWndw"), ("DLSW-MIB", "dlswCircuitFCHalveWndwSents"), ("DLSW-MIB", "dlswCircuitDiscReasonRemoteData"), ("DLSW-MIB", "dlswCircuitFCHalveWndwRcvds"), ("DLSW-MIB", "dlswCircuitDiscReasonLocal"), ("DLSW-MIB", "dlswCircuitS2CircuitId"), ("DLSW-MIB", "dlswCircuitStateTime"), ("DLSW-MIB", "dlswCircuitS2Location"), ("DLSW-MIB", "dlswCircuitS1CircuitId"), ("DLSW-MIB", "dlswCircuitFCResetOpRcvds"), ("DLSW-MIB", "dlswCircuitFCResetOpSents"), ) )
if mibBuilder.loadTexts: dlswCircuitGroup.setDescription("Conformance group for DLSw circuits.")
dlswSdlcGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 46, 3, 2, 16)).setObjects(*(("DLSW-MIB", "dlswSdlcLsEntries"), ("DLSW-MIB", "dlswSdlcLsLocalIdBlock"), ("DLSW-MIB", "dlswSdlcLsLocalSap"), ("DLSW-MIB", "dlswSdlcLsLocalIdNum"), ("DLSW-MIB", "dlswSdlcLsRemoteMac"), ("DLSW-MIB", "dlswSdlcLsRemoteSap"), ("DLSW-MIB", "dlswSdlcLsLocalMac"), ("DLSW-MIB", "dlswSdlcLsRowStatus"), ) )
if mibBuilder.loadTexts: dlswSdlcGroup.setDescription("Conformance group for DLSw SDLC support.")
dlswNotificationGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 46, 3, 2, 17)).setObjects(*(("DLSW-MIB", "dlswTrapCircuitUp"), ("DLSW-MIB", "dlswTrapTConnUp"), ("DLSW-MIB", "dlswTrapCircuitDown"), ("DLSW-MIB", "dlswTrapTConnPartnerReject"), ("DLSW-MIB", "dlswTrapTConnDown"), ("DLSW-MIB", "dlswTrapTConnProtViolation"), ) )
if mibBuilder.loadTexts: dlswNotificationGroup.setDescription("Conformance group for DLSw notifications.")

# Compliances

dlswCoreCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 46, 3, 1, 1)).setObjects(*(("DLSW-MIB", "dlswTConnNBGroup"), ("DLSW-MIB", "dlswCircuitGroup"), ("DLSW-MIB", "dlswCircuitStatGroup"), ("DLSW-MIB", "dlswTConnConfigGroup"), ("DLSW-MIB", "dlswNodeNBGroup"), ("DLSW-MIB", "dlswInterfaceGroup"), ("DLSW-MIB", "dlswNotificationGroup"), ("DLSW-MIB", "dlswTConnStatGroup"), ("DLSW-MIB", "dlswNodeGroup"), ("DLSW-MIB", "dlswTConnOperGroup"), ) )
if mibBuilder.loadTexts: dlswCoreCompliance.setDescription("The core compliance statement for all DLSw nodes.")
dlswTConnTcpCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 46, 3, 1, 2)).setObjects(*(("DLSW-MIB", "dlswTConnTcpConfigGroup"), ("DLSW-MIB", "dlswTConnTcpOperGroup"), ) )
if mibBuilder.loadTexts: dlswTConnTcpCompliance.setDescription("Compliance for DLSw nodes that use TCP as a\ntransport connection protocol.")
dlswDirCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 46, 3, 1, 3)).setObjects(*(("DLSW-MIB", "dlswDirNBGroup"), ("DLSW-MIB", "dlswDirGroup"), ) )
if mibBuilder.loadTexts: dlswDirCompliance.setDescription("Compliance for DLSw nodes that provide a directory\nfunction.")
dlswDirLocateCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 46, 3, 1, 4)).setObjects(*(("DLSW-MIB", "dlswDirLocateGroup"), ("DLSW-MIB", "dlswDirLocateNBGroup"), ) )
if mibBuilder.loadTexts: dlswDirLocateCompliance.setDescription("Compliance for DLSw nodes that provide an ordered\nlist of directory entries for a given resource.")
dlswSdlcCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 46, 3, 1, 5)).setObjects(*(("DLSW-MIB", "dlswSdlcGroup"), ) )
if mibBuilder.loadTexts: dlswSdlcCompliance.setDescription("Compliance for DLSw nodes that support SDLC.")

# Exports

# Module identity
mibBuilder.exportSymbols("DLSW-MIB", PYSNMP_MODULE_ID=dlsw)

# Types
mibBuilder.exportSymbols("DLSW-MIB", DlcType=DlcType, DlswTCPAddress=DlswTCPAddress, EndStationLocation=EndStationLocation, LFSize=LFSize, MacAddressNC=MacAddressNC, NBName=NBName, TAddress=TAddress)

# Objects
mibBuilder.exportSymbols("DLSW-MIB", null=null, dlsw=dlsw, dlswMIB=dlswMIB, dlswTraps=dlswTraps, dlswNode=dlswNode, dlswNodeVersion=dlswNodeVersion, dlswNodeVendorID=dlswNodeVendorID, dlswNodeVersionString=dlswNodeVersionString, dlswNodeStdPacingSupport=dlswNodeStdPacingSupport, dlswNodeStatus=dlswNodeStatus, dlswNodeUpTime=dlswNodeUpTime, dlswNodeVirtualSegmentLFSize=dlswNodeVirtualSegmentLFSize, dlswNodeResourceNBExclusivity=dlswNodeResourceNBExclusivity, dlswNodeResourceMacExclusivity=dlswNodeResourceMacExclusivity, dlswTrapControl=dlswTrapControl, dlswTrapCntlTConnPartnerReject=dlswTrapCntlTConnPartnerReject, dlswTrapCntlTConnProtViolation=dlswTrapCntlTConnProtViolation, dlswTrapCntlTConn=dlswTrapCntlTConn, dlswTrapCntlCircuit=dlswTrapCntlCircuit, dlswTConn=dlswTConn, dlswTConnStat=dlswTConnStat, dlswTConnStatActiveConnections=dlswTConnStatActiveConnections, dlswTConnStatCloseIdles=dlswTConnStatCloseIdles, dlswTConnStatCloseBusys=dlswTConnStatCloseBusys, dlswTConnConfigTable=dlswTConnConfigTable, dlswTConnConfigEntry=dlswTConnConfigEntry, dlswTConnConfigIndex=dlswTConnConfigIndex, dlswTConnConfigTDomain=dlswTConnConfigTDomain, dlswTConnConfigLocalTAddr=dlswTConnConfigLocalTAddr, dlswTConnConfigRemoteTAddr=dlswTConnConfigRemoteTAddr, dlswTConnConfigLastModifyTime=dlswTConnConfigLastModifyTime, dlswTConnConfigEntryType=dlswTConnConfigEntryType, dlswTConnConfigGroupDefinition=dlswTConnConfigGroupDefinition, dlswTConnConfigSetupType=dlswTConnConfigSetupType, dlswTConnConfigSapList=dlswTConnConfigSapList, dlswTConnConfigAdvertiseMacNB=dlswTConnConfigAdvertiseMacNB, dlswTConnConfigInitCirRecvWndw=dlswTConnConfigInitCirRecvWndw, dlswTConnConfigOpens=dlswTConnConfigOpens, dlswTConnConfigRowStatus=dlswTConnConfigRowStatus, dlswTConnOperTable=dlswTConnOperTable, dlswTConnOperEntry=dlswTConnOperEntry, dlswTConnOperTDomain=dlswTConnOperTDomain, dlswTConnOperLocalTAddr=dlswTConnOperLocalTAddr, dlswTConnOperRemoteTAddr=dlswTConnOperRemoteTAddr, dlswTConnOperEntryTime=dlswTConnOperEntryTime, dlswTConnOperConnectTime=dlswTConnOperConnectTime, dlswTConnOperState=dlswTConnOperState, dlswTConnOperConfigIndex=dlswTConnOperConfigIndex, dlswTConnOperFlowCntlMode=dlswTConnOperFlowCntlMode, dlswTConnOperPartnerVersion=dlswTConnOperPartnerVersion, dlswTConnOperPartnerVendorID=dlswTConnOperPartnerVendorID, dlswTConnOperPartnerVersionStr=dlswTConnOperPartnerVersionStr, dlswTConnOperPartnerInitPacingWndw=dlswTConnOperPartnerInitPacingWndw, dlswTConnOperPartnerSapList=dlswTConnOperPartnerSapList, dlswTConnOperPartnerNBExcl=dlswTConnOperPartnerNBExcl, dlswTConnOperPartnerMacExcl=dlswTConnOperPartnerMacExcl, dlswTConnOperPartnerNBInfo=dlswTConnOperPartnerNBInfo, dlswTConnOperPartnerMacInfo=dlswTConnOperPartnerMacInfo, dlswTConnOperDiscTime=dlswTConnOperDiscTime, dlswTConnOperDiscReason=dlswTConnOperDiscReason, dlswTConnOperDiscActiveCir=dlswTConnOperDiscActiveCir, dlswTConnOperInDataPkts=dlswTConnOperInDataPkts, dlswTConnOperOutDataPkts=dlswTConnOperOutDataPkts, dlswTConnOperInDataOctets=dlswTConnOperInDataOctets, dlswTConnOperOutDataOctets=dlswTConnOperOutDataOctets, dlswTConnOperInCntlPkts=dlswTConnOperInCntlPkts, dlswTConnOperOutCntlPkts=dlswTConnOperOutCntlPkts, dlswTConnOperCURexSents=dlswTConnOperCURexSents, dlswTConnOperICRexRcvds=dlswTConnOperICRexRcvds, dlswTConnOperCURexRcvds=dlswTConnOperCURexRcvds, dlswTConnOperICRexSents=dlswTConnOperICRexSents, dlswTConnOperNQexSents=dlswTConnOperNQexSents, dlswTConnOperNRexRcvds=dlswTConnOperNRexRcvds, dlswTConnOperNQexRcvds=dlswTConnOperNQexRcvds, dlswTConnOperNRexSents=dlswTConnOperNRexSents, dlswTConnOperCirCreates=dlswTConnOperCirCreates, dlswTConnOperCircuits=dlswTConnOperCircuits, dlswTConnSpecific=dlswTConnSpecific, dlswTConnTcp=dlswTConnTcp, dlswTConnTcpConfigTable=dlswTConnTcpConfigTable, dlswTConnTcpConfigEntry=dlswTConnTcpConfigEntry, dlswTConnTcpConfigKeepAliveInt=dlswTConnTcpConfigKeepAliveInt, dlswTConnTcpConfigTcpConnections=dlswTConnTcpConfigTcpConnections, dlswTConnTcpConfigMaxSegmentSize=dlswTConnTcpConfigMaxSegmentSize, dlswTConnTcpOperTable=dlswTConnTcpOperTable, dlswTConnTcpOperEntry=dlswTConnTcpOperEntry, dlswTConnTcpOperKeepAliveInt=dlswTConnTcpOperKeepAliveInt, dlswTConnTcpOperPrefTcpConnections=dlswTConnTcpOperPrefTcpConnections, dlswTConnTcpOperTcpConnections=dlswTConnTcpOperTcpConnections, dlswInterface=dlswInterface, dlswIfTable=dlswIfTable, dlswIfEntry=dlswIfEntry, dlswIfRowStatus=dlswIfRowStatus, dlswIfVirtualSegment=dlswIfVirtualSegment, dlswIfSapList=dlswIfSapList, dlswDirectory=dlswDirectory, dlswDirStat=dlswDirStat, dlswDirMacEntries=dlswDirMacEntries, dlswDirMacCacheHits=dlswDirMacCacheHits, dlswDirMacCacheMisses=dlswDirMacCacheMisses, dlswDirMacCacheNextIndex=dlswDirMacCacheNextIndex, dlswDirNBEntries=dlswDirNBEntries, dlswDirNBCacheHits=dlswDirNBCacheHits, dlswDirNBCacheMisses=dlswDirNBCacheMisses, dlswDirNBCacheNextIndex=dlswDirNBCacheNextIndex, dlswDirCache=dlswDirCache, dlswDirMacTable=dlswDirMacTable, dlswDirMacEntry=dlswDirMacEntry, dlswDirMacIndex=dlswDirMacIndex, dlswDirMacMac=dlswDirMacMac, dlswDirMacMask=dlswDirMacMask, dlswDirMacEntryType=dlswDirMacEntryType, dlswDirMacLocationType=dlswDirMacLocationType, dlswDirMacLocation=dlswDirMacLocation, dlswDirMacStatus=dlswDirMacStatus, dlswDirMacLFSize=dlswDirMacLFSize, dlswDirMacRowStatus=dlswDirMacRowStatus, dlswDirNBTable=dlswDirNBTable, dlswDirNBEntry=dlswDirNBEntry, dlswDirNBIndex=dlswDirNBIndex, dlswDirNBName=dlswDirNBName, dlswDirNBNameType=dlswDirNBNameType, dlswDirNBEntryType=dlswDirNBEntryType, dlswDirNBLocationType=dlswDirNBLocationType, dlswDirNBLocation=dlswDirNBLocation, dlswDirNBStatus=dlswDirNBStatus)
mibBuilder.exportSymbols("DLSW-MIB", dlswDirNBLFSize=dlswDirNBLFSize, dlswDirNBRowStatus=dlswDirNBRowStatus, dlswDirLocate=dlswDirLocate, dlswDirLocateMacTable=dlswDirLocateMacTable, dlswDirLocateMacEntry=dlswDirLocateMacEntry, dlswDirLocateMacMac=dlswDirLocateMacMac, dlswDirLocateMacMatch=dlswDirLocateMacMatch, dlswDirLocateMacLocation=dlswDirLocateMacLocation, dlswDirLocateNBTable=dlswDirLocateNBTable, dlswDirLocateNBEntry=dlswDirLocateNBEntry, dlswDirLocateNBName=dlswDirLocateNBName, dlswDirLocateNBMatch=dlswDirLocateNBMatch, dlswDirLocateNBLocation=dlswDirLocateNBLocation, dlswCircuit=dlswCircuit, dlswCircuitStat=dlswCircuitStat, dlswCircuitStatActives=dlswCircuitStatActives, dlswCircuitStatCreates=dlswCircuitStatCreates, dlswCircuitTable=dlswCircuitTable, dlswCircuitEntry=dlswCircuitEntry, dlswCircuitS1Mac=dlswCircuitS1Mac, dlswCircuitS1Sap=dlswCircuitS1Sap, dlswCircuitS1IfIndex=dlswCircuitS1IfIndex, dlswCircuitS1DlcType=dlswCircuitS1DlcType, dlswCircuitS1RouteInfo=dlswCircuitS1RouteInfo, dlswCircuitS1CircuitId=dlswCircuitS1CircuitId, dlswCircuitS1Dlc=dlswCircuitS1Dlc, dlswCircuitS2Mac=dlswCircuitS2Mac, dlswCircuitS2Sap=dlswCircuitS2Sap, dlswCircuitS2Location=dlswCircuitS2Location, dlswCircuitS2TDomain=dlswCircuitS2TDomain, dlswCircuitS2TAddress=dlswCircuitS2TAddress, dlswCircuitS2CircuitId=dlswCircuitS2CircuitId, dlswCircuitOrigin=dlswCircuitOrigin, dlswCircuitEntryTime=dlswCircuitEntryTime, dlswCircuitStateTime=dlswCircuitStateTime, dlswCircuitState=dlswCircuitState, dlswCircuitPriority=dlswCircuitPriority, dlswCircuitFCSendGrantedUnits=dlswCircuitFCSendGrantedUnits, dlswCircuitFCSendCurrentWndw=dlswCircuitFCSendCurrentWndw, dlswCircuitFCRecvGrantedUnits=dlswCircuitFCRecvGrantedUnits, dlswCircuitFCRecvCurrentWndw=dlswCircuitFCRecvCurrentWndw, dlswCircuitFCLargestRecvGranted=dlswCircuitFCLargestRecvGranted, dlswCircuitFCLargestSendGranted=dlswCircuitFCLargestSendGranted, dlswCircuitFCHalveWndwSents=dlswCircuitFCHalveWndwSents, dlswCircuitFCResetOpSents=dlswCircuitFCResetOpSents, dlswCircuitFCHalveWndwRcvds=dlswCircuitFCHalveWndwRcvds, dlswCircuitFCResetOpRcvds=dlswCircuitFCResetOpRcvds, dlswCircuitDiscReasonLocal=dlswCircuitDiscReasonLocal, dlswCircuitDiscReasonRemote=dlswCircuitDiscReasonRemote, dlswCircuitDiscReasonRemoteData=dlswCircuitDiscReasonRemoteData, dlswSdlc=dlswSdlc, dlswSdlcLsEntries=dlswSdlcLsEntries, dlswSdlcLsTable=dlswSdlcLsTable, dlswSdlcLsEntry=dlswSdlcLsEntry, dlswSdlcLsLocalMac=dlswSdlcLsLocalMac, dlswSdlcLsLocalSap=dlswSdlcLsLocalSap, dlswSdlcLsLocalIdBlock=dlswSdlcLsLocalIdBlock, dlswSdlcLsLocalIdNum=dlswSdlcLsLocalIdNum, dlswSdlcLsRemoteMac=dlswSdlcLsRemoteMac, dlswSdlcLsRemoteSap=dlswSdlcLsRemoteSap, dlswSdlcLsRowStatus=dlswSdlcLsRowStatus, dlswDomains=dlswDomains, dlswTCPDomain=dlswTCPDomain, dlswConformance=dlswConformance, dlswCompliances=dlswCompliances, dlswGroups=dlswGroups)

# Notifications
mibBuilder.exportSymbols("DLSW-MIB", dlswTrapTConnPartnerReject=dlswTrapTConnPartnerReject, dlswTrapTConnProtViolation=dlswTrapTConnProtViolation, dlswTrapTConnUp=dlswTrapTConnUp, dlswTrapTConnDown=dlswTrapTConnDown, dlswTrapCircuitUp=dlswTrapCircuitUp, dlswTrapCircuitDown=dlswTrapCircuitDown)

# Groups
mibBuilder.exportSymbols("DLSW-MIB", dlswNodeGroup=dlswNodeGroup, dlswNodeNBGroup=dlswNodeNBGroup, dlswTConnStatGroup=dlswTConnStatGroup, dlswTConnConfigGroup=dlswTConnConfigGroup, dlswTConnOperGroup=dlswTConnOperGroup, dlswTConnNBGroup=dlswTConnNBGroup, dlswTConnTcpConfigGroup=dlswTConnTcpConfigGroup, dlswTConnTcpOperGroup=dlswTConnTcpOperGroup, dlswInterfaceGroup=dlswInterfaceGroup, dlswDirGroup=dlswDirGroup, dlswDirNBGroup=dlswDirNBGroup, dlswDirLocateGroup=dlswDirLocateGroup, dlswDirLocateNBGroup=dlswDirLocateNBGroup, dlswCircuitStatGroup=dlswCircuitStatGroup, dlswCircuitGroup=dlswCircuitGroup, dlswSdlcGroup=dlswSdlcGroup, dlswNotificationGroup=dlswNotificationGroup)

# Compliances
mibBuilder.exportSymbols("DLSW-MIB", dlswCoreCompliance=dlswCoreCompliance, dlswTConnTcpCompliance=dlswTConnTcpCompliance, dlswDirCompliance=dlswDirCompliance, dlswDirLocateCompliance=dlswDirLocateCompliance, dlswSdlcCompliance=dlswSdlcCompliance)
