# PySNMP SMI module. Autogenerated from smidump -f python Printer-MIB
# by libsmi2pysnmp-0.1.3 at Mon Apr  2 20:39:29 2012,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsIntersection, ConstraintsUnion, SingleValueConstraint, ValueRangeConstraint, ValueSizeConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsIntersection", "ConstraintsUnion", "SingleValueConstraint", "ValueRangeConstraint", "ValueSizeConstraint")
( hrDeviceIndex, hrStorageIndex, ) = mibBuilder.importSymbols("HOST-RESOURCES-MIB", "hrDeviceIndex", "hrStorageIndex")
( IANACharset, ) = mibBuilder.importSymbols("IANA-CHARSET-MIB", "IANACharset")
( PrtAlertCodeTC, PrtAlertGroupTC, PrtAlertTrainingLevelTC, PrtChannelTypeTC, PrtConsoleColorTC, PrtConsoleDisableTC, PrtCoverStatusTC, PrtGeneralResetTC, PrtInputTypeTC, PrtInterpreterLangFamilyTC, PrtMarkerMarkTechTC, PrtMarkerSuppliesTypeTC, PrtMediaPathTypeTC, PrtOutputTypeTC, ) = mibBuilder.importSymbols("IANA-PRINTER-MIB", "PrtAlertCodeTC", "PrtAlertGroupTC", "PrtAlertTrainingLevelTC", "PrtChannelTypeTC", "PrtConsoleColorTC", "PrtConsoleDisableTC", "PrtCoverStatusTC", "PrtGeneralResetTC", "PrtInputTypeTC", "PrtInterpreterLangFamilyTC", "PrtMarkerMarkTechTC", "PrtMarkerSuppliesTypeTC", "PrtMediaPathTypeTC", "PrtOutputTypeTC")
( InterfaceIndexOrZero, ) = mibBuilder.importSymbols("IF-MIB", "InterfaceIndexOrZero")
( ModuleCompliance, NotificationGroup, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup", "ObjectGroup")
( Bits, Counter32, Integer32, Integer32, ModuleIdentity, MibIdentifier, NotificationType, ObjectIdentity, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, TimeTicks, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Integer32", "Integer32", "ModuleIdentity", "MibIdentifier", "NotificationType", "ObjectIdentity", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "TimeTicks", "mib-2")
( TextualConvention, ) = mibBuilder.importSymbols("SNMPv2-TC", "TextualConvention")

# Types

class CapacityUnit(Integer):
    subtypeSpec = Integer.subtypeSpec+SingleValueConstraint(16,17,8,3,4,)
    namedValues = NamedValues(("feet", 16), ("meters", 17), ("tenThousandthsOfInches", 3), ("micrometers", 4), ("sheets", 8), )
    
class CodedCharSet(Integer):
    subtypeSpec = Integer.subtypeSpec+SingleValueConstraint(1,)
    namedValues = NamedValues(("other", 1), )
    
class MediaUnit(Integer):
    subtypeSpec = Integer.subtypeSpec+SingleValueConstraint(3,4,)
    namedValues = NamedValues(("tenThousandthsOfInches", 3), ("micrometers", 4), )
    
class PresentOnOff(Integer):
    subtypeSpec = Integer.subtypeSpec+SingleValueConstraint(3,4,1,5,)
    namedValues = NamedValues(("other", 1), ("on", 3), ("off", 4), ("notPresent", 5), )
    
class PrtAlertSeverityLevelTC(Integer):
    subtypeSpec = Integer.subtypeSpec+SingleValueConstraint(1,3,5,4,)
    namedValues = NamedValues(("other", 1), ("critical", 3), ("warning", 4), ("warningBinaryChangeEvent", 5), )
    
class PrtCapacityUnitTC(Integer):
    subtypeSpec = Integer.subtypeSpec+SingleValueConstraint(16,17,8,3,2,19,4,1,18,)
    namedValues = NamedValues(("other", 1), ("feet", 16), ("meters", 17), ("items", 18), ("percent", 19), ("unknown", 2), ("tenThousandthsOfInches", 3), ("micrometers", 4), ("sheets", 8), )
    
class PrtChannelStateTC(Integer):
    subtypeSpec = Integer.subtypeSpec+SingleValueConstraint(3,4,1,)
    namedValues = NamedValues(("other", 1), ("printDataAccepted", 3), ("noDataAccepted", 4), )
    
class PrtConsoleDescriptionStringTC(OctetString):
    subtypeSpec = OctetString.subtypeSpec+ValueSizeConstraint(0,255)
    
class PrtInterpreterTwoWayTC(Integer):
    subtypeSpec = Integer.subtypeSpec+SingleValueConstraint(3,4,)
    namedValues = NamedValues(("yes", 3), ("no", 4), )
    
class PrtLocalizedDescriptionStringTC(OctetString):
    subtypeSpec = OctetString.subtypeSpec+ValueSizeConstraint(0,255)
    
class PrtMarkerAddressabilityUnitTC(Integer):
    subtypeSpec = Integer.subtypeSpec+SingleValueConstraint(3,4,)
    namedValues = NamedValues(("tenThousandthsOfInches", 3), ("micrometers", 4), )
    
class PrtMarkerColorantRoleTC(Integer):
    subtypeSpec = Integer.subtypeSpec+SingleValueConstraint(3,4,1,)
    namedValues = NamedValues(("other", 1), ("process", 3), ("spot", 4), )
    
class PrtMarkerCounterUnitTC(Integer):
    subtypeSpec = Integer.subtypeSpec+SingleValueConstraint(5,11,17,8,3,7,16,6,4,9,)
    namedValues = NamedValues(("hours", 11), ("feet", 16), ("meters", 17), ("tenThousandthsOfInches", 3), ("micrometers", 4), ("characters", 5), ("lines", 6), ("impressions", 7), ("sheets", 8), ("dotRow", 9), )
    
class PrtMarkerSuppliesClassTC(Integer):
    subtypeSpec = Integer.subtypeSpec+SingleValueConstraint(3,1,4,)
    namedValues = NamedValues(("other", 1), ("supplyThatIsConsumed", 3), ("receptacleThatIsFilled", 4), )
    
class PrtMarkerSuppliesSupplyUnitTC(Integer):
    subtypeSpec = Integer.subtypeSpec+SingleValueConstraint(12,15,2,14,13,4,11,19,1,17,8,3,7,18,16,)
    namedValues = NamedValues(("other", 1), ("hours", 11), ("thousandthsOfOunces", 12), ("tenthsOfGrams", 13), ("hundrethsOfFluidOunces", 14), ("tenthsOfMilliliters", 15), ("feet", 16), ("meters", 17), ("items", 18), ("percent", 19), ("unknown", 2), ("tenThousandthsOfInches", 3), ("micrometers", 4), ("impressions", 7), ("sheets", 8), )
    
class PrtMediaPathMaxSpeedPrintUnitTC(Integer):
    subtypeSpec = Integer.subtypeSpec+SingleValueConstraint(6,5,4,3,17,7,9,16,8,)
    namedValues = NamedValues(("feetPerHour", 16), ("metersPerHour", 17), ("tenThousandthsOfInchesPerHour", 3), ("micrometersPerHour", 4), ("charactersPerHour", 5), ("linesPerHour", 6), ("impressionsPerHour", 7), ("sheetsPerHour", 8), ("dotRowPerHour", 9), )
    
class PrtMediaUnitTC(Integer):
    subtypeSpec = Integer.subtypeSpec+SingleValueConstraint(3,4,)
    namedValues = NamedValues(("tenThousandthsOfInches", 3), ("micrometers", 4), )
    
class PrtOutputPageDeliveryOrientationTC(Integer):
    subtypeSpec = Integer.subtypeSpec+SingleValueConstraint(3,4,)
    namedValues = NamedValues(("faceUp", 3), ("faceDown", 4), )
    
class PrtOutputStackingOrderTC(Integer):
    subtypeSpec = Integer.subtypeSpec+SingleValueConstraint(2,4,3,)
    namedValues = NamedValues(("unknown", 2), ("firstToLast", 3), ("lastToFirst", 4), )
    
class PrtPrintOrientationTC(Integer):
    subtypeSpec = Integer.subtypeSpec+SingleValueConstraint(1,3,4,)
    namedValues = NamedValues(("other", 1), ("portrait", 3), ("landscape", 4), )
    
class PrtSubUnitStatusTC(Integer32):
    subtypeSpec = Integer32.subtypeSpec+ValueRangeConstraint(0,126)
    
class SubUnitStatus(Integer32):
    subtypeSpec = Integer32.subtypeSpec+ValueRangeConstraint(0,126)
    

# Objects

printmib = ModuleIdentity((1, 3, 6, 1, 2, 1, 43)).setRevisions(("2004-06-02 00:00","1994-11-25 00:00",))
if mibBuilder.loadTexts: printmib.setOrganization("PWG IEEE/ISTO Printer Working Group")
if mibBuilder.loadTexts: printmib.setContactInfo("Harry Lewis\nIBM\nPhone (303) 924-5337\nEmail: harryl@us.ibm.com\nhttp://www.pwg.org/index.html\n\nSend comments to the printmib WG using the Printer MIB\nProject (PMP) Mailing List:  pmp@pwg.org\n\nFor further information, access the PWG web page under 'Printer\nMIB':      http://www.pwg.org/\n\nImplementers of this specification are encouraged to join the\npmp mailing list in order to participate in discussions on any\nclarifications needed and registration proposals being reviewed\nin order to achieve consensus.")
if mibBuilder.loadTexts: printmib.setDescription("The MIB module for management of printers.\nCopyright (C) The Internet Society (2004). This\nversion of this MIB module was published\nin RFC 3805. For full legal notices see the RFC itself.")
prtMIBConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 43, 2))
prtMIBGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 43, 2, 2))
prtMIB2Groups = MibIdentifier((1, 3, 6, 1, 2, 1, 43, 2, 4))
prtGeneral = MibIdentifier((1, 3, 6, 1, 2, 1, 43, 5))
prtGeneralTable = MibTable((1, 3, 6, 1, 2, 1, 43, 5, 1))
if mibBuilder.loadTexts: prtGeneralTable.setDescription("A table of general information per printer.\nObjects in this table are defined in various\nplaces in the MIB, nearby the groups to\nwhich they apply.  They are all defined\nhere to minimize the number of tables that would\notherwise need to exist.")
prtGeneralEntry = MibTableRow((1, 3, 6, 1, 2, 1, 43, 5, 1, 1)).setIndexNames((0, "HOST-RESOURCES-MIB", "hrDeviceIndex"))
if mibBuilder.loadTexts: prtGeneralEntry.setDescription("An entry exists in this table for each device entry in the\nhost resources MIB device table with a device type of\n'printer'.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtGeneralConfigChanges = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 5, 1, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtGeneralConfigChanges.setDescription("Counts configuration changes within the printer. A\nconfiguration change is defined to be an action that results in\na change to any MIB object other than those that reflect status\nor level, or those that act as counters or gauges. In addition,\nany action that results in a row being added or deleted from\nany table in the Printer MIB is considered a configuration\nchange. Such changes will often affect the capability of the\nprinter to service certain types of print jobs. Management\napplications may cache infrequently changed configuration\ninformation about sub units within the printer. This object\nshould be incremented whenever the agent wishes to notify\nmanagement applications that any cached configuration\ninformation for this device is to be considered 'stale'. At\nthis point, the management application should flush any\nconfiguration information cached about this device and fetch\n\n\n\nnew configuration information.\n\nThe following are examples of actions that would cause the\nprtGeneralConfigChanges object to be incremented:\n\n- Adding an output bin\n- Changing the media in a sensing input tray\n- Changing the value of prtInputMediaType\n\nNote that the prtGeneralConfigChanges counter would not be\nincremented when an input tray is temporarily removed to load\nadditional paper or when the level of an input device changes.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtGeneralCurrentLocalization = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 5, 1, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtGeneralCurrentLocalization.setDescription("The value of the prtLocalizationIndex corresponding to the\ncurrent language, country, and character set to be used for\nlocalized string values that are identified as being dependent\non the value of this object.  Note that this object does not\napply to localized strings in the prtConsole group or to any\nobject that is not explicitly identified as being localized\naccording to prtGeneralCurrentLocalization.  When an object's\n'charset' is controlled by the value of\nprtGeneralCurrentLocalization, it MUST specify\nPrtLocalizedDescriptionStringTC as its syntax.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtGeneralReset = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 5, 1, 1, 3), PrtGeneralResetTC()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtGeneralReset.setDescription("Setting this value to 'powerCycleReset', 'resetToNVRAM', or\n'resetToFactoryDefaults' will result in the resetting of the\nprinter.  When read, this object will always have the value\n\n\n\n'notResetting(3)', and a SET of the value 'notResetting' shall\nhave no effect on the printer.  Some of the defined values are\noptional.  However, every implementation must support at least\nthe values 'notResetting' and 'resetToNVRAM'.")
prtGeneralCurrentOperator = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 5, 1, 1, 4), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 127))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtGeneralCurrentOperator.setDescription("The name of the person who is responsible for operating\nthis printer.  It is suggested that this string include\ninformation that would enable other humans to reach the\noperator, such as a phone number.  As a convention to\nfacilitate automatic notification of the operator by the\nagent or network management station, the phone number,\nfax number or email address should be indicated by the\nURL schemes 'tel:', 'fax:' and 'mailto:', respectively.\nIf either the phone, fax, or email information is not\navailable, then a line should not be included for this\ninformation.\n\nNOTE: For interoperability purposes, it is advisable to\nuse email addresses formatted according to [RFC2822]\nrequirements.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtGeneralServicePerson = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 5, 1, 1, 5), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 127))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtGeneralServicePerson.setDescription("The name of the person responsible for servicing this\nprinter.  It is suggested that this string include\ninformation that would enable other humans to reach the\nservice person, such as a phone number.  As a convention\nto facilitate automatic notification of the operator by\nthe agent or network management station, the phone\nnumber, fax number or email address should be indicated\nby the URL schemes 'tel:', 'fax:' and 'mailto:',\nrespectively.  If either the phone, fax, or email\ninformation is not available, then a line should not\n\n\n\nbe included for this information.\n\nNOTE: For interoperability purposes, it is advisable to use\nemail addresses formatted per [RFC2822] requirements.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtInputDefaultIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 5, 1, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtInputDefaultIndex.setDescription("The value of prtInputIndex corresponding to the default input\nsub-unit: that is, this object selects the default source of\ninput media.")
prtOutputDefaultIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 5, 1, 1, 7), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtOutputDefaultIndex.setDescription("The value of prtOutputIndex corresponding to the default\noutput sub-unit; that is, this object selects the default\noutput destination.")
prtMarkerDefaultIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 5, 1, 1, 8), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtMarkerDefaultIndex.setDescription("The value of prtMarkerIndex corresponding to the\ndefault marker sub-unit; that is, this object selects the\ndefault marker.")
prtMediaPathDefaultIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 5, 1, 1, 9), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtMediaPathDefaultIndex.setDescription("The value of prtMediaPathIndex corresponding to\nthe default media path; that is, the selection of the\ndefault media path.")
prtConsoleLocalization = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 5, 1, 1, 10), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtConsoleLocalization.setDescription("The value of the prtLocalizationIndex corresponding to\nthe language, country, and character set to be used for the\nconsole.  This localization applies both to the actual display\non the console as well as the encoding of these console objects\nin management operations.  When an object's 'charset' is\ncontrolled by the value of prtConsoleLocalization, it MUST\nspecify PrtConsoleDescriptionStringTC as its syntax.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtConsoleNumberOfDisplayLines = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 5, 1, 1, 11), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtConsoleNumberOfDisplayLines.setDescription("The number of lines on the printer's physical\ndisplay.  This value is 0 if there are no lines on the\nphysical display or if there is no physical display")
prtConsoleNumberOfDisplayChars = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 5, 1, 1, 12), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtConsoleNumberOfDisplayChars.setDescription("The number of characters per line displayed on the physical\n\n\n\ndisplay.  This value is 0 if there are no lines on the physical\ndisplay or if there is no physical display")
prtConsoleDisable = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 5, 1, 1, 13), PrtConsoleDisableTC()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtConsoleDisable.setDescription("This value indicates how input is (or is not) accepted from\nthe operator console.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtAuxiliarySheetStartupPage = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 5, 1, 1, 14), PresentOnOff()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtAuxiliarySheetStartupPage.setDescription("Used to enable or disable printing a startup page.  If enabled,\na startup page will be printed shortly after power-up, when the\ndevice is ready.  Typical startup pages include test patterns\nand/or printer configuration information.")
prtAuxiliarySheetBannerPage = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 5, 1, 1, 15), PresentOnOff()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtAuxiliarySheetBannerPage.setDescription("Used to enable or disable printing banner pages at the\nbeginning of jobs.  This is a master switch which applies to all\njobs, regardless of interpreter.")
prtGeneralPrinterName = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 5, 1, 1, 16), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 127))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtGeneralPrinterName.setDescription("An administrator-specified name for this printer.  Depending\nupon implementation of this printer, the value of this object\nmay or may not be same as the value for the MIB-II 'SysName'\nobject.")
prtGeneralSerialNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 5, 1, 1, 17), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 255))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtGeneralSerialNumber.setDescription("A recorded serial number for this device that indexes some\ntype device catalog or inventory.  This value is usually set by\nthe device manufacturer but the MIB supports the option of\nwriting for this object for site-specific administration of\ndevice inventory or tracking.")
prtAlertCriticalEvents = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 5, 1, 1, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtAlertCriticalEvents.setDescription("A running counter of the number of critical alert events that\nhave been recorded in the alert table.  The value of this object\nis RESET in the event of a power cycle operation (i.e., the\nvalue is not persistent.")
prtAlertAllEvents = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 5, 1, 1, 19), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtAlertAllEvents.setDescription("A running counter of the total number of alert event entries\n(critical and non-critical) that have been recorded in the\nalert table")
prtStorageRefTable = MibTable((1, 3, 6, 1, 2, 1, 43, 5, 2))
if mibBuilder.loadTexts: prtStorageRefTable.setDescription("This table defines which printer, amongst multiple printers\nserviced by one agent, owns which storage units.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtStorageRefEntry = MibTableRow((1, 3, 6, 1, 2, 1, 43, 5, 2, 1)).setIndexNames((0, "HOST-RESOURCES-MIB", "hrStorageIndex"), (0, "Printer-MIB", "prtStorageRefSeqNumber"))
if mibBuilder.loadTexts: prtStorageRefEntry.setDescription("This table will have an entry for each entry in the Host\nResources MIB storage table that represents storage associated\nwith a printer managed by this agent.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtStorageRefSeqNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 5, 2, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: prtStorageRefSeqNumber.setDescription("This value will be unique amongst all entries with a common\nvalue of hrStorageIndex. This object allows a storage entry to\npoint to the multiple printer devices with which it is\nassociated.")
prtStorageRefIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 5, 2, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtStorageRefIndex.setDescription("The value of the hrDeviceIndex of the printer device that this\nstorageEntry is associated with.")
prtDeviceRefTable = MibTable((1, 3, 6, 1, 2, 1, 43, 5, 3))
if mibBuilder.loadTexts: prtDeviceRefTable.setDescription("This table defines which printer, amongst multiple printers\nserviced by one agent, is associated with which devices.\n\nNOTE: The above description has been modified from RFC 1759\n\n\n\nfor clarification.")
prtDeviceRefEntry = MibTableRow((1, 3, 6, 1, 2, 1, 43, 5, 3, 1)).setIndexNames((0, "HOST-RESOURCES-MIB", "hrDeviceIndex"), (0, "Printer-MIB", "prtDeviceRefSeqNumber"))
if mibBuilder.loadTexts: prtDeviceRefEntry.setDescription("This table will have an entry for each entry in the Host\nResources MIB device table that represents a device associated\nwith a printer managed by this agent.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtDeviceRefSeqNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 5, 3, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: prtDeviceRefSeqNumber.setDescription("This value will be unique amongst all entries with a common\nvalue of hrDeviceIndex. This object allows a device entry to\npoint to the multiple printer devices with which it is\nassociated.")
prtDeviceRefIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 5, 3, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtDeviceRefIndex.setDescription("The value of the hrDeviceIndex of the printer device that this\ndeviceEntry is associated with.")
prtCover = MibIdentifier((1, 3, 6, 1, 2, 1, 43, 6))
prtCoverTable = MibTable((1, 3, 6, 1, 2, 1, 43, 6, 1))
if mibBuilder.loadTexts: prtCoverTable.setDescription("A table of the covers and interlocks of the printer.")
prtCoverEntry = MibTableRow((1, 3, 6, 1, 2, 1, 43, 6, 1, 1)).setIndexNames((0, "HOST-RESOURCES-MIB", "hrDeviceIndex"), (0, "Printer-MIB", "prtCoverIndex"))
if mibBuilder.loadTexts: prtCoverEntry.setDescription("Information about a cover or interlock.\nEntries may exist in the table for each device\nindex with a device type of 'printer'.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtCoverIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 6, 1, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: prtCoverIndex.setDescription("A unique value used by the printer to identify this Cover sub\n\n\n\nunit.  Although these values may change due to a major\nreconfiguration of the device (e.g., the addition of new cover\nsub-units to the printer), values SHOULD remain stable across\nsuccessive printer power cycles.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtCoverDescription = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 6, 1, 1, 2), PrtLocalizedDescriptionStringTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtCoverDescription.setDescription("The manufacturer provided cover sub-mechanism name in the\nlocalization specified by prtGeneralCurrentLocalization.")
prtCoverStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 6, 1, 1, 3), PrtCoverStatusTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtCoverStatus.setDescription("The status of this cover sub-unit.")
prtLocalization = MibIdentifier((1, 3, 6, 1, 2, 1, 43, 7))
prtLocalizationTable = MibTable((1, 3, 6, 1, 2, 1, 43, 7, 1))
if mibBuilder.loadTexts: prtLocalizationTable.setDescription("The available localizations in this printer.")
prtLocalizationEntry = MibTableRow((1, 3, 6, 1, 2, 1, 43, 7, 1, 1)).setIndexNames((0, "HOST-RESOURCES-MIB", "hrDeviceIndex"), (0, "Printer-MIB", "prtLocalizationIndex"))
if mibBuilder.loadTexts: prtLocalizationEntry.setDescription("A description of a localization.\nEntries may exist in the table for each device\nindex with a device type of 'printer'.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtLocalizationIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 7, 1, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: prtLocalizationIndex.setDescription("A unique value used by the printer to identify this\nlocalization entry.  Although these values may change due to a\nmajor reconfiguration of the device (e.g., the addition of new\nlocalization data to the printer), values SHOULD remain\nstable across successive printer power cycles.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtLocalizationLanguage = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 7, 1, 1, 2), OctetString().subtype(subtypeSpec=ValueSizeConstraint(2, 2)).setFixedLength(2)).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtLocalizationLanguage.setDescription("A two character language code from ISO 639.  Examples en,\nes, fr, de.  NOTE: These examples were shown as upper case in\nRFC 1759 and are now shown as lower case to agree with ISO 639.")
prtLocalizationCountry = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 7, 1, 1, 3), OctetString().subtype(subtypeSpec=ValueSizeConstraint(2, 2)).setFixedLength(2)).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtLocalizationCountry.setDescription("A two character country code from ISO 3166, a blank string\n(two space characters) shall indicate that the country is not\ndefined.  Examples: US, GB, FR, DE, ...")
prtLocalizationCharacterSet = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 7, 1, 1, 4), IANACharset()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtLocalizationCharacterSet.setDescription("The coded character set used for this localization.")
prtInput = MibIdentifier((1, 3, 6, 1, 2, 1, 43, 8))
prtInputTable = MibTable((1, 3, 6, 1, 2, 1, 43, 8, 2))
if mibBuilder.loadTexts: prtInputTable.setDescription("A table of the devices capable of providing media for input to\nthe printing process.")
prtInputEntry = MibTableRow((1, 3, 6, 1, 2, 1, 43, 8, 2, 1)).setIndexNames((0, "HOST-RESOURCES-MIB", "hrDeviceIndex"), (0, "Printer-MIB", "prtInputIndex"))
if mibBuilder.loadTexts: prtInputEntry.setDescription("Attributes of a device capable of providing media for input to\nthe printing process.  Entries may exist in the table for each\ndevice index with a device type of 'printer'.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtInputIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 8, 2, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: prtInputIndex.setDescription("A unique value used by the printer to identify this input\nsub-unit.  Although these values may change due to a major\nreconfiguration of the device (e.g., the addition of new input\nsub-units to the printer), values SHOULD remain stable across\nsuccessive printer power cycles.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtInputType = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 8, 2, 1, 2), PrtInputTypeTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtInputType.setDescription("The type of technology (discriminated primarily according to\nfeeder mechanism type) employed by the input sub-unit.  Note,\nthe Input Class provides for a descriptor field to further\nqualify the other choice.")
prtInputDimUnit = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 8, 2, 1, 3), PrtMediaUnitTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtInputDimUnit.setDescription("The unit of measurement for use calculating and relaying\ndimensional values for this input sub-unit.")
prtInputMediaDimFeedDirDeclared = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 8, 2, 1, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2, 2147483647))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtInputMediaDimFeedDirDeclared.setDescription("This object provides the value of the declared dimension, in\nthe feed direction, of the media that is (or, if empty, was or\nwill be) in this input sub-unit.  The feed direction is the\ndirection in which the media is fed on this sub-unit.  This\ndimension is measured in input sub-unit dimensional units\n(controlled by prtInputDimUnit, which uses PrtMediaUnitTC).  If\nthis input sub-unit can reliably sense this value, the value is\nsensed by the printer and may not be changed by management\nrequests.  Otherwise, the value may be changed.  The value (-1)\nmeans other and specifically means that this sub-unit places no\nrestriction on this parameter.  The value (-2) indicates\nunknown.")
prtInputMediaDimXFeedDirDeclared = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 8, 2, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2, 2147483647))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtInputMediaDimXFeedDirDeclared.setDescription("This object provides the value of the declared dimension, in\nthe cross feed direction, of the media that is (or, if empty,\nwas or will be) in this input sub-unit.  The cross  feed\ndirection is ninety degrees relative to the feed direction\nassociated with this sub-unit.  This dimension is measured in\ninput sub-unit dimensional units (controlled by\nprtInputDimUnit,which uses PrtMediaUnitTC).  If this input sub-\nunit can reliably sense this value, the value is sensed by the\nprinter and may not be changed by management requests.\nOtherwise, the value may be changed.  The value (-1) means other\nand specifically means that this sub-unit places no restriction\non this parameter.  The value (-2) indicates unknown.")
prtInputMediaDimFeedDirChosen = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 8, 2, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtInputMediaDimFeedDirChosen.setDescription("The printer will act as if media of the chosen dimension (in\nthe feed direction) is present in this input source.  Note that\nthis value will be used even if the input tray is empty.  Feed\ndimension measurements are taken relative to the feed direction\nassociated with that sub-unit and are in input sub-unit\ndimensional units (controlled by prtInputDimUnit, which uses\nPrtMediaUnitTC).  If the printer supports the declared\ndimension,the granted dimension is the same as the declared\ndimension.  If not, the granted dimension is set to the closest\ndimension that the printer supports when the declared dimension\nis set.  The value (-1) means other and specifically indicates\nthat this sub-unit places no restriction on this parameter.  The\nvalue (-2)indicates unknown.")
prtInputMediaDimXFeedDirChosen = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 8, 2, 1, 7), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtInputMediaDimXFeedDirChosen.setDescription("The printer will act as if media of the chosen dimension (in\nthe cross feed direction) is present in this input source.  Note\nthat this value will be used even if the input tray is empty.\nThe cross feed direction is ninety degrees relative to the feed\ndirection associated with this sub-unit.  This dimension is\nmeasured in input sub-unit dimensional units (controlled by\nprtInputDimUnit, which uses PrtMediaUnitTC).  If the printer\nsupports the declare dimension, the granted dimension is the\nsame as the declared dimension.  If not, the granted dimension\nis set to the closest dimension that the printer supports when\nthe declared dimension is set.  The value (-1) means other and\nspecifically indicates that this sub-unit places no restriction\non this parameter.  The value (-2) indicates unknown.")
prtInputCapacityUnit = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 8, 2, 1, 8), PrtCapacityUnitTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtInputCapacityUnit.setDescription("The unit of measurement for use in calculating and relaying\ncapacity values for this input sub-unit.")
prtInputMaxCapacity = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 8, 2, 1, 9), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2, 2147483647))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtInputMaxCapacity.setDescription("The maximum capacity of the input sub-unit in input sub-unit\ncapacity units (PrtCapacityUnitTC).  There is no convention\nassociated with the media itself so this value reflects claimed\ncapacity.  If this input sub-unit can reliably sense this value,\nthe value is sensed by the printer and may not be changed by\nmanagement requests; otherwise, the value may be written (by a\nRemote Control Panel or a Management Application). The value\n(-1) means other and specifically indicates that the sub-unit\nplaces no restrictions on this parameter.  The value (-2) means\nunknown.")
prtInputCurrentLevel = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 8, 2, 1, 10), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-3, 2147483647))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtInputCurrentLevel.setDescription("The current capacity of the input sub-unit in input sub-unit\ncapacity units (PrtCapacityUnitTC).  If this input sub-unit can\nreliably sense this value, the value is sensed by the printer\nand may not be changed by management requests; otherwise, the\nvalue may be written (by a Remote Control Panel or a Management\nApplication).  The value (-1) means other and specifically\nindicates that the sub-unit places no restrictions on this\nparameter.  The value (-2) means unknown.  The value (-3) means\nthat the printer knows that at least one unit remains.")
prtInputStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 8, 2, 1, 11), PrtSubUnitStatusTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtInputStatus.setDescription("The current status of this input sub-unit.")
prtInputMediaName = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 8, 2, 1, 12), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 63))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtInputMediaName.setDescription("A description of the media contained in this input sub-unit;\nThis description is to be used by a client to format and\nLocalize a string for display to a human operator.  This\ndescription is not processed by the printer.  It is used to\nprovide information not expressible in terms of the other\nmedia attributes (e.g., prtInputMediaDimFeedDirChosen,\nprtInputMediaDimXFeedDirChosen, prtInputMediaWeight,\nprtInputMediaType).")
prtInputName = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 8, 2, 1, 13), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 63))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtInputName.setDescription("The name assigned to this input sub-unit.")
prtInputVendorName = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 8, 2, 1, 14), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 63))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtInputVendorName.setDescription("The vendor name of this input sub-unit.")
prtInputModel = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 8, 2, 1, 15), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 63))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtInputModel.setDescription("The model name of this input sub-unit.")
prtInputVersion = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 8, 2, 1, 16), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 63))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtInputVersion.setDescription("The version of this input sub-unit.")
prtInputSerialNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 8, 2, 1, 17), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 32))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtInputSerialNumber.setDescription("The serial number assigned to this input sub-unit.")
prtInputDescription = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 8, 2, 1, 18), PrtLocalizedDescriptionStringTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtInputDescription.setDescription("A free-form text description of this input sub-unit in the\nlocalization specified by  prtGeneralCurrentLocalization.")
prtInputSecurity = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 8, 2, 1, 19), PresentOnOff()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtInputSecurity.setDescription("Indicates if this input sub-unit has some security associated\nwith it.")
prtInputMediaWeight = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 8, 2, 1, 20), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2, 2147483647))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtInputMediaWeight.setDescription("The weight of the medium associated with this input sub-unit\nin grams / per meter squared.  The value (-2) means unknown.")
prtInputMediaType = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 8, 2, 1, 21), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 63))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtInputMediaType.setDescription("The name of the type of medium associated with this input sub\nunit.  This name need not be processed by the printer; it might\nsimply be displayed to an operator.\n\nNOTE: The above description has been modified from RFC 1759.")
prtInputMediaColor = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 8, 2, 1, 22), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 63))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtInputMediaColor.setDescription("The name of the color of the medium associated with\nthis input sub-unit using standardized string values.\n\nNOTE: The above description has been modified from RFC 1759.")
prtInputMediaFormParts = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 8, 2, 1, 23), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2, 2147483647))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtInputMediaFormParts.setDescription("The number of parts associated with the medium\nassociated with this input sub-unit if the medium is a\nmulti-part form.  The value (-1) means other and\nspecifically indicates that the device places no\nrestrictions on this parameter.  The value (-2) means\nunknown.")
prtInputMediaLoadTimeout = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 8, 2, 1, 24), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2, 2147483647))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtInputMediaLoadTimeout.setDescription("When the printer is not able to print due to a subunit being\nempty or the requested media must be manually loaded, the\nprinter will wait for the duration (in seconds) specified by\nthis object.  Upon expiration of the time-out, the printer will\ntake the action specified by prtInputNextIndex.\n\nThe event which causes the printer to enter the waiting state\nis product specific.  If the printer is not waiting for manually\nfed media, it may switch from an empty subunit to a different\nsubunit without waiting for the time-out to expire.\n\nA value of (-1) implies 'other' or 'infinite' which translates\nto 'wait forever'.  The action which causes printing to continue\nis product specific.  A value of (-2) implies 'unknown'.")
prtInputNextIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 8, 2, 1, 25), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-3, 2147483647))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtInputNextIndex.setDescription("The value of prtInputIndex corresponding to the input subunit\nwhich will be used when this input subunit is emptied and the\ntime-out specified by prtInputMediaLoadTimeout expires.  A value\nof zero(0) indicates that auto input switching will not occur\nwhen this input subunit is emptied.  If the time-out specified\nby prtInputLoadMediaTimeout expires and this value is zero(0),\nthe job will be aborted.  A value of (-1) means other.  The\nvalue (-2)means 'unknown' and specifically indicates that an\nimplementation specific method will determine the next input\nsubunit to use at the time this subunit is emptied and the time\nout expires.  The value(-3) means input switching is not\nsupported for this subunit.")
prtOutput = MibIdentifier((1, 3, 6, 1, 2, 1, 43, 9))
prtOutputTable = MibTable((1, 3, 6, 1, 2, 1, 43, 9, 2))
if mibBuilder.loadTexts: prtOutputTable.setDescription("A table of the devices capable of receiving media delivered\nfrom the printing process.")
prtOutputEntry = MibTableRow((1, 3, 6, 1, 2, 1, 43, 9, 2, 1)).setIndexNames((0, "HOST-RESOURCES-MIB", "hrDeviceIndex"), (0, "Printer-MIB", "prtOutputIndex"))
if mibBuilder.loadTexts: prtOutputEntry.setDescription("Attributes of a device capable of receiving media delivered\nfrom the printing process.  Entries may exist in the table for\neach device index with a device type of 'printer'.\n\n\n\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtOutputIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 9, 2, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: prtOutputIndex.setDescription("A unique value used by this printer to identify this output\nsub-unit.  Although these values may change due to a major\nreconfiguration of the sub-unit (e.g., the addition of new\noutput devices to the printer), values SHOULD remain stable\nacross successive printer power cycles.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtOutputType = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 9, 2, 1, 2), PrtOutputTypeTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtOutputType.setDescription("The type of technology supported by this output sub-unit.")
prtOutputCapacityUnit = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 9, 2, 1, 3), PrtCapacityUnitTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtOutputCapacityUnit.setDescription("The unit of measurement for use in calculating and relaying\ncapacity values for this output sub-unit.")
prtOutputMaxCapacity = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 9, 2, 1, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2, 2147483647))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtOutputMaxCapacity.setDescription("The maximum capacity of this output sub-unit in output sub-\nunit capacity units (PrtCapacityUnitTC).  There is no convention\nassociated with the media itself so this value essentially\nreflects claimed capacity.  If this output sub-unit can reliably\nsense this value, the value is sensed by the printer and may\nnot be changed by management requests; otherwise, the value may\nbe written (by a Remote Control Panel or a Management\nApplication).  The value (-1) means other and specifically\nindicates that the sub-unit places no restrictions on this\nparameter.  The value (-2) means unknown.")
prtOutputRemainingCapacity = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 9, 2, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-3, 2147483647))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtOutputRemainingCapacity.setDescription("The remaining capacity of the possible output sub-unit\ncapacity in output sub-unit capacity units\n(PrtCapacityUnitTC)of this output sub-unit.  If this output sub-\nunit can reliably sense this value, the value is sensed by the\nprinter and may not be modified by management requests;\n\n\n\notherwise, the value may be written (by a Remote Control Panel\nor a Management Application).  The value (-1) means other and\nspecifically indicates that the sub-unit places no restrictions\non this parameter.  The value (-2) means unknown.  The value\n(-3) means that the printer knows that there remains capacity\nfor at least one unit.")
prtOutputStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 9, 2, 1, 6), PrtSubUnitStatusTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtOutputStatus.setDescription("The current status of this output sub-unit.")
prtOutputName = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 9, 2, 1, 7), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 63))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtOutputName.setDescription("The name assigned to this output sub-unit.")
prtOutputVendorName = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 9, 2, 1, 8), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 63))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtOutputVendorName.setDescription("The vendor name of this output sub-unit.")
prtOutputModel = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 9, 2, 1, 9), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 63))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtOutputModel.setDescription("The model name assigned to this output sub-unit.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtOutputVersion = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 9, 2, 1, 10), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 63))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtOutputVersion.setDescription("The version of this output sub-unit.")
prtOutputSerialNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 9, 2, 1, 11), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 63))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtOutputSerialNumber.setDescription("The serial number assigned to this output sub-unit.")
prtOutputDescription = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 9, 2, 1, 12), PrtLocalizedDescriptionStringTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtOutputDescription.setDescription("A free-form text description of this output sub-unit in the\nlocalization specified by prtGeneralCurrentLocalization.")
prtOutputSecurity = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 9, 2, 1, 13), PresentOnOff()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtOutputSecurity.setDescription("Indicates if this output sub-unit has some security associated\nwith it and if that security is enabled or not.")
prtOutputDimUnit = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 9, 2, 1, 14), PrtMediaUnitTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtOutputDimUnit.setDescription("The unit of measurement for use in calculating and relaying\ndimensional values for this output sub-unit.")
prtOutputMaxDimFeedDir = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 9, 2, 1, 15), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2, 2147483647))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtOutputMaxDimFeedDir.setDescription("The maximum dimensions supported by this output sub-unit\nfor measurements taken parallel relative to the feed\ndirection associated with that sub-unit in output\nsub-unit dimensional units (controlled by prtOutputDimUnit,\nwhich uses PrtMediaUnitTC).  If this output sub-unit can\nreliably sense this value, the value is sensed by the printer\nand may not be changed with management protocol operations.\nThe value (-1) means other and specifically indicates that the\nsub-unit places no restrictions on this parameter.  The value\n(-2) means unknown.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification and to explain the purpose of (-1) and (-2).")
prtOutputMaxDimXFeedDir = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 9, 2, 1, 16), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2, 2147483647))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtOutputMaxDimXFeedDir.setDescription("The maximum dimensions supported by this output sub-unit\nfor measurements taken ninety degrees relative to the\nfeed direction associated with that sub-unit in output\nsub-unit dimensional units (controlled by prtOutputDimUnit,\nwhich uses PrtMediaUnitTC).  If this output sub-unit can\nreliably sense this value, the value is sensed by the printer\nand may not be changed with management protocol operations.\nThe value (-1) means other and specifically indicates that the\nsub-unit places no restrictions on this parameter.  The value\n(-2) means unknown.\n\n\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification and to explain the purpose of (-1) and (-2).")
prtOutputMinDimFeedDir = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 9, 2, 1, 17), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2, 2147483647))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtOutputMinDimFeedDir.setDescription("The minimum dimensions supported by this output sub-unit\nfor measurements taken parallel relative to the feed\ndirection associated with that sub-unit in output\nsub-unit dimensional units (controlled by prtOutputDimUnit,\nwhich uses PrtMediaUnitTC).  If this output sub-unit can\nreliably sense this value, the value is sensed by the printer\nand may not be changed with management protocol operations.\nThe value (-1) means other and specifically indicates that the\nsub-unit places no restrictions on this parameter.  The value\n(-2) means unknown.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification and to explain the purpose of (-1) and (-2).")
prtOutputMinDimXFeedDir = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 9, 2, 1, 18), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2, 2147483647))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtOutputMinDimXFeedDir.setDescription("The minimum dimensions supported by this output sub-unit\nfor measurements taken ninety degrees relative to the\nfeed direction associated with that sub-unit in output\nsub-unit dimensional units (controlled by prtOutputDimUnit,\nwhich uses PrtMediaUnitTC).  If this output sub-unit can\nreliably sense this value, the value is sensed by the printer\nand may not be changed with management protocol operations.\nThe value (-1) means other and specifically indicates that the\nsub-unit places no restrictions on this parameter.  The value\n(-2) means unknown.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification and to explain the purpose of (-1) and (-2).")
prtOutputStackingOrder = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 9, 2, 1, 19), PrtOutputStackingOrderTC()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtOutputStackingOrder.setDescription("The current state of the stacking order for the\nassociated output sub-unit. 'FirstToLast' means\nthat as pages are output the front of the next page is\nplaced against the back of the previous page.\n'LasttoFirst' means that as pages are output the back\nof the next page is placed against the front of the\nprevious page.")
prtOutputPageDeliveryOrientation = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 9, 2, 1, 20), PrtOutputPageDeliveryOrientationTC()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtOutputPageDeliveryOrientation.setDescription("The reading surface that will be 'up' when pages are\ndelivered to the associated output sub-unit.  Values are\nfaceUp and faceDown.  (Note: interpretation of these\nvalues is in general context-dependent based on locale;\npresentation of these values to an end-user should be\nnormalized to the expectations of the user).")
prtOutputBursting = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 9, 2, 1, 21), PresentOnOff()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtOutputBursting.setDescription("This object indicates that the outputting sub-unit supports\nbursting, and if so, whether the feature is enabled.  Bursting\nis the process by which continuous media is separated into\nindividual sheets, typically by bursting along pre-formed\nperforations.")
prtOutputDecollating = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 9, 2, 1, 22), PresentOnOff()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtOutputDecollating.setDescription("This object indicates that the output supports decollating,\nand if so, whether the feature is enabled.  Decollating is the\nprocess by which the individual parts within a multi-part form\nare separated and sorted into separate stacks for each part.")
prtOutputPageCollated = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 9, 2, 1, 23), PresentOnOff()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtOutputPageCollated.setDescription("This object indicates that the output sub-unit supports page\ncollation, and if so, whether the feature is enabled.  See RFC\n3805 Appendix A, Glossary Of Terms, for definition of how this\ndocument defines collation.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtOutputOffsetStacking = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 9, 2, 1, 24), PresentOnOff()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtOutputOffsetStacking.setDescription("This object indicates that the output supports offset\nstacking,and if so, whether the feature is enabled.  See RFC\n3805 Appendix A, Glossary Of Terms,  for how Offset Stacking is\ndefined by this document.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtMarker = MibIdentifier((1, 3, 6, 1, 2, 1, 43, 10))
prtMarkerTable = MibTable((1, 3, 6, 1, 2, 1, 43, 10, 2))
if mibBuilder.loadTexts: prtMarkerTable.setDescription("The marker table provides a description of each marker\nsub-unit contained within the printer.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtMarkerEntry = MibTableRow((1, 3, 6, 1, 2, 1, 43, 10, 2, 1)).setIndexNames((0, "HOST-RESOURCES-MIB", "hrDeviceIndex"), (0, "Printer-MIB", "prtMarkerIndex"))
if mibBuilder.loadTexts: prtMarkerEntry.setDescription("Entries in this table define the characteristics and status\nof each marker sub-unit in the printer.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtMarkerIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 10, 2, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: prtMarkerIndex.setDescription("A unique value used by the printer to identify this marking\nSubUnit.  Although these values may change due to a major\nreconfiguration of the device (e.g., the addition of new marking\nsub-units to the printer), values SHOULD remain stable across\nsuccessive printer power cycles.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtMarkerMarkTech = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 10, 2, 1, 2), PrtMarkerMarkTechTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMarkerMarkTech.setDescription("The type of marking technology used for this marking\nsub-unit.")
prtMarkerCounterUnit = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 10, 2, 1, 3), PrtMarkerCounterUnitTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMarkerCounterUnit.setDescription("The unit that will be used by the printer when reporting\ncounter values for this marking sub-unit.  The time units of\nmeasure are provided for a device like a strip recorder that\ndoes not or cannot track the physical dimensions of the media\nand does not use characters, lines or sheets.")
prtMarkerLifeCount = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 10, 2, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMarkerLifeCount.setDescription("The count of the number of units of measure counted during the\n\n\n\nlife of printer using units of measure as specified by\nprtMarkerCounterUnit.\n\nNote: This object should be implemented as a persistent object\nwith a reliable value throughout the lifetime of the printer.")
prtMarkerPowerOnCount = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 10, 2, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMarkerPowerOnCount.setDescription("The count of the number of units of measure counted since the\nequipment was most recently powered on using units of measure\nas specified by prtMarkerCounterUnit.")
prtMarkerProcessColorants = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 10, 2, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMarkerProcessColorants.setDescription("The number of process colors supported by this marker.  A\nprocess color of 1 implies monochrome.  The value of this\nobject and prtMarkerSpotColorants cannot both be 0.  The value\nof prtMarkerProcessColorants must be 0 or greater.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtMarkerSpotColorants = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 10, 2, 1, 7), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMarkerSpotColorants.setDescription("The number of spot colors supported by this marker.  The value\nof this object and prtMarkerProcessColorants cannot both be 0.\nMust be 0 or greater.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtMarkerAddressabilityUnit = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 10, 2, 1, 8), PrtMarkerAddressabilityUnitTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMarkerAddressabilityUnit.setDescription("The unit of measure of distances, as applied to the marker's\nresolution.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtMarkerAddressabilityFeedDir = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 10, 2, 1, 9), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMarkerAddressabilityFeedDir.setDescription("The maximum number of addressable marking positions in the\nfeed direction per 10000 units of measure specified by\nprtMarkerAddressabilityUnit.  A value of (-1) implies 'other'\nor 'infinite' while a value of (-2) implies 'unknown'.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtMarkerAddressabilityXFeedDir = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 10, 2, 1, 10), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMarkerAddressabilityXFeedDir.setDescription("The maximum number of addressable marking positions in the\ncross feed direction in 10000 units of measure specified by\nprtMarkerAddressabilityUnit.  A value of (-1) implies 'other'\nor 'infinite' while a value of (-2) implies 'unknown'.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtMarkerNorthMargin = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 10, 2, 1, 11), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMarkerNorthMargin.setDescription("The margin, in units identified by prtMarkerAddressabilityUnit,\nfrom the leading edge of the medium as the medium flows through\n\n\n\nthe marking engine with the side to be imaged facing the\nobserver.  The leading edge is the North edge and the other\nedges are defined by the normal compass layout of  directions\nwith the compass facing the observer.  Printing within the area\nbounded by all four margins is guaranteed for all interpreters.\nThe value (-2) means unknown.")
prtMarkerSouthMargin = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 10, 2, 1, 12), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMarkerSouthMargin.setDescription("The margin from the South edge  (see prtMarkerNorthMargin) of\nthe medium in units identified by prtMarkerAddressabilityUnit.\nPrinting within the area bounded by all four margins  is\nguaranteed for all interpreters.  The value (-2) means unknown.")
prtMarkerWestMargin = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 10, 2, 1, 13), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMarkerWestMargin.setDescription("The margin from the West edge (see prtMarkerNorthMargin) of\nthe medium in units identified by prtMarkerAddressabilityUnit.\nPrinting within the area bounded by all four margins is\nguaranteed for all interpreters.  The value (-2) means unknown.")
prtMarkerEastMargin = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 10, 2, 1, 14), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMarkerEastMargin.setDescription("The margin from the East edge (see prtMarkerNorthMargin) of\nthe medium in units identified by prtMarkerAddressabilityUnit.\nPrinting within the area bounded by all four margins is\nguaranteed for all interpreters.  The value (-2) means unknown.")
prtMarkerStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 10, 2, 1, 15), PrtSubUnitStatusTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMarkerStatus.setDescription("The current status of this marker sub-unit.")
prtMarkerSupplies = MibIdentifier((1, 3, 6, 1, 2, 1, 43, 11))
prtMarkerSuppliesTable = MibTable((1, 3, 6, 1, 2, 1, 43, 11, 1))
if mibBuilder.loadTexts: prtMarkerSuppliesTable.setDescription("A table of the marker supplies available on this printer.")
prtMarkerSuppliesEntry = MibTableRow((1, 3, 6, 1, 2, 1, 43, 11, 1, 1)).setIndexNames((0, "HOST-RESOURCES-MIB", "hrDeviceIndex"), (0, "Printer-MIB", "prtMarkerSuppliesIndex"))
if mibBuilder.loadTexts: prtMarkerSuppliesEntry.setDescription("Attributes of a marker supply.  Entries may exist in the table\nfor each device index with a device type of 'printer'.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtMarkerSuppliesIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 11, 1, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: prtMarkerSuppliesIndex.setDescription("A unique value used by the printer to identify this marker\nsupply.  Although these values may change due to a major\nreconfiguration of the device (e.g., the addition of new marker\n\n\n\nsupplies to the printer), values SHOULD remain stable across\nsuccessive printer power cycles.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtMarkerSuppliesMarkerIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 11, 1, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMarkerSuppliesMarkerIndex.setDescription("The value of prtMarkerIndex corresponding to the marking sub\nunit with which this marker supply sub-unit is associated.")
prtMarkerSuppliesColorantIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 11, 1, 1, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMarkerSuppliesColorantIndex.setDescription("The value of prtMarkerColorantIndex corresponding to the\ncolorant with which this marker supply sub-unit is associated.\nThis value shall be 0 if there is no colorant table or if this\nsupply does not depend on a single specified colorant.\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtMarkerSuppliesClass = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 11, 1, 1, 4), PrtMarkerSuppliesClassTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMarkerSuppliesClass.setDescription("Indicates whether this supply entity represents a supply that\nis consumed or a receptacle that is filled.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtMarkerSuppliesType = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 11, 1, 1, 5), PrtMarkerSuppliesTypeTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMarkerSuppliesType.setDescription("The type of this supply.")
prtMarkerSuppliesDescription = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 11, 1, 1, 6), PrtLocalizedDescriptionStringTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMarkerSuppliesDescription.setDescription("The description of this supply container/receptacle in the\nlocalization specified by prtGeneralCurrentLocalization.")
prtMarkerSuppliesSupplyUnit = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 11, 1, 1, 7), PrtMarkerSuppliesSupplyUnitTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMarkerSuppliesSupplyUnit.setDescription("Unit of measure of this marker supply container/receptacle.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtMarkerSuppliesMaxCapacity = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 11, 1, 1, 8), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2, 2147483647))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtMarkerSuppliesMaxCapacity.setDescription("The maximum capacity of this supply container/receptacle\nexpressed in prtMarkerSuppliesSupplyUnit.  If this supply\ncontainer/receptacle can reliably sense this value, the value\nis reported by the printer and is read-only; otherwise, the\nvalue may be written (by a Remote Control Panel or a Management\nApplication).  The value (-1) means other and specifically\nindicates that the sub-unit places no restrictions on this\nparameter.  The value (-2) means unknown.")
prtMarkerSuppliesLevel = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 11, 1, 1, 9), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-3, 2147483647))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtMarkerSuppliesLevel.setDescription("The current level if this supply is a container; the remaining\nspace if this supply is a receptacle.  If this supply\ncontainer/receptacle can reliably sense this value, the value\nis reported by the printer and is read-only; otherwise, the\nvalue may be written (by a Remote Control Panel or a Management\nApplication).  The value (-1) means other and specifically\nindicates that the sub-unit places no restrictions on this\nparameter.  The value (-2) means unknown.  A value of (-3) means\nthat the printer knows that there is some supply/remaining\nspace, respectively.")
prtMarkerColorant = MibIdentifier((1, 3, 6, 1, 2, 1, 43, 12))
prtMarkerColorantTable = MibTable((1, 3, 6, 1, 2, 1, 43, 12, 1))
if mibBuilder.loadTexts: prtMarkerColorantTable.setDescription("A table of all of the colorants available on the printer.")
prtMarkerColorantEntry = MibTableRow((1, 3, 6, 1, 2, 1, 43, 12, 1, 1)).setIndexNames((0, "HOST-RESOURCES-MIB", "hrDeviceIndex"), (0, "Printer-MIB", "prtMarkerColorantIndex"))
if mibBuilder.loadTexts: prtMarkerColorantEntry.setDescription("Attributes of a colorant available on the printer.  Entries may\nexist in the table for each device index with a device type of\n'printer'.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtMarkerColorantIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 12, 1, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: prtMarkerColorantIndex.setDescription("A unique value used by the printer to identify this colorant.\nAlthough these values may change due to a major reconfiguration\nof the device (e.g., the addition of new colorants to the\nprinter) , values SHOULD remain stable across successive\nprinter power cycles.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtMarkerColorantMarkerIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 12, 1, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMarkerColorantMarkerIndex.setDescription("The value of prtMarkerIndex corresponding to the marker sub\nunit with which this colorant entry is associated.")
prtMarkerColorantRole = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 12, 1, 1, 3), PrtMarkerColorantRoleTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMarkerColorantRole.setDescription("The role played by this colorant.")
prtMarkerColorantValue = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 12, 1, 1, 4), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMarkerColorantValue.setDescription("The name of the color of this colorant using standardized\nstring names from ISO 10175 (DPA) and ISO 10180 (SPDL) such as:\n    other\n    unknown\n    white\n    red\n    green\n    blue\n\n\n\n    cyan\n    magenta\n    yellow\n    black\nImplementers may add additional string values.  The naming\nconventions in ISO 9070 are recommended in order to avoid\npotential name clashes")
prtMarkerColorantTonality = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 12, 1, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(2, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMarkerColorantTonality.setDescription("The distinct levels of tonality realizable by a marking sub\nunit when using this colorant.  This value does not include the\nnumber of levels of tonal difference that an interpreter can\nobtain by techniques such as half toning.  This value must be at\nleast 2.")
prtMediaPath = MibIdentifier((1, 3, 6, 1, 2, 1, 43, 13))
prtMediaPathTable = MibTable((1, 3, 6, 1, 2, 1, 43, 13, 4))
if mibBuilder.loadTexts: prtMediaPathTable.setDescription("The media path table includes both physical and logical paths\nwithin the printer.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtMediaPathEntry = MibTableRow((1, 3, 6, 1, 2, 1, 43, 13, 4, 1)).setIndexNames((0, "HOST-RESOURCES-MIB", "hrDeviceIndex"), (0, "Printer-MIB", "prtMediaPathIndex"))
if mibBuilder.loadTexts: prtMediaPathEntry.setDescription("Entries may exist in the table for each device index with a\ndevice type of 'printer'  Each entry defines the physical\ncharacteristics of and the status of the media path.  The data\nprovided indicates the maximum throughput and the media\nsize limitations of these subunits.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtMediaPathIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 13, 4, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: prtMediaPathIndex.setDescription("A unique value used by the printer to identify this media\npath.  Although these values may change due to a major\nreconfiguration of the device (e.g., the addition of new media\npaths to the printer), values SHOULD remain stable across\nsuccessive printer power cycles.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtMediaPathMaxSpeedPrintUnit = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 13, 4, 1, 2), PrtMediaPathMaxSpeedPrintUnitTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMediaPathMaxSpeedPrintUnit.setDescription("The unit of measure used in specifying the speed of all media\npaths in the printer.")
prtMediaPathMediaSizeUnit = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 13, 4, 1, 3), PrtMediaUnitTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMediaPathMediaSizeUnit.setDescription("The units of measure of media size for use in calculating and\nrelaying dimensional values for all media paths in the\nprinter.")
prtMediaPathMaxSpeed = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 13, 4, 1, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMediaPathMaxSpeed.setDescription("The maximum printing speed of this media path expressed in\nprtMediaPathMaxSpeedUnit's.  A value of (-1) implies 'other'.")
prtMediaPathMaxMediaFeedDir = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 13, 4, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMediaPathMaxMediaFeedDir.setDescription("The maximum physical media size in the feed direction of this\nmedia path expressed in units of measure specified by\nPrtMediaPathMediaSizeUnit.  A value of (-1) implies 'unlimited'\na value of (-2) implies 'unknown'.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtMediaPathMaxMediaXFeedDir = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 13, 4, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMediaPathMaxMediaXFeedDir.setDescription("The maximum physical media size across the feed direction of\nthis media path expressed in units of measure specified by\nprtMediaPathMediaSizeUnit.  A value of (-2) implies 'unknown'.\n\n\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtMediaPathMinMediaFeedDir = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 13, 4, 1, 7), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMediaPathMinMediaFeedDir.setDescription("The minimum physical media size in the feed direction of this\nmedia path expressed in units of measure specified by\nprtMediaPathMediaSizeUnit.  A value of (-2) implies 'unknown'.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtMediaPathMinMediaXFeedDir = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 13, 4, 1, 8), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMediaPathMinMediaXFeedDir.setDescription("The minimum physical media size across the feed direction of\nthis media path expressed in units of measure specified by\nprtMediaPathMediaSizeUnit.  A value of (-2) implies 'unknown'.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtMediaPathType = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 13, 4, 1, 9), PrtMediaPathTypeTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMediaPathType.setDescription("The type of the media path for this media path.")
prtMediaPathDescription = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 13, 4, 1, 10), PrtLocalizedDescriptionStringTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMediaPathDescription.setDescription("The manufacturer-provided description of this media path in\nthe localization specified by prtGeneralCurrentLocalization.")
prtMediaPathStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 13, 4, 1, 11), PrtSubUnitStatusTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtMediaPathStatus.setDescription("The current status of this media path.")
prtChannel = MibIdentifier((1, 3, 6, 1, 2, 1, 43, 14))
prtChannelTable = MibTable((1, 3, 6, 1, 2, 1, 43, 14, 1))
if mibBuilder.loadTexts: prtChannelTable.setDescription("The channel table represents the set of input data sources\nwhich can provide print data to one or more of the\ninterpreters available on a printer.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtChannelEntry = MibTableRow((1, 3, 6, 1, 2, 1, 43, 14, 1, 1)).setIndexNames((0, "HOST-RESOURCES-MIB", "hrDeviceIndex"), (0, "Printer-MIB", "prtChannelIndex"))
if mibBuilder.loadTexts: prtChannelEntry.setDescription("Entries may exist in the table for each device index with a\ndevice type of 'printer'.  Each channel table entry is\ncharacterized by a unique protocol stack and/or addressing.\nThe channel may also have printer dependent features that are\nassociated with a printing language.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtChannelIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 14, 1, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: prtChannelIndex.setDescription("A unique value used by the printer to identify this data\nchannel.  Although these values may change due to a major\nreconfiguration of the device (e.g., the addition of new data\nchannels to the printer), values SHOULD remain stable across\nsuccessive printer power cycles.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtChannelType = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 14, 1, 1, 2), PrtChannelTypeTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtChannelType.setDescription("The type of this print data channel.  This object provides the\nlinkage to ChannelType-specific groups that may (conceptually)\nextend the prtChannelTable with additional details about that\nchannel.")
prtChannelProtocolVersion = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 14, 1, 1, 3), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 63))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtChannelProtocolVersion.setDescription("The version of the protocol used on this channel.  The format\nused for version numbering depends on prtChannelType.")
prtChannelCurrentJobCntlLangIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 14, 1, 1, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtChannelCurrentJobCntlLangIndex.setDescription("The value of prtInterpreterIndex corresponding to the Control\nLanguage Interpreter for this channel.  This interpreter defines\nthe syntax used for control functions, such as querying or\nchanging environment variables and identifying job boundaries\n(e.g., PJL, PostScript, NPAP).  A value of zero indicates that\nthere is no current Job Control Language Interpreter for this\nchannel.\n\n\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtChannelDefaultPageDescLangIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 14, 1, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtChannelDefaultPageDescLangIndex.setDescription("The value of prtInterpreterIndex corresponding to the Page\nDescription Language Interpreter for this channel.  This\ninterpreter defines the default Page Description Language\ninterpreter to be used for the print data unless the Control\nLanguage is used to select a specific interpreter (e.g., PCL,\nPostScript Language, auto-sense).  A value of zero indicates\nthat there is no default page description language interpreter\nfor this channel.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtChannelState = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 14, 1, 1, 6), PrtChannelStateTC()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtChannelState.setDescription("The state of this print data channel.  The value determines\nwhether control information and print data is allowed through\nthis channel or not.")
prtChannelIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 14, 1, 1, 7), InterfaceIndexOrZero()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtChannelIfIndex.setDescription("The value of ifIndex in the ifTable; see the Interfaces Group\nMIB [RFC2863] which corresponds to this channel.\nWhen more than one row of the ifTable is relevant, this is the\nindex of the row representing the topmost layer in the\ninterface hierarchy.  A value of zero indicates that no\ninterface is associated with this channel.\n\nNOTE: The above description has been modified from RFC 1759\n\n\n\nfor clarification.")
prtChannelStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 14, 1, 1, 8), PrtSubUnitStatusTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtChannelStatus.setDescription("The current status of the channel.")
prtChannelInformation = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 14, 1, 1, 9), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtChannelInformation.setDescription("Auxiliary information to allow a printing application to use\nthe channel for data submission to the printer.  An application\ncapable of using a specific PrtChannelType should be able to\nuse the combined information from the prtChannelInformation and\nother channel and interface group objects to 'bootstrap' its\nuse of the channel.  prtChannelInformation is not intended to\nprovide a general channel description, nor to provide\ninformation that is available once the channel is in use.\n\nThe encoding and interpretation of the prtChannelInformation\nobject is specific to channel type.  The description of each\nPrtChannelType enum value for which prtChannelInformation is\ndefined specifies the appropriate encoding and interpretation,\nincluding interaction with other objects.  For channel types\nthat do not specify a prtChannelInformation value, its value\nshall be null (0 length).\n\nWhen a new PrtChannelType enumeration value is registered, its\naccompanying description must specify the encoding and\ninterpretation of the prtChannelInformation value for the\nchannel type.  prtChannelInformation semantics for an existing\nPrtChannelType may be added or amended in the same manner as\ndescribed in section 2.4.1 for type 2 enumeration values.\n\nThe prtChannelInformation specifies values for a collection of\nchannel attributes, represented as text according to the\nfollowing rules:\n\n1. The prtChannelInformation is not affected by localization.\n\n2. The prtChannelInformation is a list of entries representing\nthe attribute values.  Each entry consists of the following\n\n\n\nitems, in order:\n\na. A keyword, composed of alphabetic characters (A-Z, a-z)\nrepresented by their NVT ASCII [RFC854] codes, that\nidentifies a channel attribute,\n\nb. The NVT ASCII code for an Equals Sign (=) (code 61) to\ndelimit the keyword,\n\nc. A data value encoded using rules specific to the\nPrtChannelType to with the prtChannelInformation applies which\nmust in no case allow an octet with value 10 (the NVT ASCII\nLine Feed code),\n\nd. the NVT ASCII code for a Line Feed character (code 10) to\ndelimit the data value.\n\nNo other octets shall be present.\n\nKeywords are case-sensitive.  Conventionally, keywords are\ncapitalized (including each word of a multi-word keyword) and\nsince they occupy space in the prtChannelInformation, they are\nkept short.\n\n3. If a channel attribute has multiple values, it is\nrepresented by multiple entries with the same keyword, each\nspecifying one value. Otherwise, there shall be at most one\nentry for each attribute.\n\n4. By default, entries may appear in any order.  If there are\nordering constraints for particular entries, these must be\nspecified in their definitions.\n\n5. The prtChannelInformation value by default consists of text\nrepresented by NVT ASCII graphics character codes.  However,\nother representations may be specified:\n\na. In cases where the prtChannelInformation value contains\ninformation not normally coded in textual form, whatever\nsymbolic representation is conventionally used for the\ninformation should be used for encoding the\nprtChannelInformation value.  (For instance, a binary port value\nmight be represented as a decimal number using NVT ASCII\ncodes.)  Such encoding must be specified in the definition of\nthe value.\n\nb. The value may contain textual information in a character set\nother than NVT ASCII graphics characters.  (For instance, an\n\n\n\nidentifier might consist of ISO 10646 text encoded using the\nUTF-8 encoding scheme.)  Such a character set and its encoding\nmust be specified in the definition of the value.\n\n6. For each PrtChannelType for which prtChannelInformation\nentries are defined, the descriptive text associated with the\nPrtChannelType enumeration value shall specify the following\ninformation for each entry:\n\nTitle:        Brief description phrase, e.g.: 'Port name',\n              'Service Name', etc.\n\nKeyword:      The keyword value, e.g.: 'Port' or 'Service'\n\nSyntax:       The encoding of the entry value if it cannot be\n              directly represented by NVT ASCII.\n\nStatus:       'Mandatory', 'Optional', or 'Conditionally\n              Mandatory'\n\nMultiplicity: 'Single' or 'Multiple' to indicate whether the\n              entry may be present multiple times.\n\nDescription:  Description of the use of the entry, other\n              information required to complete the definition\n              (e.g.: ordering constraints, interactions between\n              entries).\n\nApplications that interpret prtChannelInformation should ignore\nunrecognized entries, so they are not affected if new entry\ntypes are added.")
prtInterpreter = MibIdentifier((1, 3, 6, 1, 2, 1, 43, 15))
prtInterpreterTable = MibTable((1, 3, 6, 1, 2, 1, 43, 15, 1))
if mibBuilder.loadTexts: prtInterpreterTable.setDescription("The interpreter table is a table representing the\ninterpreters in the printer.  An entry shall be placed in the\ninterpreter table for each interpreter on the printer.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtInterpreterEntry = MibTableRow((1, 3, 6, 1, 2, 1, 43, 15, 1, 1)).setIndexNames((0, "HOST-RESOURCES-MIB", "hrDeviceIndex"), (0, "Printer-MIB", "prtInterpreterIndex"))
if mibBuilder.loadTexts: prtInterpreterEntry.setDescription("Entries may exist in the table for each device index with a\ndevice type of 'printer'.  Each table entry provides a complete\ndescription of the interpreter, including version information,\nrendering resolutions, default character sets, output\norientation, and communication capabilities.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtInterpreterIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 15, 1, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: prtInterpreterIndex.setDescription("A unique value for each PDL or control language for which\nthere exists an interpreter or emulator in the printer.  The\nvalue is used to identify this interpreter.  Although these\nvalues may change due to a major reconfiguration of the device\n(e.g., the addition of new interpreters to the printer), values\nSHOULD remain stable across successive printer power cycles.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtInterpreterLangFamily = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 15, 1, 1, 2), PrtInterpreterLangFamilyTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtInterpreterLangFamily.setDescription("The family name of a Page Description Language (PDL) or\ncontrol language which this interpreter in the printer can\ninterpret or emulate.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtInterpreterLangLevel = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 15, 1, 1, 3), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 31))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtInterpreterLangLevel.setDescription("The level of the language which this interpreter is\ninterpreting or emulating.  This might contain a value like\n'5e'for an interpreter which is emulating level 5e of the PCL\nlanguage.  It might contain '2' for an interpreter which is\nemulating level 2 of the PostScript language.  Similarly it\nmight contain '2' for an interpreter which is emulating level 2\nof the HPGL language.")
prtInterpreterLangVersion = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 15, 1, 1, 4), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 31))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtInterpreterLangVersion.setDescription("The date code or version of the language which this\ninterpreter is interpreting or emulating.")
prtInterpreterDescription = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 15, 1, 1, 5), PrtLocalizedDescriptionStringTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtInterpreterDescription.setDescription("A string to identify this interpreter in the localization\nspecified by prtGeneralCurrentLocalization as opposed to the\nlanguage which is being interpreted.  It is anticipated that\nthis string will allow manufacturers to unambiguously identify\ntheir interpreters.")
prtInterpreterVersion = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 15, 1, 1, 6), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 31))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtInterpreterVersion.setDescription("The date code, version number, or other product specific\ninformation tied to this interpreter.  This value is associated\nwith the interpreter, rather than with the version of the\nlanguage which is being interpreted or emulated.")
prtInterpreterDefaultOrientation = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 15, 1, 1, 7), PrtPrintOrientationTC()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtInterpreterDefaultOrientation.setDescription("The current orientation default for this interpreter.  This\nvalue may be overridden for a particular job (e.g., by a\ncommand in the input data stream).")
prtInterpreterFeedAddressability = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 15, 1, 1, 8), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtInterpreterFeedAddressability.setDescription("The maximum interpreter addressability in the feed\ndirection in 10000 prtMarkerAddressabilityUnits (as specified\nby prtMarkerDefaultIndex) for this interpreter.  The\nvalue (-1) means other and specifically indicates that the\nsub-unit places no restrictions on this parameter.  The value\n(-2) means unknown.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtInterpreterXFeedAddressability = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 15, 1, 1, 9), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtInterpreterXFeedAddressability.setDescription("The maximum interpreter addressability in the cross feed\ndirection in 10000 prtMarkerAddressabilityUnits (as specified\nby prtMarkerDefaultIndex) for this interpreter.  The\nvalue (-1) means other and specifically indicates that the\nsub-unit places no restrictions on this parameter.  The value\n(-2) means unknown.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtInterpreterDefaultCharSetIn = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 15, 1, 1, 10), IANACharset()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtInterpreterDefaultCharSetIn.setDescription("The default coded character set for input octets encountered\noutside a context in which the Page Description Language\nestablished the interpretation of the octets.  (Input octets are\npresented to the interpreter through a path defined in the\nchannel group.)")
prtInterpreterDefaultCharSetOut = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 15, 1, 1, 11), IANACharset()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtInterpreterDefaultCharSetOut.setDescription("The default character set for data coming from this\ninterpreter through the printer's output channel (i.e. the\n'backchannel').")
prtInterpreterTwoWay = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 15, 1, 1, 12), PrtInterpreterTwoWayTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtInterpreterTwoWay.setDescription("Indicates whether or not this interpreter returns information\nback to the host.")
prtConsoleDisplayBuffer = MibIdentifier((1, 3, 6, 1, 2, 1, 43, 16))
prtConsoleDisplayBufferTable = MibTable((1, 3, 6, 1, 2, 1, 43, 16, 5))
if mibBuilder.loadTexts: prtConsoleDisplayBufferTable.setDescription("Physical display buffer for printer console display or\noperator panel\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtConsoleDisplayBufferEntry = MibTableRow((1, 3, 6, 1, 2, 1, 43, 16, 5, 1)).setIndexNames((0, "HOST-RESOURCES-MIB", "hrDeviceIndex"), (0, "Printer-MIB", "prtConsoleDisplayBufferIndex"))
if mibBuilder.loadTexts: prtConsoleDisplayBufferEntry.setDescription("This table contains one entry for each physical line on\nthe display.  Lines cannot be added or deleted.  Entries may\nexist in the table for each device index with a device type of\n'printer'.\n\nNOTE: The above description has been modified from RFC 1759\n\n\n\nfor clarification.")
prtConsoleDisplayBufferIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 16, 5, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: prtConsoleDisplayBufferIndex.setDescription("A unique value for each console line in the printer.  The value\nis used to identify this console line.  Although these values\nmay change due to a major reconfiguration of the device (e.g.,\nthe addition of new console lines to the printer).  Values\nSHOULD remain stable across successive printer power cycles.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtConsoleDisplayBufferText = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 16, 5, 1, 2), PrtConsoleDescriptionStringTC()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtConsoleDisplayBufferText.setDescription("The content of a line in the logical display buffer of\nthe operator's console of the printer.  When a write\noperation occurs, normally a critical message, to one of\nthe LineText strings, the agent should make that line\ndisplayable if a physical display is present.  Writing a zero\nlength string clears the line.  It is an implementation-\nspecific matter as to whether the agent allows a line to be\noverwritten before it has been cleared.  Printer generated\nstrings shall be in the localization specified by\nprtConsoleLocalization.Management Application generated strings\nshould be localized by the Management Application.")
prtConsoleLights = MibIdentifier((1, 3, 6, 1, 2, 1, 43, 17))
prtConsoleLightTable = MibTable((1, 3, 6, 1, 2, 1, 43, 17, 6))
if mibBuilder.loadTexts: prtConsoleLightTable.setDescription("The console light table provides a description and state\ninformation for each light present on the printer console.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtConsoleLightEntry = MibTableRow((1, 3, 6, 1, 2, 1, 43, 17, 6, 1)).setIndexNames((0, "HOST-RESOURCES-MIB", "hrDeviceIndex"), (0, "Printer-MIB", "prtConsoleLightIndex"))
if mibBuilder.loadTexts: prtConsoleLightEntry.setDescription("Entries may exist in the table for each device index with a\ndevice type of 'printer'.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtConsoleLightIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 17, 6, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: prtConsoleLightIndex.setDescription("A unique value used by the printer to identify this light.\nAlthough these values may change due to a major\nreconfiguration of the device (e.g., the addition of new lights\nto the printer).  Values SHOULD remain stable across successive\nprinter power cycles.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtConsoleOnTime = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 17, 6, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtConsoleOnTime.setDescription("This object, in conjunction with prtConsoleOffTime, defines\nthe current status of the light.  If both prtConsoleOnTime and\nprtConsoleOffTime are non-zero, the lamp is blinking and the\nvalues presented define the on time and off time, respectively,\nin milliseconds.  If prtConsoleOnTime is zero and\nprtConsoleOffTime is non-zero, the lamp is off.  If\nprtConsoleOffTime is zero and prtConsoleOnTime is non-zero, the\nlamp is on.  If both values are zero the lamp is off.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtConsoleOffTime = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 17, 6, 1, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: prtConsoleOffTime.setDescription("This object, in conjunction with prtConsoleOnTime, defines the\ncurrent status of the light.  If both prtConsoleOnTime and\nprtConsoleOffTime are non-zero, the lamp is blinking and the\nvalues presented define the on time and off time, respectively,\nin milliseconds.  If prtConsoleOnTime is zero and\nprtConsoleOffTime is non-zero, the lamp is off.  If\nprtConsoleOffTime is zero and prtConsoleOnTime is non-zero, the\nlamp is on.  If both values are zero the lamp is off.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtConsoleColor = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 17, 6, 1, 4), PrtConsoleColorTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtConsoleColor.setDescription("The color of this light.")
prtConsoleDescription = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 17, 6, 1, 5), PrtConsoleDescriptionStringTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtConsoleDescription.setDescription("The vendor description or label of this light in the\nlocalization specified by prtConsoleLocalization.")
prtAlert = MibIdentifier((1, 3, 6, 1, 2, 1, 43, 18))
prtAlertTable = MibTable((1, 3, 6, 1, 2, 1, 43, 18, 1))
if mibBuilder.loadTexts: prtAlertTable.setDescription("The prtAlertTable lists all the critical and non-critical\nalerts currently active in the printer.  A critical alert is\none that stops the printer from printing immediately and\nprinting can not continue until the critical alert condition\nis eliminated.  Non-critical alerts are those items that do\nnot stop printing but may at some future time.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtAlertEntry = MibTableRow((1, 3, 6, 1, 2, 1, 43, 18, 1, 1)).setIndexNames((0, "HOST-RESOURCES-MIB", "hrDeviceIndex"), (0, "Printer-MIB", "prtAlertIndex"))
if mibBuilder.loadTexts: prtAlertEntry.setDescription("Entries may exist in the table for each device\nindex with a device type of 'printer'.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtAlertIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 18, 1, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtAlertIndex.setDescription("The index value used to determine which alerts have been added\nor removed from the alert table.  This is an incrementing\ninteger initialized to 1 when the printer is reset.  (i.e., The\nfirst event placed in the alert table after a reset of the\nprinter shall have an index value of 1.)  When the printer adds\nan alert to the table, that alert is assigned the next higher\ninteger value from the last item entered into the table.  If\nthe index value reaches its maximum value, the next index value\nused must be 1.\n\nNOTE: The management application will read the alert table when\na trap or event notification occurs or at a periodic rate and\nthen parse the table to determine if any new entries were added\nby comparing the last known index value with the current\nhighest index value.  The management application will then\nupdate its copy of the alert table.  When the printer discovers\nthat an alert is no longer active, the printer shall remove the\n\n\n\nrow for that alert from the table and shall reduce the number\nof rows in the table.  The printer may add or delete any number\nof rows from the table at any time.  The management station can\ndetect when binary change alerts have been deleted by\nrequesting an attribute of each alert, and noting alerts as\ndeleted when that retrieval is not possible.  The objects\n'prtAlertCriticalEvents'and 'prtAlertAllEvents' in the\n'prtGeneralTable' reduce the need for management applications\nto scan the 'prtAlertTable'.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtAlertSeverityLevel = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 18, 1, 1, 2), PrtAlertSeverityLevelTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtAlertSeverityLevel.setDescription("The level of severity of this alert table entry.  The printer\ndetermines the severity level assigned to each entry into the\ntable.")
prtAlertTrainingLevel = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 18, 1, 1, 3), PrtAlertTrainingLevelTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtAlertTrainingLevel.setDescription("See TEXTUAL-CONVENTION PrtAlertTrainingLevelTC.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtAlertGroup = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 18, 1, 1, 4), PrtAlertGroupTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtAlertGroup.setDescription("The type of sub-unit within the printer model that this alert\nis related.  Input, output, and markers are examples of printer\n\n\n\nmodel groups, i.e., examples of types of sub-units.  Wherever\npossible, these enumerations match the sub-identifier that\nidentifies the relevant table in the printmib.")
prtAlertGroupIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 18, 1, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtAlertGroupIndex.setDescription("The low-order index of the row within the table identified\nby prtAlertGroup that represents the sub-unit of the printer\nthat caused this alert, or -1 if not applicable.  The\ncombination of the prtAlertGroup and the prtAlertGroupIndex\ndefines exactly which printer sub-unit caused the alert; for\nexample, Input #3, Output#2, and Marker #1.  Every object in\nthis MIB is indexed with hrDeviceIndex and optionally, another\nindex variable.  If this other index variable is present in the\ntable that generated the alert, it will be used as the value\nfor this object.  Otherwise, this value shall be -1.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtAlertLocation = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 18, 1, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-2, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtAlertLocation.setDescription("The sub-unit location that is defined by the printer\nmanufacturer to further refine the location of this alert\nwithin the designated sub-unit.  The location is used in\nconjunction with the Group and GroupIndex values; for example,\nthere is an alert in Input #2 at location number 7.  The value\n(-2) indicates unknown.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtAlertCode = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 18, 1, 1, 7), PrtAlertCodeTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtAlertCode.setDescription("See associated TEXTUAL-CONVENTION PrtAlertCodeTC.\n\nNOTE: The above description has been modified from RFC 1759\nfor clarification.")
prtAlertDescription = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 18, 1, 1, 8), PrtLocalizedDescriptionStringTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtAlertDescription.setDescription("A description of this alert entry in the localization\nspecified by prtGeneralCurrentLocalization.  The description is\nprovided by the printer to further elaborate on the enumerated\nalert or provide information in the case where the code is\nclassified as 'other' or 'unknown'.  The printer is required to\nreturn a description string but the string may be a null\nstring.")
prtAlertTime = MibTableColumn((1, 3, 6, 1, 2, 1, 43, 18, 1, 1, 9), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: prtAlertTime.setDescription("The value of sysUpTime at the time that this alert was\ngenerated.")
printerV1Alert = ObjectIdentity((1, 3, 6, 1, 2, 1, 43, 18, 2))
if mibBuilder.loadTexts: printerV1Alert.setDescription("The value of the enterprise-specific OID in an SNMPv1 trap\nsent signaling a critical event in the prtAlertTable.")
printerV2AlertPrefix = MibIdentifier((1, 3, 6, 1, 2, 1, 43, 18, 2, 0))

# Augmentions

# Notifications

printerV2Alert = NotificationType((1, 3, 6, 1, 2, 1, 43, 18, 2, 0, 1)).setObjects(*(("Printer-MIB", "prtAlertGroupIndex"), ("Printer-MIB", "prtAlertGroup"), ("Printer-MIB", "prtAlertLocation"), ("Printer-MIB", "prtAlertCode"), ("Printer-MIB", "prtAlertSeverityLevel"), ("Printer-MIB", "prtAlertIndex"), ) )
if mibBuilder.loadTexts: printerV2Alert.setDescription("This trap is sent whenever a critical event is added to the\n\n\n\nprtAlertTable.\n\nNOTE: The prtAlertIndex object was redundantly included in the\nbindings of the 'printerV2Alert' notification in RFC 1759, even\nthough the value exists in the instance qualifier of all the\nother bindings.  This object has been retained to provide\ncompatiblity with existing RFC 1759 implementaions.")

# Groups

prtGeneralGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 43, 2, 2, 1)).setObjects(*(("Printer-MIB", "prtCoverDescription"), ("Printer-MIB", "prtLocalizationLanguage"), ("Printer-MIB", "prtGeneralConfigChanges"), ("Printer-MIB", "prtGeneralCurrentLocalization"), ("Printer-MIB", "prtDeviceRefIndex"), ("Printer-MIB", "prtGeneralReset"), ("Printer-MIB", "prtStorageRefIndex"), ("Printer-MIB", "prtCoverStatus"), ("Printer-MIB", "prtLocalizationCharacterSet"), ("Printer-MIB", "prtLocalizationCountry"), ) )
if mibBuilder.loadTexts: prtGeneralGroup.setDescription("The general printer group.")
prtResponsiblePartyGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 43, 2, 2, 2)).setObjects(*(("Printer-MIB", "prtGeneralCurrentOperator"), ("Printer-MIB", "prtGeneralServicePerson"), ) )
if mibBuilder.loadTexts: prtResponsiblePartyGroup.setDescription("The responsible party group contains contact information for\nhumans responsible for the printer.")
prtInputGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 43, 2, 2, 3)).setObjects(*(("Printer-MIB", "prtInputMediaDimFeedDirDeclared"), ("Printer-MIB", "prtInputMediaDimXFeedDirChosen"), ("Printer-MIB", "prtInputMediaName"), ("Printer-MIB", "prtInputDefaultIndex"), ("Printer-MIB", "prtInputType"), ("Printer-MIB", "prtInputMaxCapacity"), ("Printer-MIB", "prtInputCurrentLevel"), ("Printer-MIB", "prtInputMediaDimXFeedDirDeclared"), ("Printer-MIB", "prtInputStatus"), ("Printer-MIB", "prtInputCapacityUnit"), ("Printer-MIB", "prtInputDimUnit"), ("Printer-MIB", "prtInputMediaDimFeedDirChosen"), ) )
if mibBuilder.loadTexts: prtInputGroup.setDescription("The input group.")
prtExtendedInputGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 43, 2, 2, 4)).setObjects(*(("Printer-MIB", "prtInputModel"), ("Printer-MIB", "prtInputDescription"), ("Printer-MIB", "prtInputName"), ("Printer-MIB", "prtInputSerialNumber"), ("Printer-MIB", "prtInputVendorName"), ("Printer-MIB", "prtInputSecurity"), ("Printer-MIB", "prtInputVersion"), ) )
if mibBuilder.loadTexts: prtExtendedInputGroup.setDescription("The extended input group.")
prtInputMediaGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 43, 2, 2, 5)).setObjects(*(("Printer-MIB", "prtInputMediaFormParts"), ("Printer-MIB", "prtInputMediaWeight"), ("Printer-MIB", "prtInputMediaColor"), ("Printer-MIB", "prtInputMediaType"), ) )
if mibBuilder.loadTexts: prtInputMediaGroup.setDescription("The input media group.")
prtOutputGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 43, 2, 2, 6)).setObjects(*(("Printer-MIB", "prtOutputMaxCapacity"), ("Printer-MIB", "prtOutputStatus"), ("Printer-MIB", "prtOutputCapacityUnit"), ("Printer-MIB", "prtOutputType"), ("Printer-MIB", "prtOutputDefaultIndex"), ("Printer-MIB", "prtOutputRemainingCapacity"), ) )
if mibBuilder.loadTexts: prtOutputGroup.setDescription("The output group.")
prtExtendedOutputGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 43, 2, 2, 7)).setObjects(*(("Printer-MIB", "prtOutputSecurity"), ("Printer-MIB", "prtOutputSerialNumber"), ("Printer-MIB", "prtOutputDescription"), ("Printer-MIB", "prtOutputName"), ("Printer-MIB", "prtOutputModel"), ("Printer-MIB", "prtOutputVersion"), ("Printer-MIB", "prtOutputVendorName"), ) )
if mibBuilder.loadTexts: prtExtendedOutputGroup.setDescription("The extended output group.")
prtOutputDimensionsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 43, 2, 2, 8)).setObjects(*(("Printer-MIB", "prtOutputMaxDimFeedDir"), ("Printer-MIB", "prtOutputMinDimXFeedDir"), ("Printer-MIB", "prtOutputMinDimFeedDir"), ("Printer-MIB", "prtOutputMaxDimXFeedDir"), ("Printer-MIB", "prtOutputDimUnit"), ) )
if mibBuilder.loadTexts: prtOutputDimensionsGroup.setDescription("The output dimensions group")
prtOutputFeaturesGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 43, 2, 2, 9)).setObjects(*(("Printer-MIB", "prtOutputOffsetStacking"), ("Printer-MIB", "prtOutputPageDeliveryOrientation"), ("Printer-MIB", "prtOutputDecollating"), ("Printer-MIB", "prtOutputPageCollated"), ("Printer-MIB", "prtOutputStackingOrder"), ("Printer-MIB", "prtOutputBursting"), ) )
if mibBuilder.loadTexts: prtOutputFeaturesGroup.setDescription("The output features group.")
prtMarkerGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 43, 2, 2, 10)).setObjects(*(("Printer-MIB", "prtMarkerMarkTech"), ("Printer-MIB", "prtMarkerPowerOnCount"), ("Printer-MIB", "prtMarkerStatus"), ("Printer-MIB", "prtMarkerLifeCount"), ("Printer-MIB", "prtMarkerNorthMargin"), ("Printer-MIB", "prtMarkerAddressabilityXFeedDir"), ("Printer-MIB", "prtMarkerAddressabilityFeedDir"), ("Printer-MIB", "prtMarkerSouthMargin"), ("Printer-MIB", "prtMarkerDefaultIndex"), ("Printer-MIB", "prtMarkerSpotColorants"), ("Printer-MIB", "prtMarkerCounterUnit"), ("Printer-MIB", "prtMarkerProcessColorants"), ("Printer-MIB", "prtMarkerEastMargin"), ("Printer-MIB", "prtMarkerWestMargin"), ("Printer-MIB", "prtMarkerAddressabilityUnit"), ) )
if mibBuilder.loadTexts: prtMarkerGroup.setDescription("The marker group.")
prtMarkerSuppliesGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 43, 2, 2, 11)).setObjects(*(("Printer-MIB", "prtMarkerSuppliesType"), ("Printer-MIB", "prtMarkerSuppliesMaxCapacity"), ("Printer-MIB", "prtMarkerSuppliesMarkerIndex"), ("Printer-MIB", "prtMarkerSuppliesColorantIndex"), ("Printer-MIB", "prtMarkerSuppliesLevel"), ("Printer-MIB", "prtMarkerSuppliesDescription"), ("Printer-MIB", "prtMarkerSuppliesSupplyUnit"), ("Printer-MIB", "prtMarkerSuppliesClass"), ) )
if mibBuilder.loadTexts: prtMarkerSuppliesGroup.setDescription("The marker supplies group.")
prtMarkerColorantGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 43, 2, 2, 12)).setObjects(*(("Printer-MIB", "prtMarkerColorantRole"), ("Printer-MIB", "prtMarkerColorantMarkerIndex"), ("Printer-MIB", "prtMarkerColorantTonality"), ("Printer-MIB", "prtMarkerColorantValue"), ) )
if mibBuilder.loadTexts: prtMarkerColorantGroup.setDescription("The marker colorant group.")
prtMediaPathGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 43, 2, 2, 13)).setObjects(*(("Printer-MIB", "prtMediaPathMinMediaXFeedDir"), ("Printer-MIB", "prtMediaPathMaxMediaFeedDir"), ("Printer-MIB", "prtMediaPathDefaultIndex"), ("Printer-MIB", "prtMediaPathType"), ("Printer-MIB", "prtMediaPathDescription"), ("Printer-MIB", "prtMediaPathMaxMediaXFeedDir"), ("Printer-MIB", "prtMediaPathMaxSpeedPrintUnit"), ("Printer-MIB", "prtMediaPathMinMediaFeedDir"), ("Printer-MIB", "prtMediaPathMediaSizeUnit"), ("Printer-MIB", "prtMediaPathStatus"), ("Printer-MIB", "prtMediaPathMaxSpeed"), ) )
if mibBuilder.loadTexts: prtMediaPathGroup.setDescription("The media path group.")
prtChannelGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 43, 2, 2, 14)).setObjects(*(("Printer-MIB", "prtChannelCurrentJobCntlLangIndex"), ("Printer-MIB", "prtChannelProtocolVersion"), ("Printer-MIB", "prtChannelIfIndex"), ("Printer-MIB", "prtChannelStatus"), ("Printer-MIB", "prtChannelState"), ("Printer-MIB", "prtChannelType"), ("Printer-MIB", "prtChannelDefaultPageDescLangIndex"), ) )
if mibBuilder.loadTexts: prtChannelGroup.setDescription("The channel group.")
prtInterpreterGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 43, 2, 2, 15)).setObjects(*(("Printer-MIB", "prtInterpreterTwoWay"), ("Printer-MIB", "prtInterpreterLangLevel"), ("Printer-MIB", "prtInterpreterDescription"), ("Printer-MIB", "prtInterpreterDefaultCharSetIn"), ("Printer-MIB", "prtInterpreterVersion"), ("Printer-MIB", "prtInterpreterDefaultOrientation"), ("Printer-MIB", "prtInterpreterDefaultCharSetOut"), ("Printer-MIB", "prtInterpreterLangVersion"), ("Printer-MIB", "prtInterpreterLangFamily"), ("Printer-MIB", "prtInterpreterFeedAddressability"), ("Printer-MIB", "prtInterpreterXFeedAddressability"), ) )
if mibBuilder.loadTexts: prtInterpreterGroup.setDescription("The interpreter group.")
prtConsoleGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 43, 2, 2, 16)).setObjects(*(("Printer-MIB", "prtConsoleNumberOfDisplayChars"), ("Printer-MIB", "prtConsoleLocalization"), ("Printer-MIB", "prtConsoleColor"), ("Printer-MIB", "prtConsoleOnTime"), ("Printer-MIB", "prtConsoleNumberOfDisplayLines"), ("Printer-MIB", "prtConsoleDisplayBufferText"), ("Printer-MIB", "prtConsoleDisable"), ("Printer-MIB", "prtConsoleDescription"), ("Printer-MIB", "prtConsoleOffTime"), ) )
if mibBuilder.loadTexts: prtConsoleGroup.setDescription("The console group.")
prtAlertTableGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 43, 2, 2, 17)).setObjects(*(("Printer-MIB", "prtAlertTrainingLevel"), ("Printer-MIB", "prtAlertDescription"), ("Printer-MIB", "prtAlertGroupIndex"), ("Printer-MIB", "prtAlertGroup"), ("Printer-MIB", "prtAlertLocation"), ("Printer-MIB", "prtAlertCode"), ("Printer-MIB", "prtAlertSeverityLevel"), ) )
if mibBuilder.loadTexts: prtAlertTableGroup.setDescription("The alert table group.")
prtAlertTimeGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 43, 2, 2, 18)).setObjects(*(("Printer-MIB", "prtAlertTime"), ) )
if mibBuilder.loadTexts: prtAlertTimeGroup.setDescription("The alert time group. Implementation of prtAlertTime is\nstrongly RECOMMENDED.")
prtAuxiliarySheetGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 43, 2, 2, 19)).setObjects(*(("Printer-MIB", "prtAuxiliarySheetBannerPage"), ("Printer-MIB", "prtAuxiliarySheetStartupPage"), ) )
if mibBuilder.loadTexts: prtAuxiliarySheetGroup.setDescription("The auxiliary sheet group.")
prtInputSwitchingGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 43, 2, 2, 20)).setObjects(*(("Printer-MIB", "prtInputNextIndex"), ("Printer-MIB", "prtInputMediaLoadTimeout"), ) )
if mibBuilder.loadTexts: prtInputSwitchingGroup.setDescription("The input switching group.")
prtGeneralV2Group = ObjectGroup((1, 3, 6, 1, 2, 1, 43, 2, 2, 21)).setObjects(*(("Printer-MIB", "prtGeneralSerialNumber"), ("Printer-MIB", "prtGeneralPrinterName"), ) )
if mibBuilder.loadTexts: prtGeneralV2Group.setDescription("The general printer group with new v2 objects.")
prtAlertTableV2Group = ObjectGroup((1, 3, 6, 1, 2, 1, 43, 2, 2, 22)).setObjects(*(("Printer-MIB", "prtAlertCriticalEvents"), ("Printer-MIB", "prtAlertIndex"), ("Printer-MIB", "prtAlertAllEvents"), ) )
if mibBuilder.loadTexts: prtAlertTableV2Group.setDescription("The alert table group with new v2 objects and prtAlertIndex\nchanged to MAX-ACCESS of 'read-only' for inclusion in the trap\nbindings (as originally defined in RFC 1759).")
prtChannelV2Group = ObjectGroup((1, 3, 6, 1, 2, 1, 43, 2, 2, 23)).setObjects(*(("Printer-MIB", "prtChannelInformation"), ) )
if mibBuilder.loadTexts: prtChannelV2Group.setDescription("The channel group with a new v2 object.")
prtAlertTrapGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 43, 2, 2, 24)).setObjects(*(("Printer-MIB", "printerV2Alert"), ) )
if mibBuilder.loadTexts: prtAlertTrapGroup.setDescription("The alert trap group.")

# Compliances

prtMIBCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 43, 2, 1)).setObjects(*(("Printer-MIB", "prtInputGroup"), ("Printer-MIB", "prtAlertTableGroup"), ("Printer-MIB", "prtGeneralGroup"), ("Printer-MIB", "prtChannelGroup"), ("Printer-MIB", "prtMarkerGroup"), ("Printer-MIB", "prtOutputGroup"), ("Printer-MIB", "prtMediaPathGroup"), ("Printer-MIB", "prtInterpreterGroup"), ("Printer-MIB", "prtConsoleGroup"), ) )
if mibBuilder.loadTexts: prtMIBCompliance.setDescription("The compliance statement for agents that implement the\nprinter MIB as defined by RFC 1759.")
prtMIB2Compliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 43, 2, 3)).setObjects(*(("Printer-MIB", "prtMarkerGroup"), ("Printer-MIB", "prtGeneralGroup"), ("Printer-MIB", "prtOutputGroup"), ("Printer-MIB", "prtInputMediaGroup"), ("Printer-MIB", "prtChannelV2Group"), ("Printer-MIB", "prtAlertTimeGroup"), ("Printer-MIB", "prtChannelGroup"), ("Printer-MIB", "prtAlertTableGroup"), ("Printer-MIB", "prtMediaPathGroup"), ("Printer-MIB", "prtConsoleGroup"), ("Printer-MIB", "prtInterpreterGroup"), ("Printer-MIB", "prtOutputFeaturesGroup"), ("Printer-MIB", "prtInputSwitchingGroup"), ("Printer-MIB", "prtInputGroup"), ("Printer-MIB", "prtResponsiblePartyGroup"), ("Printer-MIB", "prtExtendedInputGroup"), ("Printer-MIB", "prtAuxiliarySheetGroup"), ("Printer-MIB", "prtMarkerColorantGroup"), ("Printer-MIB", "prtAlertTableV2Group"), ("Printer-MIB", "prtOutputDimensionsGroup"), ("Printer-MIB", "prtAlertTrapGroup"), ("Printer-MIB", "prtExtendedOutputGroup"), ("Printer-MIB", "prtGeneralV2Group"), ("Printer-MIB", "prtMarkerSuppliesGroup"), ) )
if mibBuilder.loadTexts: prtMIB2Compliance.setDescription("The compliance statement for agents that implement the\nprinter MIB V2.")

# Exports

# Module identity
mibBuilder.exportSymbols("Printer-MIB", PYSNMP_MODULE_ID=printmib)

# Types
mibBuilder.exportSymbols("Printer-MIB", CapacityUnit=CapacityUnit, CodedCharSet=CodedCharSet, MediaUnit=MediaUnit, PresentOnOff=PresentOnOff, PrtAlertSeverityLevelTC=PrtAlertSeverityLevelTC, PrtCapacityUnitTC=PrtCapacityUnitTC, PrtChannelStateTC=PrtChannelStateTC, PrtConsoleDescriptionStringTC=PrtConsoleDescriptionStringTC, PrtInterpreterTwoWayTC=PrtInterpreterTwoWayTC, PrtLocalizedDescriptionStringTC=PrtLocalizedDescriptionStringTC, PrtMarkerAddressabilityUnitTC=PrtMarkerAddressabilityUnitTC, PrtMarkerColorantRoleTC=PrtMarkerColorantRoleTC, PrtMarkerCounterUnitTC=PrtMarkerCounterUnitTC, PrtMarkerSuppliesClassTC=PrtMarkerSuppliesClassTC, PrtMarkerSuppliesSupplyUnitTC=PrtMarkerSuppliesSupplyUnitTC, PrtMediaPathMaxSpeedPrintUnitTC=PrtMediaPathMaxSpeedPrintUnitTC, PrtMediaUnitTC=PrtMediaUnitTC, PrtOutputPageDeliveryOrientationTC=PrtOutputPageDeliveryOrientationTC, PrtOutputStackingOrderTC=PrtOutputStackingOrderTC, PrtPrintOrientationTC=PrtPrintOrientationTC, PrtSubUnitStatusTC=PrtSubUnitStatusTC, SubUnitStatus=SubUnitStatus)

# Objects
mibBuilder.exportSymbols("Printer-MIB", printmib=printmib, prtMIBConformance=prtMIBConformance, prtMIBGroups=prtMIBGroups, prtMIB2Groups=prtMIB2Groups, prtGeneral=prtGeneral, prtGeneralTable=prtGeneralTable, prtGeneralEntry=prtGeneralEntry, prtGeneralConfigChanges=prtGeneralConfigChanges, prtGeneralCurrentLocalization=prtGeneralCurrentLocalization, prtGeneralReset=prtGeneralReset, prtGeneralCurrentOperator=prtGeneralCurrentOperator, prtGeneralServicePerson=prtGeneralServicePerson, prtInputDefaultIndex=prtInputDefaultIndex, prtOutputDefaultIndex=prtOutputDefaultIndex, prtMarkerDefaultIndex=prtMarkerDefaultIndex, prtMediaPathDefaultIndex=prtMediaPathDefaultIndex, prtConsoleLocalization=prtConsoleLocalization, prtConsoleNumberOfDisplayLines=prtConsoleNumberOfDisplayLines, prtConsoleNumberOfDisplayChars=prtConsoleNumberOfDisplayChars, prtConsoleDisable=prtConsoleDisable, prtAuxiliarySheetStartupPage=prtAuxiliarySheetStartupPage, prtAuxiliarySheetBannerPage=prtAuxiliarySheetBannerPage, prtGeneralPrinterName=prtGeneralPrinterName, prtGeneralSerialNumber=prtGeneralSerialNumber, prtAlertCriticalEvents=prtAlertCriticalEvents, prtAlertAllEvents=prtAlertAllEvents, prtStorageRefTable=prtStorageRefTable, prtStorageRefEntry=prtStorageRefEntry, prtStorageRefSeqNumber=prtStorageRefSeqNumber, prtStorageRefIndex=prtStorageRefIndex, prtDeviceRefTable=prtDeviceRefTable, prtDeviceRefEntry=prtDeviceRefEntry, prtDeviceRefSeqNumber=prtDeviceRefSeqNumber, prtDeviceRefIndex=prtDeviceRefIndex, prtCover=prtCover, prtCoverTable=prtCoverTable, prtCoverEntry=prtCoverEntry, prtCoverIndex=prtCoverIndex, prtCoverDescription=prtCoverDescription, prtCoverStatus=prtCoverStatus, prtLocalization=prtLocalization, prtLocalizationTable=prtLocalizationTable, prtLocalizationEntry=prtLocalizationEntry, prtLocalizationIndex=prtLocalizationIndex, prtLocalizationLanguage=prtLocalizationLanguage, prtLocalizationCountry=prtLocalizationCountry, prtLocalizationCharacterSet=prtLocalizationCharacterSet, prtInput=prtInput, prtInputTable=prtInputTable, prtInputEntry=prtInputEntry, prtInputIndex=prtInputIndex, prtInputType=prtInputType, prtInputDimUnit=prtInputDimUnit, prtInputMediaDimFeedDirDeclared=prtInputMediaDimFeedDirDeclared, prtInputMediaDimXFeedDirDeclared=prtInputMediaDimXFeedDirDeclared, prtInputMediaDimFeedDirChosen=prtInputMediaDimFeedDirChosen, prtInputMediaDimXFeedDirChosen=prtInputMediaDimXFeedDirChosen, prtInputCapacityUnit=prtInputCapacityUnit, prtInputMaxCapacity=prtInputMaxCapacity, prtInputCurrentLevel=prtInputCurrentLevel, prtInputStatus=prtInputStatus, prtInputMediaName=prtInputMediaName, prtInputName=prtInputName, prtInputVendorName=prtInputVendorName, prtInputModel=prtInputModel, prtInputVersion=prtInputVersion, prtInputSerialNumber=prtInputSerialNumber, prtInputDescription=prtInputDescription, prtInputSecurity=prtInputSecurity, prtInputMediaWeight=prtInputMediaWeight, prtInputMediaType=prtInputMediaType, prtInputMediaColor=prtInputMediaColor, prtInputMediaFormParts=prtInputMediaFormParts, prtInputMediaLoadTimeout=prtInputMediaLoadTimeout, prtInputNextIndex=prtInputNextIndex, prtOutput=prtOutput, prtOutputTable=prtOutputTable, prtOutputEntry=prtOutputEntry, prtOutputIndex=prtOutputIndex, prtOutputType=prtOutputType, prtOutputCapacityUnit=prtOutputCapacityUnit, prtOutputMaxCapacity=prtOutputMaxCapacity, prtOutputRemainingCapacity=prtOutputRemainingCapacity, prtOutputStatus=prtOutputStatus, prtOutputName=prtOutputName, prtOutputVendorName=prtOutputVendorName, prtOutputModel=prtOutputModel, prtOutputVersion=prtOutputVersion, prtOutputSerialNumber=prtOutputSerialNumber, prtOutputDescription=prtOutputDescription, prtOutputSecurity=prtOutputSecurity, prtOutputDimUnit=prtOutputDimUnit, prtOutputMaxDimFeedDir=prtOutputMaxDimFeedDir, prtOutputMaxDimXFeedDir=prtOutputMaxDimXFeedDir, prtOutputMinDimFeedDir=prtOutputMinDimFeedDir, prtOutputMinDimXFeedDir=prtOutputMinDimXFeedDir, prtOutputStackingOrder=prtOutputStackingOrder, prtOutputPageDeliveryOrientation=prtOutputPageDeliveryOrientation, prtOutputBursting=prtOutputBursting, prtOutputDecollating=prtOutputDecollating, prtOutputPageCollated=prtOutputPageCollated, prtOutputOffsetStacking=prtOutputOffsetStacking, prtMarker=prtMarker, prtMarkerTable=prtMarkerTable, prtMarkerEntry=prtMarkerEntry, prtMarkerIndex=prtMarkerIndex, prtMarkerMarkTech=prtMarkerMarkTech, prtMarkerCounterUnit=prtMarkerCounterUnit, prtMarkerLifeCount=prtMarkerLifeCount, prtMarkerPowerOnCount=prtMarkerPowerOnCount, prtMarkerProcessColorants=prtMarkerProcessColorants, prtMarkerSpotColorants=prtMarkerSpotColorants, prtMarkerAddressabilityUnit=prtMarkerAddressabilityUnit, prtMarkerAddressabilityFeedDir=prtMarkerAddressabilityFeedDir, prtMarkerAddressabilityXFeedDir=prtMarkerAddressabilityXFeedDir, prtMarkerNorthMargin=prtMarkerNorthMargin, prtMarkerSouthMargin=prtMarkerSouthMargin, prtMarkerWestMargin=prtMarkerWestMargin, prtMarkerEastMargin=prtMarkerEastMargin, prtMarkerStatus=prtMarkerStatus, prtMarkerSupplies=prtMarkerSupplies, prtMarkerSuppliesTable=prtMarkerSuppliesTable, prtMarkerSuppliesEntry=prtMarkerSuppliesEntry, prtMarkerSuppliesIndex=prtMarkerSuppliesIndex, prtMarkerSuppliesMarkerIndex=prtMarkerSuppliesMarkerIndex, prtMarkerSuppliesColorantIndex=prtMarkerSuppliesColorantIndex)
mibBuilder.exportSymbols("Printer-MIB", prtMarkerSuppliesClass=prtMarkerSuppliesClass, prtMarkerSuppliesType=prtMarkerSuppliesType, prtMarkerSuppliesDescription=prtMarkerSuppliesDescription, prtMarkerSuppliesSupplyUnit=prtMarkerSuppliesSupplyUnit, prtMarkerSuppliesMaxCapacity=prtMarkerSuppliesMaxCapacity, prtMarkerSuppliesLevel=prtMarkerSuppliesLevel, prtMarkerColorant=prtMarkerColorant, prtMarkerColorantTable=prtMarkerColorantTable, prtMarkerColorantEntry=prtMarkerColorantEntry, prtMarkerColorantIndex=prtMarkerColorantIndex, prtMarkerColorantMarkerIndex=prtMarkerColorantMarkerIndex, prtMarkerColorantRole=prtMarkerColorantRole, prtMarkerColorantValue=prtMarkerColorantValue, prtMarkerColorantTonality=prtMarkerColorantTonality, prtMediaPath=prtMediaPath, prtMediaPathTable=prtMediaPathTable, prtMediaPathEntry=prtMediaPathEntry, prtMediaPathIndex=prtMediaPathIndex, prtMediaPathMaxSpeedPrintUnit=prtMediaPathMaxSpeedPrintUnit, prtMediaPathMediaSizeUnit=prtMediaPathMediaSizeUnit, prtMediaPathMaxSpeed=prtMediaPathMaxSpeed, prtMediaPathMaxMediaFeedDir=prtMediaPathMaxMediaFeedDir, prtMediaPathMaxMediaXFeedDir=prtMediaPathMaxMediaXFeedDir, prtMediaPathMinMediaFeedDir=prtMediaPathMinMediaFeedDir, prtMediaPathMinMediaXFeedDir=prtMediaPathMinMediaXFeedDir, prtMediaPathType=prtMediaPathType, prtMediaPathDescription=prtMediaPathDescription, prtMediaPathStatus=prtMediaPathStatus, prtChannel=prtChannel, prtChannelTable=prtChannelTable, prtChannelEntry=prtChannelEntry, prtChannelIndex=prtChannelIndex, prtChannelType=prtChannelType, prtChannelProtocolVersion=prtChannelProtocolVersion, prtChannelCurrentJobCntlLangIndex=prtChannelCurrentJobCntlLangIndex, prtChannelDefaultPageDescLangIndex=prtChannelDefaultPageDescLangIndex, prtChannelState=prtChannelState, prtChannelIfIndex=prtChannelIfIndex, prtChannelStatus=prtChannelStatus, prtChannelInformation=prtChannelInformation, prtInterpreter=prtInterpreter, prtInterpreterTable=prtInterpreterTable, prtInterpreterEntry=prtInterpreterEntry, prtInterpreterIndex=prtInterpreterIndex, prtInterpreterLangFamily=prtInterpreterLangFamily, prtInterpreterLangLevel=prtInterpreterLangLevel, prtInterpreterLangVersion=prtInterpreterLangVersion, prtInterpreterDescription=prtInterpreterDescription, prtInterpreterVersion=prtInterpreterVersion, prtInterpreterDefaultOrientation=prtInterpreterDefaultOrientation, prtInterpreterFeedAddressability=prtInterpreterFeedAddressability, prtInterpreterXFeedAddressability=prtInterpreterXFeedAddressability, prtInterpreterDefaultCharSetIn=prtInterpreterDefaultCharSetIn, prtInterpreterDefaultCharSetOut=prtInterpreterDefaultCharSetOut, prtInterpreterTwoWay=prtInterpreterTwoWay, prtConsoleDisplayBuffer=prtConsoleDisplayBuffer, prtConsoleDisplayBufferTable=prtConsoleDisplayBufferTable, prtConsoleDisplayBufferEntry=prtConsoleDisplayBufferEntry, prtConsoleDisplayBufferIndex=prtConsoleDisplayBufferIndex, prtConsoleDisplayBufferText=prtConsoleDisplayBufferText, prtConsoleLights=prtConsoleLights, prtConsoleLightTable=prtConsoleLightTable, prtConsoleLightEntry=prtConsoleLightEntry, prtConsoleLightIndex=prtConsoleLightIndex, prtConsoleOnTime=prtConsoleOnTime, prtConsoleOffTime=prtConsoleOffTime, prtConsoleColor=prtConsoleColor, prtConsoleDescription=prtConsoleDescription, prtAlert=prtAlert, prtAlertTable=prtAlertTable, prtAlertEntry=prtAlertEntry, prtAlertIndex=prtAlertIndex, prtAlertSeverityLevel=prtAlertSeverityLevel, prtAlertTrainingLevel=prtAlertTrainingLevel, prtAlertGroup=prtAlertGroup, prtAlertGroupIndex=prtAlertGroupIndex, prtAlertLocation=prtAlertLocation, prtAlertCode=prtAlertCode, prtAlertDescription=prtAlertDescription, prtAlertTime=prtAlertTime, printerV1Alert=printerV1Alert, printerV2AlertPrefix=printerV2AlertPrefix)

# Notifications
mibBuilder.exportSymbols("Printer-MIB", printerV2Alert=printerV2Alert)

# Groups
mibBuilder.exportSymbols("Printer-MIB", prtGeneralGroup=prtGeneralGroup, prtResponsiblePartyGroup=prtResponsiblePartyGroup, prtInputGroup=prtInputGroup, prtExtendedInputGroup=prtExtendedInputGroup, prtInputMediaGroup=prtInputMediaGroup, prtOutputGroup=prtOutputGroup, prtExtendedOutputGroup=prtExtendedOutputGroup, prtOutputDimensionsGroup=prtOutputDimensionsGroup, prtOutputFeaturesGroup=prtOutputFeaturesGroup, prtMarkerGroup=prtMarkerGroup, prtMarkerSuppliesGroup=prtMarkerSuppliesGroup, prtMarkerColorantGroup=prtMarkerColorantGroup, prtMediaPathGroup=prtMediaPathGroup, prtChannelGroup=prtChannelGroup, prtInterpreterGroup=prtInterpreterGroup, prtConsoleGroup=prtConsoleGroup, prtAlertTableGroup=prtAlertTableGroup, prtAlertTimeGroup=prtAlertTimeGroup, prtAuxiliarySheetGroup=prtAuxiliarySheetGroup, prtInputSwitchingGroup=prtInputSwitchingGroup, prtGeneralV2Group=prtGeneralV2Group, prtAlertTableV2Group=prtAlertTableV2Group, prtChannelV2Group=prtChannelV2Group, prtAlertTrapGroup=prtAlertTrapGroup)

# Compliances
mibBuilder.exportSymbols("Printer-MIB", prtMIBCompliance=prtMIBCompliance, prtMIB2Compliance=prtMIB2Compliance)
