r"""
    This code was generated by
   ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
    |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
    |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \

    Twilio - Api
    This is the public Twilio REST API.

    NOTE: This class is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
    Do not edit the class manually.
"""


from datetime import date, datetime
from typing import Any, Dict, List, Optional, Union
from twilio.base import deserialize, serialize, values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.version import Version


class FeedbackSummaryInstance(InstanceResource):
    class Status(object):
        QUEUED = "queued"
        IN_PROGRESS = "in-progress"
        COMPLETED = "completed"
        FAILED = "failed"

    """
    :ivar account_sid: The unique id of the [Account](https://www.twilio.com/docs/iam/api/account) responsible for this resource.
    :ivar call_count: The total number of calls.
    :ivar call_feedback_count: The total number of calls with a feedback entry.
    :ivar date_created: The date that this resource was created, given in [RFC 2822](https://www.php.net/manual/en/class.datetime.php#datetime.constants.rfc2822) format.
    :ivar date_updated: The date that this resource was last updated, given in [RFC 2822](https://www.php.net/manual/en/class.datetime.php#datetime.constants.rfc2822) format.
    :ivar end_date: The last date for which feedback entries are included in this Feedback Summary, formatted as `YYYY-MM-DD` and specified in UTC.
    :ivar include_subaccounts: Whether the feedback summary includes subaccounts; `true` if it does, otherwise `false`.
    :ivar issues: A list of issues experienced during the call. The issues can be: `imperfect-audio`, `dropped-call`, `incorrect-caller-id`, `post-dial-delay`, `digits-not-captured`, `audio-latency`, or `one-way-audio`.
    :ivar quality_score_average: The average QualityScore of the feedback entries.
    :ivar quality_score_median: The median QualityScore of the feedback entries.
    :ivar quality_score_standard_deviation: The standard deviation of the quality scores.
    :ivar sid: A 34 character string that uniquely identifies this resource.
    :ivar start_date: The first date for which feedback entries are included in this feedback summary, formatted as `YYYY-MM-DD` and specified in UTC.
    :ivar status: 
    """

    def __init__(
        self,
        version: Version,
        payload: Dict[str, Any],
        account_sid: str,
        sid: Optional[str] = None,
    ):
        super().__init__(version)

        self.account_sid: Optional[str] = payload.get("account_sid")
        self.call_count: Optional[int] = deserialize.integer(payload.get("call_count"))
        self.call_feedback_count: Optional[int] = deserialize.integer(
            payload.get("call_feedback_count")
        )
        self.date_created: Optional[datetime] = deserialize.rfc2822_datetime(
            payload.get("date_created")
        )
        self.date_updated: Optional[datetime] = deserialize.rfc2822_datetime(
            payload.get("date_updated")
        )
        self.end_date: Optional[date] = deserialize.iso8601_date(
            payload.get("end_date")
        )
        self.include_subaccounts: Optional[bool] = payload.get("include_subaccounts")
        self.issues: Optional[List[object]] = payload.get("issues")
        self.quality_score_average: Optional[float] = deserialize.decimal(
            payload.get("quality_score_average")
        )
        self.quality_score_median: Optional[float] = deserialize.decimal(
            payload.get("quality_score_median")
        )
        self.quality_score_standard_deviation: Optional[float] = deserialize.decimal(
            payload.get("quality_score_standard_deviation")
        )
        self.sid: Optional[str] = payload.get("sid")
        self.start_date: Optional[date] = deserialize.iso8601_date(
            payload.get("start_date")
        )
        self.status: Optional["FeedbackSummaryInstance.Status"] = payload.get("status")

        self._solution = {
            "account_sid": account_sid,
            "sid": sid or self.sid,
        }
        self._context: Optional[FeedbackSummaryContext] = None

    @property
    def _proxy(self) -> "FeedbackSummaryContext":
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions. All instance actions are proxied to the context

        :returns: FeedbackSummaryContext for this FeedbackSummaryInstance
        """
        if self._context is None:
            self._context = FeedbackSummaryContext(
                self._version,
                account_sid=self._solution["account_sid"],
                sid=self._solution["sid"],
            )
        return self._context

    def delete(self) -> bool:
        """
        Deletes the FeedbackSummaryInstance


        :returns: True if delete succeeds, False otherwise
        """
        return self._proxy.delete()

    async def delete_async(self) -> bool:
        """
        Asynchronous coroutine that deletes the FeedbackSummaryInstance


        :returns: True if delete succeeds, False otherwise
        """
        return await self._proxy.delete_async()

    def fetch(self) -> "FeedbackSummaryInstance":
        """
        Fetch the FeedbackSummaryInstance


        :returns: The fetched FeedbackSummaryInstance
        """
        return self._proxy.fetch()

    async def fetch_async(self) -> "FeedbackSummaryInstance":
        """
        Asynchronous coroutine to fetch the FeedbackSummaryInstance


        :returns: The fetched FeedbackSummaryInstance
        """
        return await self._proxy.fetch_async()

    def __repr__(self) -> str:
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        """
        context = " ".join("{}={}".format(k, v) for k, v in self._solution.items())
        return "<Twilio.Api.V2010.FeedbackSummaryInstance {}>".format(context)


class FeedbackSummaryContext(InstanceContext):
    def __init__(self, version: Version, account_sid: str, sid: str):
        """
        Initialize the FeedbackSummaryContext

        :param version: Version that contains the resource
        :param account_sid: The unique id of the [Account](https://www.twilio.com/docs/iam/api/account) responsible for this resource.
        :param sid: A 34 character string that uniquely identifies this resource.
        """
        super().__init__(version)

        # Path Solution
        self._solution = {
            "account_sid": account_sid,
            "sid": sid,
        }
        self._uri = "/Accounts/{account_sid}/Calls/FeedbackSummary/{sid}.json".format(
            **self._solution
        )

    def delete(self) -> bool:
        """
        Deletes the FeedbackSummaryInstance


        :returns: True if delete succeeds, False otherwise
        """
        return self._version.delete(
            method="DELETE",
            uri=self._uri,
        )

    async def delete_async(self) -> bool:
        """
        Asynchronous coroutine that deletes the FeedbackSummaryInstance


        :returns: True if delete succeeds, False otherwise
        """
        return await self._version.delete_async(
            method="DELETE",
            uri=self._uri,
        )

    def fetch(self) -> FeedbackSummaryInstance:
        """
        Fetch the FeedbackSummaryInstance


        :returns: The fetched FeedbackSummaryInstance
        """

        payload = self._version.fetch(
            method="GET",
            uri=self._uri,
        )

        return FeedbackSummaryInstance(
            self._version,
            payload,
            account_sid=self._solution["account_sid"],
            sid=self._solution["sid"],
        )

    async def fetch_async(self) -> FeedbackSummaryInstance:
        """
        Asynchronous coroutine to fetch the FeedbackSummaryInstance


        :returns: The fetched FeedbackSummaryInstance
        """

        payload = await self._version.fetch_async(
            method="GET",
            uri=self._uri,
        )

        return FeedbackSummaryInstance(
            self._version,
            payload,
            account_sid=self._solution["account_sid"],
            sid=self._solution["sid"],
        )

    def __repr__(self) -> str:
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        """
        context = " ".join("{}={}".format(k, v) for k, v in self._solution.items())
        return "<Twilio.Api.V2010.FeedbackSummaryContext {}>".format(context)


class FeedbackSummaryList(ListResource):
    def __init__(self, version: Version, account_sid: str):
        """
        Initialize the FeedbackSummaryList

        :param version: Version that contains the resource
        :param account_sid: The unique id of the [Account](https://www.twilio.com/docs/iam/api/account) responsible for this resource.

        """
        super().__init__(version)

        # Path Solution
        self._solution = {
            "account_sid": account_sid,
        }
        self._uri = "/Accounts/{account_sid}/Calls/FeedbackSummary.json".format(
            **self._solution
        )

    def create(
        self,
        start_date: date,
        end_date: date,
        include_subaccounts: Union[bool, object] = values.unset,
        status_callback: Union[str, object] = values.unset,
        status_callback_method: Union[str, object] = values.unset,
    ) -> FeedbackSummaryInstance:
        """
        Create the FeedbackSummaryInstance

        :param start_date: Only include feedback given on or after this date. Format is `YYYY-MM-DD` and specified in UTC.
        :param end_date: Only include feedback given on or before this date. Format is `YYYY-MM-DD` and specified in UTC.
        :param include_subaccounts: Whether to also include Feedback resources from all subaccounts. `true` includes feedback from all subaccounts and `false`, the default, includes feedback from only the specified account.
        :param status_callback: The URL that we will request when the feedback summary is complete.
        :param status_callback_method: The HTTP method (`GET` or `POST`) we use to make the request to the `StatusCallback` URL.

        :returns: The created FeedbackSummaryInstance
        """
        data = values.of(
            {
                "StartDate": serialize.iso8601_date(start_date),
                "EndDate": serialize.iso8601_date(end_date),
                "IncludeSubaccounts": include_subaccounts,
                "StatusCallback": status_callback,
                "StatusCallbackMethod": status_callback_method,
            }
        )

        payload = self._version.create(
            method="POST",
            uri=self._uri,
            data=data,
        )

        return FeedbackSummaryInstance(
            self._version, payload, account_sid=self._solution["account_sid"]
        )

    async def create_async(
        self,
        start_date: date,
        end_date: date,
        include_subaccounts: Union[bool, object] = values.unset,
        status_callback: Union[str, object] = values.unset,
        status_callback_method: Union[str, object] = values.unset,
    ) -> FeedbackSummaryInstance:
        """
        Asynchronously create the FeedbackSummaryInstance

        :param start_date: Only include feedback given on or after this date. Format is `YYYY-MM-DD` and specified in UTC.
        :param end_date: Only include feedback given on or before this date. Format is `YYYY-MM-DD` and specified in UTC.
        :param include_subaccounts: Whether to also include Feedback resources from all subaccounts. `true` includes feedback from all subaccounts and `false`, the default, includes feedback from only the specified account.
        :param status_callback: The URL that we will request when the feedback summary is complete.
        :param status_callback_method: The HTTP method (`GET` or `POST`) we use to make the request to the `StatusCallback` URL.

        :returns: The created FeedbackSummaryInstance
        """
        data = values.of(
            {
                "StartDate": serialize.iso8601_date(start_date),
                "EndDate": serialize.iso8601_date(end_date),
                "IncludeSubaccounts": include_subaccounts,
                "StatusCallback": status_callback,
                "StatusCallbackMethod": status_callback_method,
            }
        )

        payload = await self._version.create_async(
            method="POST",
            uri=self._uri,
            data=data,
        )

        return FeedbackSummaryInstance(
            self._version, payload, account_sid=self._solution["account_sid"]
        )

    def get(self, sid: str) -> FeedbackSummaryContext:
        """
        Constructs a FeedbackSummaryContext

        :param sid: A 34 character string that uniquely identifies this resource.
        """
        return FeedbackSummaryContext(
            self._version, account_sid=self._solution["account_sid"], sid=sid
        )

    def __call__(self, sid: str) -> FeedbackSummaryContext:
        """
        Constructs a FeedbackSummaryContext

        :param sid: A 34 character string that uniquely identifies this resource.
        """
        return FeedbackSummaryContext(
            self._version, account_sid=self._solution["account_sid"], sid=sid
        )

    def __repr__(self) -> str:
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        """
        return "<Twilio.Api.V2010.FeedbackSummaryList>"
