#!/usr/bin/env Rscript
options(warn=-1)
library(ggplot2)
args = commandArgs(trailingOnly=TRUE)

mytable<- read.csv(args[1], header = F)
colnames(mytable) <- c("Sample", "Trimmed", "Read", "Value", "Count")
mytable<- mytable[which(mytable$Count>0),]


if(!any(is.na(mytable$Read))){
  gp<- ggplot(mytable, aes(fill=Read,group=interaction(Sample, Trimmed, Read),x=Sample, y=Value, weight=Count))
  gp<- gp+ geom_boxplot(outlier.size = 0.5) +theme(axis.text.x=element_text(angle=90, hjust=1,  vjust = 0.5),legend.position="none") + 
    scale_fill_manual(values=c("#E25845", "#4593C1")) +
    ggtitle(args[3]) + 
    xlab(args[4])+
    ylab(args[5])
}else{
  gp<- ggplot(mytable, aes(fill="R1",group=Sample,x=Sample, y=Value, weight=Count))
  gp<- gp+ geom_boxplot(outlier.size = 0.5) +theme(axis.text.x=element_text(angle=90, hjust=1,  vjust = 0.5),legend.position="none") + 
    scale_fill_manual(values=c("#E25845")) +
    ggtitle(args[3]) + 
    xlab(args[4])+
    ylab(args[5])
}  
 
if(length(unique(mytable$Sample))>15){
  gp<-gp + facet_wrap(~ Trimmed, ncol=1)
  height=20  
}else{
  gp<-gp + facet_wrap(~ Trimmed)
  height=10
}
ggsave(args[2],plot=gp, unit="cm")