% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowLogSumExps.R
\name{rowLogSumExps}
\alias{rowLogSumExps}
\alias{rowLogSumExps,matrix_OR_array_OR_table_OR_numeric-method}
\alias{rowLogSumExps,ANY-method}
\alias{colLogSumExps}
\alias{colLogSumExps,matrix_OR_array_OR_table_OR_numeric-method}
\alias{colLogSumExps,ANY-method}
\title{Accurately calculates the logarithm of the sum of exponentials for each row
(column) of a matrix-like object}
\usage{
rowLogSumExps(lx, rows = NULL, cols = NULL, na.rm = FALSE, ...,
  useNames = TRUE)

\S4method{rowLogSumExps}{matrix_OR_array_OR_table_OR_numeric}(lx,
  rows = NULL, cols = NULL, na.rm = FALSE, dim. = dim(lx), ...,
  useNames = TRUE)

\S4method{rowLogSumExps}{ANY}(lx, rows = NULL, cols = NULL,
  na.rm = FALSE, ..., useNames = TRUE)

colLogSumExps(lx, rows = NULL, cols = NULL, na.rm = FALSE, ...,
  useNames = TRUE)

\S4method{colLogSumExps}{matrix_OR_array_OR_table_OR_numeric}(lx,
  rows = NULL, cols = NULL, na.rm = FALSE, dim. = dim(lx), ...,
  useNames = TRUE)

\S4method{colLogSumExps}{ANY}(lx, rows = NULL, cols = NULL,
  na.rm = FALSE, ..., useNames = TRUE)
}
\arguments{
\item{lx}{An NxK matrix-like object. Typically \code{lx} are \code{log(x)} values.}

\item{rows, cols}{A \code{\link{vector}} indicating the subset (and/or
columns) to operate over. If \code{\link{NULL}}, no subsetting is done.}

\item{na.rm}{If \code{\link[base]{TRUE}}, missing values
(\code{\link[base]{NA}} or \code{\link[base]{NaN}}) are
omitted from the calculations.}

\item{...}{Additional arguments passed to specific methods.}

\item{useNames}{If \code{\link{TRUE}} (default), names attributes of result are set. Else if \code{\link{FALSE}}, no naming support is done.}

\item{dim.}{An \code{\link{integer}} \code{\link{vector}} of length two
specifying the dimension of \code{x}, essential when x is a
\code{\link{numeric}} vector. Note, that this is not a generic
argument and not all methods need provide it.}
}
\value{
Returns a \code{\link{numeric}} \code{\link{vector}} of length N (K).
}
\description{
Accurately calculates the logarithm of the sum of exponentials for each row
(column) of a matrix-like object.
}
\details{
The S4 methods for \code{x} of type \code{\link{matrix}},
\code{\link{array}}, \code{\link{table}}, or \code{\link{numeric}} call
\code{matrixStats::\link[matrixStats]{rowLogSumExps}} /
\code{matrixStats::\link[matrixStats]{colLogSumExps}}.
}
\examples{
mat <- matrix(rnorm(15), nrow = 5, ncol = 3)
mat[2, 1] <- NA
mat[3, 3] <- Inf
mat[4, 1] <- 0

print(mat)

rowLogSumExps(mat)
colLogSumExps(mat)
}
\seealso{
\itemize{
\item \code{matrixStats::\link[matrixStats]{rowLogSumExps}()} and
\code{matrixStats::\link[matrixStats:rowLogSumExps]{colLogSumExps}()}
which are used when the input is a \code{matrix} or \code{numeric} vector.
\item \code{\link[=rowSums2]{rowSums2()}}
}
}
\keyword{array}
\keyword{iteration}
\keyword{robust}
\keyword{univar}
