% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FSEA.R
\name{plotEnrichmentHeatmap}
\alias{plotEnrichmentHeatmap}
\title{Heatmap of Feature Set Enrichment Analysis results}
\usage{
plotEnrichmentHeatmap(fsea.results, alpha = 0.05, logScale = TRUE, ...)
}
\arguments{
\item{fsea.results}{output of \link{runEnrichmentAnalysis} function}

\item{alpha}{FDR threshold to filter out unsignificant feature sets which are
not represented in the heatmap. Default is 0.05.}

\item{logScale}{boolean indicating whether to plot the log of the p.values.}

\item{...}{extra arguments to be passed to \link{pheatmap} function}
}
\value{
produces a heatmap
}
\description{
This method generates a heatmap with the adjusted p.values that
 result from the the feature set enrichment analysis. Rows are feature sets and columns are factors.
}
\examples{
# Example on the CLL data
filepath <- system.file("extdata", "CLL_model.hdf5", package = "MOFAdata")
MOFAobject <- loadModel(filepath)

# perform Enrichment Analysis on mRNA data using pre-build Reactome gene sets
data("reactomeGS", package = "MOFAdata")
fsea.results <- runEnrichmentAnalysis(MOFAobject, view="mRNA", feature.sets=reactomeGS)

# overview of enriched pathways per factor at an FDR of 1\%
plotEnrichmentHeatmap(fsea.results, alpha=0.01)
}
