% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BEAM.R
\name{branchTest}
\alias{branchTest}
\title{Test for branch-dependent expression}
\usage{
branchTest(
  cds,
  fullModelFormulaStr = "~sm.ns(Pseudotime, df = 3)*Branch",
  reducedModelFormulaStr = "~sm.ns(Pseudotime, df = 3)",
  branch_states = NULL,
  branch_point = 1,
  relative_expr = TRUE,
  cores = 1,
  branch_labels = NULL,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{cds}{a CellDataSet object upon which to perform this operation}

\item{fullModelFormulaStr}{a formula string specifying the full model in differential expression tests (i.e. likelihood ratio tests) for each gene/feature.}

\item{reducedModelFormulaStr}{a formula string specifying the reduced model in differential expression tests (i.e. likelihood ratio tests) for each gene/feature.}

\item{branch_states}{states corresponding to two branches}

\item{branch_point}{The ID of the branch point to analyze. Can only be used when reduceDimension is called with method = "DDRTree".}

\item{relative_expr}{a logic flag to determine whether or not the relative gene expression should be used}

\item{cores}{the number of cores to be used while testing each gene for differential expression}

\item{branch_labels}{the name for each branch, for example, AT1 or AT2}

\item{verbose}{Whether to show VGAM errors and warnings. Only valid for cores = 1.}

\item{...}{Additional arguments passed to differentialGeneTest}
}
\value{
a data frame containing the p values and q-values from the likelihood ratio tests on the parallel arrays of models.
}
\description{
Testing for branch-dependent expression with \code{\link{BEAM}()} first
involves constructing a CellDataSet that assigns each cell to a branch, and 
then performing a likelihood ratio test to see if the branch assignments 
significantly improves the fit over a null model that does not split the cells.
\code{branchTest()} implements these two steps.
}
