% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list-creds.R
\name{gitcreds_list}
\alias{gitcreds_list}
\title{List all credentials stored by a git credential helper}
\usage{
gitcreds_list(
  url = "https://github.com",
  credential_helper = NULL,
  protocol = NULL
)
}
\arguments{
\item{url}{URL to list credentials for. If \code{NULL} then the credentials
are listed for all URLs. Note that for a host the results might be
different if you specify or omit this argument. \code{gitcreds_list()}
uses heuristics when the \code{url} is not specified. If is always best to
specify the URL.}

\item{credential_helper}{Credential helper to use. If this is \code{NULL},
then the configured credential helper is used. If multiple credential
helpers are configured, then the first one is used, with a warning.}

\item{protocol}{Protocol to list credentials for. If \code{NULL} and \code{url}
includes a protocol then that is used. Otherwise \code{"https"} is used.}
}
\value{
A list of \code{oskeyring_macos_item} objects. See
\code{\link[oskeyring:macos_keychain]{oskeyring::macos_item()}}.
}
\description{
This function is meant to be used interactively, to help you when
configuring credential helpers. It is especially useful if you have
multiple accounts on a host.
}
\details{
Note that this function does not use the credential helper itself,
so it does not have to be installed. But it may also give false
results, so interpret the results with caution, and also use the tool
provided by your OS, to look at the credentials: 'Keychain Access'
on macOS and 'Credential Manager' on Windows.

Only a small number of credential helpers are supported currently.
Here is a brief description of each.
\subsection{\code{osxkeychain} on macOS}{

This is the default credential helper on macOS.

It has some peculiarities:
\itemize{
\item If you don't specify a username in the URL, then it will return the
\emph{oldest} credentials that match the specified host name, with an
arbitrary user name.
\item If the user name is specified in the URL, then it is used to look up
the credentials.
}

To change or delete the listed credentials, see the oskeyring package
or the 'Keychain Access' macOS app.
}

\subsection{\code{manager}, on Windows}{

This is Git Credential Manager for Windows, see
https://github.com/microsoft/Git-Credential-Manager-for-Windows

It is currently the default helper on Windows, included in the git
installer.

It has some oddities, especially with multiple GitHub users:
\itemize{
\item The \code{github} authority (which is used by default for \code{github.com}
URLs) cannot handle multiple users. It always sets the \code{target_name}
of the Windows credential to \verb{git:<URL>} where \verb{<URL>} does not
contain the user name. Since \code{target_name} is a primary key, it is
not possible to add multiple GitHub users with the default
configuration.
\item To support multiple users, switch to the \code{Basic} authority, e.g. by
setting the \code{GCM_AUTHORITY} env var to \code{Basic}. Then the user name
will be included in \code{target_name}, and everything works fine.
\item For this helper \code{gitcreds_list()} lists all records with a matching
host name.
}
}

\subsection{\code{manager-core} on Windows}{

This is Git Credential Manager Core, see
https://github.com/microsoft/Git-Credential-Manager-Core

On Windows it behaves almost the same way as \code{manager}, with some
differences:
\itemize{
\item Instead of \emph{authorities}, it has providers. \code{github.com} URLs use the
\code{github} provider by default. For better support for multiple GitHub
accounts, switch to the \code{generic} provider by setting the
\code{GCM_PROVIDER} env var to \code{generic}.
\item \code{gitcreds_list()} will list all credentials with a matching host,
irrespectively of the user name in the input URL.
}
}

\subsection{\code{manager-core}, \emph{before} version 2.0.246-beta, on macOS}{

This is Git Credential Manager Core, see
https://github.com/microsoft/Git-Credential-Manager-Core

This helper has some peculiarities w.r.t. user names:
\itemize{
\item If the "github" provider is used (which is the default for
\code{github.com} URLs), then it completely ignores user names, even if
they are explicitly specified in the query.
\item For other providers, the user name (if specified) is saved in the
Keychain item.
\item For this helper, \code{gitcreds_list()} always lists all records that
match the \emph{host}, even if the user name does not match, because it
is impossible to tell if the user name would be used in a proper
git credential lookup.
}

To change or delete the listed credentials, see the oskeyring package
or the 'Keychain Access' macOS app.
}

\subsection{\code{manager-core}, version 2.0.246-beta or newer, on macOS}{

This is a newer version of Git Credential Manager Core, that supports
multiple users better:
\itemize{
\item if a user name is provided, then it saves it in the credential store,
and it uses this user name for looking up credentials, even for the
\code{github} provider.
\item \code{gitcreds_list()} always lists all records that match the host, even
if the user name does not match.
\item Credentials that were created by an older version of \code{manager-core},
with the \code{generic} provider, do not work with the newer version of
\code{manager-core}, because the format of the Keychain item is different.
}
}
}
