% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/access.R
\name{get.edges}
\alias{get.edges}
\alias{get.edgeIDs}
\alias{get.dyads.eids}
\title{Retrieve Edges or Edge IDs Associated with a Given Vertex}
\usage{
get.edgeIDs(
  x,
  v,
  alter = NULL,
  neighborhood = c("out", "in", "combined"),
  na.omit = TRUE
)

get.edges(
  x,
  v,
  alter = NULL,
  neighborhood = c("out", "in", "combined"),
  na.omit = TRUE
)

get.dyads.eids(
  x,
  tails,
  heads,
  neighborhood = c("out", "in", "combined"),
  na.omit = TRUE
)
}
\arguments{
\item{x}{an object of class \code{network}}

\item{v}{a vertex ID}

\item{alter}{optionally, the ID of another vertex}

\item{neighborhood}{an indicator for whether we are interested in in-edges,
out-edges, or both (relative to \code{v}). defaults to \code{'combined'} for
undirected networks}

\item{na.omit}{logical; should we omit missing edges?}

\item{tails}{a vector of vertex ID for the 'tails' (v) side of the dyad}

\item{heads}{a vector of vertex ID for the 'heads' (alter) side of the dyad}
}
\value{
For \code{get.edges}, a list of edges.  For \code{get.edgeIDs}, a
vector of edge ID numbers. For \code{get.dyads.eids}, a list of edge IDs
corresponding to the dyads defined by the vertex ids in \code{tails} and
\code{heads}
}
\description{
\code{get.edges} retrieves a list of edges incident on a given vertex;
\code{get.edgeIDs} returns the internal identifiers for those edges,
instead.  Both allow edges to be selected based on vertex neighborhood and
(optionally) an additional endpoint.
}
\details{
By default, \code{get.edges} returns all out-, in-, or out- and in-edges
containing \code{v}.  \code{get.edgeIDs} is identical, save in its return
value, as it returns only the ids of the edges.  Specifying a vertex in
\code{alter} causes these edges to be further selected such that alter must
also belong to the edge -- this can be used to extract edges between two
particular vertices.  Omission of missing edges is accomplished via
\code{na.omit}.  Note that for multiplex networks, multiple edges or edge
ids can be returned.

The function \code{get.dyads.eids} simplifies the process of looking up the
edge ids associated with a set of 'dyads' (tail and head vertex ids) for
edges. It only is intended for working with non-multiplex networks and will
return a warning and \code{NA} value for any dyads that correspond to
multiple edges. The value \code{numeric(0)} will be returned for any dyads
that do not have a corresponding edge.
}
\examples{

#Create a network with three edges
m<-matrix(0,3,3)
m[1,2]<-1; m[2,3]<-1; m[3,1]<-1
g<-network(m)

get.edges(g,1,neighborhood="out")
get.edgeIDs(g,1,neighborhood="in")

}
\references{
Butts, C. T.  (2008).  \dQuote{network: a Package for Managing
Relational Data in R.} \emph{Journal of Statistical Software}, 24(2).
\url{https://www.jstatsoft.org/v24/i02/}
}
\seealso{
\code{\link{get.neighborhood}}, \code{\link{valid.eids}}
}
\author{
Carter T. Butts \email{buttsc@uci.edu}
}
\keyword{classes}
\keyword{graphs}
