% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polyCub.exact.Gauss.R
\name{polyCub.exact.Gauss}
\alias{polyCub.exact.Gauss}
\title{Quasi-Exact Cubature of the Bivariate Normal Density (DEFUNCT)}
\usage{
polyCub.exact.Gauss(polyregion, mean = c(0, 0), Sigma = diag(2),
  plot = FALSE)
}
\arguments{
\item{polyregion}{a \code{"gpc.poly"} polygon or
something that can be coerced to this class, e.g., an \code{"owin"} polygon
(via \code{\link{owin2gpc}}), or an \code{"sfg"} polygon (via
\code{\link{sfg2gpc}}).}

\item{mean, Sigma}{mean and covariance matrix of the bivariate normal density
to be integrated.}

\item{plot}{logical indicating if an illustrative plot of the numerical
integration should be produced. Note that the \code{polyregion} will be
transformed (shifted and scaled).}
}
\value{
The integral of the bivariate normal density over \code{polyregion}.
Two attributes are appended to the integral value:
\item{nEval}{
number of triangles over which the standard bivariate normal density had to
be integrated, i.e. number of calls to \code{\link[mvtnorm]{pmvnorm}} and
\code{\link[stats]{pnorm}}, the former of which being the most time-consuming
operation.
}
\item{error}{
Approximate absolute integration error stemming from the error introduced by
the \code{nEval} \code{\link[mvtnorm]{pmvnorm}} evaluations.
For this reason, the cubature method is in fact only
quasi-exact (as is the \code{pmvnorm} function).
}
}
\description{
This cubature method is \strong{defunct} as of \pkg{polyCub} version 0.9.0.
It relied on \code{tristrip()} from package \CRANpkg{gpclib} for polygon
triangulation, but that package did not have a \acronym{FOSS} license and
was no longer maintained on a mainstream repository.\cr
Contributions to resurrect this cubature method are welcome: an alternative
implementation for constrained polygon triangulation is needed, see
\url{https://github.com/bastistician/polyCub/issues/2}.
}
\details{
The bivariate Gaussian density can be integrated based on a triangulation of
the (transformed) polygonal domain, using formulae from the
Abramowitz and Stegun (1972) handbook (Section 26.9, Example 9, pp. 956f.).
This method is quite cumbersome because the A&S formula is only for triangles
where one vertex is the origin (0,0). For each triangle
we have to check in which of the 6 outer
regions of the triangle the origin (0,0) lies and adapt the signs in the
formula appropriately: \eqn{(AOB+BOC-AOC)} or \eqn{(AOB-AOC-BOC)} or
\eqn{(AOB+AOC-BOC)} or \eqn{(AOC+BOC-AOB)} or \ldots.
However, the most time consuming step is the
evaluation of \code{\link[mvtnorm]{pmvnorm}}.
}
\examples{
## a function to integrate (here: isotropic zero-mean Gaussian density)
f <- function (s, sigma = 5)
    exp(-rowSums(s^2)/2/sigma^2) / (2*pi*sigma^2)

## a simple polygon as integration domain
hexagon <- list(
    list(x = c(7.33, 7.33, 3, -1.33, -1.33, 3),
         y = c(-0.5, 4.5, 7, 4.5, -0.5, -3))
)

## quasi-exact integration based on gpclib::tristrip() and mvtnorm::pmvnorm()
\dontrun{## (this example requires gpclib)
hexagon.gpc <- new("gpc.poly", pts = lapply(hexagon, c, list(hole = FALSE)))
plotpolyf(hexagon.gpc, f, xlim = c(-8,8), ylim = c(-8,8))
print(polyCub.exact.Gauss(hexagon.gpc, mean = c(0,0), Sigma = 5^2*diag(2),
                          plot = TRUE), digits = 16)
}
}
\references{
Abramowitz, M. and Stegun, I. A. (1972).
Handbook of Mathematical Functions with Formulas, Graphs, and Mathematical
Tables. New York: Dover Publications.
}
\seealso{
\code{\link{circleCub.Gauss}} for quasi-exact cubature of the
isotropic Gaussian density over a circular domain.

Other polyCub-methods: 
\code{\link{polyCub.SV}()},
\code{\link{polyCub.iso}()},
\code{\link{polyCub.midpoint}()},
\code{\link{polyCub}()}
}
\concept{polyCub-methods}
\keyword{math}
\keyword{spatial}
