% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcnemar_test.R
\name{mcnemar_test}
\alias{mcnemar_test}
\alias{pairwise_mcnemar_test}
\title{McNemar's Chi-squared Test for Count Data}
\usage{
mcnemar_test(x, y = NULL, correct = TRUE)

pairwise_mcnemar_test(
  data,
  formula,
  type = c("mcnemar", "exact"),
  correct = TRUE,
  p.adjust.method = "bonferroni"
)
}
\arguments{
\item{x}{either a two-dimensional contingency table in matrix form,
    or a factor object.}

\item{y}{a factor object; ignored if \code{x} is a matrix.}

\item{correct}{a logical indicating whether to apply continuity
    correction when computing the test statistic.}

\item{data}{a data frame containing the variables in the formula.}

\item{formula}{a formula of the form \code{a ~ b | c}, where \code{a} is the
outcome variable name; b is the within-subjects factor variables; and c
(factor) is the column name containing individuals/subjects identifier.
Should be unique per individual.}

\item{type}{type of statistical tests used for pairwise comparisons. Allowed
values are one of \code{c("mcnemar", "exact")}.}

\item{p.adjust.method}{method to adjust p values for multiple comparisons.
Used when pairwise comparisons are performed. Allowed values include "holm",
"hochberg", "hommel", "bonferroni", "BH", "BY", "fdr", "none". If you don't
want to adjust the p value (not recommended), use p.adjust.method = "none".}
}
\value{
return a data frame with the following columns: \itemize{
\item \code{n}: the number of participants.
\item \code{statistic}: the value of McNemar's statistic. \item \code{df} the
 degrees of freedom of the approximate chi-squared distribution of the test
 statistic. \item \code{p}: p-value. \item \code{p.adj}: the adjusted
 p-value. \item \code{method}: the used statistical test. \item
 \code{p.signif}: the significance level of p-values.}

 The \strong{returned object has an attribute called args}, which is a list
 holding the test arguments.
}
\description{
Performs McNemar chi-squared test to compare paired proportions.

 Wrappers around the R base function \code{\link[stats]{mcnemar.test}()}, but
 provide pairwise comparisons between multiple groups
}
\section{Functions}{
\itemize{
\item \code{mcnemar_test()}: performs McNemar's chi-squared test for comparing two
paired proportions

\item \code{pairwise_mcnemar_test()}: performs pairwise McNemar's chi-squared test between
multiple groups. Could be used for post-hoc tests following a significant Cochran's Q test.

}}
\examples{

# Comparing two paired proportions
#\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%
# Data: frequencies of smokers before and after interventions
xtab <- as.table(
  rbind(c(25, 6), c(21,10))
)
dimnames(xtab) <- list(
  before = c("non.smoker", "smoker"),
  after = c("non.smoker", "smoker")
)
xtab

# Compare the proportion of smokers
mcnemar_test(xtab)

# Comparing multiple related proportions
# \%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%
# Generate a demo data
mydata <- data.frame(
  outcome = c(0,1,1,0,0,1,0,1,1,1,1,1,0,0,1,1,0,1,0,1,1,0,0,1,0,1,1,0,0,1),
  treatment = gl(3,1,30,labels=LETTERS[1:3]),
  participant = gl(10,3,labels=letters[1:10])
)
mydata$outcome <- factor(
  mydata$outcome, levels = c(1, 0),
  labels = c("success", "failure")
  )
# Cross-tabulation
xtabs(~outcome + treatment, mydata)

# Compare the proportion of success between treatments
cochran_qtest(mydata, outcome ~ treatment|participant)

# pairwise comparisons between groups
pairwise_mcnemar_test(mydata, outcome ~ treatment|participant)

}
