% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform-numeric.R
\name{transform_yj}
\alias{transform_yj}
\alias{yj_trans}
\title{Yeo-Johnson transformation}
\usage{
transform_yj(p)

yj_trans(p)
}
\arguments{
\item{p}{Transformation exponent, \eqn{\lambda}.}
}
\description{
The Yeo-Johnson transformation is a flexible transformation that is similar
to Box-Cox, \code{\link[=transform_boxcox]{transform_boxcox()}}, but does not require input values to be
greater than zero.
}
\details{
The transformation takes one of four forms depending on the values of \code{y} and \eqn{\lambda}.
\itemize{
\item \eqn{y \ge 0} and \eqn{\lambda \neq 0}{\lambda != 0} :
\eqn{y^{(\lambda)} = \frac{(y + 1)^\lambda - 1}{\lambda}}{y^(\lambda) = ((y + 1)^\lambda - 1)/\lambda}
\item \eqn{y \ge 0} and \eqn{\lambda = 0}:
\eqn{y^{(\lambda)} = \ln(y + 1)}{y^(\lambda) = ln(y + 1)}
\item \eqn{y < 0} and \eqn{\lambda \neq 2}{\lambda != 2}:
\eqn{y^{(\lambda)} = -\frac{(-y + 1)^{(2 - \lambda)} - 1}{2 - \lambda}}{y^(\lambda) = -((-y + 1)^(2 - \lambda) - 1)/(2 - \lambda)}
\item \eqn{y < 0} and \eqn{\lambda = 2}:
\eqn{y^{(\lambda)} = -\ln(-y + 1)}{y^(\lambda) = -ln(-y + 1)}
}
}
\examples{
plot(transform_yj(-1), xlim = c(-10, 10))
plot(transform_yj(0), xlim = c(-10, 10))
plot(transform_yj(1), xlim = c(-10, 10))
plot(transform_yj(2), xlim = c(-10, 10))
}
\references{
Yeo, I., & Johnson, R. (2000).
A New Family of Power Transformations to Improve Normality or Symmetry. Biometrika, 87(4), 954-959.
\url{https://www.jstor.org/stable/2673623}
}
