# sjPlot - Data Visualization for Statistics in Social Science <img src="man/figures/logo.png" align="right" />

[![CRAN_Status_Badge](http://www.r-pkg.org/badges/version/sjPlot)](https://cran.r-project.org/package=sjPlot)

Collection of plotting and table output functions for data visualization. Results of various statistical analyses (that are commonly used in social sciences) can be visualized using this package, including simple and cross tabulated frequencies, histograms, box plots, (generalized) linear models, mixed effects models, PCA and correlation matrices, cluster analyses, scatter plots, Likert scales, effects plots of interaction terms in regression models, constructing index or score variables and much more.

## Installation

### Latest development build

To install the latest development snapshot (see latest changes below), type the following commands into the R console:

```r
library(devtools)
devtools::install_github("strengejacke/sjPlot")
```

### Official, stable release

To install the latest stable release from CRAN, type the following command into the R console:

```r
install.packages("sjPlot")
```

## Documentation and examples

Please visit [https://strengejacke.github.io/sjPlot/](https://strengejacke.github.io/sjPlot/) for documentation and vignettes.

See also this [package-review](https://yuzar-blog.netlify.app/posts/2022-08-01-sjplot/), which provides a comprehensive overview on how to easily visualize data and model results.

## Citation

In case you want / have to cite my package, please use `citation('sjPlot')` for citation information. Since core functionality of package depends on the [ggplot-package](https://cran.r-project.org/package=ggplot2), consider citing this package as well.

[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.1308157.svg)](https://doi.org/10.5281/zenodo.1308157)
