% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CTI.R
\name{CTI}
\alias{CTI}
\title{Ehler's Correlation Trend Indicator}
\usage{
CTI(price, n = 20, slope = 1)
}
\arguments{
\item{price}{Price series that is coercible to xts or matrix.}

\item{n}{Number of periods to use.}

\item{slope}{Slope of desired trend.}
}
\value{
A object of the same class as \code{price} or a matrix (if
\code{try.xts} fails) with the column:
 \describe{
  \item{cti}{ The Correlation Trend Indicator. }
 }
}
\description{
Ehler's Correlation Trend Indicator (CTI) measures the Spearman correlation
of the price with the ideal trend line: a straight line with increasing
slope.
}
\details{
The CTI measures the Spearman correlation between the price and the ideal
trend line with slope of \code{slope}, over the past \code{n} days.

See URL in references section for further details.
}
\note{
Positive/negative CTI values signal positive/negative correlation with
the desired trend line slope. A simple strategy could be long when the CTI
is positive and, short when it is negative.
}
\examples{

data(ttrc)
cti <- CTI(ttrc[,"Close"], n = 20)

}
\references{
John Ehlers, Correlation Trend Indicator, Stocks & Commodities May-2020
The following site(s) were used to code/document this indicator:\cr
\url{https://financial-hacker.com/petra-on-programming-a-unique-trend-indicator/}\cr
}
\seealso{
See \code{\link{aroon}}, \code{\link{CCI}}, \code{\link{ADX}},
\code{\link{VHF}}, \code{\link{GMMA}}, \code{\link{TDI}} for other
indicators that measure trend direction/strength.
}
\author{
Ethan Smith, Joshua Ulrich
}
\keyword{ts}
