# Announce: Rakudo Perl 6 compiler, Development Release #85 (“Berlin”)

On behalf of the Rakudo development team, I’m happy to announce the
February 2015 release of Rakudo Perl 6 #85 “Berlin”. Rakudo is an
implementation of Perl 6 on the Moar Virtual Machine[^1], the Java Virtual
Machine and the Parrot Virtual Machine[^2]. The tarball for this release
is available from <http://rakudo.org/downloads/rakudo/>.

Please note: This announcement is not for the Rakudo Star
distribution[^3] --- it’s announcing a new release of the compiler
only. For the latest Rakudo Star release, see
<http://rakudo.org/downloads/star/>.

As described by pmichaud in a recent blog post:

  http://pmthium.com/2015/02/suspending-rakudo-parrot/

this is the *last* release of Rakudo that supports Parrot as a backend
for the foreseeable future.  Whether Parrot support can be restored at
some point in the future, really depends on people with tuits making the
necessary changes.  In that light, I would like to emphasize the last
paragraph of said blog post:

    If there are people that want to work on refactoring Rakudo’s support
    for Parrot so that it’s more consistent with the other VMs, we can
    certainly point them in the right direction. For the GLR this will
    mainly consists of migrating parrot-specific code from Rakudo into
    NQP’s APIs. For the NSA and NFG work, it will involve developing a lot
    of new code and feature capabilities that Parrot doesn’t possess.

The Rakudo Perl compiler follows a monthly release cycle, with each
release named after a Perl Mongers group. This release is named after
Berlin.pm for several reasons:

+ Historically, Berlin has been known to be a divided city.  Just over 25
  years ago, the miracle of reunification started.  Berlin today is a thriving
  city, still redefining itself.  The fact that this release will most
  likely be the last release supporting Parrot, signifies a division that we
  hope will be undone in the future.  The history of Berlin should be an
  inspiration for this.

+ In April 2015, the next Perl QA Hackathon will take place in Berlin.  This
  hackathon will be attended by developers who will be working on both Perl 5
  as well as Perl 6.  A further sign of reunification.

Some of the changes in this release are outlined below:

These are only some of the changes in this release. For a more
detailed list, see “docs/ChangeLog”.

INCOMPATIBLE CHANGES:
+ On MoarVM, symlinks are now followed.  This means that e.g. a given path
  can have both .l and .d be true, if the symlink points to a directory.
  This behaviour now matches the behaviour on the Parrot and JVM backend,
  therefore one could consider this a bug fix, rather than an incompatible
  change.

+ Overriding invoke/postcircumfix:<( )> for type coercions (ex. MyType(...))
  now passes the function arguments as-is, rather than just passing a Capture
  containing them. To get the old behavior, simply declare a Capture
  parameter (|c).

+ "6;" at unit start is no longer a way to say "no strict;".  It was deemed
  to be a bad meme and huffmannized inappropriately.

+ The NativeCall module (for incorporating external libraries as Perl 6
  subs) is now part of the compiler distribution.  To activate it, one
  must still do a "use NativeCall", but it does *not* have to be installed
  with panda anymore.  If you are a module developer, you can now remove
  NativeCall as a prerequisite from the meta information of your distribution.

Other notable changes:

+ Coercion syntax now works in signatures: sub foo(Str(Any) $a) { ... }
  will take Any value as its first positional parameter, and coerce it to
  Str before making it available in $a.  Note that Str(Any) can be shortened
  to Str().

+ "sub MAIN;" (as in, rest of file is the MAIN unit) has been implemented.

+ Metaop "=" now respects the precedence of the op it is meta-ing.

+ Added numerical "polymod" method: $seconds.polymod(60,60,24) will give you
  a list with seconds, minutes, hours, days.

+ Added rational "base-repeating" method: (1/7).base-repeating(10) will give
  you a base of "0." and a repeating factor of "142857".  In contrast,
  printf("%0.20f",1/7) would give you 0.14285714285714300000, which is less
  accurate.

+ Repeated mixins of the same role and same type are now 10x faster, and use
  much less memory.  Str.trans, tr/// and Str.subst on simple Str, are now
  about 20x faster.

+ Many optimizations, improved error messages and bugs fixed (over
  200 commits to Rakudo since the 2015.01 release).


The development team thanks all of our contributors and sponsors for
making Rakudo Perl possible, as well as those people who worked on
Parrot, the Perl 6 test suite, MoarVM and the specification.

The following people contributed to this release:
Alexander Moquin, Moritz Lenz, Tobias Leich, Jonathan Worthington, Larry Wall,
Will "Coke" Coleda, Timo Paulssen, Rob Hoelz, Andrew Egeler, Paul Cochrane,
Stefan Seifert, Brad Gilbert, Mikhail Khorkov, Pepe Schwarz, avuserow, nwc10,
skids, mj41, Tux, raydiak, Elizabeth Mattijsen

If you would like to contribute, see <http://rakudo.org/how-to-help>,
ask on the <perl6-compiler@perl.org> mailing list, or ask on IRC
\#perl6 on freenode.

The next release of Rakudo (#86), is scheduled for 19 March 2015.
A list of the other planned release dates and code names for future
releases is available in the “docs/release_guide.pod” file. A Rakudo
development release typically occurs a few days (often two) after the
third Tuesday of each month.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback -- get in touch with
us through (the above-mentioned) mailing list of IRC channel. Enjoy!

[^1]: See <http://moarvm.org/>

[^2]: See <http://parrot.org/>

[^3]: What’s the difference between the Rakudo compiler and the Rakudo
Star distribution?

The Rakudo compiler is a compiler for the Perl 6 language.
Nothing else.

The Rakudo Star distribution is the Rakudo compiler plus a selection
of useful Perl 6 modules, a module installer, the most recent
incarnation of the “Using Perl 6” book, and other software that can
be used with the Rakudo compiler to enhance its utility.  Rakudo Star
is meant for early adopters who wish to explore what’s possible with
Rakudo Perl 6 and provide feedback on what works, what doesn’t, and
what else they would like to see included in the distribution.
