require 'spec_helper'

RSpec.describe Humanize, "en locale" do
  # rubocop:disable Metrics/LineLength
  en_tests = [
    [-1, "negative one"],
    [-0.042, "negative zero point zero four two"],
    [-0.00003345, "negative zero point zero zero zero zero three three four five"],
    [-0.0000017854, "negative zero point zero zero zero zero zero one seven eight five four"],
    [0.000000123, "zero point zero zero zero zero zero zero one two three"],
    [0, "zero"],
    [8.15, "eight point one five"],
    [8.000015, "eight point zero zero zero zero one five"],
    [8, "eight"],
    [11, "eleven"],
    [21, "twenty-one"],
    [99, "ninety-nine"],
    [100, "one hundred"],
    [101, "one hundred and one"],
    [111, "one hundred and eleven"],
    [121, "one hundred and twenty-one"],
    [1079, "one thousand and seventy-nine"],
    [10_000, "ten thousand"],
    [10_079, "ten thousand and seventy-nine"],
    [235_409, "two hundred and thirty-five thousand, four hundred and nine"],
    [1_007_310, "one million, seven thousand, three hundred and ten"],
    [21_007_310, "twenty-one million, seven thousand, three hundred and ten"],
    [321_007_310, "three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [4_321_007_310, "four billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [14_321_007_310, "fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [514_321_007_310, "five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [6_514_321_007_310, "six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [76_514_321_007_310, "seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [176_514_321_007_310, "one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [2_176_514_321_007_310, "two quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [12_176_514_321_007_310, "twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [112_176_514_321_007_310, "one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [1_112_176_514_321_007_310, "one quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [11_112_176_514_321_007_310, "eleven quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [111_112_176_514_321_007_310, "one hundred and eleven quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [1_111_112_176_514_321_007_310, "one sextillion, one hundred and eleven quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [21_111_112_176_514_321_007_310, "twenty-one sextillion, one hundred and eleven quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [221_111_112_176_514_321_007_310, "two hundred and twenty-one sextillion, one hundred and eleven quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [3_221_111_112_176_514_321_007_310, "three septillion, two hundred and twenty-one sextillion, one hundred and eleven quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [33_221_111_112_176_514_321_007_310, "thirty-three septillion, two hundred and twenty-one sextillion, one hundred and eleven quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [333_221_111_112_176_514_321_007_310, "three hundred and thirty-three septillion, two hundred and twenty-one sextillion, one hundred and eleven quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [4_333_221_111_112_176_514_321_007_310, "four octillion, three hundred and thirty-three septillion, two hundred and twenty-one sextillion, one hundred and eleven quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [44_333_221_111_112_176_514_321_007_310, "forty-four octillion, three hundred and thirty-three septillion, two hundred and twenty-one sextillion, one hundred and eleven quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [444_333_221_111_112_176_514_321_007_310, "four hundred and forty-four octillion, three hundred and thirty-three septillion, two hundred and twenty-one sextillion, one hundred and eleven quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [5_444_333_221_111_112_176_514_321_007_310, "five nonillion, four hundred and forty-four octillion, three hundred and thirty-three septillion, two hundred and twenty-one sextillion, one hundred and eleven quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [55_444_333_221_111_112_176_514_321_007_310, "fifty-five nonillion, four hundred and forty-four octillion, three hundred and thirty-three septillion, two hundred and twenty-one sextillion, one hundred and eleven quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [555_444_333_221_111_112_176_514_321_007_310, "five hundred and fifty-five nonillion, four hundred and forty-four octillion, three hundred and thirty-three septillion, two hundred and twenty-one sextillion, one hundred and eleven quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [6_555_444_333_221_111_112_176_514_321_007_310, "six decillion, five hundred and fifty-five nonillion, four hundred and forty-four octillion, three hundred and thirty-three septillion, two hundred and twenty-one sextillion, one hundred and eleven quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [66_555_444_333_221_111_112_176_514_321_007_310, "sixty-six decillion, five hundred and fifty-five nonillion, four hundred and forty-four octillion, three hundred and thirty-three septillion, two hundred and twenty-one sextillion, one hundred and eleven quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [666_555_444_333_221_111_112_176_514_321_007_310, "six hundred and sixty-six decillion, five hundred and fifty-five nonillion, four hundred and forty-four octillion, three hundred and thirty-three septillion, two hundred and twenty-one sextillion, one hundred and eleven quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [7_666_555_444_333_221_111_112_176_514_321_007_310, "seven undecillion, six hundred and sixty-six decillion, five hundred and fifty-five nonillion, four hundred and forty-four octillion, three hundred and thirty-three septillion, two hundred and twenty-one sextillion, one hundred and eleven quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [77_666_555_444_333_221_111_112_176_514_321_007_310, "seventy-seven undecillion, six hundred and sixty-six decillion, five hundred and fifty-five nonillion, four hundred and forty-four octillion, three hundred and thirty-three septillion, two hundred and twenty-one sextillion, one hundred and eleven quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [777_666_555_444_333_221_111_112_176_514_321_007_310, "seven hundred and seventy-seven undecillion, six hundred and sixty-six decillion, five hundred and fifty-five nonillion, four hundred and forty-four octillion, three hundred and thirty-three septillion, two hundred and twenty-one sextillion, one hundred and eleven quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [9_777_666_555_444_333_221_111_112_176_514_321_007_310, "nine duodecillion, seven hundred and seventy-seven undecillion, six hundred and sixty-six decillion, five hundred and fifty-five nonillion, four hundred and forty-four octillion, three hundred and thirty-three septillion, two hundred and twenty-one sextillion, one hundred and eleven quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [99_777_666_555_444_333_221_111_112_176_514_321_007_310, "ninety-nine duodecillion, seven hundred and seventy-seven undecillion, six hundred and sixty-six decillion, five hundred and fifty-five nonillion, four hundred and forty-four octillion, three hundred and thirty-three septillion, two hundred and twenty-one sextillion, one hundred and eleven quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [999_777_666_555_444_333_221_111_112_176_514_321_007_310, "nine hundred and ninety-nine duodecillion, seven hundred and seventy-seven undecillion, six hundred and sixty-six decillion, five hundred and fifty-five nonillion, four hundred and forty-four octillion, three hundred and thirty-three septillion, two hundred and twenty-one sextillion, one hundred and eleven quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [1_999_777_666_555_444_333_221_111_112_176_514_321_007_310, "one tredecillion, nine hundred and ninety-nine duodecillion, seven hundred and seventy-seven undecillion, six hundred and sixty-six decillion, five hundred and fifty-five nonillion, four hundred and forty-four octillion, three hundred and thirty-three septillion, two hundred and twenty-one sextillion, one hundred and eleven quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [11_999_777_666_555_444_333_221_111_112_176_514_321_007_310, "eleven tredecillion, nine hundred and ninety-nine duodecillion, seven hundred and seventy-seven undecillion, six hundred and sixty-six decillion, five hundred and fifty-five nonillion, four hundred and forty-four octillion, three hundred and thirty-three septillion, two hundred and twenty-one sextillion, one hundred and eleven quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [111_999_777_666_555_444_333_221_111_112_176_514_321_007_310, "one hundred and eleven tredecillion, nine hundred and ninety-nine duodecillion, seven hundred and seventy-seven undecillion, six hundred and sixty-six decillion, five hundred and fifty-five nonillion, four hundred and forty-four octillion, three hundred and thirty-three septillion, two hundred and twenty-one sextillion, one hundred and eleven quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [2_111_999_777_666_555_444_333_221_111_112_176_514_321_007_310, "two quattuordecillion, one hundred and eleven tredecillion, nine hundred and ninety-nine duodecillion, seven hundred and seventy-seven undecillion, six hundred and sixty-six decillion, five hundred and fifty-five nonillion, four hundred and forty-four octillion, three hundred and thirty-three septillion, two hundred and twenty-one sextillion, one hundred and eleven quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [22_111_999_777_666_555_444_333_221_111_112_176_514_321_007_310, "twenty-two quattuordecillion, one hundred and eleven tredecillion, nine hundred and ninety-nine duodecillion, seven hundred and seventy-seven undecillion, six hundred and sixty-six decillion, five hundred and fifty-five nonillion, four hundred and forty-four octillion, three hundred and thirty-three septillion, two hundred and twenty-one sextillion, one hundred and eleven quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [3_222_111_999_777_666_555_444_333_221_111_112_176_514_321_007_310, "three quindecillion, two hundred and twenty-two quattuordecillion, one hundred and eleven tredecillion, nine hundred and ninety-nine duodecillion, seven hundred and seventy-seven undecillion, six hundred and sixty-six decillion, five hundred and fifty-five nonillion, four hundred and forty-four octillion, three hundred and thirty-three septillion, two hundred and twenty-one sextillion, one hundred and eleven quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [33_222_111_999_777_666_555_444_333_221_111_112_176_514_321_007_310, "thirty-three quindecillion, two hundred and twenty-two quattuordecillion, one hundred and eleven tredecillion, nine hundred and ninety-nine duodecillion, seven hundred and seventy-seven undecillion, six hundred and sixty-six decillion, five hundred and fifty-five nonillion, four hundred and forty-four octillion, three hundred and thirty-three septillion, two hundred and twenty-one sextillion, one hundred and eleven quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [333_222_111_999_777_666_555_444_333_221_111_112_176_514_321_007_310, "three hundred and thirty-three quindecillion, two hundred and twenty-two quattuordecillion, one hundred and eleven tredecillion, nine hundred and ninety-nine duodecillion, seven hundred and seventy-seven undecillion, six hundred and sixty-six decillion, five hundred and fifty-five nonillion, four hundred and forty-four octillion, three hundred and thirty-three septillion, two hundred and twenty-one sextillion, one hundred and eleven quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [4_333_222_111_999_777_666_555_444_333_221_111_112_176_514_321_007_310, "four sexdecillion, three hundred and thirty-three quindecillion, two hundred and twenty-two quattuordecillion, one hundred and eleven tredecillion, nine hundred and ninety-nine duodecillion, seven hundred and seventy-seven undecillion, six hundred and sixty-six decillion, five hundred and fifty-five nonillion, four hundred and forty-four octillion, three hundred and thirty-three septillion, two hundred and twenty-one sextillion, one hundred and eleven quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [44_333_222_111_999_777_666_555_444_333_221_111_112_176_514_321_007_310, "forty-four sexdecillion, three hundred and thirty-three quindecillion, two hundred and twenty-two quattuordecillion, one hundred and eleven tredecillion, nine hundred and ninety-nine duodecillion, seven hundred and seventy-seven undecillion, six hundred and sixty-six decillion, five hundred and fifty-five nonillion, four hundred and forty-four octillion, three hundred and thirty-three septillion, two hundred and twenty-one sextillion, one hundred and eleven quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [444_333_222_111_999_777_666_555_444_333_221_111_112_176_514_321_007_310, "four hundred and forty-four sexdecillion, three hundred and thirty-three quindecillion, two hundred and twenty-two quattuordecillion, one hundred and eleven tredecillion, nine hundred and ninety-nine duodecillion, seven hundred and seventy-seven undecillion, six hundred and sixty-six decillion, five hundred and fifty-five nonillion, four hundred and forty-four octillion, three hundred and thirty-three septillion, two hundred and twenty-one sextillion, one hundred and eleven quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [5_444_333_222_111_999_777_666_555_444_333_221_111_112_176_514_321_007_310, "five septendecillion, four hundred and forty-four sexdecillion, three hundred and thirty-three quindecillion, two hundred and twenty-two quattuordecillion, one hundred and eleven tredecillion, nine hundred and ninety-nine duodecillion, seven hundred and seventy-seven undecillion, six hundred and sixty-six decillion, five hundred and fifty-five nonillion, four hundred and forty-four octillion, three hundred and thirty-three septillion, two hundred and twenty-one sextillion, one hundred and eleven quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [55_444_333_222_111_999_777_666_555_444_333_221_111_112_176_514_321_007_310, "fifty-five septendecillion, four hundred and forty-four sexdecillion, three hundred and thirty-three quindecillion, two hundred and twenty-two quattuordecillion, one hundred and eleven tredecillion, nine hundred and ninety-nine duodecillion, seven hundred and seventy-seven undecillion, six hundred and sixty-six decillion, five hundred and fifty-five nonillion, four hundred and forty-four octillion, three hundred and thirty-three septillion, two hundred and twenty-one sextillion, one hundred and eleven quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [555_444_333_222_111_999_777_666_555_444_333_221_111_112_176_514_321_007_310, "five hundred and fifty-five septendecillion, four hundred and forty-four sexdecillion, three hundred and thirty-three quindecillion, two hundred and twenty-two quattuordecillion, one hundred and eleven tredecillion, nine hundred and ninety-nine duodecillion, seven hundred and seventy-seven undecillion, six hundred and sixty-six decillion, five hundred and fifty-five nonillion, four hundred and forty-four octillion, three hundred and thirty-three septillion, two hundred and twenty-one sextillion, one hundred and eleven quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [6_555_444_333_222_111_999_777_666_555_444_333_221_111_112_176_514_321_007_310, "six octodecillion, five hundred and fifty-five septendecillion, four hundred and forty-four sexdecillion, three hundred and thirty-three quindecillion, two hundred and twenty-two quattuordecillion, one hundred and eleven tredecillion, nine hundred and ninety-nine duodecillion, seven hundred and seventy-seven undecillion, six hundred and sixty-six decillion, five hundred and fifty-five nonillion, four hundred and forty-four octillion, three hundred and thirty-three septillion, two hundred and twenty-one sextillion, one hundred and eleven quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [66_555_444_333_222_111_999_777_666_555_444_333_221_111_112_176_514_321_007_310, "sixty-six octodecillion, five hundred and fifty-five septendecillion, four hundred and forty-four sexdecillion, three hundred and thirty-three quindecillion, two hundred and twenty-two quattuordecillion, one hundred and eleven tredecillion, nine hundred and ninety-nine duodecillion, seven hundred and seventy-seven undecillion, six hundred and sixty-six decillion, five hundred and fifty-five nonillion, four hundred and forty-four octillion, three hundred and thirty-three septillion, two hundred and twenty-one sextillion, one hundred and eleven quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [666_555_444_333_222_111_999_777_666_555_444_333_221_111_112_176_514_321_007_310, "six hundred and sixty-six octodecillion, five hundred and fifty-five septendecillion, four hundred and forty-four sexdecillion, three hundred and thirty-three quindecillion, two hundred and twenty-two quattuordecillion, one hundred and eleven tredecillion, nine hundred and ninety-nine duodecillion, seven hundred and seventy-seven undecillion, six hundred and sixty-six decillion, five hundred and fifty-five nonillion, four hundred and forty-four octillion, three hundred and thirty-three septillion, two hundred and twenty-one sextillion, one hundred and eleven quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [7_666_555_444_333_222_111_999_777_666_555_444_333_221_111_112_176_514_321_007_310, "seven novemdecillion, six hundred and sixty-six octodecillion, five hundred and fifty-five septendecillion, four hundred and forty-four sexdecillion, three hundred and thirty-three quindecillion, two hundred and twenty-two quattuordecillion, one hundred and eleven tredecillion, nine hundred and ninety-nine duodecillion, seven hundred and seventy-seven undecillion, six hundred and sixty-six decillion, five hundred and fifty-five nonillion, four hundred and forty-four octillion, three hundred and thirty-three septillion, two hundred and twenty-one sextillion, one hundred and eleven quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [77_666_555_444_333_222_111_999_777_666_555_444_333_221_111_112_176_514_321_007_310, "seventy-seven novemdecillion, six hundred and sixty-six octodecillion, five hundred and fifty-five septendecillion, four hundred and forty-four sexdecillion, three hundred and thirty-three quindecillion, two hundred and twenty-two quattuordecillion, one hundred and eleven tredecillion, nine hundred and ninety-nine duodecillion, seven hundred and seventy-seven undecillion, six hundred and sixty-six decillion, five hundred and fifty-five nonillion, four hundred and forty-four octillion, three hundred and thirty-three septillion, two hundred and twenty-one sextillion, one hundred and eleven quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [777_666_555_444_333_222_111_999_777_666_555_444_333_221_111_112_176_514_321_007_310, "seven hundred and seventy-seven novemdecillion, six hundred and sixty-six octodecillion, five hundred and fifty-five septendecillion, four hundred and forty-four sexdecillion, three hundred and thirty-three quindecillion, two hundred and twenty-two quattuordecillion, one hundred and eleven tredecillion, nine hundred and ninety-nine duodecillion, seven hundred and seventy-seven undecillion, six hundred and sixty-six decillion, five hundred and fifty-five nonillion, four hundred and forty-four octillion, three hundred and thirty-three septillion, two hundred and twenty-one sextillion, one hundred and eleven quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [9_777_666_555_444_333_222_111_999_777_666_555_444_333_221_111_112_176_514_321_007_310, "nine vigintillion, seven hundred and seventy-seven novemdecillion, six hundred and sixty-six octodecillion, five hundred and fifty-five septendecillion, four hundred and forty-four sexdecillion, three hundred and thirty-three quindecillion, two hundred and twenty-two quattuordecillion, one hundred and eleven tredecillion, nine hundred and ninety-nine duodecillion, seven hundred and seventy-seven undecillion, six hundred and sixty-six decillion, five hundred and fifty-five nonillion, four hundred and forty-four octillion, three hundred and thirty-three septillion, two hundred and twenty-one sextillion, one hundred and eleven quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [99_777_666_555_444_333_222_111_999_777_666_555_444_333_221_111_112_176_514_321_007_310, "ninety-nine vigintillion, seven hundred and seventy-seven novemdecillion, six hundred and sixty-six octodecillion, five hundred and fifty-five septendecillion, four hundred and forty-four sexdecillion, three hundred and thirty-three quindecillion, two hundred and twenty-two quattuordecillion, one hundred and eleven tredecillion, nine hundred and ninety-nine duodecillion, seven hundred and seventy-seven undecillion, six hundred and sixty-six decillion, five hundred and fifty-five nonillion, four hundred and forty-four octillion, three hundred and thirty-three septillion, two hundred and twenty-one sextillion, one hundred and eleven quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [999_777_666_555_444_333_222_111_999_777_666_555_444_333_221_111_112_176_514_321_007_310, "nine hundred and ninety-nine vigintillion, seven hundred and seventy-seven novemdecillion, six hundred and sixty-six octodecillion, five hundred and fifty-five septendecillion, four hundred and forty-four sexdecillion, three hundred and thirty-three quindecillion, two hundred and twenty-two quattuordecillion, one hundred and eleven tredecillion, nine hundred and ninety-nine duodecillion, seven hundred and seventy-seven undecillion, six hundred and sixty-six decillion, five hundred and fifty-five nonillion, four hundred and forty-four octillion, three hundred and thirty-three septillion, two hundred and twenty-one sextillion, one hundred and eleven quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [1_999_777_666_555_444_333_222_111_999_777_666_555_444_333_221_111_112_176_514_321_007_310, "one unvigintillion, nine hundred and ninety-nine vigintillion, seven hundred and seventy-seven novemdecillion, six hundred and sixty-six octodecillion, five hundred and fifty-five septendecillion, four hundred and forty-four sexdecillion, three hundred and thirty-three quindecillion, two hundred and twenty-two quattuordecillion, one hundred and eleven tredecillion, nine hundred and ninety-nine duodecillion, seven hundred and seventy-seven undecillion, six hundred and sixty-six decillion, five hundred and fifty-five nonillion, four hundred and forty-four octillion, three hundred and thirty-three septillion, two hundred and twenty-one sextillion, one hundred and eleven quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [11_999_777_666_555_444_333_222_111_999_777_666_555_444_333_221_111_112_176_514_321_007_310, "eleven unvigintillion, nine hundred and ninety-nine vigintillion, seven hundred and seventy-seven novemdecillion, six hundred and sixty-six octodecillion, five hundred and fifty-five septendecillion, four hundred and forty-four sexdecillion, three hundred and thirty-three quindecillion, two hundred and twenty-two quattuordecillion, one hundred and eleven tredecillion, nine hundred and ninety-nine duodecillion, seven hundred and seventy-seven undecillion, six hundred and sixty-six decillion, five hundred and fifty-five nonillion, four hundred and forty-four octillion, three hundred and thirty-three septillion, two hundred and twenty-one sextillion, one hundred and eleven quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [111_999_777_666_555_444_333_222_111_999_777_666_555_444_333_221_111_112_176_514_321_007_310, "one hundred and eleven unvigintillion, nine hundred and ninety-nine vigintillion, seven hundred and seventy-seven novemdecillion, six hundred and sixty-six octodecillion, five hundred and fifty-five septendecillion, four hundred and forty-four sexdecillion, three hundred and thirty-three quindecillion, two hundred and twenty-two quattuordecillion, one hundred and eleven tredecillion, nine hundred and ninety-nine duodecillion, seven hundred and seventy-seven undecillion, six hundred and sixty-six decillion, five hundred and fifty-five nonillion, four hundred and forty-four octillion, three hundred and thirty-three septillion, two hundred and twenty-one sextillion, one hundred and eleven quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [2_111_999_777_666_555_444_333_222_111_999_777_666_555_444_333_221_111_112_176_514_321_007_310, "two duovigintillion, one hundred and eleven unvigintillion, nine hundred and ninety-nine vigintillion, seven hundred and seventy-seven novemdecillion, six hundred and sixty-six octodecillion, five hundred and fifty-five septendecillion, four hundred and forty-four sexdecillion, three hundred and thirty-three quindecillion, two hundred and twenty-two quattuordecillion, one hundred and eleven tredecillion, nine hundred and ninety-nine duodecillion, seven hundred and seventy-seven undecillion, six hundred and sixty-six decillion, five hundred and fifty-five nonillion, four hundred and forty-four octillion, three hundred and thirty-three septillion, two hundred and twenty-one sextillion, one hundred and eleven quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [22_111_999_777_666_555_444_333_222_111_999_777_666_555_444_333_221_111_112_176_514_321_007_310, "twenty-two duovigintillion, one hundred and eleven unvigintillion, nine hundred and ninety-nine vigintillion, seven hundred and seventy-seven novemdecillion, six hundred and sixty-six octodecillion, five hundred and fifty-five septendecillion, four hundred and forty-four sexdecillion, three hundred and thirty-three quindecillion, two hundred and twenty-two quattuordecillion, one hundred and eleven tredecillion, nine hundred and ninety-nine duodecillion, seven hundred and seventy-seven undecillion, six hundred and sixty-six decillion, five hundred and fifty-five nonillion, four hundred and forty-four octillion, three hundred and thirty-three septillion, two hundred and twenty-one sextillion, one hundred and eleven quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [222_111_999_777_666_555_444_333_222_111_999_777_666_555_444_333_221_111_112_176_514_321_007_310, "two hundred and twenty-two duovigintillion, one hundred and eleven unvigintillion, nine hundred and ninety-nine vigintillion, seven hundred and seventy-seven novemdecillion, six hundred and sixty-six octodecillion, five hundred and fifty-five septendecillion, four hundred and forty-four sexdecillion, three hundred and thirty-three quindecillion, two hundred and twenty-two quattuordecillion, one hundred and eleven tredecillion, nine hundred and ninety-nine duodecillion, seven hundred and seventy-seven undecillion, six hundred and sixty-six decillion, five hundred and fifty-five nonillion, four hundred and forty-four octillion, three hundred and thirty-three septillion, two hundred and twenty-one sextillion, one hundred and eleven quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [3_222_111_999_777_666_555_444_333_222_111_999_777_666_555_444_333_221_111_112_176_514_321_007_310, "three trevigintillion, two hundred and twenty-two duovigintillion, one hundred and eleven unvigintillion, nine hundred and ninety-nine vigintillion, seven hundred and seventy-seven novemdecillion, six hundred and sixty-six octodecillion, five hundred and fifty-five septendecillion, four hundred and forty-four sexdecillion, three hundred and thirty-three quindecillion, two hundred and twenty-two quattuordecillion, one hundred and eleven tredecillion, nine hundred and ninety-nine duodecillion, seven hundred and seventy-seven undecillion, six hundred and sixty-six decillion, five hundred and fifty-five nonillion, four hundred and forty-four octillion, three hundred and thirty-three septillion, two hundred and twenty-one sextillion, one hundred and eleven quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [33_222_111_999_777_666_555_444_333_222_111_999_777_666_555_444_333_221_111_112_176_514_321_007_310, "thirty-three trevigintillion, two hundred and twenty-two duovigintillion, one hundred and eleven unvigintillion, nine hundred and ninety-nine vigintillion, seven hundred and seventy-seven novemdecillion, six hundred and sixty-six octodecillion, five hundred and fifty-five septendecillion, four hundred and forty-four sexdecillion, three hundred and thirty-three quindecillion, two hundred and twenty-two quattuordecillion, one hundred and eleven tredecillion, nine hundred and ninety-nine duodecillion, seven hundred and seventy-seven undecillion, six hundred and sixty-six decillion, five hundred and fifty-five nonillion, four hundred and forty-four octillion, three hundred and thirty-three septillion, two hundred and twenty-one sextillion, one hundred and eleven quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [333_222_111_999_777_666_555_444_333_222_111_999_777_666_555_444_333_221_111_112_176_514_321_007_310, "three hundred and thirty-three trevigintillion, two hundred and twenty-two duovigintillion, one hundred and eleven unvigintillion, nine hundred and ninety-nine vigintillion, seven hundred and seventy-seven novemdecillion, six hundred and sixty-six octodecillion, five hundred and fifty-five septendecillion, four hundred and forty-four sexdecillion, three hundred and thirty-three quindecillion, two hundred and twenty-two quattuordecillion, one hundred and eleven tredecillion, nine hundred and ninety-nine duodecillion, seven hundred and seventy-seven undecillion, six hundred and sixty-six decillion, five hundred and fifty-five nonillion, four hundred and forty-four octillion, three hundred and thirty-three septillion, two hundred and twenty-one sextillion, one hundred and eleven quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [4_333_222_111_999_777_666_555_444_333_222_111_999_777_666_555_444_333_221_111_112_176_514_321_007_310, "four quattuortillion, three hundred and thirty-three trevigintillion, two hundred and twenty-two duovigintillion, one hundred and eleven unvigintillion, nine hundred and ninety-nine vigintillion, seven hundred and seventy-seven novemdecillion, six hundred and sixty-six octodecillion, five hundred and fifty-five septendecillion, four hundred and forty-four sexdecillion, three hundred and thirty-three quindecillion, two hundred and twenty-two quattuordecillion, one hundred and eleven tredecillion, nine hundred and ninety-nine duodecillion, seven hundred and seventy-seven undecillion, six hundred and sixty-six decillion, five hundred and fifty-five nonillion, four hundred and forty-four octillion, three hundred and thirty-three septillion, two hundred and twenty-one sextillion, one hundred and eleven quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [44_333_222_111_999_777_666_555_444_333_222_111_999_777_666_555_444_333_221_111_112_176_514_321_007_310, "forty-four quattuortillion, three hundred and thirty-three trevigintillion, two hundred and twenty-two duovigintillion, one hundred and eleven unvigintillion, nine hundred and ninety-nine vigintillion, seven hundred and seventy-seven novemdecillion, six hundred and sixty-six octodecillion, five hundred and fifty-five septendecillion, four hundred and forty-four sexdecillion, three hundred and thirty-three quindecillion, two hundred and twenty-two quattuordecillion, one hundred and eleven tredecillion, nine hundred and ninety-nine duodecillion, seven hundred and seventy-seven undecillion, six hundred and sixty-six decillion, five hundred and fifty-five nonillion, four hundred and forty-four octillion, three hundred and thirty-three septillion, two hundred and twenty-one sextillion, one hundred and eleven quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [444_333_222_111_999_777_666_555_444_333_222_111_999_777_666_555_444_333_221_111_112_176_514_321_007_310, "four hundred and forty-four quattuortillion, three hundred and thirty-three trevigintillion, two hundred and twenty-two duovigintillion, one hundred and eleven unvigintillion, nine hundred and ninety-nine vigintillion, seven hundred and seventy-seven novemdecillion, six hundred and sixty-six octodecillion, five hundred and fifty-five septendecillion, four hundred and forty-four sexdecillion, three hundred and thirty-three quindecillion, two hundred and twenty-two quattuordecillion, one hundred and eleven tredecillion, nine hundred and ninety-nine duodecillion, seven hundred and seventy-seven undecillion, six hundred and sixty-six decillion, five hundred and fifty-five nonillion, four hundred and forty-four octillion, three hundred and thirty-three septillion, two hundred and twenty-one sextillion, one hundred and eleven quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"],
    [444_333_222_111_999_777_666_555_444_333_222_111_999_777_666_555_444_333_221_111_112_176_514_321_007_310_444_333_222_111_999_777_666_555_444_333_222_111_999_777_666_555_444_333_221_111_112_176_514_321_007_310, "four hundred and forty-four quinquagintillion, three hundred and thirty-three novenquadragintillion, two hundred and twenty-two octoquadragintillion, one hundred and eleven septenquadragintillion, nine hundred and ninety-nine sesquadragintillion, seven hundred and seventy-seven quinquadragintillion, six hundred and sixty-six quattuorquadragintillion, five hundred and fifty-five trequadragintillion, four hundred and forty-four duoquadragintillion, three hundred and thirty-three unquadragintillion, two hundred and twenty-two quadragintillion, one hundred and eleven novemtrigintillion, nine hundred and ninety-nine octotrigintillion, seven hundred and seventy-seven septentrigintillion, six hundred and sixty-six sextrigintillion, five hundred and fifty-five quintrigintillion, four hundred and forty-four quattuortrigintillion, three hundred and thirty-three trestrigintillion, two hundred and twenty-one duotrigintillion, one hundred and eleven untrigintillion, one hundred and twelve trigintillion, one hundred and seventy-six novemvigintillion, five hundred and fourteen octovigintillion, three hundred and twenty-one septenvigintillion, seven sexvigintillion, three hundred and ten quinvigintillion, four hundred and forty-four quattuortillion, three hundred and thirty-three trevigintillion, two hundred and twenty-two duovigintillion, one hundred and eleven unvigintillion, nine hundred and ninety-nine vigintillion, seven hundred and seventy-seven novemdecillion, six hundred and sixty-six octodecillion, five hundred and fifty-five septendecillion, four hundred and forty-four sexdecillion, three hundred and thirty-three quindecillion, two hundred and twenty-two quattuordecillion, one hundred and eleven tredecillion, nine hundred and ninety-nine duodecillion, seven hundred and seventy-seven undecillion, six hundred and sixty-six decillion, five hundred and fifty-five nonillion, four hundred and forty-four octillion, three hundred and thirty-three septillion, two hundred and twenty-one sextillion, one hundred and eleven quintillion, one hundred and twelve quadrillion, one hundred and seventy-six trillion, five hundred and fourteen billion, three hundred and twenty-one million, seven thousand, three hundred and ten"]
  ]
  # rubocop:enable Metrics/LineLength

  en_tests.each do |num, output|
    it "#{num} is equal to #{output}" do
      expect(num.humanize).to eq(output)
    end
  end

  describe 'when called on bigdecimal' do
    it 'reads correctly' do
      expect(BigDecimal(en_tests.last.first).humanize).to eql(en_tests.last.last)
    end
  end
end
