//! Autogenerated: 'src/ExtractionOCaml/word_by_word_montgomery' --lang Rust --inline p384_scalar 64 '2^384 - 1388124618062372383947042015309946732620727252194336364173' mul square add sub opp from_montgomery to_montgomery nonzero selectznz to_bytes from_bytes one msat divstep divstep_precomp
//! curve description: p384_scalar
//! machine_wordsize = 64 (from "64")
//! requested operations: mul, square, add, sub, opp, from_montgomery, to_montgomery, nonzero, selectznz, to_bytes, from_bytes, one, msat, divstep, divstep_precomp
//! m = 0xffffffffffffffffffffffffffffffffffffffffffffffffc7634d81f4372ddf581a0db248b0a77aecec196accc52973 (from "2^384 - 1388124618062372383947042015309946732620727252194336364173")
//!
//! NOTE: In addition to the bounds specified above each function, all
//!   functions synthesized for this Montgomery arithmetic require the
//!   input to be strictly less than the prime modulus (m), and also
//!   require the input to be in the unique saturated representation.
//!   All functions also ensure that these two properties are true of
//!   return values.
//!
//! Computed values:
//!   eval z = z[0] + (z[1] << 64) + (z[2] << 128) + (z[3] << 192) + (z[4] << 256) + (z[5] << 0x140)
//!   bytes_eval z = z[0] + (z[1] << 8) + (z[2] << 16) + (z[3] << 24) + (z[4] << 32) + (z[5] << 40) + (z[6] << 48) + (z[7] << 56) + (z[8] << 64) + (z[9] << 72) + (z[10] << 80) + (z[11] << 88) + (z[12] << 96) + (z[13] << 104) + (z[14] << 112) + (z[15] << 120) + (z[16] << 128) + (z[17] << 136) + (z[18] << 144) + (z[19] << 152) + (z[20] << 160) + (z[21] << 168) + (z[22] << 176) + (z[23] << 184) + (z[24] << 192) + (z[25] << 200) + (z[26] << 208) + (z[27] << 216) + (z[28] << 224) + (z[29] << 232) + (z[30] << 240) + (z[31] << 248) + (z[32] << 256) + (z[33] << 0x108) + (z[34] << 0x110) + (z[35] << 0x118) + (z[36] << 0x120) + (z[37] << 0x128) + (z[38] << 0x130) + (z[39] << 0x138) + (z[40] << 0x140) + (z[41] << 0x148) + (z[42] << 0x150) + (z[43] << 0x158) + (z[44] << 0x160) + (z[45] << 0x168) + (z[46] << 0x170) + (z[47] << 0x178)
//!   twos_complement_eval z = let x1 := z[0] + (z[1] << 64) + (z[2] << 128) + (z[3] << 192) + (z[4] << 256) + (z[5] << 0x140) in
//!                            if x1 & (2^384-1) < 2^383 then x1 & (2^384-1) else (x1 & (2^384-1)) - 2^384

#![allow(unused_parens)]
#![allow(non_camel_case_types)]

pub type fiat_p384_scalar_u1 = u8;
pub type fiat_p384_scalar_i1 = i8;
pub type fiat_p384_scalar_u2 = u8;
pub type fiat_p384_scalar_i2 = i8;

/* The type fiat_p384_scalar_montgomery_domain_field_element is a field element in the Montgomery domain. */
/* Bounds: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]] */
pub type fiat_p384_scalar_montgomery_domain_field_element = [u64; 6];

/* The type fiat_p384_scalar_non_montgomery_domain_field_element is a field element NOT in the Montgomery domain. */
/* Bounds: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]] */
pub type fiat_p384_scalar_non_montgomery_domain_field_element = [u64; 6];


/// The function fiat_p384_scalar_addcarryx_u64 is an addition with carry.
///
/// Postconditions:
///   out1 = (arg1 + arg2 + arg3) mod 2^64
///   out2 = ⌊(arg1 + arg2 + arg3) / 2^64⌋
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0xffffffffffffffff]
///   arg3: [0x0 ~> 0xffffffffffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffffffffffff]
///   out2: [0x0 ~> 0x1]
#[inline]
pub fn fiat_p384_scalar_addcarryx_u64(out1: &mut u64, out2: &mut fiat_p384_scalar_u1, arg1: fiat_p384_scalar_u1, arg2: u64, arg3: u64) -> () {
  let x1: u128 = (((arg1 as u128) + (arg2 as u128)) + (arg3 as u128));
  let x2: u64 = ((x1 & (0xffffffffffffffff as u128)) as u64);
  let x3: fiat_p384_scalar_u1 = ((x1 >> 64) as fiat_p384_scalar_u1);
  *out1 = x2;
  *out2 = x3;
}

/// The function fiat_p384_scalar_subborrowx_u64 is a subtraction with borrow.
///
/// Postconditions:
///   out1 = (-arg1 + arg2 + -arg3) mod 2^64
///   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^64⌋
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0xffffffffffffffff]
///   arg3: [0x0 ~> 0xffffffffffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffffffffffff]
///   out2: [0x0 ~> 0x1]
#[inline]
pub fn fiat_p384_scalar_subborrowx_u64(out1: &mut u64, out2: &mut fiat_p384_scalar_u1, arg1: fiat_p384_scalar_u1, arg2: u64, arg3: u64) -> () {
  let x1: i128 = (((arg2 as i128) - (arg1 as i128)) - (arg3 as i128));
  let x2: fiat_p384_scalar_i1 = ((x1 >> 64) as fiat_p384_scalar_i1);
  let x3: u64 = ((x1 & (0xffffffffffffffff as i128)) as u64);
  *out1 = x3;
  *out2 = (((0x0 as fiat_p384_scalar_i2) - (x2 as fiat_p384_scalar_i2)) as fiat_p384_scalar_u1);
}

/// The function fiat_p384_scalar_mulx_u64 is a multiplication, returning the full double-width result.
///
/// Postconditions:
///   out1 = (arg1 * arg2) mod 2^64
///   out2 = ⌊arg1 * arg2 / 2^64⌋
///
/// Input Bounds:
///   arg1: [0x0 ~> 0xffffffffffffffff]
///   arg2: [0x0 ~> 0xffffffffffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffffffffffff]
///   out2: [0x0 ~> 0xffffffffffffffff]
#[inline]
pub fn fiat_p384_scalar_mulx_u64(out1: &mut u64, out2: &mut u64, arg1: u64, arg2: u64) -> () {
  let x1: u128 = ((arg1 as u128) * (arg2 as u128));
  let x2: u64 = ((x1 & (0xffffffffffffffff as u128)) as u64);
  let x3: u64 = ((x1 >> 64) as u64);
  *out1 = x2;
  *out2 = x3;
}

/// The function fiat_p384_scalar_cmovznz_u64 is a single-word conditional move.
///
/// Postconditions:
///   out1 = (if arg1 = 0 then arg2 else arg3)
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0xffffffffffffffff]
///   arg3: [0x0 ~> 0xffffffffffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffffffffffff]
#[inline]
pub fn fiat_p384_scalar_cmovznz_u64(out1: &mut u64, arg1: fiat_p384_scalar_u1, arg2: u64, arg3: u64) -> () {
  let x1: fiat_p384_scalar_u1 = (!(!arg1));
  let x2: u64 = ((((((0x0 as fiat_p384_scalar_i2) - (x1 as fiat_p384_scalar_i2)) as fiat_p384_scalar_i1) as i128) & (0xffffffffffffffff as i128)) as u64);
  let x3: u64 = ((x2 & arg3) | ((!x2) & arg2));
  *out1 = x3;
}

/// The function fiat_p384_scalar_mul multiplies two field elements in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
///   0 ≤ eval arg2 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg2)) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub fn fiat_p384_scalar_mul(out1: &mut fiat_p384_scalar_montgomery_domain_field_element, arg1: &fiat_p384_scalar_montgomery_domain_field_element, arg2: &fiat_p384_scalar_montgomery_domain_field_element) -> () {
  let x1: u64 = (arg1[1]);
  let x2: u64 = (arg1[2]);
  let x3: u64 = (arg1[3]);
  let x4: u64 = (arg1[4]);
  let x5: u64 = (arg1[5]);
  let x6: u64 = (arg1[0]);
  let mut x7: u64 = 0;
  let mut x8: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x7, &mut x8, x6, (arg2[5]));
  let mut x9: u64 = 0;
  let mut x10: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x9, &mut x10, x6, (arg2[4]));
  let mut x11: u64 = 0;
  let mut x12: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x11, &mut x12, x6, (arg2[3]));
  let mut x13: u64 = 0;
  let mut x14: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x13, &mut x14, x6, (arg2[2]));
  let mut x15: u64 = 0;
  let mut x16: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x15, &mut x16, x6, (arg2[1]));
  let mut x17: u64 = 0;
  let mut x18: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x17, &mut x18, x6, (arg2[0]));
  let mut x19: u64 = 0;
  let mut x20: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x19, &mut x20, 0x0, x18, x15);
  let mut x21: u64 = 0;
  let mut x22: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x21, &mut x22, x20, x16, x13);
  let mut x23: u64 = 0;
  let mut x24: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x23, &mut x24, x22, x14, x11);
  let mut x25: u64 = 0;
  let mut x26: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x25, &mut x26, x24, x12, x9);
  let mut x27: u64 = 0;
  let mut x28: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x27, &mut x28, x26, x10, x7);
  let x29: u64 = ((x28 as u64) + x8);
  let mut x30: u64 = 0;
  let mut x31: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x30, &mut x31, x17, 0x6ed46089e88fdc45);
  let mut x32: u64 = 0;
  let mut x33: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x32, &mut x33, x30, 0xffffffffffffffff);
  let mut x34: u64 = 0;
  let mut x35: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x34, &mut x35, x30, 0xffffffffffffffff);
  let mut x36: u64 = 0;
  let mut x37: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x36, &mut x37, x30, 0xffffffffffffffff);
  let mut x38: u64 = 0;
  let mut x39: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x38, &mut x39, x30, 0xc7634d81f4372ddf);
  let mut x40: u64 = 0;
  let mut x41: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x40, &mut x41, x30, 0x581a0db248b0a77a);
  let mut x42: u64 = 0;
  let mut x43: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x42, &mut x43, x30, 0xecec196accc52973);
  let mut x44: u64 = 0;
  let mut x45: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x44, &mut x45, 0x0, x43, x40);
  let mut x46: u64 = 0;
  let mut x47: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x46, &mut x47, x45, x41, x38);
  let mut x48: u64 = 0;
  let mut x49: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x48, &mut x49, x47, x39, x36);
  let mut x50: u64 = 0;
  let mut x51: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x50, &mut x51, x49, x37, x34);
  let mut x52: u64 = 0;
  let mut x53: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x52, &mut x53, x51, x35, x32);
  let x54: u64 = ((x53 as u64) + x33);
  let mut x55: u64 = 0;
  let mut x56: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x55, &mut x56, 0x0, x17, x42);
  let mut x57: u64 = 0;
  let mut x58: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x57, &mut x58, x56, x19, x44);
  let mut x59: u64 = 0;
  let mut x60: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x59, &mut x60, x58, x21, x46);
  let mut x61: u64 = 0;
  let mut x62: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x61, &mut x62, x60, x23, x48);
  let mut x63: u64 = 0;
  let mut x64: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x63, &mut x64, x62, x25, x50);
  let mut x65: u64 = 0;
  let mut x66: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x65, &mut x66, x64, x27, x52);
  let mut x67: u64 = 0;
  let mut x68: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x67, &mut x68, x66, x29, x54);
  let mut x69: u64 = 0;
  let mut x70: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x69, &mut x70, x1, (arg2[5]));
  let mut x71: u64 = 0;
  let mut x72: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x71, &mut x72, x1, (arg2[4]));
  let mut x73: u64 = 0;
  let mut x74: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x73, &mut x74, x1, (arg2[3]));
  let mut x75: u64 = 0;
  let mut x76: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x75, &mut x76, x1, (arg2[2]));
  let mut x77: u64 = 0;
  let mut x78: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x77, &mut x78, x1, (arg2[1]));
  let mut x79: u64 = 0;
  let mut x80: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x79, &mut x80, x1, (arg2[0]));
  let mut x81: u64 = 0;
  let mut x82: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x81, &mut x82, 0x0, x80, x77);
  let mut x83: u64 = 0;
  let mut x84: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x83, &mut x84, x82, x78, x75);
  let mut x85: u64 = 0;
  let mut x86: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x85, &mut x86, x84, x76, x73);
  let mut x87: u64 = 0;
  let mut x88: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x87, &mut x88, x86, x74, x71);
  let mut x89: u64 = 0;
  let mut x90: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x89, &mut x90, x88, x72, x69);
  let x91: u64 = ((x90 as u64) + x70);
  let mut x92: u64 = 0;
  let mut x93: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x92, &mut x93, 0x0, x57, x79);
  let mut x94: u64 = 0;
  let mut x95: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x94, &mut x95, x93, x59, x81);
  let mut x96: u64 = 0;
  let mut x97: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x96, &mut x97, x95, x61, x83);
  let mut x98: u64 = 0;
  let mut x99: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x98, &mut x99, x97, x63, x85);
  let mut x100: u64 = 0;
  let mut x101: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x100, &mut x101, x99, x65, x87);
  let mut x102: u64 = 0;
  let mut x103: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x102, &mut x103, x101, x67, x89);
  let mut x104: u64 = 0;
  let mut x105: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x104, &mut x105, x103, (x68 as u64), x91);
  let mut x106: u64 = 0;
  let mut x107: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x106, &mut x107, x92, 0x6ed46089e88fdc45);
  let mut x108: u64 = 0;
  let mut x109: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x108, &mut x109, x106, 0xffffffffffffffff);
  let mut x110: u64 = 0;
  let mut x111: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x110, &mut x111, x106, 0xffffffffffffffff);
  let mut x112: u64 = 0;
  let mut x113: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x112, &mut x113, x106, 0xffffffffffffffff);
  let mut x114: u64 = 0;
  let mut x115: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x114, &mut x115, x106, 0xc7634d81f4372ddf);
  let mut x116: u64 = 0;
  let mut x117: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x116, &mut x117, x106, 0x581a0db248b0a77a);
  let mut x118: u64 = 0;
  let mut x119: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x118, &mut x119, x106, 0xecec196accc52973);
  let mut x120: u64 = 0;
  let mut x121: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x120, &mut x121, 0x0, x119, x116);
  let mut x122: u64 = 0;
  let mut x123: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x122, &mut x123, x121, x117, x114);
  let mut x124: u64 = 0;
  let mut x125: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x124, &mut x125, x123, x115, x112);
  let mut x126: u64 = 0;
  let mut x127: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x126, &mut x127, x125, x113, x110);
  let mut x128: u64 = 0;
  let mut x129: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x128, &mut x129, x127, x111, x108);
  let x130: u64 = ((x129 as u64) + x109);
  let mut x131: u64 = 0;
  let mut x132: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x131, &mut x132, 0x0, x92, x118);
  let mut x133: u64 = 0;
  let mut x134: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x133, &mut x134, x132, x94, x120);
  let mut x135: u64 = 0;
  let mut x136: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x135, &mut x136, x134, x96, x122);
  let mut x137: u64 = 0;
  let mut x138: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x137, &mut x138, x136, x98, x124);
  let mut x139: u64 = 0;
  let mut x140: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x139, &mut x140, x138, x100, x126);
  let mut x141: u64 = 0;
  let mut x142: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x141, &mut x142, x140, x102, x128);
  let mut x143: u64 = 0;
  let mut x144: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x143, &mut x144, x142, x104, x130);
  let x145: u64 = ((x144 as u64) + (x105 as u64));
  let mut x146: u64 = 0;
  let mut x147: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x146, &mut x147, x2, (arg2[5]));
  let mut x148: u64 = 0;
  let mut x149: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x148, &mut x149, x2, (arg2[4]));
  let mut x150: u64 = 0;
  let mut x151: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x150, &mut x151, x2, (arg2[3]));
  let mut x152: u64 = 0;
  let mut x153: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x152, &mut x153, x2, (arg2[2]));
  let mut x154: u64 = 0;
  let mut x155: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x154, &mut x155, x2, (arg2[1]));
  let mut x156: u64 = 0;
  let mut x157: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x156, &mut x157, x2, (arg2[0]));
  let mut x158: u64 = 0;
  let mut x159: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x158, &mut x159, 0x0, x157, x154);
  let mut x160: u64 = 0;
  let mut x161: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x160, &mut x161, x159, x155, x152);
  let mut x162: u64 = 0;
  let mut x163: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x162, &mut x163, x161, x153, x150);
  let mut x164: u64 = 0;
  let mut x165: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x164, &mut x165, x163, x151, x148);
  let mut x166: u64 = 0;
  let mut x167: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x166, &mut x167, x165, x149, x146);
  let x168: u64 = ((x167 as u64) + x147);
  let mut x169: u64 = 0;
  let mut x170: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x169, &mut x170, 0x0, x133, x156);
  let mut x171: u64 = 0;
  let mut x172: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x171, &mut x172, x170, x135, x158);
  let mut x173: u64 = 0;
  let mut x174: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x173, &mut x174, x172, x137, x160);
  let mut x175: u64 = 0;
  let mut x176: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x175, &mut x176, x174, x139, x162);
  let mut x177: u64 = 0;
  let mut x178: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x177, &mut x178, x176, x141, x164);
  let mut x179: u64 = 0;
  let mut x180: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x179, &mut x180, x178, x143, x166);
  let mut x181: u64 = 0;
  let mut x182: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x181, &mut x182, x180, x145, x168);
  let mut x183: u64 = 0;
  let mut x184: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x183, &mut x184, x169, 0x6ed46089e88fdc45);
  let mut x185: u64 = 0;
  let mut x186: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x185, &mut x186, x183, 0xffffffffffffffff);
  let mut x187: u64 = 0;
  let mut x188: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x187, &mut x188, x183, 0xffffffffffffffff);
  let mut x189: u64 = 0;
  let mut x190: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x189, &mut x190, x183, 0xffffffffffffffff);
  let mut x191: u64 = 0;
  let mut x192: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x191, &mut x192, x183, 0xc7634d81f4372ddf);
  let mut x193: u64 = 0;
  let mut x194: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x193, &mut x194, x183, 0x581a0db248b0a77a);
  let mut x195: u64 = 0;
  let mut x196: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x195, &mut x196, x183, 0xecec196accc52973);
  let mut x197: u64 = 0;
  let mut x198: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x197, &mut x198, 0x0, x196, x193);
  let mut x199: u64 = 0;
  let mut x200: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x199, &mut x200, x198, x194, x191);
  let mut x201: u64 = 0;
  let mut x202: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x201, &mut x202, x200, x192, x189);
  let mut x203: u64 = 0;
  let mut x204: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x203, &mut x204, x202, x190, x187);
  let mut x205: u64 = 0;
  let mut x206: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x205, &mut x206, x204, x188, x185);
  let x207: u64 = ((x206 as u64) + x186);
  let mut x208: u64 = 0;
  let mut x209: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x208, &mut x209, 0x0, x169, x195);
  let mut x210: u64 = 0;
  let mut x211: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x210, &mut x211, x209, x171, x197);
  let mut x212: u64 = 0;
  let mut x213: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x212, &mut x213, x211, x173, x199);
  let mut x214: u64 = 0;
  let mut x215: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x214, &mut x215, x213, x175, x201);
  let mut x216: u64 = 0;
  let mut x217: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x216, &mut x217, x215, x177, x203);
  let mut x218: u64 = 0;
  let mut x219: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x218, &mut x219, x217, x179, x205);
  let mut x220: u64 = 0;
  let mut x221: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x220, &mut x221, x219, x181, x207);
  let x222: u64 = ((x221 as u64) + (x182 as u64));
  let mut x223: u64 = 0;
  let mut x224: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x223, &mut x224, x3, (arg2[5]));
  let mut x225: u64 = 0;
  let mut x226: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x225, &mut x226, x3, (arg2[4]));
  let mut x227: u64 = 0;
  let mut x228: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x227, &mut x228, x3, (arg2[3]));
  let mut x229: u64 = 0;
  let mut x230: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x229, &mut x230, x3, (arg2[2]));
  let mut x231: u64 = 0;
  let mut x232: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x231, &mut x232, x3, (arg2[1]));
  let mut x233: u64 = 0;
  let mut x234: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x233, &mut x234, x3, (arg2[0]));
  let mut x235: u64 = 0;
  let mut x236: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x235, &mut x236, 0x0, x234, x231);
  let mut x237: u64 = 0;
  let mut x238: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x237, &mut x238, x236, x232, x229);
  let mut x239: u64 = 0;
  let mut x240: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x239, &mut x240, x238, x230, x227);
  let mut x241: u64 = 0;
  let mut x242: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x241, &mut x242, x240, x228, x225);
  let mut x243: u64 = 0;
  let mut x244: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x243, &mut x244, x242, x226, x223);
  let x245: u64 = ((x244 as u64) + x224);
  let mut x246: u64 = 0;
  let mut x247: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x246, &mut x247, 0x0, x210, x233);
  let mut x248: u64 = 0;
  let mut x249: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x248, &mut x249, x247, x212, x235);
  let mut x250: u64 = 0;
  let mut x251: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x250, &mut x251, x249, x214, x237);
  let mut x252: u64 = 0;
  let mut x253: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x252, &mut x253, x251, x216, x239);
  let mut x254: u64 = 0;
  let mut x255: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x254, &mut x255, x253, x218, x241);
  let mut x256: u64 = 0;
  let mut x257: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x256, &mut x257, x255, x220, x243);
  let mut x258: u64 = 0;
  let mut x259: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x258, &mut x259, x257, x222, x245);
  let mut x260: u64 = 0;
  let mut x261: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x260, &mut x261, x246, 0x6ed46089e88fdc45);
  let mut x262: u64 = 0;
  let mut x263: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x262, &mut x263, x260, 0xffffffffffffffff);
  let mut x264: u64 = 0;
  let mut x265: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x264, &mut x265, x260, 0xffffffffffffffff);
  let mut x266: u64 = 0;
  let mut x267: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x266, &mut x267, x260, 0xffffffffffffffff);
  let mut x268: u64 = 0;
  let mut x269: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x268, &mut x269, x260, 0xc7634d81f4372ddf);
  let mut x270: u64 = 0;
  let mut x271: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x270, &mut x271, x260, 0x581a0db248b0a77a);
  let mut x272: u64 = 0;
  let mut x273: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x272, &mut x273, x260, 0xecec196accc52973);
  let mut x274: u64 = 0;
  let mut x275: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x274, &mut x275, 0x0, x273, x270);
  let mut x276: u64 = 0;
  let mut x277: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x276, &mut x277, x275, x271, x268);
  let mut x278: u64 = 0;
  let mut x279: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x278, &mut x279, x277, x269, x266);
  let mut x280: u64 = 0;
  let mut x281: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x280, &mut x281, x279, x267, x264);
  let mut x282: u64 = 0;
  let mut x283: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x282, &mut x283, x281, x265, x262);
  let x284: u64 = ((x283 as u64) + x263);
  let mut x285: u64 = 0;
  let mut x286: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x285, &mut x286, 0x0, x246, x272);
  let mut x287: u64 = 0;
  let mut x288: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x287, &mut x288, x286, x248, x274);
  let mut x289: u64 = 0;
  let mut x290: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x289, &mut x290, x288, x250, x276);
  let mut x291: u64 = 0;
  let mut x292: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x291, &mut x292, x290, x252, x278);
  let mut x293: u64 = 0;
  let mut x294: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x293, &mut x294, x292, x254, x280);
  let mut x295: u64 = 0;
  let mut x296: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x295, &mut x296, x294, x256, x282);
  let mut x297: u64 = 0;
  let mut x298: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x297, &mut x298, x296, x258, x284);
  let x299: u64 = ((x298 as u64) + (x259 as u64));
  let mut x300: u64 = 0;
  let mut x301: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x300, &mut x301, x4, (arg2[5]));
  let mut x302: u64 = 0;
  let mut x303: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x302, &mut x303, x4, (arg2[4]));
  let mut x304: u64 = 0;
  let mut x305: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x304, &mut x305, x4, (arg2[3]));
  let mut x306: u64 = 0;
  let mut x307: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x306, &mut x307, x4, (arg2[2]));
  let mut x308: u64 = 0;
  let mut x309: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x308, &mut x309, x4, (arg2[1]));
  let mut x310: u64 = 0;
  let mut x311: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x310, &mut x311, x4, (arg2[0]));
  let mut x312: u64 = 0;
  let mut x313: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x312, &mut x313, 0x0, x311, x308);
  let mut x314: u64 = 0;
  let mut x315: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x314, &mut x315, x313, x309, x306);
  let mut x316: u64 = 0;
  let mut x317: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x316, &mut x317, x315, x307, x304);
  let mut x318: u64 = 0;
  let mut x319: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x318, &mut x319, x317, x305, x302);
  let mut x320: u64 = 0;
  let mut x321: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x320, &mut x321, x319, x303, x300);
  let x322: u64 = ((x321 as u64) + x301);
  let mut x323: u64 = 0;
  let mut x324: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x323, &mut x324, 0x0, x287, x310);
  let mut x325: u64 = 0;
  let mut x326: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x325, &mut x326, x324, x289, x312);
  let mut x327: u64 = 0;
  let mut x328: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x327, &mut x328, x326, x291, x314);
  let mut x329: u64 = 0;
  let mut x330: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x329, &mut x330, x328, x293, x316);
  let mut x331: u64 = 0;
  let mut x332: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x331, &mut x332, x330, x295, x318);
  let mut x333: u64 = 0;
  let mut x334: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x333, &mut x334, x332, x297, x320);
  let mut x335: u64 = 0;
  let mut x336: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x335, &mut x336, x334, x299, x322);
  let mut x337: u64 = 0;
  let mut x338: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x337, &mut x338, x323, 0x6ed46089e88fdc45);
  let mut x339: u64 = 0;
  let mut x340: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x339, &mut x340, x337, 0xffffffffffffffff);
  let mut x341: u64 = 0;
  let mut x342: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x341, &mut x342, x337, 0xffffffffffffffff);
  let mut x343: u64 = 0;
  let mut x344: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x343, &mut x344, x337, 0xffffffffffffffff);
  let mut x345: u64 = 0;
  let mut x346: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x345, &mut x346, x337, 0xc7634d81f4372ddf);
  let mut x347: u64 = 0;
  let mut x348: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x347, &mut x348, x337, 0x581a0db248b0a77a);
  let mut x349: u64 = 0;
  let mut x350: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x349, &mut x350, x337, 0xecec196accc52973);
  let mut x351: u64 = 0;
  let mut x352: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x351, &mut x352, 0x0, x350, x347);
  let mut x353: u64 = 0;
  let mut x354: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x353, &mut x354, x352, x348, x345);
  let mut x355: u64 = 0;
  let mut x356: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x355, &mut x356, x354, x346, x343);
  let mut x357: u64 = 0;
  let mut x358: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x357, &mut x358, x356, x344, x341);
  let mut x359: u64 = 0;
  let mut x360: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x359, &mut x360, x358, x342, x339);
  let x361: u64 = ((x360 as u64) + x340);
  let mut x362: u64 = 0;
  let mut x363: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x362, &mut x363, 0x0, x323, x349);
  let mut x364: u64 = 0;
  let mut x365: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x364, &mut x365, x363, x325, x351);
  let mut x366: u64 = 0;
  let mut x367: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x366, &mut x367, x365, x327, x353);
  let mut x368: u64 = 0;
  let mut x369: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x368, &mut x369, x367, x329, x355);
  let mut x370: u64 = 0;
  let mut x371: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x370, &mut x371, x369, x331, x357);
  let mut x372: u64 = 0;
  let mut x373: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x372, &mut x373, x371, x333, x359);
  let mut x374: u64 = 0;
  let mut x375: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x374, &mut x375, x373, x335, x361);
  let x376: u64 = ((x375 as u64) + (x336 as u64));
  let mut x377: u64 = 0;
  let mut x378: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x377, &mut x378, x5, (arg2[5]));
  let mut x379: u64 = 0;
  let mut x380: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x379, &mut x380, x5, (arg2[4]));
  let mut x381: u64 = 0;
  let mut x382: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x381, &mut x382, x5, (arg2[3]));
  let mut x383: u64 = 0;
  let mut x384: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x383, &mut x384, x5, (arg2[2]));
  let mut x385: u64 = 0;
  let mut x386: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x385, &mut x386, x5, (arg2[1]));
  let mut x387: u64 = 0;
  let mut x388: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x387, &mut x388, x5, (arg2[0]));
  let mut x389: u64 = 0;
  let mut x390: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x389, &mut x390, 0x0, x388, x385);
  let mut x391: u64 = 0;
  let mut x392: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x391, &mut x392, x390, x386, x383);
  let mut x393: u64 = 0;
  let mut x394: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x393, &mut x394, x392, x384, x381);
  let mut x395: u64 = 0;
  let mut x396: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x395, &mut x396, x394, x382, x379);
  let mut x397: u64 = 0;
  let mut x398: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x397, &mut x398, x396, x380, x377);
  let x399: u64 = ((x398 as u64) + x378);
  let mut x400: u64 = 0;
  let mut x401: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x400, &mut x401, 0x0, x364, x387);
  let mut x402: u64 = 0;
  let mut x403: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x402, &mut x403, x401, x366, x389);
  let mut x404: u64 = 0;
  let mut x405: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x404, &mut x405, x403, x368, x391);
  let mut x406: u64 = 0;
  let mut x407: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x406, &mut x407, x405, x370, x393);
  let mut x408: u64 = 0;
  let mut x409: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x408, &mut x409, x407, x372, x395);
  let mut x410: u64 = 0;
  let mut x411: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x410, &mut x411, x409, x374, x397);
  let mut x412: u64 = 0;
  let mut x413: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x412, &mut x413, x411, x376, x399);
  let mut x414: u64 = 0;
  let mut x415: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x414, &mut x415, x400, 0x6ed46089e88fdc45);
  let mut x416: u64 = 0;
  let mut x417: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x416, &mut x417, x414, 0xffffffffffffffff);
  let mut x418: u64 = 0;
  let mut x419: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x418, &mut x419, x414, 0xffffffffffffffff);
  let mut x420: u64 = 0;
  let mut x421: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x420, &mut x421, x414, 0xffffffffffffffff);
  let mut x422: u64 = 0;
  let mut x423: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x422, &mut x423, x414, 0xc7634d81f4372ddf);
  let mut x424: u64 = 0;
  let mut x425: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x424, &mut x425, x414, 0x581a0db248b0a77a);
  let mut x426: u64 = 0;
  let mut x427: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x426, &mut x427, x414, 0xecec196accc52973);
  let mut x428: u64 = 0;
  let mut x429: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x428, &mut x429, 0x0, x427, x424);
  let mut x430: u64 = 0;
  let mut x431: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x430, &mut x431, x429, x425, x422);
  let mut x432: u64 = 0;
  let mut x433: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x432, &mut x433, x431, x423, x420);
  let mut x434: u64 = 0;
  let mut x435: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x434, &mut x435, x433, x421, x418);
  let mut x436: u64 = 0;
  let mut x437: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x436, &mut x437, x435, x419, x416);
  let x438: u64 = ((x437 as u64) + x417);
  let mut x439: u64 = 0;
  let mut x440: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x439, &mut x440, 0x0, x400, x426);
  let mut x441: u64 = 0;
  let mut x442: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x441, &mut x442, x440, x402, x428);
  let mut x443: u64 = 0;
  let mut x444: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x443, &mut x444, x442, x404, x430);
  let mut x445: u64 = 0;
  let mut x446: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x445, &mut x446, x444, x406, x432);
  let mut x447: u64 = 0;
  let mut x448: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x447, &mut x448, x446, x408, x434);
  let mut x449: u64 = 0;
  let mut x450: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x449, &mut x450, x448, x410, x436);
  let mut x451: u64 = 0;
  let mut x452: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x451, &mut x452, x450, x412, x438);
  let x453: u64 = ((x452 as u64) + (x413 as u64));
  let mut x454: u64 = 0;
  let mut x455: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x454, &mut x455, 0x0, x441, 0xecec196accc52973);
  let mut x456: u64 = 0;
  let mut x457: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x456, &mut x457, x455, x443, 0x581a0db248b0a77a);
  let mut x458: u64 = 0;
  let mut x459: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x458, &mut x459, x457, x445, 0xc7634d81f4372ddf);
  let mut x460: u64 = 0;
  let mut x461: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x460, &mut x461, x459, x447, 0xffffffffffffffff);
  let mut x462: u64 = 0;
  let mut x463: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x462, &mut x463, x461, x449, 0xffffffffffffffff);
  let mut x464: u64 = 0;
  let mut x465: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x464, &mut x465, x463, x451, 0xffffffffffffffff);
  let mut x466: u64 = 0;
  let mut x467: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x466, &mut x467, x465, x453, (0x0 as u64));
  let mut x468: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x468, x467, x454, x441);
  let mut x469: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x469, x467, x456, x443);
  let mut x470: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x470, x467, x458, x445);
  let mut x471: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x471, x467, x460, x447);
  let mut x472: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x472, x467, x462, x449);
  let mut x473: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x473, x467, x464, x451);
  out1[0] = x468;
  out1[1] = x469;
  out1[2] = x470;
  out1[3] = x471;
  out1[4] = x472;
  out1[5] = x473;
}

/// The function fiat_p384_scalar_square squares a field element in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg1)) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub fn fiat_p384_scalar_square(out1: &mut fiat_p384_scalar_montgomery_domain_field_element, arg1: &fiat_p384_scalar_montgomery_domain_field_element) -> () {
  let x1: u64 = (arg1[1]);
  let x2: u64 = (arg1[2]);
  let x3: u64 = (arg1[3]);
  let x4: u64 = (arg1[4]);
  let x5: u64 = (arg1[5]);
  let x6: u64 = (arg1[0]);
  let mut x7: u64 = 0;
  let mut x8: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x7, &mut x8, x6, (arg1[5]));
  let mut x9: u64 = 0;
  let mut x10: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x9, &mut x10, x6, (arg1[4]));
  let mut x11: u64 = 0;
  let mut x12: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x11, &mut x12, x6, (arg1[3]));
  let mut x13: u64 = 0;
  let mut x14: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x13, &mut x14, x6, (arg1[2]));
  let mut x15: u64 = 0;
  let mut x16: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x15, &mut x16, x6, (arg1[1]));
  let mut x17: u64 = 0;
  let mut x18: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x17, &mut x18, x6, (arg1[0]));
  let mut x19: u64 = 0;
  let mut x20: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x19, &mut x20, 0x0, x18, x15);
  let mut x21: u64 = 0;
  let mut x22: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x21, &mut x22, x20, x16, x13);
  let mut x23: u64 = 0;
  let mut x24: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x23, &mut x24, x22, x14, x11);
  let mut x25: u64 = 0;
  let mut x26: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x25, &mut x26, x24, x12, x9);
  let mut x27: u64 = 0;
  let mut x28: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x27, &mut x28, x26, x10, x7);
  let x29: u64 = ((x28 as u64) + x8);
  let mut x30: u64 = 0;
  let mut x31: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x30, &mut x31, x17, 0x6ed46089e88fdc45);
  let mut x32: u64 = 0;
  let mut x33: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x32, &mut x33, x30, 0xffffffffffffffff);
  let mut x34: u64 = 0;
  let mut x35: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x34, &mut x35, x30, 0xffffffffffffffff);
  let mut x36: u64 = 0;
  let mut x37: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x36, &mut x37, x30, 0xffffffffffffffff);
  let mut x38: u64 = 0;
  let mut x39: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x38, &mut x39, x30, 0xc7634d81f4372ddf);
  let mut x40: u64 = 0;
  let mut x41: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x40, &mut x41, x30, 0x581a0db248b0a77a);
  let mut x42: u64 = 0;
  let mut x43: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x42, &mut x43, x30, 0xecec196accc52973);
  let mut x44: u64 = 0;
  let mut x45: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x44, &mut x45, 0x0, x43, x40);
  let mut x46: u64 = 0;
  let mut x47: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x46, &mut x47, x45, x41, x38);
  let mut x48: u64 = 0;
  let mut x49: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x48, &mut x49, x47, x39, x36);
  let mut x50: u64 = 0;
  let mut x51: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x50, &mut x51, x49, x37, x34);
  let mut x52: u64 = 0;
  let mut x53: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x52, &mut x53, x51, x35, x32);
  let x54: u64 = ((x53 as u64) + x33);
  let mut x55: u64 = 0;
  let mut x56: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x55, &mut x56, 0x0, x17, x42);
  let mut x57: u64 = 0;
  let mut x58: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x57, &mut x58, x56, x19, x44);
  let mut x59: u64 = 0;
  let mut x60: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x59, &mut x60, x58, x21, x46);
  let mut x61: u64 = 0;
  let mut x62: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x61, &mut x62, x60, x23, x48);
  let mut x63: u64 = 0;
  let mut x64: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x63, &mut x64, x62, x25, x50);
  let mut x65: u64 = 0;
  let mut x66: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x65, &mut x66, x64, x27, x52);
  let mut x67: u64 = 0;
  let mut x68: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x67, &mut x68, x66, x29, x54);
  let mut x69: u64 = 0;
  let mut x70: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x69, &mut x70, x1, (arg1[5]));
  let mut x71: u64 = 0;
  let mut x72: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x71, &mut x72, x1, (arg1[4]));
  let mut x73: u64 = 0;
  let mut x74: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x73, &mut x74, x1, (arg1[3]));
  let mut x75: u64 = 0;
  let mut x76: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x75, &mut x76, x1, (arg1[2]));
  let mut x77: u64 = 0;
  let mut x78: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x77, &mut x78, x1, (arg1[1]));
  let mut x79: u64 = 0;
  let mut x80: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x79, &mut x80, x1, (arg1[0]));
  let mut x81: u64 = 0;
  let mut x82: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x81, &mut x82, 0x0, x80, x77);
  let mut x83: u64 = 0;
  let mut x84: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x83, &mut x84, x82, x78, x75);
  let mut x85: u64 = 0;
  let mut x86: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x85, &mut x86, x84, x76, x73);
  let mut x87: u64 = 0;
  let mut x88: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x87, &mut x88, x86, x74, x71);
  let mut x89: u64 = 0;
  let mut x90: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x89, &mut x90, x88, x72, x69);
  let x91: u64 = ((x90 as u64) + x70);
  let mut x92: u64 = 0;
  let mut x93: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x92, &mut x93, 0x0, x57, x79);
  let mut x94: u64 = 0;
  let mut x95: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x94, &mut x95, x93, x59, x81);
  let mut x96: u64 = 0;
  let mut x97: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x96, &mut x97, x95, x61, x83);
  let mut x98: u64 = 0;
  let mut x99: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x98, &mut x99, x97, x63, x85);
  let mut x100: u64 = 0;
  let mut x101: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x100, &mut x101, x99, x65, x87);
  let mut x102: u64 = 0;
  let mut x103: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x102, &mut x103, x101, x67, x89);
  let mut x104: u64 = 0;
  let mut x105: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x104, &mut x105, x103, (x68 as u64), x91);
  let mut x106: u64 = 0;
  let mut x107: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x106, &mut x107, x92, 0x6ed46089e88fdc45);
  let mut x108: u64 = 0;
  let mut x109: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x108, &mut x109, x106, 0xffffffffffffffff);
  let mut x110: u64 = 0;
  let mut x111: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x110, &mut x111, x106, 0xffffffffffffffff);
  let mut x112: u64 = 0;
  let mut x113: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x112, &mut x113, x106, 0xffffffffffffffff);
  let mut x114: u64 = 0;
  let mut x115: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x114, &mut x115, x106, 0xc7634d81f4372ddf);
  let mut x116: u64 = 0;
  let mut x117: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x116, &mut x117, x106, 0x581a0db248b0a77a);
  let mut x118: u64 = 0;
  let mut x119: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x118, &mut x119, x106, 0xecec196accc52973);
  let mut x120: u64 = 0;
  let mut x121: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x120, &mut x121, 0x0, x119, x116);
  let mut x122: u64 = 0;
  let mut x123: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x122, &mut x123, x121, x117, x114);
  let mut x124: u64 = 0;
  let mut x125: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x124, &mut x125, x123, x115, x112);
  let mut x126: u64 = 0;
  let mut x127: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x126, &mut x127, x125, x113, x110);
  let mut x128: u64 = 0;
  let mut x129: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x128, &mut x129, x127, x111, x108);
  let x130: u64 = ((x129 as u64) + x109);
  let mut x131: u64 = 0;
  let mut x132: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x131, &mut x132, 0x0, x92, x118);
  let mut x133: u64 = 0;
  let mut x134: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x133, &mut x134, x132, x94, x120);
  let mut x135: u64 = 0;
  let mut x136: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x135, &mut x136, x134, x96, x122);
  let mut x137: u64 = 0;
  let mut x138: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x137, &mut x138, x136, x98, x124);
  let mut x139: u64 = 0;
  let mut x140: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x139, &mut x140, x138, x100, x126);
  let mut x141: u64 = 0;
  let mut x142: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x141, &mut x142, x140, x102, x128);
  let mut x143: u64 = 0;
  let mut x144: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x143, &mut x144, x142, x104, x130);
  let x145: u64 = ((x144 as u64) + (x105 as u64));
  let mut x146: u64 = 0;
  let mut x147: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x146, &mut x147, x2, (arg1[5]));
  let mut x148: u64 = 0;
  let mut x149: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x148, &mut x149, x2, (arg1[4]));
  let mut x150: u64 = 0;
  let mut x151: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x150, &mut x151, x2, (arg1[3]));
  let mut x152: u64 = 0;
  let mut x153: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x152, &mut x153, x2, (arg1[2]));
  let mut x154: u64 = 0;
  let mut x155: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x154, &mut x155, x2, (arg1[1]));
  let mut x156: u64 = 0;
  let mut x157: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x156, &mut x157, x2, (arg1[0]));
  let mut x158: u64 = 0;
  let mut x159: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x158, &mut x159, 0x0, x157, x154);
  let mut x160: u64 = 0;
  let mut x161: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x160, &mut x161, x159, x155, x152);
  let mut x162: u64 = 0;
  let mut x163: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x162, &mut x163, x161, x153, x150);
  let mut x164: u64 = 0;
  let mut x165: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x164, &mut x165, x163, x151, x148);
  let mut x166: u64 = 0;
  let mut x167: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x166, &mut x167, x165, x149, x146);
  let x168: u64 = ((x167 as u64) + x147);
  let mut x169: u64 = 0;
  let mut x170: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x169, &mut x170, 0x0, x133, x156);
  let mut x171: u64 = 0;
  let mut x172: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x171, &mut x172, x170, x135, x158);
  let mut x173: u64 = 0;
  let mut x174: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x173, &mut x174, x172, x137, x160);
  let mut x175: u64 = 0;
  let mut x176: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x175, &mut x176, x174, x139, x162);
  let mut x177: u64 = 0;
  let mut x178: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x177, &mut x178, x176, x141, x164);
  let mut x179: u64 = 0;
  let mut x180: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x179, &mut x180, x178, x143, x166);
  let mut x181: u64 = 0;
  let mut x182: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x181, &mut x182, x180, x145, x168);
  let mut x183: u64 = 0;
  let mut x184: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x183, &mut x184, x169, 0x6ed46089e88fdc45);
  let mut x185: u64 = 0;
  let mut x186: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x185, &mut x186, x183, 0xffffffffffffffff);
  let mut x187: u64 = 0;
  let mut x188: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x187, &mut x188, x183, 0xffffffffffffffff);
  let mut x189: u64 = 0;
  let mut x190: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x189, &mut x190, x183, 0xffffffffffffffff);
  let mut x191: u64 = 0;
  let mut x192: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x191, &mut x192, x183, 0xc7634d81f4372ddf);
  let mut x193: u64 = 0;
  let mut x194: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x193, &mut x194, x183, 0x581a0db248b0a77a);
  let mut x195: u64 = 0;
  let mut x196: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x195, &mut x196, x183, 0xecec196accc52973);
  let mut x197: u64 = 0;
  let mut x198: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x197, &mut x198, 0x0, x196, x193);
  let mut x199: u64 = 0;
  let mut x200: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x199, &mut x200, x198, x194, x191);
  let mut x201: u64 = 0;
  let mut x202: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x201, &mut x202, x200, x192, x189);
  let mut x203: u64 = 0;
  let mut x204: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x203, &mut x204, x202, x190, x187);
  let mut x205: u64 = 0;
  let mut x206: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x205, &mut x206, x204, x188, x185);
  let x207: u64 = ((x206 as u64) + x186);
  let mut x208: u64 = 0;
  let mut x209: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x208, &mut x209, 0x0, x169, x195);
  let mut x210: u64 = 0;
  let mut x211: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x210, &mut x211, x209, x171, x197);
  let mut x212: u64 = 0;
  let mut x213: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x212, &mut x213, x211, x173, x199);
  let mut x214: u64 = 0;
  let mut x215: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x214, &mut x215, x213, x175, x201);
  let mut x216: u64 = 0;
  let mut x217: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x216, &mut x217, x215, x177, x203);
  let mut x218: u64 = 0;
  let mut x219: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x218, &mut x219, x217, x179, x205);
  let mut x220: u64 = 0;
  let mut x221: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x220, &mut x221, x219, x181, x207);
  let x222: u64 = ((x221 as u64) + (x182 as u64));
  let mut x223: u64 = 0;
  let mut x224: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x223, &mut x224, x3, (arg1[5]));
  let mut x225: u64 = 0;
  let mut x226: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x225, &mut x226, x3, (arg1[4]));
  let mut x227: u64 = 0;
  let mut x228: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x227, &mut x228, x3, (arg1[3]));
  let mut x229: u64 = 0;
  let mut x230: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x229, &mut x230, x3, (arg1[2]));
  let mut x231: u64 = 0;
  let mut x232: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x231, &mut x232, x3, (arg1[1]));
  let mut x233: u64 = 0;
  let mut x234: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x233, &mut x234, x3, (arg1[0]));
  let mut x235: u64 = 0;
  let mut x236: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x235, &mut x236, 0x0, x234, x231);
  let mut x237: u64 = 0;
  let mut x238: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x237, &mut x238, x236, x232, x229);
  let mut x239: u64 = 0;
  let mut x240: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x239, &mut x240, x238, x230, x227);
  let mut x241: u64 = 0;
  let mut x242: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x241, &mut x242, x240, x228, x225);
  let mut x243: u64 = 0;
  let mut x244: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x243, &mut x244, x242, x226, x223);
  let x245: u64 = ((x244 as u64) + x224);
  let mut x246: u64 = 0;
  let mut x247: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x246, &mut x247, 0x0, x210, x233);
  let mut x248: u64 = 0;
  let mut x249: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x248, &mut x249, x247, x212, x235);
  let mut x250: u64 = 0;
  let mut x251: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x250, &mut x251, x249, x214, x237);
  let mut x252: u64 = 0;
  let mut x253: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x252, &mut x253, x251, x216, x239);
  let mut x254: u64 = 0;
  let mut x255: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x254, &mut x255, x253, x218, x241);
  let mut x256: u64 = 0;
  let mut x257: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x256, &mut x257, x255, x220, x243);
  let mut x258: u64 = 0;
  let mut x259: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x258, &mut x259, x257, x222, x245);
  let mut x260: u64 = 0;
  let mut x261: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x260, &mut x261, x246, 0x6ed46089e88fdc45);
  let mut x262: u64 = 0;
  let mut x263: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x262, &mut x263, x260, 0xffffffffffffffff);
  let mut x264: u64 = 0;
  let mut x265: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x264, &mut x265, x260, 0xffffffffffffffff);
  let mut x266: u64 = 0;
  let mut x267: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x266, &mut x267, x260, 0xffffffffffffffff);
  let mut x268: u64 = 0;
  let mut x269: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x268, &mut x269, x260, 0xc7634d81f4372ddf);
  let mut x270: u64 = 0;
  let mut x271: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x270, &mut x271, x260, 0x581a0db248b0a77a);
  let mut x272: u64 = 0;
  let mut x273: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x272, &mut x273, x260, 0xecec196accc52973);
  let mut x274: u64 = 0;
  let mut x275: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x274, &mut x275, 0x0, x273, x270);
  let mut x276: u64 = 0;
  let mut x277: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x276, &mut x277, x275, x271, x268);
  let mut x278: u64 = 0;
  let mut x279: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x278, &mut x279, x277, x269, x266);
  let mut x280: u64 = 0;
  let mut x281: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x280, &mut x281, x279, x267, x264);
  let mut x282: u64 = 0;
  let mut x283: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x282, &mut x283, x281, x265, x262);
  let x284: u64 = ((x283 as u64) + x263);
  let mut x285: u64 = 0;
  let mut x286: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x285, &mut x286, 0x0, x246, x272);
  let mut x287: u64 = 0;
  let mut x288: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x287, &mut x288, x286, x248, x274);
  let mut x289: u64 = 0;
  let mut x290: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x289, &mut x290, x288, x250, x276);
  let mut x291: u64 = 0;
  let mut x292: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x291, &mut x292, x290, x252, x278);
  let mut x293: u64 = 0;
  let mut x294: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x293, &mut x294, x292, x254, x280);
  let mut x295: u64 = 0;
  let mut x296: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x295, &mut x296, x294, x256, x282);
  let mut x297: u64 = 0;
  let mut x298: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x297, &mut x298, x296, x258, x284);
  let x299: u64 = ((x298 as u64) + (x259 as u64));
  let mut x300: u64 = 0;
  let mut x301: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x300, &mut x301, x4, (arg1[5]));
  let mut x302: u64 = 0;
  let mut x303: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x302, &mut x303, x4, (arg1[4]));
  let mut x304: u64 = 0;
  let mut x305: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x304, &mut x305, x4, (arg1[3]));
  let mut x306: u64 = 0;
  let mut x307: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x306, &mut x307, x4, (arg1[2]));
  let mut x308: u64 = 0;
  let mut x309: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x308, &mut x309, x4, (arg1[1]));
  let mut x310: u64 = 0;
  let mut x311: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x310, &mut x311, x4, (arg1[0]));
  let mut x312: u64 = 0;
  let mut x313: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x312, &mut x313, 0x0, x311, x308);
  let mut x314: u64 = 0;
  let mut x315: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x314, &mut x315, x313, x309, x306);
  let mut x316: u64 = 0;
  let mut x317: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x316, &mut x317, x315, x307, x304);
  let mut x318: u64 = 0;
  let mut x319: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x318, &mut x319, x317, x305, x302);
  let mut x320: u64 = 0;
  let mut x321: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x320, &mut x321, x319, x303, x300);
  let x322: u64 = ((x321 as u64) + x301);
  let mut x323: u64 = 0;
  let mut x324: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x323, &mut x324, 0x0, x287, x310);
  let mut x325: u64 = 0;
  let mut x326: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x325, &mut x326, x324, x289, x312);
  let mut x327: u64 = 0;
  let mut x328: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x327, &mut x328, x326, x291, x314);
  let mut x329: u64 = 0;
  let mut x330: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x329, &mut x330, x328, x293, x316);
  let mut x331: u64 = 0;
  let mut x332: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x331, &mut x332, x330, x295, x318);
  let mut x333: u64 = 0;
  let mut x334: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x333, &mut x334, x332, x297, x320);
  let mut x335: u64 = 0;
  let mut x336: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x335, &mut x336, x334, x299, x322);
  let mut x337: u64 = 0;
  let mut x338: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x337, &mut x338, x323, 0x6ed46089e88fdc45);
  let mut x339: u64 = 0;
  let mut x340: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x339, &mut x340, x337, 0xffffffffffffffff);
  let mut x341: u64 = 0;
  let mut x342: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x341, &mut x342, x337, 0xffffffffffffffff);
  let mut x343: u64 = 0;
  let mut x344: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x343, &mut x344, x337, 0xffffffffffffffff);
  let mut x345: u64 = 0;
  let mut x346: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x345, &mut x346, x337, 0xc7634d81f4372ddf);
  let mut x347: u64 = 0;
  let mut x348: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x347, &mut x348, x337, 0x581a0db248b0a77a);
  let mut x349: u64 = 0;
  let mut x350: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x349, &mut x350, x337, 0xecec196accc52973);
  let mut x351: u64 = 0;
  let mut x352: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x351, &mut x352, 0x0, x350, x347);
  let mut x353: u64 = 0;
  let mut x354: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x353, &mut x354, x352, x348, x345);
  let mut x355: u64 = 0;
  let mut x356: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x355, &mut x356, x354, x346, x343);
  let mut x357: u64 = 0;
  let mut x358: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x357, &mut x358, x356, x344, x341);
  let mut x359: u64 = 0;
  let mut x360: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x359, &mut x360, x358, x342, x339);
  let x361: u64 = ((x360 as u64) + x340);
  let mut x362: u64 = 0;
  let mut x363: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x362, &mut x363, 0x0, x323, x349);
  let mut x364: u64 = 0;
  let mut x365: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x364, &mut x365, x363, x325, x351);
  let mut x366: u64 = 0;
  let mut x367: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x366, &mut x367, x365, x327, x353);
  let mut x368: u64 = 0;
  let mut x369: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x368, &mut x369, x367, x329, x355);
  let mut x370: u64 = 0;
  let mut x371: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x370, &mut x371, x369, x331, x357);
  let mut x372: u64 = 0;
  let mut x373: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x372, &mut x373, x371, x333, x359);
  let mut x374: u64 = 0;
  let mut x375: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x374, &mut x375, x373, x335, x361);
  let x376: u64 = ((x375 as u64) + (x336 as u64));
  let mut x377: u64 = 0;
  let mut x378: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x377, &mut x378, x5, (arg1[5]));
  let mut x379: u64 = 0;
  let mut x380: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x379, &mut x380, x5, (arg1[4]));
  let mut x381: u64 = 0;
  let mut x382: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x381, &mut x382, x5, (arg1[3]));
  let mut x383: u64 = 0;
  let mut x384: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x383, &mut x384, x5, (arg1[2]));
  let mut x385: u64 = 0;
  let mut x386: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x385, &mut x386, x5, (arg1[1]));
  let mut x387: u64 = 0;
  let mut x388: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x387, &mut x388, x5, (arg1[0]));
  let mut x389: u64 = 0;
  let mut x390: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x389, &mut x390, 0x0, x388, x385);
  let mut x391: u64 = 0;
  let mut x392: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x391, &mut x392, x390, x386, x383);
  let mut x393: u64 = 0;
  let mut x394: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x393, &mut x394, x392, x384, x381);
  let mut x395: u64 = 0;
  let mut x396: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x395, &mut x396, x394, x382, x379);
  let mut x397: u64 = 0;
  let mut x398: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x397, &mut x398, x396, x380, x377);
  let x399: u64 = ((x398 as u64) + x378);
  let mut x400: u64 = 0;
  let mut x401: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x400, &mut x401, 0x0, x364, x387);
  let mut x402: u64 = 0;
  let mut x403: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x402, &mut x403, x401, x366, x389);
  let mut x404: u64 = 0;
  let mut x405: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x404, &mut x405, x403, x368, x391);
  let mut x406: u64 = 0;
  let mut x407: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x406, &mut x407, x405, x370, x393);
  let mut x408: u64 = 0;
  let mut x409: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x408, &mut x409, x407, x372, x395);
  let mut x410: u64 = 0;
  let mut x411: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x410, &mut x411, x409, x374, x397);
  let mut x412: u64 = 0;
  let mut x413: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x412, &mut x413, x411, x376, x399);
  let mut x414: u64 = 0;
  let mut x415: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x414, &mut x415, x400, 0x6ed46089e88fdc45);
  let mut x416: u64 = 0;
  let mut x417: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x416, &mut x417, x414, 0xffffffffffffffff);
  let mut x418: u64 = 0;
  let mut x419: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x418, &mut x419, x414, 0xffffffffffffffff);
  let mut x420: u64 = 0;
  let mut x421: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x420, &mut x421, x414, 0xffffffffffffffff);
  let mut x422: u64 = 0;
  let mut x423: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x422, &mut x423, x414, 0xc7634d81f4372ddf);
  let mut x424: u64 = 0;
  let mut x425: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x424, &mut x425, x414, 0x581a0db248b0a77a);
  let mut x426: u64 = 0;
  let mut x427: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x426, &mut x427, x414, 0xecec196accc52973);
  let mut x428: u64 = 0;
  let mut x429: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x428, &mut x429, 0x0, x427, x424);
  let mut x430: u64 = 0;
  let mut x431: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x430, &mut x431, x429, x425, x422);
  let mut x432: u64 = 0;
  let mut x433: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x432, &mut x433, x431, x423, x420);
  let mut x434: u64 = 0;
  let mut x435: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x434, &mut x435, x433, x421, x418);
  let mut x436: u64 = 0;
  let mut x437: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x436, &mut x437, x435, x419, x416);
  let x438: u64 = ((x437 as u64) + x417);
  let mut x439: u64 = 0;
  let mut x440: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x439, &mut x440, 0x0, x400, x426);
  let mut x441: u64 = 0;
  let mut x442: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x441, &mut x442, x440, x402, x428);
  let mut x443: u64 = 0;
  let mut x444: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x443, &mut x444, x442, x404, x430);
  let mut x445: u64 = 0;
  let mut x446: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x445, &mut x446, x444, x406, x432);
  let mut x447: u64 = 0;
  let mut x448: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x447, &mut x448, x446, x408, x434);
  let mut x449: u64 = 0;
  let mut x450: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x449, &mut x450, x448, x410, x436);
  let mut x451: u64 = 0;
  let mut x452: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x451, &mut x452, x450, x412, x438);
  let x453: u64 = ((x452 as u64) + (x413 as u64));
  let mut x454: u64 = 0;
  let mut x455: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x454, &mut x455, 0x0, x441, 0xecec196accc52973);
  let mut x456: u64 = 0;
  let mut x457: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x456, &mut x457, x455, x443, 0x581a0db248b0a77a);
  let mut x458: u64 = 0;
  let mut x459: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x458, &mut x459, x457, x445, 0xc7634d81f4372ddf);
  let mut x460: u64 = 0;
  let mut x461: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x460, &mut x461, x459, x447, 0xffffffffffffffff);
  let mut x462: u64 = 0;
  let mut x463: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x462, &mut x463, x461, x449, 0xffffffffffffffff);
  let mut x464: u64 = 0;
  let mut x465: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x464, &mut x465, x463, x451, 0xffffffffffffffff);
  let mut x466: u64 = 0;
  let mut x467: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x466, &mut x467, x465, x453, (0x0 as u64));
  let mut x468: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x468, x467, x454, x441);
  let mut x469: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x469, x467, x456, x443);
  let mut x470: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x470, x467, x458, x445);
  let mut x471: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x471, x467, x460, x447);
  let mut x472: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x472, x467, x462, x449);
  let mut x473: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x473, x467, x464, x451);
  out1[0] = x468;
  out1[1] = x469;
  out1[2] = x470;
  out1[3] = x471;
  out1[4] = x472;
  out1[5] = x473;
}

/// The function fiat_p384_scalar_add adds two field elements in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
///   0 ≤ eval arg2 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) + eval (from_montgomery arg2)) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub fn fiat_p384_scalar_add(out1: &mut fiat_p384_scalar_montgomery_domain_field_element, arg1: &fiat_p384_scalar_montgomery_domain_field_element, arg2: &fiat_p384_scalar_montgomery_domain_field_element) -> () {
  let mut x1: u64 = 0;
  let mut x2: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x1, &mut x2, 0x0, (arg1[0]), (arg2[0]));
  let mut x3: u64 = 0;
  let mut x4: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x3, &mut x4, x2, (arg1[1]), (arg2[1]));
  let mut x5: u64 = 0;
  let mut x6: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x5, &mut x6, x4, (arg1[2]), (arg2[2]));
  let mut x7: u64 = 0;
  let mut x8: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x7, &mut x8, x6, (arg1[3]), (arg2[3]));
  let mut x9: u64 = 0;
  let mut x10: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x9, &mut x10, x8, (arg1[4]), (arg2[4]));
  let mut x11: u64 = 0;
  let mut x12: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x11, &mut x12, x10, (arg1[5]), (arg2[5]));
  let mut x13: u64 = 0;
  let mut x14: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x13, &mut x14, 0x0, x1, 0xecec196accc52973);
  let mut x15: u64 = 0;
  let mut x16: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x15, &mut x16, x14, x3, 0x581a0db248b0a77a);
  let mut x17: u64 = 0;
  let mut x18: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x17, &mut x18, x16, x5, 0xc7634d81f4372ddf);
  let mut x19: u64 = 0;
  let mut x20: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x19, &mut x20, x18, x7, 0xffffffffffffffff);
  let mut x21: u64 = 0;
  let mut x22: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x21, &mut x22, x20, x9, 0xffffffffffffffff);
  let mut x23: u64 = 0;
  let mut x24: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x23, &mut x24, x22, x11, 0xffffffffffffffff);
  let mut x25: u64 = 0;
  let mut x26: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x25, &mut x26, x24, (x12 as u64), (0x0 as u64));
  let mut x27: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x27, x26, x13, x1);
  let mut x28: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x28, x26, x15, x3);
  let mut x29: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x29, x26, x17, x5);
  let mut x30: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x30, x26, x19, x7);
  let mut x31: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x31, x26, x21, x9);
  let mut x32: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x32, x26, x23, x11);
  out1[0] = x27;
  out1[1] = x28;
  out1[2] = x29;
  out1[3] = x30;
  out1[4] = x31;
  out1[5] = x32;
}

/// The function fiat_p384_scalar_sub subtracts two field elements in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
///   0 ≤ eval arg2 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) - eval (from_montgomery arg2)) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub fn fiat_p384_scalar_sub(out1: &mut fiat_p384_scalar_montgomery_domain_field_element, arg1: &fiat_p384_scalar_montgomery_domain_field_element, arg2: &fiat_p384_scalar_montgomery_domain_field_element) -> () {
  let mut x1: u64 = 0;
  let mut x2: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x1, &mut x2, 0x0, (arg1[0]), (arg2[0]));
  let mut x3: u64 = 0;
  let mut x4: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x3, &mut x4, x2, (arg1[1]), (arg2[1]));
  let mut x5: u64 = 0;
  let mut x6: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x5, &mut x6, x4, (arg1[2]), (arg2[2]));
  let mut x7: u64 = 0;
  let mut x8: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x7, &mut x8, x6, (arg1[3]), (arg2[3]));
  let mut x9: u64 = 0;
  let mut x10: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x9, &mut x10, x8, (arg1[4]), (arg2[4]));
  let mut x11: u64 = 0;
  let mut x12: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x11, &mut x12, x10, (arg1[5]), (arg2[5]));
  let mut x13: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x13, x12, (0x0 as u64), 0xffffffffffffffff);
  let mut x14: u64 = 0;
  let mut x15: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x14, &mut x15, 0x0, x1, (x13 & 0xecec196accc52973));
  let mut x16: u64 = 0;
  let mut x17: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x16, &mut x17, x15, x3, (x13 & 0x581a0db248b0a77a));
  let mut x18: u64 = 0;
  let mut x19: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x18, &mut x19, x17, x5, (x13 & 0xc7634d81f4372ddf));
  let mut x20: u64 = 0;
  let mut x21: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x20, &mut x21, x19, x7, x13);
  let mut x22: u64 = 0;
  let mut x23: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x22, &mut x23, x21, x9, x13);
  let mut x24: u64 = 0;
  let mut x25: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x24, &mut x25, x23, x11, x13);
  out1[0] = x14;
  out1[1] = x16;
  out1[2] = x18;
  out1[3] = x20;
  out1[4] = x22;
  out1[5] = x24;
}

/// The function fiat_p384_scalar_opp negates a field element in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = -eval (from_montgomery arg1) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub fn fiat_p384_scalar_opp(out1: &mut fiat_p384_scalar_montgomery_domain_field_element, arg1: &fiat_p384_scalar_montgomery_domain_field_element) -> () {
  let mut x1: u64 = 0;
  let mut x2: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x1, &mut x2, 0x0, (0x0 as u64), (arg1[0]));
  let mut x3: u64 = 0;
  let mut x4: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x3, &mut x4, x2, (0x0 as u64), (arg1[1]));
  let mut x5: u64 = 0;
  let mut x6: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x5, &mut x6, x4, (0x0 as u64), (arg1[2]));
  let mut x7: u64 = 0;
  let mut x8: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x7, &mut x8, x6, (0x0 as u64), (arg1[3]));
  let mut x9: u64 = 0;
  let mut x10: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x9, &mut x10, x8, (0x0 as u64), (arg1[4]));
  let mut x11: u64 = 0;
  let mut x12: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x11, &mut x12, x10, (0x0 as u64), (arg1[5]));
  let mut x13: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x13, x12, (0x0 as u64), 0xffffffffffffffff);
  let mut x14: u64 = 0;
  let mut x15: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x14, &mut x15, 0x0, x1, (x13 & 0xecec196accc52973));
  let mut x16: u64 = 0;
  let mut x17: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x16, &mut x17, x15, x3, (x13 & 0x581a0db248b0a77a));
  let mut x18: u64 = 0;
  let mut x19: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x18, &mut x19, x17, x5, (x13 & 0xc7634d81f4372ddf));
  let mut x20: u64 = 0;
  let mut x21: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x20, &mut x21, x19, x7, x13);
  let mut x22: u64 = 0;
  let mut x23: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x22, &mut x23, x21, x9, x13);
  let mut x24: u64 = 0;
  let mut x25: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x24, &mut x25, x23, x11, x13);
  out1[0] = x14;
  out1[1] = x16;
  out1[2] = x18;
  out1[3] = x20;
  out1[4] = x22;
  out1[5] = x24;
}

/// The function fiat_p384_scalar_from_montgomery translates a field element out of the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   eval out1 mod m = (eval arg1 * ((2^64)⁻¹ mod m)^6) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub fn fiat_p384_scalar_from_montgomery(out1: &mut fiat_p384_scalar_non_montgomery_domain_field_element, arg1: &fiat_p384_scalar_montgomery_domain_field_element) -> () {
  let x1: u64 = (arg1[0]);
  let mut x2: u64 = 0;
  let mut x3: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x2, &mut x3, x1, 0x6ed46089e88fdc45);
  let mut x4: u64 = 0;
  let mut x5: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x4, &mut x5, x2, 0xffffffffffffffff);
  let mut x6: u64 = 0;
  let mut x7: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x6, &mut x7, x2, 0xffffffffffffffff);
  let mut x8: u64 = 0;
  let mut x9: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x8, &mut x9, x2, 0xffffffffffffffff);
  let mut x10: u64 = 0;
  let mut x11: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x10, &mut x11, x2, 0xc7634d81f4372ddf);
  let mut x12: u64 = 0;
  let mut x13: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x12, &mut x13, x2, 0x581a0db248b0a77a);
  let mut x14: u64 = 0;
  let mut x15: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x14, &mut x15, x2, 0xecec196accc52973);
  let mut x16: u64 = 0;
  let mut x17: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x16, &mut x17, 0x0, x15, x12);
  let mut x18: u64 = 0;
  let mut x19: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x18, &mut x19, x17, x13, x10);
  let mut x20: u64 = 0;
  let mut x21: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x20, &mut x21, x19, x11, x8);
  let mut x22: u64 = 0;
  let mut x23: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x22, &mut x23, x21, x9, x6);
  let mut x24: u64 = 0;
  let mut x25: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x24, &mut x25, x23, x7, x4);
  let mut x26: u64 = 0;
  let mut x27: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x26, &mut x27, 0x0, x1, x14);
  let mut x28: u64 = 0;
  let mut x29: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x28, &mut x29, x27, (0x0 as u64), x16);
  let mut x30: u64 = 0;
  let mut x31: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x30, &mut x31, x29, (0x0 as u64), x18);
  let mut x32: u64 = 0;
  let mut x33: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x32, &mut x33, x31, (0x0 as u64), x20);
  let mut x34: u64 = 0;
  let mut x35: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x34, &mut x35, x33, (0x0 as u64), x22);
  let mut x36: u64 = 0;
  let mut x37: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x36, &mut x37, x35, (0x0 as u64), x24);
  let mut x38: u64 = 0;
  let mut x39: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x38, &mut x39, x37, (0x0 as u64), ((x25 as u64) + x5));
  let mut x40: u64 = 0;
  let mut x41: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x40, &mut x41, 0x0, x28, (arg1[1]));
  let mut x42: u64 = 0;
  let mut x43: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x42, &mut x43, x41, x30, (0x0 as u64));
  let mut x44: u64 = 0;
  let mut x45: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x44, &mut x45, x43, x32, (0x0 as u64));
  let mut x46: u64 = 0;
  let mut x47: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x46, &mut x47, x45, x34, (0x0 as u64));
  let mut x48: u64 = 0;
  let mut x49: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x48, &mut x49, x47, x36, (0x0 as u64));
  let mut x50: u64 = 0;
  let mut x51: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x50, &mut x51, x49, x38, (0x0 as u64));
  let mut x52: u64 = 0;
  let mut x53: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x52, &mut x53, x40, 0x6ed46089e88fdc45);
  let mut x54: u64 = 0;
  let mut x55: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x54, &mut x55, x52, 0xffffffffffffffff);
  let mut x56: u64 = 0;
  let mut x57: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x56, &mut x57, x52, 0xffffffffffffffff);
  let mut x58: u64 = 0;
  let mut x59: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x58, &mut x59, x52, 0xffffffffffffffff);
  let mut x60: u64 = 0;
  let mut x61: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x60, &mut x61, x52, 0xc7634d81f4372ddf);
  let mut x62: u64 = 0;
  let mut x63: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x62, &mut x63, x52, 0x581a0db248b0a77a);
  let mut x64: u64 = 0;
  let mut x65: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x64, &mut x65, x52, 0xecec196accc52973);
  let mut x66: u64 = 0;
  let mut x67: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x66, &mut x67, 0x0, x65, x62);
  let mut x68: u64 = 0;
  let mut x69: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x68, &mut x69, x67, x63, x60);
  let mut x70: u64 = 0;
  let mut x71: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x70, &mut x71, x69, x61, x58);
  let mut x72: u64 = 0;
  let mut x73: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x72, &mut x73, x71, x59, x56);
  let mut x74: u64 = 0;
  let mut x75: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x74, &mut x75, x73, x57, x54);
  let mut x76: u64 = 0;
  let mut x77: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x76, &mut x77, 0x0, x40, x64);
  let mut x78: u64 = 0;
  let mut x79: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x78, &mut x79, x77, x42, x66);
  let mut x80: u64 = 0;
  let mut x81: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x80, &mut x81, x79, x44, x68);
  let mut x82: u64 = 0;
  let mut x83: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x82, &mut x83, x81, x46, x70);
  let mut x84: u64 = 0;
  let mut x85: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x84, &mut x85, x83, x48, x72);
  let mut x86: u64 = 0;
  let mut x87: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x86, &mut x87, x85, x50, x74);
  let mut x88: u64 = 0;
  let mut x89: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x88, &mut x89, x87, ((x51 as u64) + (x39 as u64)), ((x75 as u64) + x55));
  let mut x90: u64 = 0;
  let mut x91: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x90, &mut x91, 0x0, x78, (arg1[2]));
  let mut x92: u64 = 0;
  let mut x93: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x92, &mut x93, x91, x80, (0x0 as u64));
  let mut x94: u64 = 0;
  let mut x95: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x94, &mut x95, x93, x82, (0x0 as u64));
  let mut x96: u64 = 0;
  let mut x97: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x96, &mut x97, x95, x84, (0x0 as u64));
  let mut x98: u64 = 0;
  let mut x99: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x98, &mut x99, x97, x86, (0x0 as u64));
  let mut x100: u64 = 0;
  let mut x101: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x100, &mut x101, x99, x88, (0x0 as u64));
  let mut x102: u64 = 0;
  let mut x103: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x102, &mut x103, x90, 0x6ed46089e88fdc45);
  let mut x104: u64 = 0;
  let mut x105: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x104, &mut x105, x102, 0xffffffffffffffff);
  let mut x106: u64 = 0;
  let mut x107: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x106, &mut x107, x102, 0xffffffffffffffff);
  let mut x108: u64 = 0;
  let mut x109: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x108, &mut x109, x102, 0xffffffffffffffff);
  let mut x110: u64 = 0;
  let mut x111: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x110, &mut x111, x102, 0xc7634d81f4372ddf);
  let mut x112: u64 = 0;
  let mut x113: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x112, &mut x113, x102, 0x581a0db248b0a77a);
  let mut x114: u64 = 0;
  let mut x115: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x114, &mut x115, x102, 0xecec196accc52973);
  let mut x116: u64 = 0;
  let mut x117: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x116, &mut x117, 0x0, x115, x112);
  let mut x118: u64 = 0;
  let mut x119: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x118, &mut x119, x117, x113, x110);
  let mut x120: u64 = 0;
  let mut x121: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x120, &mut x121, x119, x111, x108);
  let mut x122: u64 = 0;
  let mut x123: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x122, &mut x123, x121, x109, x106);
  let mut x124: u64 = 0;
  let mut x125: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x124, &mut x125, x123, x107, x104);
  let mut x126: u64 = 0;
  let mut x127: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x126, &mut x127, 0x0, x90, x114);
  let mut x128: u64 = 0;
  let mut x129: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x128, &mut x129, x127, x92, x116);
  let mut x130: u64 = 0;
  let mut x131: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x130, &mut x131, x129, x94, x118);
  let mut x132: u64 = 0;
  let mut x133: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x132, &mut x133, x131, x96, x120);
  let mut x134: u64 = 0;
  let mut x135: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x134, &mut x135, x133, x98, x122);
  let mut x136: u64 = 0;
  let mut x137: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x136, &mut x137, x135, x100, x124);
  let mut x138: u64 = 0;
  let mut x139: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x138, &mut x139, x137, ((x101 as u64) + (x89 as u64)), ((x125 as u64) + x105));
  let mut x140: u64 = 0;
  let mut x141: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x140, &mut x141, 0x0, x128, (arg1[3]));
  let mut x142: u64 = 0;
  let mut x143: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x142, &mut x143, x141, x130, (0x0 as u64));
  let mut x144: u64 = 0;
  let mut x145: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x144, &mut x145, x143, x132, (0x0 as u64));
  let mut x146: u64 = 0;
  let mut x147: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x146, &mut x147, x145, x134, (0x0 as u64));
  let mut x148: u64 = 0;
  let mut x149: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x148, &mut x149, x147, x136, (0x0 as u64));
  let mut x150: u64 = 0;
  let mut x151: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x150, &mut x151, x149, x138, (0x0 as u64));
  let mut x152: u64 = 0;
  let mut x153: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x152, &mut x153, x140, 0x6ed46089e88fdc45);
  let mut x154: u64 = 0;
  let mut x155: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x154, &mut x155, x152, 0xffffffffffffffff);
  let mut x156: u64 = 0;
  let mut x157: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x156, &mut x157, x152, 0xffffffffffffffff);
  let mut x158: u64 = 0;
  let mut x159: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x158, &mut x159, x152, 0xffffffffffffffff);
  let mut x160: u64 = 0;
  let mut x161: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x160, &mut x161, x152, 0xc7634d81f4372ddf);
  let mut x162: u64 = 0;
  let mut x163: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x162, &mut x163, x152, 0x581a0db248b0a77a);
  let mut x164: u64 = 0;
  let mut x165: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x164, &mut x165, x152, 0xecec196accc52973);
  let mut x166: u64 = 0;
  let mut x167: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x166, &mut x167, 0x0, x165, x162);
  let mut x168: u64 = 0;
  let mut x169: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x168, &mut x169, x167, x163, x160);
  let mut x170: u64 = 0;
  let mut x171: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x170, &mut x171, x169, x161, x158);
  let mut x172: u64 = 0;
  let mut x173: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x172, &mut x173, x171, x159, x156);
  let mut x174: u64 = 0;
  let mut x175: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x174, &mut x175, x173, x157, x154);
  let mut x176: u64 = 0;
  let mut x177: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x176, &mut x177, 0x0, x140, x164);
  let mut x178: u64 = 0;
  let mut x179: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x178, &mut x179, x177, x142, x166);
  let mut x180: u64 = 0;
  let mut x181: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x180, &mut x181, x179, x144, x168);
  let mut x182: u64 = 0;
  let mut x183: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x182, &mut x183, x181, x146, x170);
  let mut x184: u64 = 0;
  let mut x185: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x184, &mut x185, x183, x148, x172);
  let mut x186: u64 = 0;
  let mut x187: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x186, &mut x187, x185, x150, x174);
  let mut x188: u64 = 0;
  let mut x189: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x188, &mut x189, x187, ((x151 as u64) + (x139 as u64)), ((x175 as u64) + x155));
  let mut x190: u64 = 0;
  let mut x191: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x190, &mut x191, 0x0, x178, (arg1[4]));
  let mut x192: u64 = 0;
  let mut x193: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x192, &mut x193, x191, x180, (0x0 as u64));
  let mut x194: u64 = 0;
  let mut x195: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x194, &mut x195, x193, x182, (0x0 as u64));
  let mut x196: u64 = 0;
  let mut x197: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x196, &mut x197, x195, x184, (0x0 as u64));
  let mut x198: u64 = 0;
  let mut x199: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x198, &mut x199, x197, x186, (0x0 as u64));
  let mut x200: u64 = 0;
  let mut x201: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x200, &mut x201, x199, x188, (0x0 as u64));
  let mut x202: u64 = 0;
  let mut x203: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x202, &mut x203, x190, 0x6ed46089e88fdc45);
  let mut x204: u64 = 0;
  let mut x205: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x204, &mut x205, x202, 0xffffffffffffffff);
  let mut x206: u64 = 0;
  let mut x207: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x206, &mut x207, x202, 0xffffffffffffffff);
  let mut x208: u64 = 0;
  let mut x209: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x208, &mut x209, x202, 0xffffffffffffffff);
  let mut x210: u64 = 0;
  let mut x211: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x210, &mut x211, x202, 0xc7634d81f4372ddf);
  let mut x212: u64 = 0;
  let mut x213: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x212, &mut x213, x202, 0x581a0db248b0a77a);
  let mut x214: u64 = 0;
  let mut x215: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x214, &mut x215, x202, 0xecec196accc52973);
  let mut x216: u64 = 0;
  let mut x217: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x216, &mut x217, 0x0, x215, x212);
  let mut x218: u64 = 0;
  let mut x219: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x218, &mut x219, x217, x213, x210);
  let mut x220: u64 = 0;
  let mut x221: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x220, &mut x221, x219, x211, x208);
  let mut x222: u64 = 0;
  let mut x223: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x222, &mut x223, x221, x209, x206);
  let mut x224: u64 = 0;
  let mut x225: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x224, &mut x225, x223, x207, x204);
  let mut x226: u64 = 0;
  let mut x227: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x226, &mut x227, 0x0, x190, x214);
  let mut x228: u64 = 0;
  let mut x229: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x228, &mut x229, x227, x192, x216);
  let mut x230: u64 = 0;
  let mut x231: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x230, &mut x231, x229, x194, x218);
  let mut x232: u64 = 0;
  let mut x233: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x232, &mut x233, x231, x196, x220);
  let mut x234: u64 = 0;
  let mut x235: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x234, &mut x235, x233, x198, x222);
  let mut x236: u64 = 0;
  let mut x237: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x236, &mut x237, x235, x200, x224);
  let mut x238: u64 = 0;
  let mut x239: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x238, &mut x239, x237, ((x201 as u64) + (x189 as u64)), ((x225 as u64) + x205));
  let mut x240: u64 = 0;
  let mut x241: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x240, &mut x241, 0x0, x228, (arg1[5]));
  let mut x242: u64 = 0;
  let mut x243: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x242, &mut x243, x241, x230, (0x0 as u64));
  let mut x244: u64 = 0;
  let mut x245: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x244, &mut x245, x243, x232, (0x0 as u64));
  let mut x246: u64 = 0;
  let mut x247: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x246, &mut x247, x245, x234, (0x0 as u64));
  let mut x248: u64 = 0;
  let mut x249: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x248, &mut x249, x247, x236, (0x0 as u64));
  let mut x250: u64 = 0;
  let mut x251: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x250, &mut x251, x249, x238, (0x0 as u64));
  let mut x252: u64 = 0;
  let mut x253: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x252, &mut x253, x240, 0x6ed46089e88fdc45);
  let mut x254: u64 = 0;
  let mut x255: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x254, &mut x255, x252, 0xffffffffffffffff);
  let mut x256: u64 = 0;
  let mut x257: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x256, &mut x257, x252, 0xffffffffffffffff);
  let mut x258: u64 = 0;
  let mut x259: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x258, &mut x259, x252, 0xffffffffffffffff);
  let mut x260: u64 = 0;
  let mut x261: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x260, &mut x261, x252, 0xc7634d81f4372ddf);
  let mut x262: u64 = 0;
  let mut x263: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x262, &mut x263, x252, 0x581a0db248b0a77a);
  let mut x264: u64 = 0;
  let mut x265: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x264, &mut x265, x252, 0xecec196accc52973);
  let mut x266: u64 = 0;
  let mut x267: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x266, &mut x267, 0x0, x265, x262);
  let mut x268: u64 = 0;
  let mut x269: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x268, &mut x269, x267, x263, x260);
  let mut x270: u64 = 0;
  let mut x271: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x270, &mut x271, x269, x261, x258);
  let mut x272: u64 = 0;
  let mut x273: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x272, &mut x273, x271, x259, x256);
  let mut x274: u64 = 0;
  let mut x275: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x274, &mut x275, x273, x257, x254);
  let mut x276: u64 = 0;
  let mut x277: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x276, &mut x277, 0x0, x240, x264);
  let mut x278: u64 = 0;
  let mut x279: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x278, &mut x279, x277, x242, x266);
  let mut x280: u64 = 0;
  let mut x281: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x280, &mut x281, x279, x244, x268);
  let mut x282: u64 = 0;
  let mut x283: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x282, &mut x283, x281, x246, x270);
  let mut x284: u64 = 0;
  let mut x285: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x284, &mut x285, x283, x248, x272);
  let mut x286: u64 = 0;
  let mut x287: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x286, &mut x287, x285, x250, x274);
  let mut x288: u64 = 0;
  let mut x289: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x288, &mut x289, x287, ((x251 as u64) + (x239 as u64)), ((x275 as u64) + x255));
  let mut x290: u64 = 0;
  let mut x291: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x290, &mut x291, 0x0, x278, 0xecec196accc52973);
  let mut x292: u64 = 0;
  let mut x293: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x292, &mut x293, x291, x280, 0x581a0db248b0a77a);
  let mut x294: u64 = 0;
  let mut x295: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x294, &mut x295, x293, x282, 0xc7634d81f4372ddf);
  let mut x296: u64 = 0;
  let mut x297: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x296, &mut x297, x295, x284, 0xffffffffffffffff);
  let mut x298: u64 = 0;
  let mut x299: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x298, &mut x299, x297, x286, 0xffffffffffffffff);
  let mut x300: u64 = 0;
  let mut x301: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x300, &mut x301, x299, x288, 0xffffffffffffffff);
  let mut x302: u64 = 0;
  let mut x303: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x302, &mut x303, x301, (x289 as u64), (0x0 as u64));
  let mut x304: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x304, x303, x290, x278);
  let mut x305: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x305, x303, x292, x280);
  let mut x306: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x306, x303, x294, x282);
  let mut x307: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x307, x303, x296, x284);
  let mut x308: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x308, x303, x298, x286);
  let mut x309: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x309, x303, x300, x288);
  out1[0] = x304;
  out1[1] = x305;
  out1[2] = x306;
  out1[3] = x307;
  out1[4] = x308;
  out1[5] = x309;
}

/// The function fiat_p384_scalar_to_montgomery translates a field element into the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = eval arg1 mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub fn fiat_p384_scalar_to_montgomery(out1: &mut fiat_p384_scalar_montgomery_domain_field_element, arg1: &fiat_p384_scalar_non_montgomery_domain_field_element) -> () {
  let x1: u64 = (arg1[1]);
  let x2: u64 = (arg1[2]);
  let x3: u64 = (arg1[3]);
  let x4: u64 = (arg1[4]);
  let x5: u64 = (arg1[5]);
  let x6: u64 = (arg1[0]);
  let mut x7: u64 = 0;
  let mut x8: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x7, &mut x8, x6, 0xc84ee012b39bf21);
  let mut x9: u64 = 0;
  let mut x10: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x9, &mut x10, x6, 0x3fb05b7a28266895);
  let mut x11: u64 = 0;
  let mut x12: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x11, &mut x12, x6, 0xd40d49174aab1cc5);
  let mut x13: u64 = 0;
  let mut x14: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x13, &mut x14, x6, 0xbc3e483afcb82947);
  let mut x15: u64 = 0;
  let mut x16: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x15, &mut x16, x6, 0xff3d81e5df1aa419);
  let mut x17: u64 = 0;
  let mut x18: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x17, &mut x18, x6, 0x2d319b2419b409a9);
  let mut x19: u64 = 0;
  let mut x20: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x19, &mut x20, 0x0, x18, x15);
  let mut x21: u64 = 0;
  let mut x22: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x21, &mut x22, x20, x16, x13);
  let mut x23: u64 = 0;
  let mut x24: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x23, &mut x24, x22, x14, x11);
  let mut x25: u64 = 0;
  let mut x26: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x25, &mut x26, x24, x12, x9);
  let mut x27: u64 = 0;
  let mut x28: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x27, &mut x28, x26, x10, x7);
  let mut x29: u64 = 0;
  let mut x30: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x29, &mut x30, x17, 0x6ed46089e88fdc45);
  let mut x31: u64 = 0;
  let mut x32: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x31, &mut x32, x29, 0xffffffffffffffff);
  let mut x33: u64 = 0;
  let mut x34: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x33, &mut x34, x29, 0xffffffffffffffff);
  let mut x35: u64 = 0;
  let mut x36: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x35, &mut x36, x29, 0xffffffffffffffff);
  let mut x37: u64 = 0;
  let mut x38: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x37, &mut x38, x29, 0xc7634d81f4372ddf);
  let mut x39: u64 = 0;
  let mut x40: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x39, &mut x40, x29, 0x581a0db248b0a77a);
  let mut x41: u64 = 0;
  let mut x42: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x41, &mut x42, x29, 0xecec196accc52973);
  let mut x43: u64 = 0;
  let mut x44: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x43, &mut x44, 0x0, x42, x39);
  let mut x45: u64 = 0;
  let mut x46: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x45, &mut x46, x44, x40, x37);
  let mut x47: u64 = 0;
  let mut x48: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x47, &mut x48, x46, x38, x35);
  let mut x49: u64 = 0;
  let mut x50: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x49, &mut x50, x48, x36, x33);
  let mut x51: u64 = 0;
  let mut x52: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x51, &mut x52, x50, x34, x31);
  let mut x53: u64 = 0;
  let mut x54: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x53, &mut x54, 0x0, x17, x41);
  let mut x55: u64 = 0;
  let mut x56: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x55, &mut x56, x54, x19, x43);
  let mut x57: u64 = 0;
  let mut x58: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x57, &mut x58, x56, x21, x45);
  let mut x59: u64 = 0;
  let mut x60: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x59, &mut x60, x58, x23, x47);
  let mut x61: u64 = 0;
  let mut x62: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x61, &mut x62, x60, x25, x49);
  let mut x63: u64 = 0;
  let mut x64: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x63, &mut x64, x62, x27, x51);
  let mut x65: u64 = 0;
  let mut x66: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x65, &mut x66, x64, ((x28 as u64) + x8), ((x52 as u64) + x32));
  let mut x67: u64 = 0;
  let mut x68: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x67, &mut x68, x1, 0xc84ee012b39bf21);
  let mut x69: u64 = 0;
  let mut x70: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x69, &mut x70, x1, 0x3fb05b7a28266895);
  let mut x71: u64 = 0;
  let mut x72: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x71, &mut x72, x1, 0xd40d49174aab1cc5);
  let mut x73: u64 = 0;
  let mut x74: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x73, &mut x74, x1, 0xbc3e483afcb82947);
  let mut x75: u64 = 0;
  let mut x76: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x75, &mut x76, x1, 0xff3d81e5df1aa419);
  let mut x77: u64 = 0;
  let mut x78: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x77, &mut x78, x1, 0x2d319b2419b409a9);
  let mut x79: u64 = 0;
  let mut x80: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x79, &mut x80, 0x0, x78, x75);
  let mut x81: u64 = 0;
  let mut x82: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x81, &mut x82, x80, x76, x73);
  let mut x83: u64 = 0;
  let mut x84: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x83, &mut x84, x82, x74, x71);
  let mut x85: u64 = 0;
  let mut x86: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x85, &mut x86, x84, x72, x69);
  let mut x87: u64 = 0;
  let mut x88: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x87, &mut x88, x86, x70, x67);
  let mut x89: u64 = 0;
  let mut x90: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x89, &mut x90, 0x0, x55, x77);
  let mut x91: u64 = 0;
  let mut x92: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x91, &mut x92, x90, x57, x79);
  let mut x93: u64 = 0;
  let mut x94: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x93, &mut x94, x92, x59, x81);
  let mut x95: u64 = 0;
  let mut x96: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x95, &mut x96, x94, x61, x83);
  let mut x97: u64 = 0;
  let mut x98: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x97, &mut x98, x96, x63, x85);
  let mut x99: u64 = 0;
  let mut x100: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x99, &mut x100, x98, x65, x87);
  let mut x101: u64 = 0;
  let mut x102: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x101, &mut x102, x89, 0x6ed46089e88fdc45);
  let mut x103: u64 = 0;
  let mut x104: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x103, &mut x104, x101, 0xffffffffffffffff);
  let mut x105: u64 = 0;
  let mut x106: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x105, &mut x106, x101, 0xffffffffffffffff);
  let mut x107: u64 = 0;
  let mut x108: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x107, &mut x108, x101, 0xffffffffffffffff);
  let mut x109: u64 = 0;
  let mut x110: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x109, &mut x110, x101, 0xc7634d81f4372ddf);
  let mut x111: u64 = 0;
  let mut x112: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x111, &mut x112, x101, 0x581a0db248b0a77a);
  let mut x113: u64 = 0;
  let mut x114: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x113, &mut x114, x101, 0xecec196accc52973);
  let mut x115: u64 = 0;
  let mut x116: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x115, &mut x116, 0x0, x114, x111);
  let mut x117: u64 = 0;
  let mut x118: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x117, &mut x118, x116, x112, x109);
  let mut x119: u64 = 0;
  let mut x120: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x119, &mut x120, x118, x110, x107);
  let mut x121: u64 = 0;
  let mut x122: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x121, &mut x122, x120, x108, x105);
  let mut x123: u64 = 0;
  let mut x124: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x123, &mut x124, x122, x106, x103);
  let mut x125: u64 = 0;
  let mut x126: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x125, &mut x126, 0x0, x89, x113);
  let mut x127: u64 = 0;
  let mut x128: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x127, &mut x128, x126, x91, x115);
  let mut x129: u64 = 0;
  let mut x130: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x129, &mut x130, x128, x93, x117);
  let mut x131: u64 = 0;
  let mut x132: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x131, &mut x132, x130, x95, x119);
  let mut x133: u64 = 0;
  let mut x134: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x133, &mut x134, x132, x97, x121);
  let mut x135: u64 = 0;
  let mut x136: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x135, &mut x136, x134, x99, x123);
  let mut x137: u64 = 0;
  let mut x138: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x137, &mut x138, x136, (((x100 as u64) + (x66 as u64)) + ((x88 as u64) + x68)), ((x124 as u64) + x104));
  let mut x139: u64 = 0;
  let mut x140: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x139, &mut x140, x2, 0xc84ee012b39bf21);
  let mut x141: u64 = 0;
  let mut x142: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x141, &mut x142, x2, 0x3fb05b7a28266895);
  let mut x143: u64 = 0;
  let mut x144: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x143, &mut x144, x2, 0xd40d49174aab1cc5);
  let mut x145: u64 = 0;
  let mut x146: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x145, &mut x146, x2, 0xbc3e483afcb82947);
  let mut x147: u64 = 0;
  let mut x148: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x147, &mut x148, x2, 0xff3d81e5df1aa419);
  let mut x149: u64 = 0;
  let mut x150: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x149, &mut x150, x2, 0x2d319b2419b409a9);
  let mut x151: u64 = 0;
  let mut x152: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x151, &mut x152, 0x0, x150, x147);
  let mut x153: u64 = 0;
  let mut x154: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x153, &mut x154, x152, x148, x145);
  let mut x155: u64 = 0;
  let mut x156: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x155, &mut x156, x154, x146, x143);
  let mut x157: u64 = 0;
  let mut x158: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x157, &mut x158, x156, x144, x141);
  let mut x159: u64 = 0;
  let mut x160: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x159, &mut x160, x158, x142, x139);
  let mut x161: u64 = 0;
  let mut x162: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x161, &mut x162, 0x0, x127, x149);
  let mut x163: u64 = 0;
  let mut x164: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x163, &mut x164, x162, x129, x151);
  let mut x165: u64 = 0;
  let mut x166: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x165, &mut x166, x164, x131, x153);
  let mut x167: u64 = 0;
  let mut x168: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x167, &mut x168, x166, x133, x155);
  let mut x169: u64 = 0;
  let mut x170: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x169, &mut x170, x168, x135, x157);
  let mut x171: u64 = 0;
  let mut x172: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x171, &mut x172, x170, x137, x159);
  let mut x173: u64 = 0;
  let mut x174: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x173, &mut x174, x161, 0x6ed46089e88fdc45);
  let mut x175: u64 = 0;
  let mut x176: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x175, &mut x176, x173, 0xffffffffffffffff);
  let mut x177: u64 = 0;
  let mut x178: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x177, &mut x178, x173, 0xffffffffffffffff);
  let mut x179: u64 = 0;
  let mut x180: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x179, &mut x180, x173, 0xffffffffffffffff);
  let mut x181: u64 = 0;
  let mut x182: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x181, &mut x182, x173, 0xc7634d81f4372ddf);
  let mut x183: u64 = 0;
  let mut x184: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x183, &mut x184, x173, 0x581a0db248b0a77a);
  let mut x185: u64 = 0;
  let mut x186: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x185, &mut x186, x173, 0xecec196accc52973);
  let mut x187: u64 = 0;
  let mut x188: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x187, &mut x188, 0x0, x186, x183);
  let mut x189: u64 = 0;
  let mut x190: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x189, &mut x190, x188, x184, x181);
  let mut x191: u64 = 0;
  let mut x192: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x191, &mut x192, x190, x182, x179);
  let mut x193: u64 = 0;
  let mut x194: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x193, &mut x194, x192, x180, x177);
  let mut x195: u64 = 0;
  let mut x196: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x195, &mut x196, x194, x178, x175);
  let mut x197: u64 = 0;
  let mut x198: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x197, &mut x198, 0x0, x161, x185);
  let mut x199: u64 = 0;
  let mut x200: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x199, &mut x200, x198, x163, x187);
  let mut x201: u64 = 0;
  let mut x202: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x201, &mut x202, x200, x165, x189);
  let mut x203: u64 = 0;
  let mut x204: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x203, &mut x204, x202, x167, x191);
  let mut x205: u64 = 0;
  let mut x206: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x205, &mut x206, x204, x169, x193);
  let mut x207: u64 = 0;
  let mut x208: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x207, &mut x208, x206, x171, x195);
  let mut x209: u64 = 0;
  let mut x210: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x209, &mut x210, x208, (((x172 as u64) + (x138 as u64)) + ((x160 as u64) + x140)), ((x196 as u64) + x176));
  let mut x211: u64 = 0;
  let mut x212: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x211, &mut x212, x3, 0xc84ee012b39bf21);
  let mut x213: u64 = 0;
  let mut x214: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x213, &mut x214, x3, 0x3fb05b7a28266895);
  let mut x215: u64 = 0;
  let mut x216: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x215, &mut x216, x3, 0xd40d49174aab1cc5);
  let mut x217: u64 = 0;
  let mut x218: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x217, &mut x218, x3, 0xbc3e483afcb82947);
  let mut x219: u64 = 0;
  let mut x220: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x219, &mut x220, x3, 0xff3d81e5df1aa419);
  let mut x221: u64 = 0;
  let mut x222: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x221, &mut x222, x3, 0x2d319b2419b409a9);
  let mut x223: u64 = 0;
  let mut x224: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x223, &mut x224, 0x0, x222, x219);
  let mut x225: u64 = 0;
  let mut x226: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x225, &mut x226, x224, x220, x217);
  let mut x227: u64 = 0;
  let mut x228: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x227, &mut x228, x226, x218, x215);
  let mut x229: u64 = 0;
  let mut x230: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x229, &mut x230, x228, x216, x213);
  let mut x231: u64 = 0;
  let mut x232: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x231, &mut x232, x230, x214, x211);
  let mut x233: u64 = 0;
  let mut x234: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x233, &mut x234, 0x0, x199, x221);
  let mut x235: u64 = 0;
  let mut x236: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x235, &mut x236, x234, x201, x223);
  let mut x237: u64 = 0;
  let mut x238: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x237, &mut x238, x236, x203, x225);
  let mut x239: u64 = 0;
  let mut x240: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x239, &mut x240, x238, x205, x227);
  let mut x241: u64 = 0;
  let mut x242: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x241, &mut x242, x240, x207, x229);
  let mut x243: u64 = 0;
  let mut x244: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x243, &mut x244, x242, x209, x231);
  let mut x245: u64 = 0;
  let mut x246: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x245, &mut x246, x233, 0x6ed46089e88fdc45);
  let mut x247: u64 = 0;
  let mut x248: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x247, &mut x248, x245, 0xffffffffffffffff);
  let mut x249: u64 = 0;
  let mut x250: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x249, &mut x250, x245, 0xffffffffffffffff);
  let mut x251: u64 = 0;
  let mut x252: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x251, &mut x252, x245, 0xffffffffffffffff);
  let mut x253: u64 = 0;
  let mut x254: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x253, &mut x254, x245, 0xc7634d81f4372ddf);
  let mut x255: u64 = 0;
  let mut x256: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x255, &mut x256, x245, 0x581a0db248b0a77a);
  let mut x257: u64 = 0;
  let mut x258: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x257, &mut x258, x245, 0xecec196accc52973);
  let mut x259: u64 = 0;
  let mut x260: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x259, &mut x260, 0x0, x258, x255);
  let mut x261: u64 = 0;
  let mut x262: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x261, &mut x262, x260, x256, x253);
  let mut x263: u64 = 0;
  let mut x264: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x263, &mut x264, x262, x254, x251);
  let mut x265: u64 = 0;
  let mut x266: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x265, &mut x266, x264, x252, x249);
  let mut x267: u64 = 0;
  let mut x268: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x267, &mut x268, x266, x250, x247);
  let mut x269: u64 = 0;
  let mut x270: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x269, &mut x270, 0x0, x233, x257);
  let mut x271: u64 = 0;
  let mut x272: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x271, &mut x272, x270, x235, x259);
  let mut x273: u64 = 0;
  let mut x274: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x273, &mut x274, x272, x237, x261);
  let mut x275: u64 = 0;
  let mut x276: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x275, &mut x276, x274, x239, x263);
  let mut x277: u64 = 0;
  let mut x278: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x277, &mut x278, x276, x241, x265);
  let mut x279: u64 = 0;
  let mut x280: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x279, &mut x280, x278, x243, x267);
  let mut x281: u64 = 0;
  let mut x282: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x281, &mut x282, x280, (((x244 as u64) + (x210 as u64)) + ((x232 as u64) + x212)), ((x268 as u64) + x248));
  let mut x283: u64 = 0;
  let mut x284: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x283, &mut x284, x4, 0xc84ee012b39bf21);
  let mut x285: u64 = 0;
  let mut x286: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x285, &mut x286, x4, 0x3fb05b7a28266895);
  let mut x287: u64 = 0;
  let mut x288: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x287, &mut x288, x4, 0xd40d49174aab1cc5);
  let mut x289: u64 = 0;
  let mut x290: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x289, &mut x290, x4, 0xbc3e483afcb82947);
  let mut x291: u64 = 0;
  let mut x292: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x291, &mut x292, x4, 0xff3d81e5df1aa419);
  let mut x293: u64 = 0;
  let mut x294: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x293, &mut x294, x4, 0x2d319b2419b409a9);
  let mut x295: u64 = 0;
  let mut x296: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x295, &mut x296, 0x0, x294, x291);
  let mut x297: u64 = 0;
  let mut x298: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x297, &mut x298, x296, x292, x289);
  let mut x299: u64 = 0;
  let mut x300: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x299, &mut x300, x298, x290, x287);
  let mut x301: u64 = 0;
  let mut x302: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x301, &mut x302, x300, x288, x285);
  let mut x303: u64 = 0;
  let mut x304: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x303, &mut x304, x302, x286, x283);
  let mut x305: u64 = 0;
  let mut x306: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x305, &mut x306, 0x0, x271, x293);
  let mut x307: u64 = 0;
  let mut x308: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x307, &mut x308, x306, x273, x295);
  let mut x309: u64 = 0;
  let mut x310: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x309, &mut x310, x308, x275, x297);
  let mut x311: u64 = 0;
  let mut x312: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x311, &mut x312, x310, x277, x299);
  let mut x313: u64 = 0;
  let mut x314: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x313, &mut x314, x312, x279, x301);
  let mut x315: u64 = 0;
  let mut x316: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x315, &mut x316, x314, x281, x303);
  let mut x317: u64 = 0;
  let mut x318: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x317, &mut x318, x305, 0x6ed46089e88fdc45);
  let mut x319: u64 = 0;
  let mut x320: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x319, &mut x320, x317, 0xffffffffffffffff);
  let mut x321: u64 = 0;
  let mut x322: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x321, &mut x322, x317, 0xffffffffffffffff);
  let mut x323: u64 = 0;
  let mut x324: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x323, &mut x324, x317, 0xffffffffffffffff);
  let mut x325: u64 = 0;
  let mut x326: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x325, &mut x326, x317, 0xc7634d81f4372ddf);
  let mut x327: u64 = 0;
  let mut x328: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x327, &mut x328, x317, 0x581a0db248b0a77a);
  let mut x329: u64 = 0;
  let mut x330: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x329, &mut x330, x317, 0xecec196accc52973);
  let mut x331: u64 = 0;
  let mut x332: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x331, &mut x332, 0x0, x330, x327);
  let mut x333: u64 = 0;
  let mut x334: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x333, &mut x334, x332, x328, x325);
  let mut x335: u64 = 0;
  let mut x336: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x335, &mut x336, x334, x326, x323);
  let mut x337: u64 = 0;
  let mut x338: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x337, &mut x338, x336, x324, x321);
  let mut x339: u64 = 0;
  let mut x340: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x339, &mut x340, x338, x322, x319);
  let mut x341: u64 = 0;
  let mut x342: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x341, &mut x342, 0x0, x305, x329);
  let mut x343: u64 = 0;
  let mut x344: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x343, &mut x344, x342, x307, x331);
  let mut x345: u64 = 0;
  let mut x346: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x345, &mut x346, x344, x309, x333);
  let mut x347: u64 = 0;
  let mut x348: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x347, &mut x348, x346, x311, x335);
  let mut x349: u64 = 0;
  let mut x350: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x349, &mut x350, x348, x313, x337);
  let mut x351: u64 = 0;
  let mut x352: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x351, &mut x352, x350, x315, x339);
  let mut x353: u64 = 0;
  let mut x354: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x353, &mut x354, x352, (((x316 as u64) + (x282 as u64)) + ((x304 as u64) + x284)), ((x340 as u64) + x320));
  let mut x355: u64 = 0;
  let mut x356: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x355, &mut x356, x5, 0xc84ee012b39bf21);
  let mut x357: u64 = 0;
  let mut x358: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x357, &mut x358, x5, 0x3fb05b7a28266895);
  let mut x359: u64 = 0;
  let mut x360: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x359, &mut x360, x5, 0xd40d49174aab1cc5);
  let mut x361: u64 = 0;
  let mut x362: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x361, &mut x362, x5, 0xbc3e483afcb82947);
  let mut x363: u64 = 0;
  let mut x364: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x363, &mut x364, x5, 0xff3d81e5df1aa419);
  let mut x365: u64 = 0;
  let mut x366: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x365, &mut x366, x5, 0x2d319b2419b409a9);
  let mut x367: u64 = 0;
  let mut x368: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x367, &mut x368, 0x0, x366, x363);
  let mut x369: u64 = 0;
  let mut x370: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x369, &mut x370, x368, x364, x361);
  let mut x371: u64 = 0;
  let mut x372: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x371, &mut x372, x370, x362, x359);
  let mut x373: u64 = 0;
  let mut x374: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x373, &mut x374, x372, x360, x357);
  let mut x375: u64 = 0;
  let mut x376: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x375, &mut x376, x374, x358, x355);
  let mut x377: u64 = 0;
  let mut x378: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x377, &mut x378, 0x0, x343, x365);
  let mut x379: u64 = 0;
  let mut x380: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x379, &mut x380, x378, x345, x367);
  let mut x381: u64 = 0;
  let mut x382: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x381, &mut x382, x380, x347, x369);
  let mut x383: u64 = 0;
  let mut x384: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x383, &mut x384, x382, x349, x371);
  let mut x385: u64 = 0;
  let mut x386: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x385, &mut x386, x384, x351, x373);
  let mut x387: u64 = 0;
  let mut x388: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x387, &mut x388, x386, x353, x375);
  let mut x389: u64 = 0;
  let mut x390: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x389, &mut x390, x377, 0x6ed46089e88fdc45);
  let mut x391: u64 = 0;
  let mut x392: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x391, &mut x392, x389, 0xffffffffffffffff);
  let mut x393: u64 = 0;
  let mut x394: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x393, &mut x394, x389, 0xffffffffffffffff);
  let mut x395: u64 = 0;
  let mut x396: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x395, &mut x396, x389, 0xffffffffffffffff);
  let mut x397: u64 = 0;
  let mut x398: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x397, &mut x398, x389, 0xc7634d81f4372ddf);
  let mut x399: u64 = 0;
  let mut x400: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x399, &mut x400, x389, 0x581a0db248b0a77a);
  let mut x401: u64 = 0;
  let mut x402: u64 = 0;
  fiat_p384_scalar_mulx_u64(&mut x401, &mut x402, x389, 0xecec196accc52973);
  let mut x403: u64 = 0;
  let mut x404: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x403, &mut x404, 0x0, x402, x399);
  let mut x405: u64 = 0;
  let mut x406: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x405, &mut x406, x404, x400, x397);
  let mut x407: u64 = 0;
  let mut x408: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x407, &mut x408, x406, x398, x395);
  let mut x409: u64 = 0;
  let mut x410: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x409, &mut x410, x408, x396, x393);
  let mut x411: u64 = 0;
  let mut x412: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x411, &mut x412, x410, x394, x391);
  let mut x413: u64 = 0;
  let mut x414: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x413, &mut x414, 0x0, x377, x401);
  let mut x415: u64 = 0;
  let mut x416: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x415, &mut x416, x414, x379, x403);
  let mut x417: u64 = 0;
  let mut x418: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x417, &mut x418, x416, x381, x405);
  let mut x419: u64 = 0;
  let mut x420: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x419, &mut x420, x418, x383, x407);
  let mut x421: u64 = 0;
  let mut x422: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x421, &mut x422, x420, x385, x409);
  let mut x423: u64 = 0;
  let mut x424: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x423, &mut x424, x422, x387, x411);
  let mut x425: u64 = 0;
  let mut x426: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x425, &mut x426, x424, (((x388 as u64) + (x354 as u64)) + ((x376 as u64) + x356)), ((x412 as u64) + x392));
  let mut x427: u64 = 0;
  let mut x428: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x427, &mut x428, 0x0, x415, 0xecec196accc52973);
  let mut x429: u64 = 0;
  let mut x430: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x429, &mut x430, x428, x417, 0x581a0db248b0a77a);
  let mut x431: u64 = 0;
  let mut x432: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x431, &mut x432, x430, x419, 0xc7634d81f4372ddf);
  let mut x433: u64 = 0;
  let mut x434: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x433, &mut x434, x432, x421, 0xffffffffffffffff);
  let mut x435: u64 = 0;
  let mut x436: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x435, &mut x436, x434, x423, 0xffffffffffffffff);
  let mut x437: u64 = 0;
  let mut x438: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x437, &mut x438, x436, x425, 0xffffffffffffffff);
  let mut x439: u64 = 0;
  let mut x440: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x439, &mut x440, x438, (x426 as u64), (0x0 as u64));
  let mut x441: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x441, x440, x427, x415);
  let mut x442: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x442, x440, x429, x417);
  let mut x443: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x443, x440, x431, x419);
  let mut x444: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x444, x440, x433, x421);
  let mut x445: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x445, x440, x435, x423);
  let mut x446: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x446, x440, x437, x425);
  out1[0] = x441;
  out1[1] = x442;
  out1[2] = x443;
  out1[3] = x444;
  out1[4] = x445;
  out1[5] = x446;
}

/// The function fiat_p384_scalar_nonzero outputs a single non-zero word if the input is non-zero and zero otherwise.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   out1 = 0 ↔ eval (from_montgomery arg1) mod m = 0
///
/// Input Bounds:
///   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffffffffffff]
#[inline]
pub fn fiat_p384_scalar_nonzero(out1: &mut u64, arg1: &[u64; 6]) -> () {
  let x1: u64 = ((arg1[0]) | ((arg1[1]) | ((arg1[2]) | ((arg1[3]) | ((arg1[4]) | (arg1[5]))))));
  *out1 = x1;
}

/// The function fiat_p384_scalar_selectznz is a multi-limb conditional select.
///
/// Postconditions:
///   out1 = (if arg1 = 0 then arg2 else arg3)
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
///   arg3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
#[inline]
pub fn fiat_p384_scalar_selectznz(out1: &mut [u64; 6], arg1: fiat_p384_scalar_u1, arg2: &[u64; 6], arg3: &[u64; 6]) -> () {
  let mut x1: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x1, arg1, (arg2[0]), (arg3[0]));
  let mut x2: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x2, arg1, (arg2[1]), (arg3[1]));
  let mut x3: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x3, arg1, (arg2[2]), (arg3[2]));
  let mut x4: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x4, arg1, (arg2[3]), (arg3[3]));
  let mut x5: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x5, arg1, (arg2[4]), (arg3[4]));
  let mut x6: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x6, arg1, (arg2[5]), (arg3[5]));
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
  out1[4] = x5;
  out1[5] = x6;
}

/// The function fiat_p384_scalar_to_bytes serializes a field element NOT in the Montgomery domain to bytes in little-endian order.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   out1 = map (λ x, ⌊((eval arg1 mod m) mod 2^(8 * (x + 1))) / 2^(8 * x)⌋) [0..47]
///
/// Input Bounds:
///   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
/// Output Bounds:
///   out1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
#[inline]
pub fn fiat_p384_scalar_to_bytes(out1: &mut [u8; 48], arg1: &[u64; 6]) -> () {
  let x1: u64 = (arg1[5]);
  let x2: u64 = (arg1[4]);
  let x3: u64 = (arg1[3]);
  let x4: u64 = (arg1[2]);
  let x5: u64 = (arg1[1]);
  let x6: u64 = (arg1[0]);
  let x7: u8 = ((x6 & (0xff as u64)) as u8);
  let x8: u64 = (x6 >> 8);
  let x9: u8 = ((x8 & (0xff as u64)) as u8);
  let x10: u64 = (x8 >> 8);
  let x11: u8 = ((x10 & (0xff as u64)) as u8);
  let x12: u64 = (x10 >> 8);
  let x13: u8 = ((x12 & (0xff as u64)) as u8);
  let x14: u64 = (x12 >> 8);
  let x15: u8 = ((x14 & (0xff as u64)) as u8);
  let x16: u64 = (x14 >> 8);
  let x17: u8 = ((x16 & (0xff as u64)) as u8);
  let x18: u64 = (x16 >> 8);
  let x19: u8 = ((x18 & (0xff as u64)) as u8);
  let x20: u8 = ((x18 >> 8) as u8);
  let x21: u8 = ((x5 & (0xff as u64)) as u8);
  let x22: u64 = (x5 >> 8);
  let x23: u8 = ((x22 & (0xff as u64)) as u8);
  let x24: u64 = (x22 >> 8);
  let x25: u8 = ((x24 & (0xff as u64)) as u8);
  let x26: u64 = (x24 >> 8);
  let x27: u8 = ((x26 & (0xff as u64)) as u8);
  let x28: u64 = (x26 >> 8);
  let x29: u8 = ((x28 & (0xff as u64)) as u8);
  let x30: u64 = (x28 >> 8);
  let x31: u8 = ((x30 & (0xff as u64)) as u8);
  let x32: u64 = (x30 >> 8);
  let x33: u8 = ((x32 & (0xff as u64)) as u8);
  let x34: u8 = ((x32 >> 8) as u8);
  let x35: u8 = ((x4 & (0xff as u64)) as u8);
  let x36: u64 = (x4 >> 8);
  let x37: u8 = ((x36 & (0xff as u64)) as u8);
  let x38: u64 = (x36 >> 8);
  let x39: u8 = ((x38 & (0xff as u64)) as u8);
  let x40: u64 = (x38 >> 8);
  let x41: u8 = ((x40 & (0xff as u64)) as u8);
  let x42: u64 = (x40 >> 8);
  let x43: u8 = ((x42 & (0xff as u64)) as u8);
  let x44: u64 = (x42 >> 8);
  let x45: u8 = ((x44 & (0xff as u64)) as u8);
  let x46: u64 = (x44 >> 8);
  let x47: u8 = ((x46 & (0xff as u64)) as u8);
  let x48: u8 = ((x46 >> 8) as u8);
  let x49: u8 = ((x3 & (0xff as u64)) as u8);
  let x50: u64 = (x3 >> 8);
  let x51: u8 = ((x50 & (0xff as u64)) as u8);
  let x52: u64 = (x50 >> 8);
  let x53: u8 = ((x52 & (0xff as u64)) as u8);
  let x54: u64 = (x52 >> 8);
  let x55: u8 = ((x54 & (0xff as u64)) as u8);
  let x56: u64 = (x54 >> 8);
  let x57: u8 = ((x56 & (0xff as u64)) as u8);
  let x58: u64 = (x56 >> 8);
  let x59: u8 = ((x58 & (0xff as u64)) as u8);
  let x60: u64 = (x58 >> 8);
  let x61: u8 = ((x60 & (0xff as u64)) as u8);
  let x62: u8 = ((x60 >> 8) as u8);
  let x63: u8 = ((x2 & (0xff as u64)) as u8);
  let x64: u64 = (x2 >> 8);
  let x65: u8 = ((x64 & (0xff as u64)) as u8);
  let x66: u64 = (x64 >> 8);
  let x67: u8 = ((x66 & (0xff as u64)) as u8);
  let x68: u64 = (x66 >> 8);
  let x69: u8 = ((x68 & (0xff as u64)) as u8);
  let x70: u64 = (x68 >> 8);
  let x71: u8 = ((x70 & (0xff as u64)) as u8);
  let x72: u64 = (x70 >> 8);
  let x73: u8 = ((x72 & (0xff as u64)) as u8);
  let x74: u64 = (x72 >> 8);
  let x75: u8 = ((x74 & (0xff as u64)) as u8);
  let x76: u8 = ((x74 >> 8) as u8);
  let x77: u8 = ((x1 & (0xff as u64)) as u8);
  let x78: u64 = (x1 >> 8);
  let x79: u8 = ((x78 & (0xff as u64)) as u8);
  let x80: u64 = (x78 >> 8);
  let x81: u8 = ((x80 & (0xff as u64)) as u8);
  let x82: u64 = (x80 >> 8);
  let x83: u8 = ((x82 & (0xff as u64)) as u8);
  let x84: u64 = (x82 >> 8);
  let x85: u8 = ((x84 & (0xff as u64)) as u8);
  let x86: u64 = (x84 >> 8);
  let x87: u8 = ((x86 & (0xff as u64)) as u8);
  let x88: u64 = (x86 >> 8);
  let x89: u8 = ((x88 & (0xff as u64)) as u8);
  let x90: u8 = ((x88 >> 8) as u8);
  out1[0] = x7;
  out1[1] = x9;
  out1[2] = x11;
  out1[3] = x13;
  out1[4] = x15;
  out1[5] = x17;
  out1[6] = x19;
  out1[7] = x20;
  out1[8] = x21;
  out1[9] = x23;
  out1[10] = x25;
  out1[11] = x27;
  out1[12] = x29;
  out1[13] = x31;
  out1[14] = x33;
  out1[15] = x34;
  out1[16] = x35;
  out1[17] = x37;
  out1[18] = x39;
  out1[19] = x41;
  out1[20] = x43;
  out1[21] = x45;
  out1[22] = x47;
  out1[23] = x48;
  out1[24] = x49;
  out1[25] = x51;
  out1[26] = x53;
  out1[27] = x55;
  out1[28] = x57;
  out1[29] = x59;
  out1[30] = x61;
  out1[31] = x62;
  out1[32] = x63;
  out1[33] = x65;
  out1[34] = x67;
  out1[35] = x69;
  out1[36] = x71;
  out1[37] = x73;
  out1[38] = x75;
  out1[39] = x76;
  out1[40] = x77;
  out1[41] = x79;
  out1[42] = x81;
  out1[43] = x83;
  out1[44] = x85;
  out1[45] = x87;
  out1[46] = x89;
  out1[47] = x90;
}

/// The function fiat_p384_scalar_from_bytes deserializes a field element NOT in the Montgomery domain from bytes in little-endian order.
///
/// Preconditions:
///   0 ≤ bytes_eval arg1 < m
/// Postconditions:
///   eval out1 mod m = bytes_eval arg1 mod m
///   0 ≤ eval out1 < m
///
/// Input Bounds:
///   arg1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
#[inline]
pub fn fiat_p384_scalar_from_bytes(out1: &mut [u64; 6], arg1: &[u8; 48]) -> () {
  let x1: u64 = (((arg1[47]) as u64) << 56);
  let x2: u64 = (((arg1[46]) as u64) << 48);
  let x3: u64 = (((arg1[45]) as u64) << 40);
  let x4: u64 = (((arg1[44]) as u64) << 32);
  let x5: u64 = (((arg1[43]) as u64) << 24);
  let x6: u64 = (((arg1[42]) as u64) << 16);
  let x7: u64 = (((arg1[41]) as u64) << 8);
  let x8: u8 = (arg1[40]);
  let x9: u64 = (((arg1[39]) as u64) << 56);
  let x10: u64 = (((arg1[38]) as u64) << 48);
  let x11: u64 = (((arg1[37]) as u64) << 40);
  let x12: u64 = (((arg1[36]) as u64) << 32);
  let x13: u64 = (((arg1[35]) as u64) << 24);
  let x14: u64 = (((arg1[34]) as u64) << 16);
  let x15: u64 = (((arg1[33]) as u64) << 8);
  let x16: u8 = (arg1[32]);
  let x17: u64 = (((arg1[31]) as u64) << 56);
  let x18: u64 = (((arg1[30]) as u64) << 48);
  let x19: u64 = (((arg1[29]) as u64) << 40);
  let x20: u64 = (((arg1[28]) as u64) << 32);
  let x21: u64 = (((arg1[27]) as u64) << 24);
  let x22: u64 = (((arg1[26]) as u64) << 16);
  let x23: u64 = (((arg1[25]) as u64) << 8);
  let x24: u8 = (arg1[24]);
  let x25: u64 = (((arg1[23]) as u64) << 56);
  let x26: u64 = (((arg1[22]) as u64) << 48);
  let x27: u64 = (((arg1[21]) as u64) << 40);
  let x28: u64 = (((arg1[20]) as u64) << 32);
  let x29: u64 = (((arg1[19]) as u64) << 24);
  let x30: u64 = (((arg1[18]) as u64) << 16);
  let x31: u64 = (((arg1[17]) as u64) << 8);
  let x32: u8 = (arg1[16]);
  let x33: u64 = (((arg1[15]) as u64) << 56);
  let x34: u64 = (((arg1[14]) as u64) << 48);
  let x35: u64 = (((arg1[13]) as u64) << 40);
  let x36: u64 = (((arg1[12]) as u64) << 32);
  let x37: u64 = (((arg1[11]) as u64) << 24);
  let x38: u64 = (((arg1[10]) as u64) << 16);
  let x39: u64 = (((arg1[9]) as u64) << 8);
  let x40: u8 = (arg1[8]);
  let x41: u64 = (((arg1[7]) as u64) << 56);
  let x42: u64 = (((arg1[6]) as u64) << 48);
  let x43: u64 = (((arg1[5]) as u64) << 40);
  let x44: u64 = (((arg1[4]) as u64) << 32);
  let x45: u64 = (((arg1[3]) as u64) << 24);
  let x46: u64 = (((arg1[2]) as u64) << 16);
  let x47: u64 = (((arg1[1]) as u64) << 8);
  let x48: u8 = (arg1[0]);
  let x49: u64 = (x47 + (x48 as u64));
  let x50: u64 = (x46 + x49);
  let x51: u64 = (x45 + x50);
  let x52: u64 = (x44 + x51);
  let x53: u64 = (x43 + x52);
  let x54: u64 = (x42 + x53);
  let x55: u64 = (x41 + x54);
  let x56: u64 = (x39 + (x40 as u64));
  let x57: u64 = (x38 + x56);
  let x58: u64 = (x37 + x57);
  let x59: u64 = (x36 + x58);
  let x60: u64 = (x35 + x59);
  let x61: u64 = (x34 + x60);
  let x62: u64 = (x33 + x61);
  let x63: u64 = (x31 + (x32 as u64));
  let x64: u64 = (x30 + x63);
  let x65: u64 = (x29 + x64);
  let x66: u64 = (x28 + x65);
  let x67: u64 = (x27 + x66);
  let x68: u64 = (x26 + x67);
  let x69: u64 = (x25 + x68);
  let x70: u64 = (x23 + (x24 as u64));
  let x71: u64 = (x22 + x70);
  let x72: u64 = (x21 + x71);
  let x73: u64 = (x20 + x72);
  let x74: u64 = (x19 + x73);
  let x75: u64 = (x18 + x74);
  let x76: u64 = (x17 + x75);
  let x77: u64 = (x15 + (x16 as u64));
  let x78: u64 = (x14 + x77);
  let x79: u64 = (x13 + x78);
  let x80: u64 = (x12 + x79);
  let x81: u64 = (x11 + x80);
  let x82: u64 = (x10 + x81);
  let x83: u64 = (x9 + x82);
  let x84: u64 = (x7 + (x8 as u64));
  let x85: u64 = (x6 + x84);
  let x86: u64 = (x5 + x85);
  let x87: u64 = (x4 + x86);
  let x88: u64 = (x3 + x87);
  let x89: u64 = (x2 + x88);
  let x90: u64 = (x1 + x89);
  out1[0] = x55;
  out1[1] = x62;
  out1[2] = x69;
  out1[3] = x76;
  out1[4] = x83;
  out1[5] = x90;
}

/// The function fiat_p384_scalar_set_one returns the field element one in the Montgomery domain.
///
/// Postconditions:
///   eval (from_montgomery out1) mod m = 1 mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub fn fiat_p384_scalar_set_one(out1: &mut fiat_p384_scalar_montgomery_domain_field_element) -> () {
  out1[0] = 0x1313e695333ad68d;
  out1[1] = 0xa7e5f24db74f5885;
  out1[2] = 0x389cb27e0bc8d220;
  out1[3] = (0x0 as u64);
  out1[4] = (0x0 as u64);
  out1[5] = (0x0 as u64);
}

/// The function fiat_p384_scalar_msat returns the saturated representation of the prime modulus.
///
/// Postconditions:
///   twos_complement_eval out1 = m
///   0 ≤ eval out1 < m
///
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
#[inline]
pub fn fiat_p384_scalar_msat(out1: &mut [u64; 7]) -> () {
  out1[0] = 0xecec196accc52973;
  out1[1] = 0x581a0db248b0a77a;
  out1[2] = 0xc7634d81f4372ddf;
  out1[3] = 0xffffffffffffffff;
  out1[4] = 0xffffffffffffffff;
  out1[5] = 0xffffffffffffffff;
  out1[6] = (0x0 as u64);
}

/// The function fiat_p384_scalar_divstep computes a divstep.
///
/// Preconditions:
///   0 ≤ eval arg4 < m
///   0 ≤ eval arg5 < m
/// Postconditions:
///   out1 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then 1 - arg1 else 1 + arg1)
///   twos_complement_eval out2 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then twos_complement_eval arg3 else twos_complement_eval arg2)
///   twos_complement_eval out3 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then ⌊(twos_complement_eval arg3 - twos_complement_eval arg2) / 2⌋ else ⌊(twos_complement_eval arg3 + (twos_complement_eval arg3 mod 2) * twos_complement_eval arg2) / 2⌋)
///   eval (from_montgomery out4) mod m = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then (2 * eval (from_montgomery arg5)) mod m else (2 * eval (from_montgomery arg4)) mod m)
///   eval (from_montgomery out5) mod m = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then (eval (from_montgomery arg4) - eval (from_montgomery arg4)) mod m else (eval (from_montgomery arg5) + (twos_complement_eval arg3 mod 2) * eval (from_montgomery arg4)) mod m)
///   0 ≤ eval out5 < m
///   0 ≤ eval out5 < m
///   0 ≤ eval out2 < m
///   0 ≤ eval out3 < m
///
/// Input Bounds:
///   arg1: [0x0 ~> 0xffffffffffffffff]
///   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
///   arg3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
///   arg4: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
///   arg5: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffffffffffff]
///   out2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
///   out3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
///   out4: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
///   out5: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
#[inline]
pub fn fiat_p384_scalar_divstep(out1: &mut u64, out2: &mut [u64; 7], out3: &mut [u64; 7], out4: &mut [u64; 6], out5: &mut [u64; 6], arg1: u64, arg2: &[u64; 7], arg3: &[u64; 7], arg4: &[u64; 6], arg5: &[u64; 6]) -> () {
  let mut x1: u64 = 0;
  let mut x2: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x1, &mut x2, 0x0, (!arg1), (0x1 as u64));
  let x3: fiat_p384_scalar_u1 = (((x1 >> 63) as fiat_p384_scalar_u1) & (((arg3[0]) & (0x1 as u64)) as fiat_p384_scalar_u1));
  let mut x4: u64 = 0;
  let mut x5: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x4, &mut x5, 0x0, (!arg1), (0x1 as u64));
  let mut x6: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x6, x3, arg1, x4);
  let mut x7: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x7, x3, (arg2[0]), (arg3[0]));
  let mut x8: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x8, x3, (arg2[1]), (arg3[1]));
  let mut x9: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x9, x3, (arg2[2]), (arg3[2]));
  let mut x10: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x10, x3, (arg2[3]), (arg3[3]));
  let mut x11: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x11, x3, (arg2[4]), (arg3[4]));
  let mut x12: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x12, x3, (arg2[5]), (arg3[5]));
  let mut x13: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x13, x3, (arg2[6]), (arg3[6]));
  let mut x14: u64 = 0;
  let mut x15: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x14, &mut x15, 0x0, (0x1 as u64), (!(arg2[0])));
  let mut x16: u64 = 0;
  let mut x17: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x16, &mut x17, x15, (0x0 as u64), (!(arg2[1])));
  let mut x18: u64 = 0;
  let mut x19: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x18, &mut x19, x17, (0x0 as u64), (!(arg2[2])));
  let mut x20: u64 = 0;
  let mut x21: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x20, &mut x21, x19, (0x0 as u64), (!(arg2[3])));
  let mut x22: u64 = 0;
  let mut x23: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x22, &mut x23, x21, (0x0 as u64), (!(arg2[4])));
  let mut x24: u64 = 0;
  let mut x25: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x24, &mut x25, x23, (0x0 as u64), (!(arg2[5])));
  let mut x26: u64 = 0;
  let mut x27: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x26, &mut x27, x25, (0x0 as u64), (!(arg2[6])));
  let mut x28: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x28, x3, (arg3[0]), x14);
  let mut x29: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x29, x3, (arg3[1]), x16);
  let mut x30: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x30, x3, (arg3[2]), x18);
  let mut x31: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x31, x3, (arg3[3]), x20);
  let mut x32: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x32, x3, (arg3[4]), x22);
  let mut x33: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x33, x3, (arg3[5]), x24);
  let mut x34: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x34, x3, (arg3[6]), x26);
  let mut x35: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x35, x3, (arg4[0]), (arg5[0]));
  let mut x36: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x36, x3, (arg4[1]), (arg5[1]));
  let mut x37: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x37, x3, (arg4[2]), (arg5[2]));
  let mut x38: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x38, x3, (arg4[3]), (arg5[3]));
  let mut x39: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x39, x3, (arg4[4]), (arg5[4]));
  let mut x40: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x40, x3, (arg4[5]), (arg5[5]));
  let mut x41: u64 = 0;
  let mut x42: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x41, &mut x42, 0x0, x35, x35);
  let mut x43: u64 = 0;
  let mut x44: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x43, &mut x44, x42, x36, x36);
  let mut x45: u64 = 0;
  let mut x46: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x45, &mut x46, x44, x37, x37);
  let mut x47: u64 = 0;
  let mut x48: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x47, &mut x48, x46, x38, x38);
  let mut x49: u64 = 0;
  let mut x50: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x49, &mut x50, x48, x39, x39);
  let mut x51: u64 = 0;
  let mut x52: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x51, &mut x52, x50, x40, x40);
  let mut x53: u64 = 0;
  let mut x54: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x53, &mut x54, 0x0, x41, 0xecec196accc52973);
  let mut x55: u64 = 0;
  let mut x56: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x55, &mut x56, x54, x43, 0x581a0db248b0a77a);
  let mut x57: u64 = 0;
  let mut x58: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x57, &mut x58, x56, x45, 0xc7634d81f4372ddf);
  let mut x59: u64 = 0;
  let mut x60: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x59, &mut x60, x58, x47, 0xffffffffffffffff);
  let mut x61: u64 = 0;
  let mut x62: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x61, &mut x62, x60, x49, 0xffffffffffffffff);
  let mut x63: u64 = 0;
  let mut x64: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x63, &mut x64, x62, x51, 0xffffffffffffffff);
  let mut x65: u64 = 0;
  let mut x66: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x65, &mut x66, x64, (x52 as u64), (0x0 as u64));
  let x67: u64 = (arg4[5]);
  let x68: u64 = (arg4[4]);
  let x69: u64 = (arg4[3]);
  let x70: u64 = (arg4[2]);
  let x71: u64 = (arg4[1]);
  let x72: u64 = (arg4[0]);
  let mut x73: u64 = 0;
  let mut x74: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x73, &mut x74, 0x0, (0x0 as u64), x72);
  let mut x75: u64 = 0;
  let mut x76: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x75, &mut x76, x74, (0x0 as u64), x71);
  let mut x77: u64 = 0;
  let mut x78: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x77, &mut x78, x76, (0x0 as u64), x70);
  let mut x79: u64 = 0;
  let mut x80: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x79, &mut x80, x78, (0x0 as u64), x69);
  let mut x81: u64 = 0;
  let mut x82: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x81, &mut x82, x80, (0x0 as u64), x68);
  let mut x83: u64 = 0;
  let mut x84: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x83, &mut x84, x82, (0x0 as u64), x67);
  let mut x85: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x85, x84, (0x0 as u64), 0xffffffffffffffff);
  let mut x86: u64 = 0;
  let mut x87: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x86, &mut x87, 0x0, x73, (x85 & 0xecec196accc52973));
  let mut x88: u64 = 0;
  let mut x89: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x88, &mut x89, x87, x75, (x85 & 0x581a0db248b0a77a));
  let mut x90: u64 = 0;
  let mut x91: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x90, &mut x91, x89, x77, (x85 & 0xc7634d81f4372ddf));
  let mut x92: u64 = 0;
  let mut x93: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x92, &mut x93, x91, x79, x85);
  let mut x94: u64 = 0;
  let mut x95: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x94, &mut x95, x93, x81, x85);
  let mut x96: u64 = 0;
  let mut x97: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x96, &mut x97, x95, x83, x85);
  let mut x98: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x98, x3, (arg5[0]), x86);
  let mut x99: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x99, x3, (arg5[1]), x88);
  let mut x100: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x100, x3, (arg5[2]), x90);
  let mut x101: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x101, x3, (arg5[3]), x92);
  let mut x102: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x102, x3, (arg5[4]), x94);
  let mut x103: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x103, x3, (arg5[5]), x96);
  let x104: fiat_p384_scalar_u1 = ((x28 & (0x1 as u64)) as fiat_p384_scalar_u1);
  let mut x105: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x105, x104, (0x0 as u64), x7);
  let mut x106: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x106, x104, (0x0 as u64), x8);
  let mut x107: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x107, x104, (0x0 as u64), x9);
  let mut x108: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x108, x104, (0x0 as u64), x10);
  let mut x109: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x109, x104, (0x0 as u64), x11);
  let mut x110: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x110, x104, (0x0 as u64), x12);
  let mut x111: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x111, x104, (0x0 as u64), x13);
  let mut x112: u64 = 0;
  let mut x113: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x112, &mut x113, 0x0, x28, x105);
  let mut x114: u64 = 0;
  let mut x115: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x114, &mut x115, x113, x29, x106);
  let mut x116: u64 = 0;
  let mut x117: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x116, &mut x117, x115, x30, x107);
  let mut x118: u64 = 0;
  let mut x119: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x118, &mut x119, x117, x31, x108);
  let mut x120: u64 = 0;
  let mut x121: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x120, &mut x121, x119, x32, x109);
  let mut x122: u64 = 0;
  let mut x123: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x122, &mut x123, x121, x33, x110);
  let mut x124: u64 = 0;
  let mut x125: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x124, &mut x125, x123, x34, x111);
  let mut x126: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x126, x104, (0x0 as u64), x35);
  let mut x127: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x127, x104, (0x0 as u64), x36);
  let mut x128: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x128, x104, (0x0 as u64), x37);
  let mut x129: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x129, x104, (0x0 as u64), x38);
  let mut x130: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x130, x104, (0x0 as u64), x39);
  let mut x131: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x131, x104, (0x0 as u64), x40);
  let mut x132: u64 = 0;
  let mut x133: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x132, &mut x133, 0x0, x98, x126);
  let mut x134: u64 = 0;
  let mut x135: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x134, &mut x135, x133, x99, x127);
  let mut x136: u64 = 0;
  let mut x137: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x136, &mut x137, x135, x100, x128);
  let mut x138: u64 = 0;
  let mut x139: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x138, &mut x139, x137, x101, x129);
  let mut x140: u64 = 0;
  let mut x141: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x140, &mut x141, x139, x102, x130);
  let mut x142: u64 = 0;
  let mut x143: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x142, &mut x143, x141, x103, x131);
  let mut x144: u64 = 0;
  let mut x145: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x144, &mut x145, 0x0, x132, 0xecec196accc52973);
  let mut x146: u64 = 0;
  let mut x147: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x146, &mut x147, x145, x134, 0x581a0db248b0a77a);
  let mut x148: u64 = 0;
  let mut x149: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x148, &mut x149, x147, x136, 0xc7634d81f4372ddf);
  let mut x150: u64 = 0;
  let mut x151: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x150, &mut x151, x149, x138, 0xffffffffffffffff);
  let mut x152: u64 = 0;
  let mut x153: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x152, &mut x153, x151, x140, 0xffffffffffffffff);
  let mut x154: u64 = 0;
  let mut x155: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x154, &mut x155, x153, x142, 0xffffffffffffffff);
  let mut x156: u64 = 0;
  let mut x157: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_subborrowx_u64(&mut x156, &mut x157, x155, (x143 as u64), (0x0 as u64));
  let mut x158: u64 = 0;
  let mut x159: fiat_p384_scalar_u1 = 0;
  fiat_p384_scalar_addcarryx_u64(&mut x158, &mut x159, 0x0, x6, (0x1 as u64));
  let x160: u64 = ((x112 >> 1) | ((x114 << 63) & 0xffffffffffffffff));
  let x161: u64 = ((x114 >> 1) | ((x116 << 63) & 0xffffffffffffffff));
  let x162: u64 = ((x116 >> 1) | ((x118 << 63) & 0xffffffffffffffff));
  let x163: u64 = ((x118 >> 1) | ((x120 << 63) & 0xffffffffffffffff));
  let x164: u64 = ((x120 >> 1) | ((x122 << 63) & 0xffffffffffffffff));
  let x165: u64 = ((x122 >> 1) | ((x124 << 63) & 0xffffffffffffffff));
  let x166: u64 = ((x124 & 0x8000000000000000) | (x124 >> 1));
  let mut x167: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x167, x66, x53, x41);
  let mut x168: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x168, x66, x55, x43);
  let mut x169: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x169, x66, x57, x45);
  let mut x170: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x170, x66, x59, x47);
  let mut x171: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x171, x66, x61, x49);
  let mut x172: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x172, x66, x63, x51);
  let mut x173: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x173, x157, x144, x132);
  let mut x174: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x174, x157, x146, x134);
  let mut x175: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x175, x157, x148, x136);
  let mut x176: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x176, x157, x150, x138);
  let mut x177: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x177, x157, x152, x140);
  let mut x178: u64 = 0;
  fiat_p384_scalar_cmovznz_u64(&mut x178, x157, x154, x142);
  *out1 = x158;
  out2[0] = x7;
  out2[1] = x8;
  out2[2] = x9;
  out2[3] = x10;
  out2[4] = x11;
  out2[5] = x12;
  out2[6] = x13;
  out3[0] = x160;
  out3[1] = x161;
  out3[2] = x162;
  out3[3] = x163;
  out3[4] = x164;
  out3[5] = x165;
  out3[6] = x166;
  out4[0] = x167;
  out4[1] = x168;
  out4[2] = x169;
  out4[3] = x170;
  out4[4] = x171;
  out4[5] = x172;
  out5[0] = x173;
  out5[1] = x174;
  out5[2] = x175;
  out5[3] = x176;
  out5[4] = x177;
  out5[5] = x178;
}

/// The function fiat_p384_scalar_divstep_precomp returns the precomputed value for Bernstein-Yang-inversion (in montgomery form).
///
/// Postconditions:
///   eval (from_montgomery out1) = ⌊(m - 1) / 2⌋^(if ⌊log2 m⌋ + 1 < 46 then ⌊(49 * (⌊log2 m⌋ + 1) + 80) / 17⌋ else ⌊(49 * (⌊log2 m⌋ + 1) + 57) / 17⌋)
///   0 ≤ eval out1 < m
///
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
#[inline]
pub fn fiat_p384_scalar_divstep_precomp(out1: &mut [u64; 6]) -> () {
  out1[0] = 0x49589ae0e6045b6a;
  out1[1] = 0x3c9a5352870040ed;
  out1[2] = 0xdacb097e977dc242;
  out1[3] = 0xb5ab30a6d1ecbe36;
  out1[4] = 0x97d7a1081f959973;
  out1[5] = 0x2ba012f8d27192bc;
}
