description: 'Payment Card Industry - Data Security Standard (PCI-DSS) is a set of

    security standards designed to ensure the secure handling of payment card

    data, with the goal of preventing data breaches and protecting sensitive

    financial information.


    This profile ensures Red Hat Enterprise Linux 8 is configured in alignment

    with PCI-DSS v4.0 requirements.'
extends: null
metadata:
    version: '4.0'
    SMEs:
    - marcusburghardt
    - mab879
    - vojtapolasek
reference: https://docs-prv.pcisecuritystandards.org/PCI%20DSS/Standard/PCI-DSS-v4_0.pdf
selections:
- enable_authselect
- package_sudo_installed
- sshd_set_loglevel_verbose
- accounts_password_warn_age_login_defs
- network_nmcli_permissions
- ensure_pam_wheel_group_empty
- accounts_password_pam_unix_remember
- sudo_require_reauthentication
- file_groupowner_backup_etc_passwd
- set_ip6tables_default_rule
- sysctl_net_ipv4_conf_all_secure_redirects
- no_direct_root_logins
- configure_crypto_policy
- audit_rules_usergroup_modification_shadow
- disable_users_coredumps
- set_password_hashing_algorithm_libuserconf
- no_shelllogin_for_systemaccounts
- dconf_gnome_disable_automount_open
- rsyslog_files_ownership
- sshd_do_not_permit_user_env
- service_nftables_disabled
- account_disable_post_pw_expiration
- file_owner_cron_daily
- sshd_disable_empty_passwords
- sshd_use_approved_ciphers
- audit_rules_dac_modification_fchownat
- wireless_disable_interfaces
- file_groupowner_backup_etc_shadow
- file_owner_etc_group
- file_permissions_crontab
- sshd_use_approved_macs
- dconf_gnome_session_idle_user_locks
- sshd_set_maxstartups
- audit_rules_time_stime
- accounts_password_pam_pwhistory_remember_system_auth
- service_rpcbind_disabled
- chronyd_run_as_chrony_user
- sysctl_net_ipv4_conf_default_send_redirects
- accounts_passwords_pam_faillock_unlock_time
- sudo_require_authentication
- rsyslog_files_groupownership
- selinux_policytype
- service_auditd_enabled
- file_owner_etc_shadow
- accounts_passwords_pam_faillock_deny
- accounts_password_all_shadowed
- accounts_root_gid_zero
- selinux_state
- audit_rules_time_clock_settime
- file_permissions_sshd_config
- sysctl_net_ipv4_conf_default_accept_redirects
- audit_rules_file_deletion_events_renameat
- file_groupowner_crontab
- file_groupowner_at_allow
- audit_rules_dac_modification_removexattr
- audit_rules_dac_modification_fchmod
- audit_rules_login_events_lastlog
- no_password_auth_for_systemaccounts
- file_groupowner_cron_monthly
- audit_rules_file_deletion_events_rename
- file_permissions_etc_issue_net
- gnome_gdm_disable_automatic_login
- network_sniffer_disabled
- audit_rules_session_events
- package_dhcp_removed
- file_owner_cron_d
- sshd_set_idle_timeout
- file_groupowner_cron_weekly
- file_permissions_grub2_cfg
- file_ownership_var_log_audit
- service_firewalld_enabled
- file_groupowner_cron_d
- package_audit_installed
- package_ypserv_removed
- audit_rules_time_watch_localtime
- audit_rules_usergroup_modification_passwd
- file_groupowner_grub2_cfg
- package_audispd-plugins_installed
- accounts_password_last_change_is_in_past
- file_owner_user_cfg
- account_unique_name
- file_groupowner_etc_group
- file_permissions_cron_allow
- file_permissions_ungroupowned
- sysctl_net_ipv6_conf_default_accept_source_route
- set_password_hashing_algorithm_logindefs
- package_logrotate_installed
- service_avahi-daemon_disabled
- audit_rules_dac_modification_setxattr
- file_groupowner_user_cfg
- install_PAE_kernel_on_x86-32
- sshd_disable_root_login
- audit_rules_dac_modification_lsetxattr
- sshd_set_keepalive
- file_groupowner_cron_hourly
- audit_rules_dac_modification_lchown
- audit_rules_file_deletion_events_unlinkat
- audit_rules_suid_privilege_function
- dconf_gnome_screensaver_lock_delay
- file_owner_etc_issue_net
- audit_rules_time_settimeofday
- securetty_root_login_console_only
- file_cron_deny_not_exist
- audit_rules_dac_modification_fchmodat
- sysctl_net_ipv4_conf_all_rp_filter
- file_groupowner_cron_allow
- audit_rules_file_deletion_events_unlink
- accounts_password_pam_dcredit
- no_files_unowned_by_user
- disable_host_auth
- file_group_ownership_var_log_audit
- sudo_add_use_pty
- package_net-snmp_removed
- sudo_custom_logfile
- sysctl_fs_suid_dumpable
- dconf_gnome_screensaver_idle_delay
- file_owner_cron_weekly
- auditd_data_retention_space_left
- accounts_password_pam_pwhistory_remember_password_auth
- accounts_no_uid_except_zero
- bios_enable_execution_restrictions
- file_permissions_var_log_audit
- package_telnet-server_removed
- file_permissions_unauthorized_world_writable
- package_tftp-server_removed
- file_permissions_sshd_private_key
- sshd_disable_tcp_forwarding
- audit_rules_dac_modification_fsetxattr
- service_rsyncd_disabled
- dconf_db_up_to_date
- accounts_password_set_max_life_existing
- audit_rules_immutable
- accounts_password_set_warn_age_existing
- chronyd_specify_remote_server
- file_permissions_cron_d
- group_unique_id
- package_nftables_installed
- aide_periodic_cron_checking
- sysctl_net_ipv4_ip_forward
- audit_rules_media_export
- postfix_network_listening_disabled
- audit_rules_usergroup_modification_group
- kernel_module_usb-storage_disabled
- no_empty_passwords
- accounts_tmout
- audit_rules_login_events_faillock
- gnome_gdm_disable_guest_login
- file_permissions_etc_shadow
- accounts_password_pam_minlen
- set_password_hashing_algorithm_systemauth
- audit_rules_file_deletion_events_rmdir
- group_unique_name
- audit_rules_login_events_tallylog
- file_permissions_etc_group
- file_permissions_cron_monthly
- package_libselinux_installed
- service_chronyd_or_ntpd_enabled
- auditd_data_retention_admin_space_left_action
- directory_access_var_log_audit
- file_owner_cron_hourly
- sysctl_net_ipv4_icmp_echo_ignore_broadcasts
- use_pam_wheel_group_for_su
- file_permissions_backup_etc_passwd
- file_permissions_cron_weekly
- audit_rules_usergroup_modification_opasswd
- dconf_gnome_screensaver_lock_enabled
- audit_rules_dac_modification_chmod
- coredump_disable_storage
- kernel_module_dccp_disabled
- aide_build_database
- coredump_disable_backtraces
- file_owner_etc_passwd
- file_permissions_backup_etc_group
- file_groupowner_backup_etc_group
- package_chrony_installed
- package_telnet_removed
- audit_sudo_log_events
- package_ypbind_removed
- dconf_gnome_screensaver_idle_activation_enabled
- sysctl_net_ipv4_tcp_syncookies
- sshd_set_max_auth_tries
- file_permissions_at_allow
- dconf_gnome_screensaver_mode_blank
- audit_rules_networkconfig_modification
- package_tftp_removed
- audit_rules_dac_modification_fchown
- file_owner_crontab
- file_permissions_user_cfg
- file_owner_grub2_cfg
- auditd_data_retention_space_left_action
- rsyslog_files_permissions
- file_owner_cron_monthly
- file_permissions_cron_daily
- selinux_confinement_of_daemons
- sysctl_net_ipv4_conf_all_send_redirects
- audit_rules_time_adjtimex
- sysctl_net_ipv4_icmp_ignore_bogus_error_responses
- ensure_gpgcheck_globally_activated
- configure_firewalld_ports
- rpm_verify_ownership
- sshd_set_login_grace_time
- auditd_audispd_syslog_plugin_activated
- sysctl_kernel_randomize_va_space
- file_owner_backup_etc_shadow
- accounts_password_pam_lcredit
- audit_rules_usergroup_modification_gshadow
- audit_rules_sysadmin_actions
- display_login_attempts
- file_permissions_backup_etc_shadow
- audit_rules_dac_modification_fremovexattr
- sshd_disable_x11_forwarding
- file_at_deny_not_exist
- audit_rules_mac_modification
- accounts_set_post_pw_existing
- account_unique_id
- file_groupowner_cron_daily
- file_groupowner_etc_issue_net
- sshd_set_max_sessions
- file_owner_backup_etc_passwd
- sshd_disable_rhosts
- rpm_verify_hashes
- file_owner_cron_allow
- file_permissions_sshd_pub_key
- dconf_gnome_disable_automount
- gid_passwd_group_same
- package_xinetd_removed
- ensure_gpgcheck_never_disabled
- package_aide_installed
- sshd_limit_user_access
- configure_ssh_crypto_policy
- accounts_maximum_age_login_defs
- file_owner_backup_etc_group
- ensure_redhat_gpgkey_installed
- file_groupowner_etc_shadow
- sysctl_kernel_core_pattern
- security_patches_up_to_date
- audit_rules_dac_modification_chown
- kernel_module_sctp_disabled
- audit_rules_dac_modification_lremovexattr
- file_permissions_etc_passwd
- grub2_audit_backlog_limit_argument
- no_empty_passwords_etc_shadow
- file_groupowner_etc_passwd
- set_firewalld_default_zone
- dir_perms_world_writable_sticky_bits
- file_permissions_cron_hourly
- grub2_enable_selinux
- sshd_enable_pam
- grub2_audit_argument
- auditd_name_format
- var_multiple_time_servers=generic
- var_auditd_admin_space_left_action=single
- var_auditd_space_left=100MB
- var_auditd_space_left_action=email
- var_auditd_name_format=fqd
- var_accounts_maximum_age_login_defs=90
- var_accounts_password_warn_age_login_defs=7
- var_password_pam_unix_remember=4
- var_password_pam_remember=4
- var_password_pam_remember_control_flag=requisite_or_required
- var_password_pam_dcredit=1
- var_password_pam_lcredit=1
- var_password_pam_minlen=12
- var_accounts_passwords_pam_faillock_deny=10
- var_accounts_passwords_pam_faillock_unlock_time=1800
- var_password_pam_tally2=10
- var_accounts_passwords_pam_tally2_unlock_time=1800
- var_password_hashing_algorithm=SHA512
- inactivity_timeout_value=15_minutes
- var_screensaver_lock_delay=10_seconds
- sshd_idle_timeout_value=15_minutes
- var_sshd_set_keepalive=0
- var_account_disable_post_pw_expiration=90
- var_system_crypto_policy=default_policy
- var_sshd_set_login_grace_time=60
- var_postfix_inet_interfaces=loopback-only
- var_selinux_policy_name=targeted
- var_selinux_state=enforcing
unselected_groups: []
platforms: !!set {}
cpe_names: !!set {}
platform: null
filter_rules: ''
policies:
- pcidss_4
title: PCI-DSS v4.0 Control Baseline for Red Hat Enterprise Linux 8
documentation_complete: true
