# wxmplot documentation build configuration file
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

import os
import sys
from datetime import date

from packaging.version import parse as version_parse

import wxmplot

project = 'wxmplot'
copyright = f'{date.today()}, Matthew Newville, The University of Chicago'

release = version_parse(wxmplot.__version__).public

html_title = "WXMPLOT: interactive plotting with Python"
html_short_title = "WXMPLOT: wxPython+matplotlib"

# sys.path.append(os.path.abspath(os.path.join('.')))
extensions = ['sphinx.ext.autodoc', 'sphinx.ext.mathjax',
              'sphinx.ext.napoleon', 'sphinxcontrib.video']

autoclass_content = 'both'
templates_path = ['_templates']
source_suffix = {'.rst': 'restructuredtext'}
master_doc = 'index'

exclude_trees = ['_build']
default_role = None

add_function_parentheses = True
add_module_names = False
pygments_style = 'sphinx'

html_theme_path = ['sphinx_theme']
html_theme = 'bizstyle'


html_static_path = ['_static']
html_sidebars = {'index': ['indexsidebar.html', 'searchbox.html']}
html_domain_indices = False
html_use_index = True
html_show_sourcelink = True

latex_documents = [('index', 'wxmplot.tex', 'wxmplot documentation',
                    'Matthew Newville', 'manual')]
