/*
 * sprite_update.c: sprite̾ﹹ
 *
 * Copyright (C) 1997-1998 Masaki Chikama (Wren) <chikama@kasumi.ipl.mech.nagoya-u.ac.jp>
 *               1998-                           <masaki-c@is.aist-nara.ac.jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
*/
/* $Id: sprite_update.c,v 1.1 2003/04/22 16:29:52 chikama Exp $ */

#include "config.h"

#include <stdio.h>
#include <glib.h>

#include "portab.h"
#include "system.h"
#include "counter.h"
#include "ags.h"
#include "graphics.h"
#include "sact.h"
#include "surface.h"
#include "ngraph.h"
#include "sprite.h"

// ץ饤Ⱥ֤δ֤ѹΤäץ饤Ȥΰ
static GSList *updatearea;

static void intersection(MyRectangle *r1, MyRectangle *r2, MyRectangle *rst);
static void disjunction(gpointer region, gpointer data);
static void get_updatearea();
static void do_update_each(gpointer data, gpointer userdata);

// ΰ裱ΰ裲Ѥ׻
static void intersection(MyRectangle *r1, MyRectangle *r2, MyRectangle *rst) {
        int x1 = max(r1->x, r2->x);
        int x2 = min(r1->x + r1->width, r2->x + r2->width);
        int y1 = max(r1->y, r2->y);
        int y2 = min(r1->y + r1->height, r2->y + r2->height);
	
        rst->x = x1;
	rst->y = y1;
	rst->width  = x2 - x1;
	rst->height = y2 - y1;
}

// ΰ裱ΰ裲򤹤٤ƴޤΰ׻
static void disjunction(gpointer region, gpointer data) {
	MyRectangle *r1 = (MyRectangle *)region;
	MyRectangle *r2 = (MyRectangle *)data;
	int x1, x2, y1, y2;
	
	//WARNING("r1x=%d,r1y=%d,r1w=%d,r1h=%d\n", r1->x, r1->y, r1->width, r1->height);
	//WARNING("r2x=%d,r2y=%d,r2w=%d,r2h=%d\n", r2->x, r2->y, r2->width, r2->height);
	
	if (r2->width == 0) {
		r2->x = r1->x;
		r2->y = r1->y;
		r2->width = r1->width;
		r2->height = r1->height;
		return;
	}
	
	x1 = min(r1->x, r2->x);
	x2 = max(r1->x + r1->width,  r2->x + r2->width);
	y1 = min(r1->y, r2->y);
	y2 = max(r1->y + r1->height, r2->y + r2->height);
	
	r2->x = x1;
	r2->y = y1;
	r2->width  = x2 - x1;
	r2->height = y2 - y1;
	
	//WARNING("res:r2x=%d,r2y=%d,r2w=%d,r2h=%d\n", r2->x, r2->y, r2->width, r2->height);
}

// ɬפʥץ饤Ȥΰ¤Ȥäƥåԥ󥰤
static void get_updatearea() {
	MyRectangle clip = {0, 0, 0, 0};
	MyRectangle rsf0 = {0, 0, sf0->width, sf0->height};
	
	g_slist_foreach(updatearea, disjunction, &clip);
	
	g_slist_free(updatearea);
	updatearea = NULL;
	
	// surface0ȤΰѤȤ
	intersection(&rsf0, &clip, &sact.updaterect);
	
	WARNING("clipped area x=%d y=%d w=%d h=%d\n",
		sact.updaterect.x, sact.updaterect.y,
		sact.updaterect.width, sact.updaterect.height);
	
	return;
}

// updatelist ϿƤ뤹٤ƤΥץ饤Ȥ򹹿
static void do_update_each(gpointer data, gpointer userdata) {
	sprite_t *sp = (sprite_t *)data;
	
	// ɽξϤʤˤ⤷ʤ
	if (!sp->show) return;
	
	if (sp == sact.draggedsp) return; // dragΥץ饤ȤϺǸɽ
		
	// ץ饤update롼θƤӽФ
	if (sp->update) {
		sp->update(sp);
	}
}

/*
  Τι
  @param syncscreen: surface0 褷Τ Screen ȿǤ뤫ɤ
 */
int sp_update_all(boolean syncscreen) {

	// ץ饤Ȱưϰư
	if (sact.movelist) {
		// ưϻ֤碌
		sact.movestarttime = get_high_counter(SYSTEMCOUNTER_MSEC);
		g_slist_foreach(sact.movelist, spev_move_setup, NULL);
		g_slist_free(sact.movelist);
		sact.movelist = NULL;
	}

	// Τ򹹿ΰ
	sact.updaterect.x = 0;
	sact.updaterect.y = 0;
	sact.updaterect.width  = sf0->width;
	sact.updaterect.height = sf0->height;
	
	// updatelistϿƤ륹ץ饤Ȥ
	// updatelistϥץ饤Ȥֹ¤Ǥ
	g_slist_foreach(sact.updatelist, do_update_each, NULL);

	// Υ롼󤬸ƤФȤϥץ饤ȤϥɥåǤϤʤ
	
	// screenƱɬפʤȤϲΤWindowž
	if (syncscreen) {
		ags_updateFull();
	}
	
	// ưΤ٤ƤΥץ饤ȤưλޤԤ
	// ʤưƱʤ 
	spev_wait4moving_sp();
	
	return OK;
}

/*
  ̤ΰ򹹿
   updateme(_part)Ͽɬפsprite¤ΰupdate
*/
int sp_update_clipped() {
	// ΰγ
	get_updatearea();
	
	// ޤϹ⤵ 0 λϤʤˤ⤷ʤ
	if (sact.updaterect.width == 0 || sact.updaterect.height == 0) {
		return OK;
	}

	// ΰäƤ륹ץ饤Ȥκ
	g_slist_foreach(sact.updatelist, do_update_each, NULL);
	
	// dragΥץ饤ȤǸ
	if (sact.draggedsp) {
		sact.draggedsp->update(sact.draggedsp);
	}
	
	// ΰ Window ž
	ags_updateArea(sact.updaterect.x, sact.updaterect.y, sact.updaterect.width, sact.updaterect.height);
	
	return OK;
}

/*
  spriteΤιϿ
  @param sp: 륹ץ饤
*/
int sp_updateme(sprite_t *sp) {
	MyRectangle *r;
	
	if (sp == NULL) return NG;
	if (sp->cursize.width == 0 || sp->cursize.height == 0) return NG;
	
	r = g_new(MyRectangle, 1);
	r->x = sp->cur.x;
	r->y = sp->cur.y;
	r->width = sp->cursize.width;
	r->height = sp->cursize.height;
	
	updatearea = g_slist_append(updatearea, r);
	
	WARNING("x = %d, y = %d, spno = %d w=%d,h=%d\n",
		r->x, r->y, sp->no, r->width, r->height);
	
	return OK;
}

/*
  spriteΰϿ
  @param sp: 륹ץ饤
  @param x: ΰغɸ
  @param y: ΰٺɸ
  @param w: ΰ
  @param h: ΰ⤵
*/
int sp_updateme_part(sprite_t *sp, int x, int y, int w, int h) {
	MyRectangle *r;
	
	if (sp == NULL) return NG;
	if (w == 0 || h == 0) return NG;
	
	r = g_new(MyRectangle, 1);
	r->x = sp->cur.x + x;
	r->y = sp->cur.y + y;
	r->width = w;
	r->height = h;
	
	updatearea = g_slist_append(updatearea, r);
	
	WARNING("x = %d, y = %d, spno = %d w=%d,h=%d\n",
		r->x, r->y, sp->no, r->width, r->height);
	
	return OK;
}

